/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.worksummary.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.worksummary.dao.TsWorkSummaryDao;
import com.biz.eisp.worksummary.entity.TsWorkSummaryEntity;
import com.biz.eisp.worksummary.service.TsWorkSummaryService;
import com.biz.eisp.worksummary.vo.TsWorkSummaryVo;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TsWorkSummaryServiceImpl
extends BaseServiceImpl<TsWorkSummaryEntity>
implements TsWorkSummaryService {
    @Autowired
    TsWorkSummaryDao tsWorkSummaryDao;

    @Override
    public AjaxJson addTsWorkSummary(TsWorkSummaryVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (!(ajaxJson = this.valite_addTsWorkSummary(vo, ajaxJson)).isSuccess()) {
            return ajaxJson;
        }
        TsWorkSummaryEntity tsWorkSummaryEntity = new TsWorkSummaryEntity();
        BeanUtils.copyProperties((Object)vo, (Object)tsWorkSummaryEntity);
        this.tsWorkSummaryDao.insertSelective(tsWorkSummaryEntity);
        return ajaxJson;
    }

    private AjaxJson valite_addTsWorkSummary(TsWorkSummaryVo vo, AjaxJson ajaxJson) {
        if (StringUtil.isEmpty((String)vo.getCurrentContent())) {
            ajaxJson.setErrMsg("\u5f53\u524d\u5de5\u4f5c\u5185\u5bb9\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getNextContent())) {
            ajaxJson.setErrMsg("\u4e0b\u4e00\u4e2a\u5de5\u4f5c\u5185\u5bb9\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getSummaryType())) {
            ajaxJson.setErrMsg("\u603b\u7ed3\u7c7b\u578b\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getProtType())) {
            ajaxJson.setErrMsg("\u53ef\u89c1\u8303\u56f4\u5fc5\u4f20");
            return ajaxJson;
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsWorkSummaryEntity> findHistoryList(TsWorkSummaryVo vo, String page, String rows) {
        AjaxJson ajaxJson = new AjaxJson();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        EuPage page1 = new EuPage();
        if (StringUtil.isEmpty((String)page)) {
            page = "1";
        }
        if (StringUtil.isEmpty((String)rows)) {
            rows = "15";
        }
        page1.setPage(page);
        page1.setRows(rows);
        Example example1 = new Example(TsWorkSummaryEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("createBy", (Object)userRedis.getId());
        if (StringUtil.isNotEmpty((CharSequence)vo.getCurrentContent())) {
            criteria1.andLike("currentContent", "%" + vo.getCurrentContent() + "%");
        }
        example1.orderBy("createDate").desc();
        List entities = this.tsWorkSummaryDao.selectByExample(example1);
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> entities, (Page)page1);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsWorkSummaryEntity> findWorkSummaryById(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)id)) {
            ajaxJson.setErrMsg("id\u5fc5\u4f20");
            return ajaxJson;
        }
        TsWorkSummaryEntity tsWorkSummaryEntity = (TsWorkSummaryEntity)this.tsWorkSummaryDao.selectByPrimaryKey(id);
        ajaxJson.setObj((Object)tsWorkSummaryEntity);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsWorkSummaryEntity> findSummaryDetail(TsWorkSummaryVo vo, Page page) {
        AjaxJson ajaxJson = new AjaxJson();
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tsWorkSummaryDao.findSummaryDetail(vo), (Page)page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }
}

