/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.datareport;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.datareport.entity.TsDataReportEntity;
import com.biz.eisp.datareport.service.TsDataReportService;
import com.biz.eisp.datareport.vo.TsDataReportVo;
import com.biz.eisp.params.Constant;
import com.biz.eisp.product.TmProductInfoVo;
import com.biz.eisp.terminal.TmTerminalVo;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.utils.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaApi/tsDataReportApiController"})
@Api(tags={"\u6570\u636e\u4e0a\u62a5"})
public class TsDataReportApiController {
    @Autowired
    TsDataReportService tsDataReportService;
    @Autowired
    MdmApiFeign mdmApiFeign;

    @PostMapping(value={"findTerminalList"})
    @ApiOperation(value="\u83b7\u53d6\u95e8\u5e97\u5217\u8868", notes="\u8fd4\u56de\u503cterminalCode\u548cterminalName\u6709\u7528\uff0c\u5176\u4ed6\u5197\u4f59\u5b57\u6bb5\u4e0d\u7ba1", httpMethod="POST")
    public Result<PageInfo<TmTerminalVo>> findTerminalListByUser(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = this.mdmApiFeign.getTerminalPage(param);
        Result<PageInfo<TmTerminalVo>> result = new Result<PageInfo<TmTerminalVo>>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"findProductInfoByPage"})
    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u5217\u8868", notes="\u4f20\u9012Map<String,Object>\u5f62\u5f0f\uff0ckey\u4e3a\u7b5b\u9009\u6761\u4ef6\uff0cvalue\u4e3a\u503c(\u4f8b\u5982 {\"productInfoName\":\"11\",\"productInfoCode\":\"22\"} )\uff0cMap\u4e2dkey\u4e3aproductInfoType\u65f6\uff0cvalue\u503c\u4e3a10\u4ee3\u8868\u672c\u54c1\uff0c30\u4ee3\u8868\u7ade\u54c1\uff0ckey\u7684\u503c\u4e3a\u5982\u679c\u6ca1\u6709\u7b5b\u9009\u6761\u4ef6\uff0c\u5219\u4f20\u7a7aMap,\u4f8b\u5982 {} ,\u4e0d\u80fd\u76f4\u63a5\u4f20null", httpMethod="POST")
    public Result<PageInfo<TmProductInfoVo>> findProductInfoByPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = this.mdmApiFeign.findProductInfoByPage(param);
        Result<PageInfo<TmProductInfoVo>> result = new Result<PageInfo<TmProductInfoVo>>();
        if (ajaxJson.getPageInfo() != null && ajaxJson.getPageInfo().getList() != null) {
            for (TmProductInfoVo tmProductInfoVo : ajaxJson.getPageInfo().getList()) {
                String saleUnit = DictUtil.getDictDataVal((String)"sale_unit", (String)tmProductInfoVo.getSaleUnit());
                String basicUnit = DictUtil.getDictDataVal((String)"basic_unit", (String)tmProductInfoVo.getBasicUnit());
                tmProductInfoVo.setSaleUnit(saleUnit);
                tmProductInfoVo.setBasicUnit(basicUnit);
            }
        }
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"addDataReport"})
    @ApiOperation(value="\u63d0\u4ea4\u6570\u636e", notes="terminalName\u95e8\u5e97\u540d\u5b57\u5fc5\u4f20\uff0cterminalCode\u95e8\u5e97\u7f16\u7801\u5fc5\u4f20\uff0cdataType\u6570\u636e\u7c7b\u578b\u5fc5\u4f20(0\u94fa\u8d27\uff0c1\u9500\u91cf\uff0c2\u5e93\u5b58\uff0c3\u7ade\u54c1)", httpMethod="POST")
    public Result addDataReport(@RequestBody TsDataReportVo vo) {
        AjaxJson ajaxJson = this.tsDataReportService.addDataReport(vo);
        Result result = new Result();
        result.setSuccess(ajaxJson.isSuccess());
        if (ajaxJson.isSuccess()) {
            result.setCode(Constant.resultCode.code_200.getValue());
        } else {
            result.setCode(Constant.resultCode.code_201.getValue());
        }
        result.setMsg(ajaxJson.getMsg());
        return result;
    }

    @PostMapping(value={"findDataHistoryList"})
    @ApiOperation(value="\u83b7\u53d6\u5386\u53f2\u4e0a\u62a5\u8bb0\u5f55", notes="dataType\u6570\u636e\u7c7b\u578b\u5fc5\u4f20(0\u94fa\u8d27\uff0c1\u9500\u91cf\uff0c2\u5e93\u5b58\uff0c3\u7ade\u54c1)", httpMethod="POST")
    public Result<PageInfo<TsDataReportEntity>> findDataHistoryList(@RequestBody TsDataReportVo vo, String page, String rows) {
        AjaxJson<TsDataReportEntity> ajaxJson = this.tsDataReportService.findDataHistoryList(vo, page, rows);
        Result<PageInfo<TsDataReportEntity>> result = new Result<PageInfo<TsDataReportEntity>>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"findDataReportInfo"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u4e0a\u62a5\u8be6\u60c5", notes="id\u5fc5\u4f20", httpMethod="POST")
    public Result<TsDataReportVo> findDataReportInfo(@RequestBody TsDataReportVo vo) {
        AjaxJson<TsDataReportVo> ajaxJson = this.tsDataReportService.findDataReportInfo(vo);
        Result<TsDataReportVo> result = new Result<TsDataReportVo>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj((TsDataReportVo)ajaxJson.getObj());
        return result;
    }
}

