/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.order.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.order.dao.TsCompetitiveDao;
import com.biz.eisp.order.dao.TsOrderDao;
import com.biz.eisp.order.dao.TsOrderItemDao;
import com.biz.eisp.order.entity.TsCompetitiveGoodsEntity;
import com.biz.eisp.order.entity.TsOrderEntity;
import com.biz.eisp.order.entity.TsOrderItemEntity;
import com.biz.eisp.order.service.TsOrderService;
import com.biz.eisp.order.vo.TsCompetitiveGoodsVo;
import com.biz.eisp.order.vo.TsOrderItemVo;
import com.biz.eisp.order.vo.TsOrderVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.params.Constant;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TsOrderServiceImpl
extends BaseServiceImpl<TsOrderEntity>
implements TsOrderService {
    @Autowired
    TsOrderDao tsOrderDao;
    @Autowired
    TsOrderItemDao tsOrderItemDao;
    @Autowired
    TsCompetitiveDao tsCompetitiveDao;

    @Override
    public PageInfo<TsOrderItemVo> findOrderItemList(TsOrderItemVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tsOrderItemDao.findOrderItemList(vo), (Page)page);
    }

    @Override
    public AjaxJson<TsOrderEntity> findOrderList(TsOrderVo vo, String page, String rows) {
        AjaxJson ajaxJson = new AjaxJson();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        EuPage page1 = new EuPage();
        if (StringUtil.isEmpty((String)page)) {
            page = "1";
        }
        if (StringUtil.isEmpty((String)rows)) {
            rows = "15";
        }
        page1.setPage(page);
        page1.setRows(rows);
        Example example1 = new Example(TsOrderEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getOrderSn())) {
            criteria1.andEqualTo("orderSn", (Object)vo.getOrderSn());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getCreateName())) {
            criteria1.andLike("createName", "%" + vo.getCreateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getTerminalName())) {
            criteria1.andLike("terminalName", "%" + vo.getTerminalName() + "%");
        }
        criteria1.andEqualTo("createBy", (Object)userRedis.getId());
        example1.orderBy("createDate").desc();
        List entities = this.tsOrderDao.selectByExample(example1);
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> entities, (Page)page1);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @Override
    public AjaxJson addOrder(TsOrderVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (vo.getItemVos() == null || vo.getItemVos().size() <= 0) {
            ajaxJson.setErrMsg("\u8ba2\u5355\u884c\u9879\u76ee\u5fc5\u4f20");
            return ajaxJson;
        }
        TsOrderEntity tsOrderEntity = new TsOrderEntity();
        BeanUtils.copyProperties((Object)vo, (Object)tsOrderEntity);
        tsOrderEntity.setEnableStatus(Constant.enableStatus.able.getValue());
        tsOrderEntity.setOrderDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        String code = CodeRuleUtil.getKnlCodingRulesString((String)"order_code");
        tsOrderEntity.setOrderSn(code);
        this.tsOrderDao.insertSelective(tsOrderEntity);
        List itemVoList = vo.getItemVos();
        Integer num = 0;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)itemVoList)) {
            for (TsOrderItemVo tsOrderItemVo : itemVoList) {
                TsOrderItemEntity tsOrderItemEntity = new TsOrderItemEntity();
                tsOrderItemVo.setId("");
                BeanUtils.copyProperties((Object)tsOrderItemVo, (Object)tsOrderItemEntity);
                tsOrderItemEntity.setOrderSn(tsOrderEntity.getOrderSn());
                tsOrderItemEntity.setProductCode(tsOrderItemVo.getProductInfoCode());
                tsOrderItemEntity.setProductName(tsOrderItemVo.getProductInfoName());
                num = num + (tsOrderItemVo.getNum() == null ? 0 : tsOrderItemVo.getNum());
                this.tsOrderItemDao.insertSelective(tsOrderItemEntity);
            }
        }
        tsOrderEntity.setOrderNum(String.valueOf(num));
        this.tsOrderDao.updateByPrimaryKeySelective(tsOrderEntity);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsOrderVo> findOrderDetail(TsOrderVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getOrderSn())) {
            ajaxJson.setErrMsg("\u8ba2\u5355\u7f16\u7801\u5fc5\u4f20");
            return ajaxJson;
        }
        Example example1 = new Example(TsOrderEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("orderSn", (Object)vo.getOrderSn());
        List orderList = this.tsOrderDao.selectByExample(example1);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)orderList)) {
            TsOrderEntity entity = (TsOrderEntity)orderList.get(0);
            TsOrderVo orderVo = new TsOrderVo();
            BeanUtils.copyProperties((Object)entity, (Object)orderVo);
            Example example = new Example(TsOrderItemEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("orderSn", (Object)vo.getOrderSn());
            List itemEntities = this.tsOrderItemDao.selectByExample(example);
            ArrayList<TsOrderItemVo> list = new ArrayList<TsOrderItemVo>();
            for (TsOrderItemEntity entity1 : itemEntities) {
                TsOrderItemVo vo1 = new TsOrderItemVo();
                BeanUtils.copyProperties((Object)entity1, (Object)vo1);
                vo1.setId(entity1.getId() + "");
                list.add(vo1);
            }
            orderVo.setItemVos(list);
            ajaxJson.setObj((Object)orderVo);
        }
        return ajaxJson;
    }

    @Override
    public PageInfo<TsCompetitiveGoodsVo> findCompetitiveList(TsCompetitiveGoodsVo vo, Page page) {
        Example example = new Example(TsCompetitiveGoodsEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getGoodCode())) {
            criteria.andEqualTo("goodCode", (Object)vo.getGoodCode());
        }
        List list = this.tsCompetitiveDao.selectByExample(example);
        return PageAutoHelperUtil.generatePage(() -> list, (Page)page);
    }

    @Override
    public TsCompetitiveGoodsVo findCompetitiveInfoById(String id) {
        TsCompetitiveGoodsVo vo = new TsCompetitiveGoodsVo();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            TsCompetitiveGoodsEntity entity = (TsCompetitiveGoodsEntity)this.tsCompetitiveDao.selectByPrimaryKey(id);
            BeanUtils.copyProperties((Object)entity, (Object)vo);
            vo.setId(entity.getId() + "");
        }
        return vo;
    }

    @Override
    public AjaxJson addCompetitiveGoods(TsCompetitiveGoodsVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isNotEmpty((CharSequence)vo.getId())) {
            TsCompetitiveGoodsEntity entity = (TsCompetitiveGoodsEntity)this.tsCompetitiveDao.selectByPrimaryKey(vo.getId());
            entity.setGoodBar(vo.getGoodBar());
            entity.setGoodName(vo.getGoodName());
            entity.setGoodUnit(vo.getGoodUnit());
            this.tsCompetitiveDao.updateByPrimaryKeySelective(entity);
        } else {
            TsCompetitiveGoodsEntity entity = new TsCompetitiveGoodsEntity();
            BeanUtils.copyProperties((Object)vo, (Object)entity);
            String code = CodeRuleUtil.getKnlCodingRulesString((String)"jp_code");
            entity.setGoodCode(code);
            this.tsCompetitiveDao.insertSelective(entity);
        }
        return ajaxJson;
    }
}

