/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.notice;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.kernel.KnlNoticeFeign;
import com.biz.eisp.notice.entity.KnlNoticeEntity;
import com.biz.eisp.notice.service.TsNoticeService;
import com.biz.eisp.params.Constant;
import com.biz.eisp.utils.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaApi/tsNoticeApiController"})
@Api(tags={"\u516c\u544a\u4fe1\u606f"})
public class TsNoticeApiController {
    @Autowired
    TsNoticeService tsNoticeService;
    @Autowired
    KnlNoticeFeign knlNoticeFeign;

    @PostMapping(value={"getKnlNoticeByPage"})
    @ApiOperation(value="\u83b7\u53d6\u516c\u544a\u5217\u8868", notes="map\u91cc\u9762\u653e\u67e5\u8be2\u6761\u4ef6\uff0ckey=noticeTitle(\u67e5\u8be2\u516c\u544a\u6807\u9898),\u65e0\u7b5b\u9009\u6761\u4ef6\u4f20\u7a7aMap \u4f8b\u5982{}\uff0c\u4e0d\u80fd\u76f4\u63a5\u4f20null", httpMethod="POST")
    public Result<PageInfo<KnlNoticeEntity>> getKnlNoticeByPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = this.knlNoticeFeign.getKnlNoticeByPage(param);
        Result<PageInfo<KnlNoticeEntity>> result = new Result<PageInfo<KnlNoticeEntity>>();
        result.setSuccess(ajaxJson.isSuccess());
        if (ajaxJson.isSuccess()) {
            result.setCode(Constant.resultCode.code_200.getValue());
        } else {
            result.setCode(Constant.resultCode.code_201.getValue());
        }
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"getKnlNoticeByParamObj"})
    @ApiOperation(value="\u83b7\u53d6\u516c\u544a\u8be6\u60c5", notes="id\u5fc5\u4f20", httpMethod="POST")
    public Result<KnlNoticeEntity> getKnlNoticeByParamObj(String id) {
        Result<KnlNoticeEntity> result = new Result<KnlNoticeEntity>();
        if (StringUtil.isEmpty((String)id)) {
            result.setCode(Constant.resultCode.code_201.getValue());
            result.setMsg("id\u4e0d\u80fd\u4e3a\u7a7a");
            result.setSuccess(false);
        } else {
            AjaxJson ajaxJson = this.knlNoticeFeign.getKnlNoticeByParamObj(id);
            result.setSuccess(ajaxJson.isSuccess());
            if (ajaxJson.isSuccess()) {
                result.setCode(Constant.resultCode.code_200.getValue());
            } else {
                result.setCode(Constant.resultCode.code_201.getValue());
            }
            result.setMsg(ajaxJson.getMsg());
            result.setObj((KnlNoticeEntity)ajaxJson.getObj());
        }
        return result;
    }
}

