/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.worktrack.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.api.feign.BusareaFeign;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.attendance.dao.TsWorkSignDao;
import com.biz.eisp.attendance.vo.TsWorkSignVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.busarea.TmBusinessAreaVo;
import com.biz.eisp.sfa.worktrack.WorkTrackMongoFegin;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.worktrack.core.TrackHandler;
import com.biz.eisp.worktrack.entity.TrackPointMongoEntity;
import com.biz.eisp.worktrack.enums.CoordType;
import com.biz.eisp.worktrack.enums.PointType;
import com.biz.eisp.worktrack.enums.TrackTypeEnum;
import com.biz.eisp.worktrack.model.LatLng;
import com.biz.eisp.worktrack.model.TrackPoint;
import com.biz.eisp.worktrack.service.TsWorkTrackService;
import com.biz.eisp.worktrack.track.AddPointsRequest;
import com.biz.eisp.worktrack.track.BasePoint;
import com.biz.eisp.worktrack.track.UploadResponse;
import com.biz.eisp.worktrack.track.trackarea.TrackAreaResultVo;
import com.biz.eisp.worktrack.track.trackarea.TrackAreaVo;
import com.biz.eisp.worktrack.track.trackquery.QueryPoint;
import com.biz.eisp.worktrack.track.trackquery.ResultPoint;
import com.biz.eisp.worktrack.track.trackterminal.TrackTerminalLastVo;
import com.biz.eisp.worktrack.track.trackterminal.TrackTerminalVo;
import com.biz.eisp.worktrack.util.ReflectClassUtil;
import com.biz.eisp.worktrack.util.TimeUtils;
import com.biz.eisp.worktrack.util.YingYanUtil;
import com.biz.eisp.worktrack.vo.AddTerminalPointVo;
import com.biz.eisp.worktrack.vo.AddTerminalVo;
import com.biz.eisp.worktrack.vo.BaiduYingyanQueryTerminalVo;
import com.biz.eisp.worktrack.vo.CountUserVo;
import com.biz.eisp.worktrack.vo.GetTrackPramsVo;
import com.biz.eisp.worktrack.vo.GetTrackVo;
import com.biz.eisp.worktrack.vo.TrackByDateAndTypePramsVo;
import com.biz.eisp.worktrack.vo.TrackByDateAndTypeReturnVo;
import com.biz.eisp.worktrack.vo.TrackByDatePramsVo;
import com.biz.eisp.worktrack.vo.TrackByDateReturnVo;
import com.biz.eisp.worktrack.vo.TrackDistancePramsVo;
import com.biz.eisp.worktrack.vo.TrackDistanceReturnVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tsWorkTrackService")
@Transactional
public class TsWorkTrackServiceImpl
implements TsWorkTrackService {
    private static final Logger log = LoggerFactory.getLogger(TsWorkTrackServiceImpl.class);
    @Autowired
    TsWorkSignDao tsWorkSignDao;
    private static AtomicLong mSequenceGenerator = new AtomicLong();
    @Value(value="${track.baidu-yingyan-ak-s}")
    private String BAIDU_YINGYAN_AK_S;
    @Value(value="${track.baidu-yingyan-service-id}")
    private long BAIDU_YINGYAN_SERVICE_ID;
    @Value(value="${track.baidu-yingyan-url}")
    private String BAIDU_YINGYAN_URL;
    @Autowired
    private BusareaFeign busareaFeign;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private WorkTrackMongoFegin workTrackMongoFegin;

    @Override
    public AjaxJson addWorkTrackEntity(AddTerminalVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        HashMap<String, Object> map = null;
        try {
            map = ReflectClassUtil.Reflect(vo);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
            throw new BusinessException("\u53cd\u5c04\u83b7\u53d6\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        String urlReq = this.BAIDU_YINGYAN_URL + "entity/add";
        String param = "ak=" + this.BAIDU_YINGYAN_AK_S + "&service_id=" + this.BAIDU_YINGYAN_SERVICE_ID;
        for (String key : map.keySet()) {
            if (!StringUtil.isNotEmpty((Object)map.get(key))) continue;
            param = param + "&" + key + "=" + map.get(key);
        }
        String returnStr = YingYanUtil.yingYanReq(urlReq, param, "POST");
        JSONObject returnJson = JSONObject.parseObject((String)returnStr);
        if (returnJson.containsKey((Object)"status") && returnJson.getString("status").equals("0")) {
            ajaxJson.setSuccess(true);
            ajaxJson.setMsg(returnJson.getString("message"));
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson updateWorkTrackEntity(AddTerminalVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getEntity_name())) {
            ajaxJson.setMsg("\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            ajaxJson.setSuccess(false);
            return ajaxJson;
        }
        HashMap<String, Object> map = null;
        try {
            map = ReflectClassUtil.Reflect(vo);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
            throw new BusinessException("\u53cd\u5c04\u83b7\u53d6\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        String urlReq = this.BAIDU_YINGYAN_URL + "entity/update";
        String param = "ak=" + this.BAIDU_YINGYAN_AK_S + "&service_id=" + this.BAIDU_YINGYAN_SERVICE_ID;
        for (String key : map.keySet()) {
            if (!StringUtil.isNotEmpty((Object)map.get(key))) continue;
            param = param + "&" + key + "=" + map.get(key);
        }
        String returnStr = YingYanUtil.yingYanReq(urlReq, param, "POST");
        JSONObject returnJson = JSONObject.parseObject((String)returnStr);
        if (returnJson.containsKey((Object)"status") && returnJson.getString("status").equals("0")) {
            ajaxJson.setSuccess(true);
            ajaxJson.setMsg(returnJson.getString("message"));
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson deleteWorkTrackEntity(String entity_name) {
        String param;
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)entity_name)) {
            ajaxJson.setMsg("\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            ajaxJson.setSuccess(false);
            return ajaxJson;
        }
        String urlReq = this.BAIDU_YINGYAN_URL + "entity/delete";
        String returnStr = YingYanUtil.yingYanReq(urlReq, param = "ak=" + this.BAIDU_YINGYAN_AK_S + "&service_id=" + this.BAIDU_YINGYAN_SERVICE_ID + "&entity_name=" + entity_name, "POST");
        JSONObject returnJson = JSONObject.parseObject((String)returnStr);
        if (returnJson.containsKey((Object)"status") && returnJson.getString("status").equals("0")) {
            ajaxJson.setSuccess(true);
            ajaxJson.setMsg(returnJson.getString("message"));
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson listWorkTrackEntity(BaiduYingyanQueryTerminalVo vo) {
        AjaxJson userJson;
        AjaxJson ajaxJson = new AjaxJson();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("page", vo.getPage_index());
        param.put("rows", vo.getPage_size());
        param.put("userType", "0");
        if (StringUtil.isNotEmpty((CharSequence)vo.getEntity_desc())) {
            param.put("realName", vo.getEntity_desc());
        }
        if (!(userJson = this.tmUserFeign.getAllUserAndPositionList(param)).isSuccess()) {
            ajaxJson.setSuccess(userJson.isSuccess());
            ajaxJson.setMsg("\u8bf7\u6c42\u7528\u6237\u5217\u8868\u5931\u8d25:" + userJson.getMsg());
        }
        PageInfo userList = userJson.getPageInfo();
        int size = userList.getSize();
        long totalSize = userList.getTotal();
        TrackTerminalVo result = new TrackTerminalVo();
        List list = userList.getList();
        String userIds = this.buliduserIds(list);
        AjaxJson children = this.workTrackMongoFegin.queryUserList(userIds);
        if (!children.isSuccess()) {
            ajaxJson.setSuccess(children.isSuccess());
            ajaxJson.setMsg("\u8bf7\u6c42mongo\u5931\u8d25:" + children.getMsg());
        }
        List childrenResult = children.getObjList();
        List<TrackTerminalLastVo> res = this.setProperties(childrenResult, list);
        result.setEntities(res);
        result.setTotal(new Long(totalSize).intValue());
        result.setSize(size);
        ajaxJson.setData((Object)result);
        return ajaxJson;
    }

    private List<TrackTerminalLastVo> setProperties(List<TrackTerminalLastVo> childrenResult, List<TmUserVo> list) {
        ArrayList<TrackTerminalLastVo> result = new ArrayList<TrackTerminalLastVo>();
        for (TmUserVo v : list) {
            TrackTerminalLastVo vt = new TrackTerminalLastVo();
            vt.setOrg_name(v.getOrgName());
            vt.setPosition_name(v.getPosName());
            vt.setEntity_desc(v.getFullname());
            vt.setEntity_name(v.getId());
            for (TrackTerminalLastVo vo : childrenResult) {
                if (!vo.getEntity_name().equals(v.getId())) continue;
                vt.setLatest_location(vo.getLatest_location());
                BigDecimal b = new BigDecimal(vo.getDistance());
                double f1 = b.setScale(2, 4).doubleValue();
                vt.setDistance(f1);
                String trackStatus = this.judgeTrackStatus(vo);
                vt.setTrackStatus(trackStatus);
            }
            result.add(vt);
        }
        return result;
    }

    private String buliduserIds(List<TmUserVo> list) {
        String ids = "";
        for (TmUserVo num : list) {
            if (num == null) continue;
            ids = ids + num.getId() + ",";
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 1);
        }
        return ids;
    }

    private AjaxJson validateResult(AjaxJson ajaxJson, JSONObject returnJson) {
        if (returnJson.containsKey((Object)"status") && returnJson.getString("status").equals("0")) {
            ajaxJson.setSuccess(true);
            ajaxJson.setMsg(returnJson.getString("message"));
        } else {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(returnJson.getString("message"));
        }
        return ajaxJson;
    }

    private Double getTrackDistance(String entityName, String toDay) {
        AjaxJson json = this.workTrackMongoFegin.queryDistance(entityName, toDay);
        return (Double)json.getObj();
    }

    private String judgeTrackStatus(TrackTerminalLastVo vo1) {
        if (vo1.getLatest_location() == null) {
            return TrackTypeEnum.exceptionStatus.getValue();
        }
        if (vo1.getPointNum() == 0L) {
            return TrackTypeEnum.inLocationStatus.getValue();
        }
        if (vo1.getPointNum() > 0L && vo1.getPointNum() < 30L) {
            return TrackTypeEnum.exceptionStatus.getValue();
        }
        if (vo1.getPointNum() >= 30L && vo1.getPointNum() < 1000L) {
            return TrackTypeEnum.incompleteStatus.getValue();
        }
        return TrackTypeEnum.formalStatus.getValue();
    }

    @Override
    public AjaxJson addWorkTrackPoints(AddTerminalPointVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        String userId = UserUtils.getUser().getId();
        String fullName = UserUtils.getUser().getRealname();
        String positionName = UserUtils.getUser().getPosName();
        String orgId = UserUtils.getUser().getOrgId();
        ArrayList<TrackPoint> trackPoints = new ArrayList<TrackPoint>();
        TrackPoint t = new TrackPoint();
        t.setEntityName(userId);
        HashMap<String, String> columns = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((CharSequence)vo.getProvince())) {
            columns.put("province", vo.getProvince());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getCity())) {
            columns.put("city", vo.getCity());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getArea())) {
            columns.put("area", vo.getArea());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getAddress())) {
            columns.put("address", vo.getAddress());
        }
        LatLng location = new LatLng(vo.getLatitude(), vo.getLongitude());
        t.setLocation(location);
        t.setColumns(columns);
        t.setLocTime(System.currentTimeMillis() / 1000L);
        t.setCoordType(CoordType.bd09ll);
        trackPoints.add(t);
        TrackPointMongoEntity entity = new TrackPointMongoEntity();
        entity.setUserId(userId);
        entity.setFullName(fullName);
        entity.setPositionName(positionName);
        entity.setOrgId(orgId);
        entity.setProvince(vo.getProvince());
        entity.setCity(vo.getCity());
        entity.setArea(vo.getArea());
        entity.setAddress(vo.getAddress());
        entity.setLatitude(vo.getLatitude());
        entity.setLongitude(vo.getLongitude());
        entity.setCreateDate(new Date());
        String dateStr = DateUtils.getDataString((SimpleDateFormat)DateUtils.date_sdf);
        String timeStr = DateUtils.getDataString((SimpleDateFormat)DateUtils.short_time_sdf);
        entity.setDateStr(dateStr);
        entity.setTimeStr(timeStr);
        entity.setLocTime(System.currentTimeMillis() / 1000L);
        entity.setLocType(CoordType.bd09ll.getValue());
        AjaxJson mongoResult = this.workTrackMongoFegin.savePoints(entity);
        if (mongoResult.isSuccess()) {
            AddPointsRequest request = new AddPointsRequest(mSequenceGenerator.incrementAndGet(), this.BAIDU_YINGYAN_AK_S, this.BAIDU_YINGYAN_SERVICE_ID, trackPoints);
            UploadResponse response = TrackHandler.addPoints(request);
            if (response.getStatus() == 0) {
                ajaxJson.setSuccess(true);
                ajaxJson.setMsg(response.getMessage());
            } else {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg(response.getMessage());
            }
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson getTrack(GetTrackPramsVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        AjaxJson result = this.workTrackMongoFegin.queryTracksByMongo(vo);
        if (result.isSuccess()) {
            ajaxJson.setSuccess(true);
            ajaxJson.setMsg(result.getMsg());
            List tacks = result.getObjList();
            ResultPoint resultPoint = this.bulidResult(tacks);
            this.bulidMsgForResultPoint(resultPoint, vo.getEntityName());
            ajaxJson.setData((Object)resultPoint);
        } else {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(result.getMsg());
        }
        return ajaxJson;
    }

    private ResultPoint bulidResult(List<TrackPointMongoEntity> tacks) {
        ResultPoint resultPoint = new ResultPoint();
        ArrayList<BasePoint> points = new ArrayList<BasePoint>();
        for (TrackPointMongoEntity entity : tacks) {
            BasePoint point = new BasePoint();
            point.setProvince(entity.getProvince());
            point.setCity(entity.getCity());
            point.setArea(entity.getArea());
            point.setAddress(entity.getAddress());
            point.setLatitude(entity.getLatitude());
            point.setLongitude(entity.getLongitude());
            point.setCreate_time(entity.getDateStr() + " " + entity.getTimeStr());
            point.setLoc_time(entity.getLocTime());
            point.setCoord_type(CoordType.bd09ll.getValue());
            point.setPointType(PointType.trackpoint.getValue());
            point.setPointTypeMsg(PointType.trackpoint.getName());
            points.add(point);
        }
        resultPoint.setPoints(points);
        return resultPoint;
    }

    private String queryTrack(GetTrackVo vo) {
        String urlReq = this.BAIDU_YINGYAN_URL + "track/gettrack";
        String param = "ak=" + this.BAIDU_YINGYAN_AK_S + "&service_id=" + this.BAIDU_YINGYAN_SERVICE_ID;
        HashMap<String, Object> map = null;
        try {
            map = ReflectClassUtil.Reflect(vo);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
            throw new BusinessException("\u53cd\u5c04\u83b7\u53d6\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        for (String key : map.keySet()) {
            if (!StringUtil.isNotEmpty((Object)map.get(key))) continue;
            param = param + "&" + key + "=" + map.get(key);
        }
        String returnStr = YingYanUtil.yingYanReq(urlReq, param, "GET");
        return returnStr;
    }

    private void bulidMsgForResultPoint(ResultPoint resultPoint, String userId) {
        TsWorkSignVo vo = new TsWorkSignVo();
        List basePoints = resultPoint.getPoints();
        vo.setCreateBy(userId);
        List<TsWorkSignVo> list = this.tsWorkSignDao.selectTodayData(vo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.stream().forEach(signVo -> {
                BasePoint point = new BasePoint();
                point.setLatitude(signVo.getLatIn().doubleValue());
                point.setLongitude(signVo.getLngIn().doubleValue());
                basePoints.add(point);
            });
        }
    }

    @Override
    public AjaxJson getTrackArea() {
        AjaxJson ajaxJson = new AjaxJson();
        String urlReq = this.BAIDU_YINGYAN_URL + "entity/districtsearch";
        String param = "ak=" + this.BAIDU_YINGYAN_AK_S + "&service_id=" + this.BAIDU_YINGYAN_SERVICE_ID;
        AjaxJson aj = this.busareaFeign.getBusareaList(null, null, "1");
        ArrayList<TrackAreaResultVo> resultList = new ArrayList<TrackAreaResultVo>();
        List queryList = aj.getObjList();
        for (TmBusinessAreaVo vo : queryList) {
            String tempParma = param;
            String returnStr = YingYanUtil.yingYanReq(urlReq, tempParma = tempParma + "&keyword=" + vo.getName(), "GET");
            TrackAreaVo result = (TrackAreaVo)JSONObject.parseObject((String)returnStr, TrackAreaVo.class);
            if (result.getStatus() != 0 || !CollectionUtil.listNotEmptyNotSizeZero((List)result.getEntities())) continue;
            TrackAreaResultVo r = new TrackAreaResultVo();
            r.setArea(vo.getName());
            r.setSize(result.getSize());
            if (StringUtil.isNotEmpty((CharSequence)vo.getLatitude())) {
                r.setCenterLatitude(Double.valueOf(vo.getLatitude()).doubleValue());
            }
            if (StringUtil.isNotEmpty((CharSequence)vo.getLongitude())) {
                r.setCenterLongitude(Double.valueOf(vo.getLongitude()).doubleValue());
            }
            r.setEntities(result.getEntities());
            resultList.add(r);
        }
        ajaxJson.setList(resultList);
        return ajaxJson;
    }

    @Override
    public AjaxJson getTrackDistanceByEntityName(TrackDistancePramsVo vo) {
        AjaxJson json = new AjaxJson();
        ArrayList<TrackDistanceReturnVo> results = new ArrayList<TrackDistanceReturnVo>();
        List<String> currentDayTimes = this.getPeroidTime(20);
        for (String t : currentDayTimes) {
            Double distance = this.getTrackDistance(vo.getEntityName(), t);
            TrackDistanceReturnVo v = new TrackDistanceReturnVo();
            v.setDateStr(t);
            v.setDistance(distance);
            v.setEntityName(vo.getEntityName());
            results.add(v);
        }
        json.setList(results);
        return json;
    }

    @Override
    public AjaxJson getTrackByDate(TrackByDatePramsVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("page", 1);
        param.put("rows", 10000);
        param.put("userType", "0");
        AjaxJson userJson = this.tmUserFeign.getAllUserAndPositionList(param);
        if (!userJson.isSuccess()) {
            ajaxJson.setSuccess(userJson.isSuccess());
            ajaxJson.setMsg("\u8bf7\u6c42\u7528\u6237\u5217\u8868\u5931\u8d25:" + userJson.getMsg());
        }
        PageInfo userList = userJson.getPageInfo();
        int size = userList.getSize();
        TrackTerminalVo result = new TrackTerminalVo();
        List list = userList.getList();
        result.setSize(size);
        result.setTotal(size);
        AjaxJson ajaxJsonUsers = this.workTrackMongoFegin.queryPointGroupByUserAndDateStr(vo.getDateStr());
        if (!ajaxJsonUsers.isSuccess()) {
            ajaxJson.setSuccess(ajaxJsonUsers.isSuccess());
            ajaxJson.setMsg("\u8bf7\u6c42\u7528\u6237\u8f68\u8ff9\u70b9\u5931\u8d25:" + ajaxJsonUsers.getMsg());
        }
        List countUserVos = ajaxJsonUsers.getObjList();
        TrackByDateReturnVo returnVo = new TrackByDateReturnVo();
        int excetionNum = 0;
        int formalNum = 0;
        int incompleteNum = 0;
        int inLocationNum = 0;
        for (TmUserVo v : list) {
            long tempCount = 0L;
            for (CountUserVo countUserVo : countUserVos) {
                if (!v.getId().equals(countUserVo.getUserId())) continue;
                tempCount = countUserVo.getCount();
            }
            if (tempCount == 0L) {
                ++inLocationNum;
                continue;
            }
            if (tempCount > 0L && tempCount < 30L) {
                ++excetionNum;
                continue;
            }
            if (tempCount >= 30L && tempCount < 1000L) {
                ++incompleteNum;
                continue;
            }
            if (tempCount < 1000L) continue;
            ++formalNum;
        }
        returnVo.setExcetionNum(excetionNum);
        returnVo.setFormalNum(formalNum);
        returnVo.setIncompleteNum(incompleteNum);
        returnVo.setInLocationNum(inLocationNum);
        ajaxJson.setData((Object)returnVo);
        return ajaxJson;
    }

    @Override
    public AjaxJson getTrackByDateAndType(TrackByDateAndTypePramsVo vo) {
        String param;
        AjaxJson ajaxJson = new AjaxJson();
        String urlReq = this.BAIDU_YINGYAN_URL + "entity/list";
        String returnStr = YingYanUtil.yingYanReq(urlReq, param = "ak=" + this.BAIDU_YINGYAN_AK_S + "&service_id=" + this.BAIDU_YINGYAN_SERVICE_ID, "GET");
        JSONObject returnJson = JSONObject.parseObject((String)returnStr);
        if (!(ajaxJson = this.validateResult(ajaxJson, returnJson)).isSuccess()) {
            return ajaxJson;
        }
        TrackTerminalVo result = (TrackTerminalVo)JSONObject.parseObject((String)returnStr, TrackTerminalVo.class);
        List list = result.getEntities();
        TrackByDateAndTypeReturnVo returnVo = new TrackByDateAndTypeReturnVo();
        int excetionNum = 0;
        int formalNum = 0;
        int incompleteNum = 0;
        int inLocationNum = 0;
        ArrayList<TrackTerminalLastVo> excetionList = new ArrayList<TrackTerminalLastVo>();
        ArrayList<TrackTerminalLastVo> formalList = new ArrayList<TrackTerminalLastVo>();
        ArrayList<TrackTerminalLastVo> incompleteList = new ArrayList<TrackTerminalLastVo>();
        ArrayList<TrackTerminalLastVo> inLocationList = new ArrayList<TrackTerminalLastVo>();
        for (TrackTerminalLastVo v : list) {
            GetTrackVo vt = new GetTrackVo();
            vt.setEntity_name(v.getEntity_name());
            vt.setStart_time(DateUtils.Date2TimeStamp((String)TimeUtils.dateStartStr(vo.getDateStr()), (String)"yyyy-MM-dd HH:mm:ss"));
            vt.setEnd_time(DateUtils.Date2TimeStamp((String)TimeUtils.dateEndStr(vo.getDateStr()), (String)"yyyy-MM-dd HH:mm:ss"));
            String returnStrTemp = this.queryTrack(vt);
            QueryPoint resultTemp = (QueryPoint)JSONObject.parseObject((String)returnStrTemp, QueryPoint.class);
            if (resultTemp.getSize() == 0) {
                ++excetionNum;
                excetionList.add(v);
                continue;
            }
            if (resultTemp.getSize() > 30 && resultTemp.getSize() < 1000) {
                ++incompleteNum;
                incompleteList.add(v);
                continue;
            }
            if (resultTemp.getSize() >= 1000) {
                ++formalNum;
                formalList.add(v);
                continue;
            }
            ++inLocationNum;
            inLocationList.add(v);
        }
        returnVo.setExcetionNum(excetionNum);
        returnVo.setFormalNum(formalNum);
        returnVo.setIncompleteNum(incompleteNum);
        returnVo.setInLocationNum(inLocationNum);
        if (TrackTypeEnum.exceptionStatus.getValue().equals(vo.getTrackStatus())) {
            returnVo.setSize(excetionNum);
            excetionList.stream().forEach(o -> o.setTrackStatus(TrackTypeEnum.exceptionStatus.getName()));
            returnVo.setTerminals(excetionList);
        }
        if (TrackTypeEnum.incompleteStatus.getValue().equals(vo.getTrackStatus())) {
            returnVo.setSize(incompleteNum);
            incompleteList.stream().forEach(o -> o.setTrackStatus(TrackTypeEnum.incompleteStatus.getName()));
            returnVo.setTerminals(incompleteList);
        }
        if (TrackTypeEnum.formalStatus.getValue().equals(vo.getTrackStatus())) {
            returnVo.setSize(formalNum);
            formalList.stream().forEach(o -> o.setTrackStatus(TrackTypeEnum.formalStatus.getName()));
            returnVo.setTerminals(formalList);
        }
        if (TrackTypeEnum.inLocationStatus.getValue().equals(vo.getTrackStatus())) {
            returnVo.setSize(inLocationNum);
            inLocationList.stream().forEach(o -> o.setTrackStatus(TrackTypeEnum.inLocationStatus.getName()));
            returnVo.setTerminals(inLocationList);
        }
        ajaxJson.setData((Object)returnVo);
        return ajaxJson;
    }

    public List<String> getPeroidTime(int dayLenght) {
        ArrayList<String> time = new ArrayList<String>();
        int MDAY = 0;
        String tday = "";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        for (int i = 0; i < dayLenght; ++i) {
            MDAY = day - i;
            if (MDAY >= 0) {
                c.set(5, MDAY);
                tday = df.format(c.getTime());
            } else {
                c.set(1, year);
                c.set(2, month - 2);
                int maximum = c.getActualMaximum(5);
                c.set(5, maximum + MDAY);
                tday = df.format(c.getTime());
            }
            time.add(tday);
        }
        return time;
    }
}

