/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.worktrack.core;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.worktrack.core.HttpClient;
import com.biz.eisp.worktrack.model.BaseRequest;
import com.biz.eisp.worktrack.model.BaseResponse;
import com.biz.eisp.worktrack.model.TrackPoint;
import com.biz.eisp.worktrack.track.AddPointRequest;
import com.biz.eisp.worktrack.track.AddPointsRequest;
import com.biz.eisp.worktrack.track.UploadResponse;
import com.biz.eisp.worktrack.util.CommonUtils;
import com.biz.eisp.worktrack.util.TrackUtils;

public class TrackHandler {
    public static void addPoint(AddPointRequest request) {
        StringBuilder parameters = new StringBuilder();
        TrackHandler.packRequest((BaseRequest)request, parameters);
        String result = HttpClient.sendRequest("track/addpoints", parameters.toString(), "POST");
        TrackHandler.parseResponse(request.getRequestID(), "track/addpoints", result);
    }

    public static UploadResponse addPoints(AddPointsRequest request) {
        StringBuilder parameters = new StringBuilder();
        TrackHandler.packRequest((BaseRequest)request, parameters);
        String result = HttpClient.sendRequest("track/addpoints", parameters.toString(), "POST");
        UploadResponse response = TrackHandler.parseResponse(request.getRequestID(), "track/addpoints", result);
        return response;
    }

    public static void packRequest(BaseRequest request, StringBuilder parameters) {
        if (null == request) {
            throw new BusinessException("request can not be null.");
        }
        TrackHandler.packCommonRequest(request, parameters);
        if (request instanceof AddPointRequest) {
            AddPointRequest addPointRequest = (AddPointRequest)request;
            TrackPoint trackPoint = addPointRequest.getTrackPoint();
            if (null == trackPoint) {
                throw new BusinessException("trackPoint can not be null.");
            }
            TrackUtils.packPoint(trackPoint, parameters);
        } else {
            AddPointsRequest addPointsRequest = (AddPointsRequest)request;
            TrackUtils.packPoints(addPointsRequest.getTrackPoints(), parameters);
        }
    }

    private static void packCommonRequest(BaseRequest request, StringBuilder parameters) {
        if (CommonUtils.isNullOrEmpty(request.getAk())) {
            throw new BusinessException("ak can not be null or empty string.");
        }
        if (request.getServiceId() <= 0L) {
            throw new BusinessException("serviceId is lower than 0.");
        }
        parameters.append("ak=").append(request.getAk());
        parameters.append("&service_id=").append(request.getServiceId());
    }

    public static UploadResponse parseResponse(long requestId, String action, String result) {
        UploadResponse response = new UploadResponse(requestId, 0, "success");
        TrackHandler.parseCommonResponse((BaseResponse)response, result);
        return response;
    }

    private static void parseCommonResponse(BaseResponse response, String result) {
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject.containsKey((Object)"status")) {
                response.setStatus(jsonObject.getIntValue("status"));
            }
            if (jsonObject.containsKey((Object)"message")) {
                response.setMessage(jsonObject.getString("message"));
            }
        }
        catch (Exception e) {
            response.setStatus(-2);
            response.setMessage("\u89e3\u6790\u5931\u8d25");
        }
    }
}

