/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.api.mdm;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TagUtil;
import com.biz.eisp.product.TmProductVo;
import com.biz.eisp.tree.TreeGrid;
import com.biz.eisp.tree.TreeGridModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/tmApiProductLevelController"})
@Controller
public class TmApiProductLevelController {
    @Autowired
    private MdmApiFeign mdmApiFeign;

    @RequestMapping(value={"goProductListMain"})
    public ModelAndView goProductListMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/api/mdm/TmProductListMain");
    }

    @RequestMapping(value={"getTmProductEntityTree"})
    @ResponseBody
    public List<TreeGrid> getTmProductEntityTree(TmProductVo tmProductEntity) {
        List<TreeGrid> treeGrids = this.findTmProductList(tmProductEntity);
        return treeGrids;
    }

    private List<TreeGrid> treeGridModel(List<TmProductVo> productList) {
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("productCode");
        treeGridModel.setSrc("productName");
        treeGridModel.setParentId("parentId");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tmProductList");
        List<TreeGrid> treeGrids = this.treegrid(productList, treeGridModel);
        return treeGrids;
    }

    private List<TreeGrid> treegrid(List all, TreeGridModel treeGridModel) {
        ArrayList<TreeGrid> treegrid = new ArrayList<TreeGrid>();
        for (Object obj : all) {
            List childList;
            Object icon;
            ReflectHelper reflectHelper = new ReflectHelper(obj);
            TreeGrid tg = new TreeGrid();
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getCode())) {
                String code = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getCode()));
                tg.setCode(code);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getOrder())) {
                String order = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getOrder()));
                tg.setOrder(order);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getIdField())) {
                String id = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getIdField()));
                tg.setId(id);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getSrc())) {
                String src = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getSrc()));
                tg.setSrc(src);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getTextField())) {
                String text = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getTextField()));
                tg.setText(text);
            }
            if (treeGridModel.getParentId() != null) {
                Object pid = TagUtil.fieldNametoValues((String)treeGridModel.getParentId(), obj);
                if (pid != null) {
                    tg.setParentId(pid.toString());
                } else {
                    tg.setParentId("");
                }
            }
            if (treeGridModel.getIcon() != null && (icon = TagUtil.fieldNametoValues((String)treeGridModel.getIcon(), obj)) != null) {
                tg.setIcon(icon.toString());
            }
            if ((childList = (List)reflectHelper.getMethodValue(treeGridModel.getChildList())) != null && childList.size() > 0) {
                tg.setState("closed");
            }
            if (treeGridModel.getFieldMap() != null) {
                tg.setFieldMap(new HashMap());
                for (Map.Entry entry : treeGridModel.getFieldMap().entrySet()) {
                    Object fieldValue = reflectHelper.getMethodValue(entry.getValue().toString());
                    tg.getFieldMap().put(entry.getKey(), fieldValue);
                }
            }
            treegrid.add(tg);
        }
        return treegrid;
    }

    public List<TreeGrid> findTmProductList(TmProductVo tmProductEntity) {
        List<TreeGrid> treeGrids = null;
        String productId = tmProductEntity.getId();
        String productCode = tmProductEntity.getProductCode();
        AjaxJson ajaxJson = null;
        if (StringUtils.isNotBlank((CharSequence)productId)) {
            ajaxJson = this.mdmApiFeign.getProductList(productId, productCode);
            if (ajaxJson != null) {
                for (TmProductVo productEntity : ajaxJson.getObjList()) {
                    treeGrids = this.treeGridModel(productEntity.getTmProductList());
                }
            }
        } else {
            ajaxJson = this.mdmApiFeign.getProductList(productId, productCode);
            if (ajaxJson != null) {
                treeGrids = this.treeGridModel(ajaxJson.getObjList());
            }
        }
        return treeGrids;
    }
}

