/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.collection.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.collection.dao.TsInputConfigDao;
import com.biz.eisp.collection.dao.TsRDirectoryInputDao;
import com.biz.eisp.collection.entity.TsInputConfigEntity;
import com.biz.eisp.collection.entity.TsRDirectoryInputEntity;
import com.biz.eisp.collection.service.TsInputConfigService;
import com.biz.eisp.collection.transformer.TsInputConfigVoToTsInputConfigEntity;
import com.biz.eisp.collection.vo.TsInputConfigVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="tsInputConfigService")
@Transactional
public class TsInputConfigServiceImpl
extends BaseServiceImpl<TsInputConfigEntity>
implements TsInputConfigService {
    @Autowired
    private TsInputConfigDao tsInputConfigDao;
    @Autowired
    private TsRDirectoryInputDao tsRDirectoryInputDao;

    @Override
    public PageInfo<TsInputConfigEntity> findTsInputConfigVoList(TsInputConfigVo tsInputConfigVo, List<String> ids, Page page) {
        tsInputConfigVo.setIds(ids);
        return PageAutoHelperUtil.generatePage(() -> this.tsInputConfigDao.findTsInputConfigVoList(tsInputConfigVo), (Page)page);
    }

    @Override
    public TsInputConfigEntity getTsInputConfig(String id) {
        TsInputConfigEntity entity = (TsInputConfigEntity)this.tsInputConfigDao.selectByPrimaryKey(id);
        return entity;
    }

    @Override
    public void saveTsInputConfig(TsInputConfigVo tsInputConfigVo) {
        TsInputConfigEntity entity = new TsInputConfigVoToTsInputConfigEntity(this).apply(tsInputConfigVo);
        if (StringUtil.isEmpty((String)entity.getLableCode())) {
            entity.setLableCode(CodeRuleUtil.getKnlCodingRulesString((String)"lable_code"));
        }
        if (entity.getId() != null && entity.getId() > 0) {
            this.updateByPrimaryKeySelective(entity);
        } else {
            this.save(entity);
        }
    }

    @Override
    public List<TsInputConfigEntity> getListByNameAndType(String id, String lableName, String inputType) {
        Example example = new Example(TsInputConfigEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("lableName", (Object)lableName);
        criteria.andEqualTo("inputType", (Object)inputType);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            criteria.andNotEqualTo("id", (Object)id);
        }
        return this.tsInputConfigDao.selectByExample(example);
    }

    @Override
    public boolean doBatchDel(Integer ids) {
        Example example = new Example(TsRDirectoryInputEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("lableId", (Object)ids);
        List list = this.tsRDirectoryInputDao.selectByExample(example);
        if (list != null && list.size() > 0) {
            return false;
        }
        this.tsInputConfigDao.deleteByPrimaryKey(ids);
        return true;
    }

    @Override
    public String getInputType(Integer lableId) {
        TsInputConfigEntity entity = (TsInputConfigEntity)this.tsInputConfigDao.selectByPrimaryKey(lableId);
        if (entity != null) {
            return entity.getInputType();
        }
        return "";
    }
}

