/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.attendance;

import com.biz.eisp.attendance.entity.TsFreesignConfigEntity;
import com.biz.eisp.attendance.entity.TsLeaveEntity;
import com.biz.eisp.attendance.entity.TsSignTypeEntity;
import com.biz.eisp.attendance.service.TsWorkSignService;
import com.biz.eisp.attendance.vo.TsApprovalRecordVo;
import com.biz.eisp.attendance.vo.TsFreesignConfigVo;
import com.biz.eisp.attendance.vo.TsLeaveVo;
import com.biz.eisp.attendance.vo.TsTravelVo;
import com.biz.eisp.attendance.vo.TsWorkSignVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.common.KeyValueVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.params.Constant;
import com.biz.eisp.utils.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaApi/tsWorkSignApiController"})
@Api(tags={"\u8003\u52e4"})
public class TsWorkSignApiController {
    @Autowired
    TsWorkSignService tsWorkSignService;

    @PostMapping(value={"findTsFreesignConfigPage"})
    public AjaxJson<TsFreesignConfigEntity> findTsFreesignConfigPage(@RequestBody TsFreesignConfigVo tsWorkSignVo, String page, String rows) {
        AjaxJson json = new AjaxJson();
        EuPage pageinfo = new EuPage();
        pageinfo.setPage(page);
        pageinfo.setRows(rows);
        PageInfo<TsFreesignConfigEntity> list = this.tsWorkSignService.findTsFreesignConfigPage(tsWorkSignVo, (Page)pageinfo);
        json.setPageInfo(list);
        return json;
    }

    @PostMapping(value={"sign"})
    @ApiOperation(value="\u8003\u52e4\u6253\u5361", notes="signType\u7b7e\u5230\u7c7b\u578b\u5fc5\u4f20(\u76f4\u63a5\u4f20\u4e0a\u73ed\u7b7e\u5230\uff0c\u4e0b\u73ed\u7b7e\u5230\u7b49\u7b7e\u5230\u7c7b\u578b\u540d\u5b57)\uff0csignDate\u7b7e\u5230\u65e5\u671f\u5fc5\u4f20\uff0caddressIn\u7b7e\u5230\u5730\u5740\u5fc5\u4f20\uff0clatIn\u548cLngIn\u7ecf\u7eac\u5ea6\u5fc5\u4f20,imgList\u7167\u7247\u975e\u5fc5\u4f20", httpMethod="POST")
    public Result sign(@RequestBody TsWorkSignVo vo) {
        AjaxJson ajaxJson = this.tsWorkSignService.sign(vo);
        Result result = new Result();
        result.setSuccess(ajaxJson.isSuccess());
        if (ajaxJson.isSuccess()) {
            result.setCode(Constant.resultCode.code_200.getValue());
        } else {
            result.setCode(Constant.resultCode.code_201.getValue());
        }
        result.setMsg(ajaxJson.getMsg());
        return result;
    }

    @PostMapping(value={"getSignInfoById"})
    @ApiOperation(value="\u83b7\u53d6\u8003\u52e4\u8be6\u60c5", notes="id\u5fc5\u4f20", httpMethod="POST")
    public Result<TsWorkSignVo> getSignInfoById(String id) {
        AjaxJson<TsWorkSignVo> ajaxJson = this.tsWorkSignService.getSignInfoById(id);
        Result<TsWorkSignVo> result = new Result<TsWorkSignVo>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj((TsWorkSignVo)ajaxJson.getObj());
        return result;
    }

    @PostMapping(value={"findOwnFreesignConfig"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5bf9\u5e94\u7684\u6253\u5361\u7ec4", notes="no params", httpMethod="POST")
    public Result<TsFreesignConfigVo> findOwnFreesignConfig() {
        AjaxJson<TsFreesignConfigVo> ajaxJson = this.tsWorkSignService.findOwnFreesignConfig();
        Result<TsFreesignConfigVo> result = new Result<TsFreesignConfigVo>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setObjList(ajaxJson.getObjList());
        result.setMsg(ajaxJson.getMsg());
        return result;
    }

    @PostMapping(value={"findHistoryWorkSign"})
    @ApiOperation(value="\u83b7\u53d6\u5386\u53f2\u8003\u52e4\u5217\u8868", notes="vo\u4e2d\u7684\u7b5b\u9009\u6761\u4ef6\u4e0d\u5fc5\u4f20\uff0cpage\u548crows\u8981\u4f20", httpMethod="POST")
    public Result<PageInfo<TsWorkSignVo>> findHistoryWorkSign(@RequestBody TsWorkSignVo vo, String page, String rows) {
        AjaxJson<TsWorkSignVo> ajaxJson = this.tsWorkSignService.findHistoryWorkSign(vo, page, rows);
        Result<PageInfo<TsWorkSignVo>> result = new Result<PageInfo<TsWorkSignVo>>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"findTsLeaveList"})
    @ApiOperation(value="\u83b7\u53d6\u8bf7\u5047\u5217\u8868", notes="page\u548crows\u5fc5\u4f20\uff0cvo\u7b5b\u9009\u6761\u4ef6\u4e0d\u5fc5\u4f20", httpMethod="POST")
    public Result<PageInfo<TsLeaveEntity>> findTsLeaveList(@RequestBody TsLeaveVo vo, String page, String rows) {
        AjaxJson<TsLeaveEntity> ajaxJson = this.tsWorkSignService.findTsLeaveList(vo, page, rows);
        Result<PageInfo<TsLeaveEntity>> result = new Result<PageInfo<TsLeaveEntity>>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"deleteTsLeave"})
    @ApiOperation(value="\u5220\u9664\u8bf7\u5047\u8bb0\u5f55", notes="id\u5fc5\u4f20", httpMethod="POST")
    public Result deleteTsLeave(@RequestBody TsLeaveVo vo) {
        AjaxJson ajaxJson = this.tsWorkSignService.deleteTsLeave(vo);
        Result result = new Result();
        result.setMsg(ajaxJson.getMsg());
        result.setSuccess(ajaxJson.isSuccess());
        return result;
    }

    @PostMapping(value={"deleteTsTravel"})
    @ApiOperation(value="\u5220\u9664\u51fa\u5dee\u8bb0\u5f55", notes="id\u5fc5\u4f20", httpMethod="POST")
    public Result deleteTsTravel(@RequestBody TsLeaveVo vo) {
        AjaxJson ajaxJson = this.tsWorkSignService.deleteTsTravel(vo);
        Result result = new Result();
        result.setMsg(ajaxJson.getMsg());
        result.setSuccess(ajaxJson.isSuccess());
        return result;
    }

    @PostMapping(value={"addTsLeave"})
    @ApiOperation(value="\u63d0\u4ea4\u8bf7\u5047\u7533\u8bf7", notes="leaveType\u8bf7\u5047\u7c7b\u578b\u5fc5\u4f20,beginTime\u5f00\u59cb\u65f6\u95f4\u5fc5\u4f20,endTime\u7ed3\u675f\u65f6\u95f4\u5fc5\u4f20,leaveReason\u8bf7\u5047\u539f\u56e0\u5fc5\u4f20", httpMethod="POST")
    public Result addTsLeave(@RequestBody TsLeaveVo vo) {
        AjaxJson ajaxJson = this.tsWorkSignService.addTsLeave(vo);
        Result result = new Result();
        result.setMsg(ajaxJson.getMsg());
        result.setSuccess(ajaxJson.isSuccess());
        return result;
    }

    @PostMapping(value={"findTsLeaveType"})
    @ApiOperation(value="\u83b7\u53d6\u8bf7\u5047\u7c7b\u578b", notes="\u65e0\u53c2\u6570", httpMethod="POST")
    public Result findTsLeaveType() {
        Result result = new Result();
        Map map = Constant.tsleaveType.getEnumMap();
        ArrayList<KeyValueVo> keyValueVos = new ArrayList<KeyValueVo>();
        for (Constant.tsleaveType tsleaveType2 : map.values()) {
            KeyValueVo keyValueVo = new KeyValueVo();
            keyValueVo.setKey(tsleaveType2.getValue());
            keyValueVo.setValue(tsleaveType2.getDesc());
            keyValueVos.add(keyValueVo);
        }
        result.setSuccess(true);
        result.setMsg("\u67e5\u8be2\u6210\u529f");
        result.setObjList(keyValueVos);
        return result;
    }

    @PostMapping(value={"findTsLeaveInfo"})
    @ApiOperation(value="\u67e5\u770b\u8bf7\u5047\u8be6\u60c5", notes="id\u5fc5\u4f20", httpMethod="POST")
    public Result<TsLeaveVo> findTsLeaveInfo(@RequestBody TsLeaveVo vo) {
        AjaxJson<TsLeaveVo> ajaxJson = this.tsWorkSignService.findTsLeaveInfo(vo);
        Result<TsLeaveVo> result = new Result<TsLeaveVo>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj((TsLeaveVo)ajaxJson.getObj());
        return result;
    }

    @PostMapping(value={"findTsTravelList"})
    @ApiOperation(value="\u83b7\u53d6\u51fa\u5dee\u7533\u8bf7\u5217\u8868", notes="page\u548crows\u5fc5\u4f20\uff0cvo\u67e5\u8be2\u6761\u4ef6\u4e0d\u5fc5\u4f20", httpMethod="POST")
    public Result<PageInfo<TsTravelVo>> findTsTravelList(@RequestBody TsTravelVo vo, String page, String rows) {
        AjaxJson<TsTravelVo> ajaxJson = this.tsWorkSignService.findTsTravelList(vo, page, rows);
        Result<PageInfo<TsTravelVo>> result = new Result<PageInfo<TsTravelVo>>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"addTsTravel"})
    @ApiOperation(value="\u6dfb\u52a0\u51fa\u5dee\u7533\u8bf7", notes="beginTime\u5f00\u59cb\u65f6\u95f4\u5fc5\u4f20\uff0cendTime\u7ed3\u675f\u65f6\u95f4\u5fc5\u4f20,address\u51fa\u5dee\u5730\u5740\u5fc5\u4f20,isStay\u662f\u5426\u4f4f\u5bbf\u5fc5\u4f20(0\u662f1\u5426),gpsAddress\u5b9a\u4f4d\u5730\u5740\u5fc5\u4f20,\u7ecf\u7eac\u5ea6\u5fc5\u4f20", httpMethod="POST")
    public Result addTsTravel(@RequestBody TsTravelVo vo) {
        AjaxJson ajaxJson = this.tsWorkSignService.addTsTravel(vo);
        Result result = new Result();
        result.setMsg(ajaxJson.getMsg());
        result.setSuccess(ajaxJson.isSuccess());
        return result;
    }

    @PostMapping(value={"findTsTravelInfo"})
    @ApiOperation(value="\u67e5\u770b\u51fa\u5dee\u8be6\u60c5", notes="id\u5fc5\u4f20", httpMethod="POST")
    public Result<TsTravelVo> findTsTravelInfo(@RequestBody TsTravelVo vo) {
        AjaxJson<TsTravelVo> ajaxJson = this.tsWorkSignService.findTsTravelInfo(vo);
        Result<TsTravelVo> result = new Result<TsTravelVo>();
        result.setMsg(ajaxJson.getMsg());
        result.setSuccess(ajaxJson.isSuccess());
        result.setObj((TsTravelVo)ajaxJson.getObj());
        return result;
    }

    @PostMapping(value={"findTsApprovalList"})
    @ApiOperation(value="\u83b7\u53d6\u5ba1\u6279\u5217\u8868", notes="page\u548crows\u5fc5\u4f20\uff0cbpmStatus\u5fc5\u4f20(0\u5f85\u5ba1\u6279\uff0c1\u5df2\u5ba1\u6279)\uff0cvo\u7b5b\u9009\u6761\u4ef6\u4e0d\u5fc5\u4f20", httpMethod="POST")
    public Result<PageInfo<TsApprovalRecordVo>> findTsApprovalList(@RequestBody TsApprovalRecordVo vo, String page, String rows) {
        AjaxJson<TsApprovalRecordVo> ajaxJson = this.tsWorkSignService.findTsApprovalList(vo, page, rows);
        Result<PageInfo<TsApprovalRecordVo>> result = new Result<PageInfo<TsApprovalRecordVo>>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"commitTsApproval"})
    @ApiOperation(value="\u5ba1\u6279\u901a\u8fc7/\u9a73\u56de", notes="bpmStatus\u5ba1\u6279\u72b6\u6001\u5fc5\u4f20(1\u5ba1\u6279\u901a\u8fc7\uff0c2\u9a73\u56de)\uff0capprovalContent\u5ba1\u6279\u610f\u89c1\u5fc5\u586b\uff0cid\u5fc5\u4f20\uff0cbusinessId\u4e1a\u52a1id\u5fc5\u4f20\uff0cbusinessType\u4e1a\u52a1\u5ba1\u6279\u7c7b\u578b\u5fc5\u4f20(0\u8bf7\u5047\uff0c1\u51fa\u5dee)", httpMethod="POST")
    public Result commitTsApproval(@RequestBody TsApprovalRecordVo vo) {
        AjaxJson ajaxJson = this.tsWorkSignService.commitTsApproval(vo);
        Result result = new Result();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        return result;
    }

    @GetMapping(value={"findTsFreesignConfigById"})
    public AjaxJson<TsFreesignConfigVo> findTsFreesignConfigById(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TsFreesignConfigVo tsFreesignConfigVo = this.tsWorkSignService.findTsFreesignConfigById(id);
        ajaxJson.setObj((Object)tsFreesignConfigVo);
        return ajaxJson;
    }

    @GetMapping(value={"getTsSignTypeEntityById"})
    public AjaxJson<TsSignTypeEntity> getTsSignTypeEntityById(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TsSignTypeEntity entity = this.tsWorkSignService.getTsSignTypeEntityById(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

