/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.product;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.params.Constant;
import com.biz.eisp.product.TmProductInfoVo;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.utils.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaApi/productApiController"})
@Api(tags={"\u4ea7\u54c1\u4fe1\u606f"})
public class ProductApiController {
    @Autowired
    MdmApiFeign mdmApiFeign;

    @PostMapping(value={"findProductInfoByPage"})
    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1", notes="\u4f20\u9012Map<String,Object>\u5f62\u5f0f\uff0ckey\u4e3a\u7b5b\u9009\u6761\u4ef6\uff0cvalue\u4e3a\u503c(\u4f8b\u5982 {\"productInfoName\":\"11\",\"productInfoCode\":\"22\"} )\uff0c\u5982\u679c\u6ca1\u6709\u7b5b\u9009\u6761\u4ef6\uff0c\u5219\u4f20\u7a7aMap,\u4f8b\u5982 {} ,\u4e0d\u80fd\u76f4\u63a5\u4f20null", httpMethod="POST")
    public Result<PageInfo<TmProductInfoVo>> findProductInfoByPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = this.mdmApiFeign.findProductInfoByPage(param);
        if (ajaxJson.getPageInfo() != null && CollectionUtil.listNotEmptyNotSizeZero((List)ajaxJson.getPageInfo().getList())) {
            for (TmProductInfoVo tmProductInfoVo : ajaxJson.getPageInfo().getList()) {
                if (StringUtil.isNotEmpty((CharSequence)tmProductInfoVo.getSaleUnit())) {
                    String saleUnit = DictUtil.getDictDataVal((String)"sale_unit", (String)tmProductInfoVo.getSaleUnit());
                    tmProductInfoVo.setSaleUnit(saleUnit);
                }
                if (StringUtil.isNotEmpty((CharSequence)tmProductInfoVo.getBasicUnit())) {
                    String basicUnit = DictUtil.getDictDataVal((String)"basic_unit", (String)tmProductInfoVo.getBasicUnit());
                    tmProductInfoVo.setBasicUnit(basicUnit);
                }
                if (!StringUtil.isNotEmpty((CharSequence)tmProductInfoVo.getProductInfoType())) continue;
                String productType2 = DictUtil.getDictDataVal((String)"product_info_type", (String)tmProductInfoVo.getProductInfoType());
                tmProductInfoVo.setProductInfoType(productType2);
            }
        }
        Result<PageInfo<TmProductInfoVo>> result = new Result<PageInfo<TmProductInfoVo>>();
        result.setSuccess(ajaxJson.isSuccess());
        result.setMsg(ajaxJson.getMsg());
        result.setObj(ajaxJson.getPageInfo());
        return result;
    }

    @PostMapping(value={"getProductInfoDetail"})
    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u8be6\u60c5", notes="id\u5fc5\u4f20", httpMethod="POST")
    public Result<TmProductInfoVo> getProductInfoDetail(String id) {
        Result<TmProductInfoVo> result = new Result<TmProductInfoVo>();
        if (StringUtil.isEmpty((String)id)) {
            result.setCode(Constant.resultCode.code_201.getValue());
            result.setMsg("id\u4e0d\u80fd\u4e3a\u7a7a");
            result.setSuccess(false);
        } else {
            AjaxJson ajaxJson = this.mdmApiFeign.getProductInfoDetail(id);
            result.setSuccess(ajaxJson.isSuccess());
            if (ajaxJson.isSuccess()) {
                result.setCode(Constant.resultCode.code_200.getValue());
            } else {
                result.setCode(Constant.resultCode.code_201.getValue());
            }
            result.setMsg(ajaxJson.getMsg());
            if (ajaxJson.getObj() != null) {
                String saleUnit = DictUtil.getDictDataVal((String)"sale_unit", (String)((TmProductInfoVo)ajaxJson.getObj()).getSaleUnit());
                String basicUnit = DictUtil.getDictDataVal((String)"basic_unit", (String)((TmProductInfoVo)ajaxJson.getObj()).getBasicUnit());
                ((TmProductInfoVo)ajaxJson.getObj()).setSaleUnit(saleUnit);
                ((TmProductInfoVo)ajaxJson.getObj()).setBasicUnit(basicUnit);
            }
            result.setObj((TmProductInfoVo)ajaxJson.getObj());
        }
        return result;
    }
}

