/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.client;

import com.biz.eisp.api.feign.CustomerFeign;
import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmTerminalFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.common.KeyValueMapList;
import com.biz.eisp.common.KeyValueVo;
import com.biz.eisp.common.SfaConstantEnum;
import com.biz.eisp.customer.TmCustomerVo;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.terminal.TmTerminalVo;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.utils.Result;
import com.biz.eisp.visitnote.vo.TsClientApiQueryVo;
import com.biz.eisp.visitnote.vo.TsVisitClientApiVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaApi/tsClientController"})
@Api(tags={"\u5ba2\u6237\u7ba1\u7406"})
public class TsClientController {
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private CustomerFeign customerFeign;
    @Autowired
    private TmTerminalFeign tmTerminalFeign;

    @PostMapping(value={"findClientByCon"})
    @ApiOperation(value="\u67e5\u8be2\u81ea\u5df1\u6743\u9650\u7684 \u7f51\u70b9", notes="custLevel\u5ba2\u6237\u7ea7\u522b\uff0ccustType\u5ba2\u6237\u7c7b\u578b,clientName\u7f51\u70b9\u540d\u79f0", httpMethod="POST")
    public Result findClientByCon(@RequestBody TsVisitClientApiVo vo) {
        Result<PageInfo> j = new Result<PageInfo>();
        UserRedis user = UserUtils.getUser();
        if (user == null || StringUtils.isBlank((CharSequence)user.getId())) {
            j.setMsg("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25");
            j.setSuccess(false);
            return j;
        }
        PageInfo pageInfo = null;
        List pos = ApiResultUtil.listResult((AjaxJson)this.tmPositionFeign.getUserPositons("", user.getId()));
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pos)) {
            List ps = pos.stream().map(TmPositionVo::getId).collect(Collectors.toList());
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("page", vo.getPage());
            param.put("rows", vo.getRows());
            param.put("customerName", vo.getClientName());
            param.put("custLevel", vo.getCustLevel());
            param.put("custType", vo.getCustType());
            param.put("posId", StringUtils.join(ps, (String)","));
            pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.mdmApiFeign.getCustomerByPosIdPage(param));
        } else {
            j.setSuccess(false);
            j.setMsg("\u672a\u914d\u7f6e\u804c\u4f4d\uff0c\u67e5\u8be2\u5931\u8d25");
        }
        j.setObj(pageInfo);
        return j;
    }

    @PostMapping(value={"getClientDetail"})
    @ApiOperation(value="\u67e5\u8be2\u7f51\u70b9\u660e\u7ec6", notes="\u67e5\u8be2\u7f51\u70b9\u660e\u7ec6", httpMethod="POST")
    public Result getClienetail(@RequestBody TsClientApiQueryVo vo) {
        Result<Object> j = new Result<Object>();
        UserRedis user = UserUtils.getUser();
        if (user == null || StringUtils.isBlank((CharSequence)user.getId())) {
            j.setMsg("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25");
            j.setSuccess(false);
            return j;
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getClientType())) {
            if (StringUtils.isNotBlank((CharSequence)vo.getClientType()) && vo.getClientType().equals(SfaConstantEnum.CusType.channel.getVal())) {
                TmCustomerVo customerVo = (TmCustomerVo)ApiResultUtil.objResult((AjaxJson)this.customerFeign.getCustomerByIdOrCode(vo.getClientId(), ""));
                j.setObj(customerVo);
            } else {
                TmTerminalVo tmTerminalVo = (TmTerminalVo)ApiResultUtil.objResult((AjaxJson)this.tmTerminalFeign.getTerminalById(vo.getClientId()));
                j.setObj(tmTerminalVo);
            }
        } else {
            j.setSuccess(false);
            j.setMsg("\u7f51\u70b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return j;
    }

    @PostMapping(value={"getClientailSearchValue"})
    @ApiOperation(value="\u83b7\u53d6\u7f51\u70b9\u67e5\u8be2\u6761\u4ef6", notes="\u65e0\u53c2\u6570", httpMethod="POST")
    public Result<KeyValueMapList> getClientailSearchValue() {
        KeyValueVo keyValueVo;
        KnlDictDataEntity knlDictDataEntity;
        Result<KeyValueMapList> result = new Result<KeyValueMapList>();
        KeyValueMapList keyValueMapList = new KeyValueMapList();
        Map custLevelMap = DictUtil.getDictMap((String)"cust_level");
        Map cust_typeMap = DictUtil.getDictMap((String)"cust_type");
        ArrayList<KeyValueVo> list1 = new ArrayList<KeyValueVo>();
        ArrayList<KeyValueVo> list2 = new ArrayList<KeyValueVo>();
        HashMap<String, ArrayList<KeyValueVo>> map = new HashMap<String, ArrayList<KeyValueVo>>();
        if (custLevelMap != null && custLevelMap.values().size() > 0) {
            for (Object object : custLevelMap.values()) {
                knlDictDataEntity = (KnlDictDataEntity)object;
                keyValueVo = new KeyValueVo();
                keyValueVo.setKey(knlDictDataEntity.getDictCode());
                keyValueVo.setValue(knlDictDataEntity.getDictValue());
                list1.add(keyValueVo);
            }
        }
        if (cust_typeMap != null && cust_typeMap.values().size() > 0) {
            for (Object object : cust_typeMap.values()) {
                knlDictDataEntity = (KnlDictDataEntity)object;
                keyValueVo = new KeyValueVo();
                keyValueVo.setKey(knlDictDataEntity.getDictCode());
                keyValueVo.setValue(knlDictDataEntity.getDictValue());
                list2.add(keyValueVo);
            }
        }
        map.put("custLevel", list1);
        map.put("custType", list2);
        keyValueMapList.setMap(map);
        result.setObj(keyValueMapList);
        result.setSuccess(true);
        result.setMsg("\u67e5\u8be2\u6210\u529f");
        return result;
    }
}

