/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.visitnote.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.visitnote.dao.VisitClientRelDao;
import com.biz.eisp.visitnote.dao.VisitGroupDao;
import com.biz.eisp.visitnote.entity.VisitGroupEntity;
import com.biz.eisp.visitnote.entity.VisitclientRelEntity;
import com.biz.eisp.visitnote.service.VisitGroupServiceI;
import com.biz.eisp.visitnote.template.TsVisitGroupEntityToVo;
import com.biz.eisp.visitnote.template.TsVisitGroupVoToEntity;
import com.biz.eisp.visitnote.vo.VisitGroupVo;
import com.biz.eisp.visitnote.vo.VisitclientRelVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Component
@Transactional
public class VisitGroupServiceImpl
extends BaseServiceImpl<VisitGroupEntity>
implements VisitGroupServiceI {
    @Autowired
    private VisitGroupDao visitGroupDao;
    @Autowired
    private VisitClientRelDao visitClientRelDao;

    @Override
    public String saveGroupAndDetail(VisitGroupEntity groupEntity) {
        String message = "\u7ebf\u8def\u7ec4\u6dfb\u52a0\u6210\u529f";
        String userId = groupEntity.getUserId();
        if (StringUtil.isEmpty((String)userId)) {
            message = "\u8bf7\u9009\u62e9\u5bf9\u5e94\u7528\u6237";
            return message;
        }
        if (StringUtil.isEmpty((String)groupEntity.getPosId())) {
            message = "\u8bf7\u9009\u62e9\u5bf9\u5e94\u7528\u6237";
            return message;
        }
        long groupCount = this.groupCount(groupEntity.getGroupName(), ConstantEnum.StatusEnum.NEW.getValue(), userId, groupEntity.getPosId());
        if (groupCount == 0L) {
            long maxCount = this.groupCount("", ConstantEnum.StatusEnum.NEW.getValue(), "", groupEntity.getPosId());
            groupEntity.setGroupOrder(Integer.valueOf(Integer.parseInt(String.valueOf(maxCount + 1L))));
            groupEntity.setStatus(ConstantEnum.StatusEnum.NEW.getValue());
            this.visitGroupDao.insertSelective(groupEntity);
            if (StringUtil.isNotEmpty((CharSequence)groupEntity.getClientJson())) {
                List visitclientRels = JSON.parseArray((String)groupEntity.getClientJson(), VisitclientRelEntity.class);
                for (VisitclientRelEntity visitclientRelEntity : visitclientRels) {
                    Example example = new Example(VisitclientRelEntity.class);
                    Example.Criteria criteria = example.createCriteria();
                    criteria.andEqualTo("clientId", (Object)visitclientRelEntity.getClientId());
                    criteria.andEqualTo("groupId", (Object)groupEntity.getId());
                    criteria.andEqualTo("status", (Object)ConstantEnum.StatusEnum.NEW.getValue());
                    long count = this.visitClientRelDao.selectCountByExample(example);
                    if (count != 0L) continue;
                    Integer groupId = groupEntity.getId();
                    VisitclientRelEntity entity = visitclientRelEntity;
                    entity.setGroupId(groupId);
                    entity.setStatus(ConstantEnum.StatusEnum.NEW.getValue());
                    this.visitClientRelDao.insertSelective(entity);
                }
            }
        } else {
            message = "\u8be5\u7ebf\u8def\u7ec4\u5df2\u7ecf\u5b58\u5728";
        }
        return message;
    }

    private int groupCount(String groupName, String status, String userId, String posId) {
        Example example = new Example(VisitGroupEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            criteria.andEqualTo("groupName", (Object)groupName);
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            criteria.andEqualTo("status", (Object)status);
        }
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            criteria.andEqualTo("userId", (Object)userId);
        }
        if (StringUtils.isNotBlank((CharSequence)posId)) {
            criteria.andEqualTo("posId", (Object)posId);
        }
        return this.visitGroupDao.selectCountByExample(example);
    }

    @Override
    public PageInfo<VisitGroupEntity> findVisitGroupPage(VisitGroupEntity entity, Page page) {
        Example example = new Example(VisitGroupEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)entity.getUserId())) {
            criteria.andEqualTo("userId", (Object)entity.getUserId());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getFullName())) {
            criteria.andLike("fullName", "%" + entity.getFullName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getPosId())) {
            criteria.andEqualTo("posId", (Object)entity.getPosId());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getPosName())) {
            criteria.andLike("posName", "%" + entity.getPosName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getOrgId())) {
            criteria.andEqualTo("orgId", (Object)entity.getOrgId());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getOrgName())) {
            criteria.andLike("orgName", "%" + entity.getOrgName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getGroupName())) {
            criteria.andLike("groupName", "%" + entity.getGroupName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getStatus())) {
            criteria.andEqualTo("status", (Object)entity.getStatus());
        }
        example.orderBy("groupOrder").asc();
        return PageAutoHelperUtil.generatePage(() -> this.visitGroupDao.selectByExample(example), (Page)page);
    }

    @Override
    public VisitGroupVo getVisitGroupById(String id) {
        VisitGroupVo visitGroupVo = null;
        if (StringUtil.isNotBlank((CharSequence)id)) {
            VisitGroupEntity visitGroupEntity = (VisitGroupEntity)this.visitGroupDao.selectByPrimaryKey(id);
            visitGroupVo = new TsVisitGroupEntityToVo().apply(visitGroupEntity);
            Example example = new Example(VisitclientRelEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("groupId", (Object)id);
            List visitclients = this.visitClientRelDao.selectByExample(example);
            visitGroupVo.setVisitclients(visitclients);
        }
        return visitGroupVo;
    }

    @Override
    public AjaxJson saveOrUpdateVisitGroup(VisitGroupVo visitGroupVo) {
        AjaxJson json = new AjaxJson();
        json.setSuccessMsg("\u4fdd\u5b58\u6210\u529f");
        UserRedis userRedis = UserUtils.getUser();
        String dateStr = DateUtils.datetimeFormat.format(new Date());
        VisitGroupEntity entity = new TsVisitGroupVoToEntity(this.visitGroupDao).apply(visitGroupVo);
        if (StringUtil.isNotEmpty((Object)visitGroupVo.getId())) {
            entity.setStatus("009");
            entity.setUpdateDate(dateStr);
            entity.setUpdateBy(userRedis.getUsername());
            entity.setUpdateName(userRedis.getRealname());
            this.visitGroupDao.updateByPrimaryKey(entity);
        } else {
            long groupCount = this.groupCount(visitGroupVo.getGroupName(), ConstantEnum.StatusEnum.NEW.getValue(), visitGroupVo.getUserId(), visitGroupVo.getPosId());
            if (groupCount > 0L) {
                json.setErrMsg("\u8be5\u7ebf\u8def\u7ec4\u5df2\u7ecf\u5b58\u5728");
                return json;
            }
            long maxCount = this.groupCount("", ConstantEnum.StatusEnum.NEW.getValue(), "", visitGroupVo.getPosId());
            entity.setGroupOrder(Integer.valueOf(Integer.parseInt(String.valueOf(maxCount + 1L))));
            entity.setStatus("009");
            entity.setPositionCode(userRedis.getPosCode());
            entity.setPositionName(userRedis.getPosName());
            entity.setCreateDate(dateStr);
            entity.setCreateBy(userRedis.getUsername());
            entity.setCreateName(userRedis.getRealname());
            entity.setUpdateDate(dateStr);
            entity.setUpdateBy(userRedis.getUsername());
            entity.setUpdateName(userRedis.getRealname());
            this.visitGroupDao.insertSelective(entity);
        }
        return json;
    }

    @Override
    public AjaxJson startVisitGroup(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u542f\u7528\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            VisitGroupEntity entity = (VisitGroupEntity)this.visitGroupDao.selectByPrimaryKey(id);
            if (null == entity || "009".equals(entity.getStatus())) continue;
            entity.setStatus("009");
            this.visitGroupDao.updateByPrimaryKey(entity);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson stopVisitGroup(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u505c\u7528\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            VisitGroupEntity entity = (VisitGroupEntity)this.visitGroupDao.selectByPrimaryKey(id);
            if (null == entity || "003".equals(entity.getStatus())) continue;
            entity.setStatus("003");
            this.visitGroupDao.updateByPrimaryKey(entity);
        }
        return ajaxJson;
    }

    @Override
    public PageInfo<VisitclientRelEntity> findVisitClientPage(VisitclientRelEntity entity, Page page) {
        Example example = new Example(VisitclientRelEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("groupId", (Object)entity.getGroupId());
        if (StringUtils.isNotBlank((CharSequence)entity.getClientName())) {
            criteria.andLike("clientName", "%" + entity.getClientName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getClientCode())) {
            criteria.andEqualTo("clientType", (Object)entity.getClientType());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getClientCode())) {
            criteria.andLike("clientCode", "%" + entity.getClientCode() + "%");
        }
        return PageAutoHelperUtil.generatePage(() -> this.visitClientRelDao.selectByExample(example), (Page)page);
    }

    @Override
    public List<VisitclientRelEntity> findVisitClientList(VisitclientRelEntity entity) {
        Example example = new Example(VisitclientRelEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("groupId", (Object)entity.getGroupId());
        if (StringUtils.isNotBlank((CharSequence)entity.getClientName())) {
            criteria.andLike("clientName", "%" + entity.getClientName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getClientCode())) {
            criteria.andEqualTo("clientType", (Object)entity.getClientType());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getClientCode())) {
            criteria.andLike("clientCode", "%" + entity.getClientCode() + "%");
        }
        return this.visitClientRelDao.selectByExample(example);
    }

    @Override
    public AjaxJson deleteVisitGroup(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u5220\u9664\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            this.visitGroupDao.deleteByPrimaryKey(id);
            Example example = new Example(VisitclientRelEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("groupId", (Object)id);
            this.visitClientRelDao.deleteByExample(example);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson addVisitClient(VisitclientRelVo visitclientRelVo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (null == visitclientRelVo || StringUtil.isEmpty((Object)visitclientRelVo.getGroupId())) {
            ajaxJson.setErrMsg("\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u7ebf\u8def\u7ec4\u3002");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)visitclientRelVo.getClientJson())) {
            ajaxJson.setErrMsg("\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u7f51\u70b9\u3002");
            return ajaxJson;
        }
        List visitclientRels = JSON.parseArray((String)visitclientRelVo.getClientJson(), VisitclientRelEntity.class);
        for (VisitclientRelEntity entity : visitclientRels) {
            entity.setStatus("009");
            entity.setGroupId(visitclientRelVo.getGroupId());
        }
        this.visitClientRelDao.insertList(visitclientRels);
        return ajaxJson;
    }

    @Override
    public AjaxJson delVisitClient(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u7f51\u70b9\u5220\u9664\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            this.visitClientRelDao.deleteByPrimaryKey(id);
        }
        return ajaxJson;
    }

    @Override
    public List<VisitGroupEntity> findVisitGroupList(String userId, String posId, String orgId, String groupName) {
        List<Object> visitGroupList = new ArrayList<VisitGroupEntity>();
        if (StringUtil.isNotEmpty((CharSequence)userId)) {
            Example example = new Example(VisitGroupEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("userId", (Object)userId);
            criteria.andEqualTo("status", (Object)"009");
            if (StringUtils.isNotBlank((CharSequence)posId)) {
                criteria.andEqualTo("posId", (Object)posId);
            }
            if (StringUtils.isNotBlank((CharSequence)orgId)) {
                criteria.andEqualTo("orgId", (Object)orgId);
            }
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                criteria.andLike("groupName", "%" + groupName + "%");
            }
            example.orderBy("groupOrder").asc();
            visitGroupList = this.visitGroupDao.selectByExample(example);
        }
        return visitGroupList;
    }

    @Override
    public List<VisitclientRelEntity> findVisitclientRelListByGroupId(String groupId) {
        List<Object> visitclientRelList = new ArrayList<VisitclientRelEntity>();
        if (StringUtil.isNotEmpty((CharSequence)groupId)) {
            Example example = new Example(VisitclientRelEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("groupId", (Object)groupId);
            criteria.andEqualTo("status", (Object)"009");
            visitclientRelList = this.visitClientRelDao.selectByExample(example);
        }
        return visitclientRelList;
    }
}

