/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.attendance.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.attendance.dao.TsApprovalRecordDao;
import com.biz.eisp.attendance.dao.TsFreesignConfigDao;
import com.biz.eisp.attendance.dao.TsFreesignObjDao;
import com.biz.eisp.attendance.dao.TsFreesignSignDao;
import com.biz.eisp.attendance.dao.TsLeaveDao;
import com.biz.eisp.attendance.dao.TsSignTypeDao;
import com.biz.eisp.attendance.dao.TsTravelDao;
import com.biz.eisp.attendance.dao.TsWorkSignDao;
import com.biz.eisp.attendance.entity.TsApprovalRecordEntity;
import com.biz.eisp.attendance.entity.TsFreesignConfigEntity;
import com.biz.eisp.attendance.entity.TsFreesignObjEntity;
import com.biz.eisp.attendance.entity.TsFreesignSignEntity;
import com.biz.eisp.attendance.entity.TsLeaveEntity;
import com.biz.eisp.attendance.entity.TsSignTypeEntity;
import com.biz.eisp.attendance.entity.TsTravelEntity;
import com.biz.eisp.attendance.entity.TsWorkSignEntity;
import com.biz.eisp.attendance.picture.dao.TsPictureDao;
import com.biz.eisp.attendance.service.TsWorkSignService;
import com.biz.eisp.attendance.vo.TsApprovalRecordVo;
import com.biz.eisp.attendance.vo.TsFreesignConfigVo;
import com.biz.eisp.attendance.vo.TsFreesignObjVo;
import com.biz.eisp.attendance.vo.TsLeaveVo;
import com.biz.eisp.attendance.vo.TsSignTypeVo;
import com.biz.eisp.attendance.vo.TsTravelVo;
import com.biz.eisp.attendance.vo.TsWorkSignVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.common.FilePathUtil;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.params.Constant;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.user.TmUserVo;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TsWorkSignServiceImpl
extends BaseServiceImpl<TsWorkSignEntity>
implements TsWorkSignService {
    private static final Logger log = LoggerFactory.getLogger(TsWorkSignServiceImpl.class);
    @Autowired
    TsWorkSignDao tsWorkSignDao;
    @Autowired
    TsSignTypeDao tsSignTypeDao;
    @Autowired
    TsFreesignConfigDao tsFreesignConfigDao;
    @Autowired
    TsFreesignSignDao tsFreesignSignDao;
    @Autowired
    TsFreesignObjDao tsFreesignObjDao;
    @Autowired
    MdmApiFeign mdmApiFeign;
    @Autowired
    TsLeaveDao tsLeaveDao;
    @Autowired
    TsApprovalRecordDao tsApprovalRecordDao;
    @Autowired
    TsTravelDao tsTravelDao;
    @Autowired
    TsPictureDao tsPictureDao;
    @Autowired
    FilePathUtil filePathUtil;

    @Override
    public PageInfo<TsFreesignConfigEntity> findTsFreesignConfigPage(TsFreesignConfigVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tsFreesignConfigDao.findTsFreesignConfigPage(vo), (Page)page);
    }

    @Override
    public PageInfo<TsSignTypeVo> findTsSignTypeList(TsSignTypeVo vo, Page page) {
        Example example = new Example(TsSignTypeEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("name", (Object)vo.getName());
        return PageAutoHelperUtil.generatePage(() -> this.tsSignTypeDao.selectByExample(example), (Page)page);
    }

    @Override
    public TsSignTypeEntity getTsSignTypeEntityById(String id) {
        if (StringUtil.isEmpty((String)id)) {
            throw new BusinessException("id\u7f3a\u5931");
        }
        return (TsSignTypeEntity)this.tsSignTypeDao.selectByPrimaryKey(id);
    }

    @Override
    public AjaxJson deleteSignType(TsSignTypeVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getId())) {
            ajaxJson.setErrMsg("id\u7f3a\u5931");
            return ajaxJson;
        }
        this.tsSignTypeDao.deleteByPrimaryKey(vo.getId());
        return ajaxJson;
    }

    @Override
    public AjaxJson addTsFreesignConfig(TsFreesignConfigVo vo) {
        String objStrJson;
        String signTypeJson;
        AjaxJson ajaxJson = new AjaxJson();
        if (!(ajaxJson = this.valite_addTsFreesignConfig(vo, ajaxJson)).isSuccess()) {
            return ajaxJson;
        }
        TsFreesignConfigEntity tsFreesignConfigEntity = new TsFreesignConfigEntity();
        BeanUtils.copyProperties((Object)vo, (Object)tsFreesignConfigEntity);
        if (StringUtil.isEmpty((String)vo.getId())) {
            this.tsFreesignConfigDao.insertSelective(tsFreesignConfigEntity);
        } else {
            tsFreesignConfigEntity.setId(Integer.valueOf(vo.getId()));
            this.tsFreesignConfigDao.updateByPrimaryKey(tsFreesignConfigEntity);
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getId())) {
            if (StringUtil.isNotEmpty((CharSequence)vo.getSignTypeJson())) {
                Example example = new Example(TsFreesignSignEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("otherId", (Object)vo.getId());
                this.tsFreesignSignDao.deleteByExample(example);
            }
            if (StringUtil.isNotEmpty((CharSequence)vo.getObjStrJson())) {
                Example example1 = new Example(TsFreesignObjEntity.class);
                Example.Criteria criteria1 = example1.createCriteria();
                criteria1.andEqualTo("freesignId", (Object)vo.getId());
                this.tsFreesignObjDao.deleteByExample(example1);
            }
        }
        if (StringUtil.isNotEmpty((CharSequence)(signTypeJson = vo.getSignTypeJson()))) {
            List typeVoList = JSON.parseArray((String)signTypeJson, TsSignTypeVo.class);
            for (TsSignTypeVo tsSignTypeVo : typeVoList) {
                TsFreesignSignEntity tsFreesignSignEntity = new TsFreesignSignEntity();
                tsFreesignSignEntity.setOtherId(tsFreesignConfigEntity.getId() + "");
                tsFreesignSignEntity.setTypeId(tsSignTypeVo.getId());
                tsFreesignSignEntity.setTypeName(tsSignTypeVo.getName());
                this.tsFreesignSignDao.insertSelective(tsFreesignSignEntity);
            }
        }
        if (StringUtil.isNotEmpty((CharSequence)(objStrJson = vo.getObjStrJson()))) {
            List signObjVos = JSON.parseArray((String)objStrJson, TsFreesignObjVo.class);
            for (TsFreesignObjVo signObjVo : signObjVos) {
                TsFreesignObjEntity tsFreesignObjEntity = new TsFreesignObjEntity();
                tsFreesignObjEntity.setFreesignId(tsFreesignConfigEntity.getId());
                tsFreesignObjEntity.setObjType(vo.getSignObj());
                tsFreesignObjEntity.setSignObj(signObjVo.getSignObj());
                tsFreesignObjEntity.setSignObjCode(signObjVo.getSignObjCode());
                this.tsFreesignObjDao.insertSelective(tsFreesignObjEntity);
            }
        }
        return ajaxJson;
    }

    @Override
    public TsFreesignConfigVo findTsFreesignConfigById(String id) {
        if (StringUtil.isEmpty((String)id)) {
            throw new BusinessException("id\u7f3a\u5931");
        }
        TsFreesignConfigEntity configEntity = (TsFreesignConfigEntity)this.tsFreesignConfigDao.selectByPrimaryKey(id);
        TsFreesignConfigVo vo = new TsFreesignConfigVo();
        BeanUtils.copyProperties((Object)configEntity, (Object)vo);
        vo.setId(configEntity.getId() + "");
        Example example = new Example(TsFreesignSignEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("otherId", (Object)id);
        List list1 = this.tsFreesignSignDao.selectByExample(example);
        Example example1 = new Example(TsFreesignObjEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("freesignId", (Object)id);
        List list2 = this.tsFreesignObjDao.selectByExample(example1);
        ArrayList<TsSignTypeVo> tsSignTypeVos = new ArrayList<TsSignTypeVo>();
        String signStr = "";
        if (list1 != null) {
            for (TsFreesignSignEntity tsFreesignSignEntity : list1) {
                TsSignTypeVo signTypeVo = new TsSignTypeVo();
                signTypeVo.setName(tsFreesignSignEntity.getTypeName());
                signTypeVo.setId(tsFreesignSignEntity.getTypeId());
                tsSignTypeVos.add(signTypeVo);
                signStr = signStr + tsFreesignSignEntity.getTypeName() + ",";
            }
        }
        vo.setSignTypeJson(JSON.toJSONString(tsSignTypeVos));
        vo.setSignTypeStr(signStr);
        JSONArray array = new JSONArray();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list2)) {
            for (TsFreesignObjEntity tsFreesignObjEntity : list2) {
                JSONObject obj = new JSONObject();
                obj.put("code", (Object)tsFreesignObjEntity.getSignObjCode());
                obj.put("name", (Object)tsFreesignObjEntity.getSignObj());
                obj.put("type", (Object)tsFreesignObjEntity.getObjType());
                array.add((Object)obj);
            }
        }
        vo.setObjStrJson(array.toJSONString());
        return vo;
    }

    private AjaxJson valite_addTsFreesignConfig(TsFreesignConfigVo vo, AjaxJson ajaxJson) {
        if (StringUtil.isEmpty((String)vo.getFreesignName())) {
            ajaxJson.setErrMsg("\u6253\u5361\u7ec4\u540d\u5b57\u5fc5\u586b");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getSignType())) {
            ajaxJson.setErrMsg("\u6253\u5361\u7c7b\u578b\u5fc5\u586b");
            return ajaxJson;
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson addSignType(TsSignTypeVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ajaxJson = this.valiteParams(vo, ajaxJson);
        }
        catch (Exception e) {
            ajaxJson.setErrMsg(e.getMessage());
            return ajaxJson;
        }
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        TsSignTypeEntity signTypeEntity = new TsSignTypeEntity();
        BeanUtils.copyProperties((Object)vo, (Object)signTypeEntity);
        if (StringUtil.isEmpty((String)vo.getId())) {
            this.tsSignTypeDao.insertSelective(signTypeEntity);
        } else {
            signTypeEntity.setId(Integer.valueOf(vo.getId()));
            this.tsSignTypeDao.updateByPrimaryKey(signTypeEntity);
        }
        return ajaxJson;
    }

    private AjaxJson valiteParams(TsSignTypeVo vo, AjaxJson ajaxJson) throws Exception {
        if (StringUtil.isEmpty((String)vo.getName())) {
            ajaxJson.setErrMsg("\u540d\u79f0\u5fc5\u586b");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getOrderNumber())) {
            ajaxJson.setErrMsg("\u5e8f\u53f7\u5fc5\u586b");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getPhotoReq())) {
            ajaxJson.setErrMsg("\u62cd\u7167\u8981\u6c42\u5fc5\u586b");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getTimeReq())) {
            ajaxJson.setErrMsg("\u65f6\u95f4\u8981\u6c42\u5fc5\u586b");
            return ajaxJson;
        }
        if ("1".equals(vo.getTimeReq())) {
            if (StringUtil.isEmpty((String)vo.getBeginDate())) {
                ajaxJson.setErrMsg("\u8d77\u6b62\u65f6\u95f4,\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                return ajaxJson;
            }
            if (StringUtil.isEmpty((String)vo.getEndDate())) {
                ajaxJson.setErrMsg("\u8d77\u6b62\u65f6\u95f4,\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                return ajaxJson;
            }
            Date beginDate = DateUtils.short_time_sdf.parse(vo.getBeginDate());
            Date endDate = DateUtils.short_time_sdf.parse(vo.getEndDate());
            if (endDate.getTime() < beginDate.getTime()) {
                ajaxJson.setErrMsg("\u8d77\u6b62\u65f6\u95f4,\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4");
                return ajaxJson;
            }
        } else {
            vo.setBeginDate(null);
            vo.setEndDate(null);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson sign(TsWorkSignVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (!(ajaxJson = this.valit_sign(vo, ajaxJson)).isSuccess()) {
            return ajaxJson;
        }
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        TsWorkSignVo paramsVo = new TsWorkSignVo();
        paramsVo.setCreateBy(userRedis.getId());
        paramsVo.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        paramsVo.setSignType(vo.getSignType());
        List<TsWorkSignVo> list = this.tsWorkSignDao.selectTodayData(paramsVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            ajaxJson.setErrMsg("\u76f8\u540c\u6253\u5361\u7c7b\u578b\u4e00\u5929\u53ea\u80fd\u63d0\u4ea4\u4e00\u6b21");
            return ajaxJson;
        }
        TsWorkSignEntity tsWorkSignEntity = new TsWorkSignEntity();
        BeanUtils.copyProperties((Object)vo, (Object)tsWorkSignEntity);
        tsWorkSignEntity.setSignDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        this.tsWorkSignDao.insertSelective(tsWorkSignEntity);
        List imgList = vo.getImgList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)imgList)) {
            for (TsPictureEntity tsPictureEntity1 : imgList) {
                tsPictureEntity1.setImgType(Constant.imgType.kq.getValue());
                tsPictureEntity1.setBusinessId(tsWorkSignEntity.getId());
                this.filePathUtil.getChangePicturePath(tsPictureEntity1);
                this.tsPictureDao.insertSelective(tsPictureEntity1);
            }
        }
        return ajaxJson;
    }

    private AjaxJson valit_sign(TsWorkSignVo vo, AjaxJson ajaxJson) {
        if (StringUtil.isEmpty((String)vo.getSignType())) {
            ajaxJson.setErrMsg("\u7b7e\u5230\u7c7b\u578b\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getAddressIn())) {
            ajaxJson.setErrMsg("\u7b7e\u5230\u5730\u5740\u5fc5\u4f20");
            return ajaxJson;
        }
        if (vo.getLatIn() == null || vo.getLatIn() == 0.0) {
            ajaxJson.setErrMsg("\u7ef4\u5ea6\u5fc5\u4f20");
            return ajaxJson;
        }
        if (vo.getLngIn() == null || vo.getLngIn() == 0.0) {
            ajaxJson.setErrMsg("\u7ecf\u5ea6\u5fc5\u4f20");
            return ajaxJson;
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsFreesignConfigVo> findOwnFreesignConfig() {
        AjaxJson ajaxJson = new AjaxJson();
        UserRedis user = UserUtils.getUser();
        if (user == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        ArrayList allList = new ArrayList();
        Example example = new Example(TsFreesignObjEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("signObjCode", (Object)user.getUsername());
        List list = this.tsFreesignObjDao.selectByExample(example);
        List<TsFreesignConfigVo> entities = this.getTsFreesignConfigByTsFreesignObj(list);
        if (CollectionUtil.listNotEmptyNotSizeZero(entities)) {
            this.initTsFreesignConfigVo(entities);
            ajaxJson.setObjList(entities);
            return ajaxJson;
        }
        Example exampleOrg = new Example(TsFreesignObjEntity.class);
        Example.Criteria criteriaOrg = exampleOrg.createCriteria();
        criteriaOrg.andEqualTo("signObjCode", (Object)user.getOrgCode());
        List orgTsFreeList = this.tsFreesignObjDao.selectByExample(exampleOrg);
        List<TsFreesignConfigVo> entitiesOrg = this.getTsFreesignConfigByTsFreesignObj(orgTsFreeList);
        if (CollectionUtil.listNotEmptyNotSizeZero(entitiesOrg)) {
            this.initTsFreesignConfigVo(entitiesOrg);
            ajaxJson.setObjList(entitiesOrg);
            return ajaxJson;
        }
        AjaxJson voAjaxJson = this.mdmApiFeign.getOrgUpById(user.getOrgId());
        if (voAjaxJson == null || voAjaxJson.getObjList() == null || voAjaxJson.getObjList().size() <= 0) {
            return ajaxJson;
        }
        for (TmOrgVo tmOrgVo : voAjaxJson.getObjList()) {
            Example exampletmOrgVo = new Example(TsFreesignObjEntity.class);
            Example.Criteria criteriaOrgVo = exampletmOrgVo.createCriteria();
            criteriaOrgVo.andEqualTo("signObjCode", (Object)tmOrgVo.getOrgCode());
            List objEntityList = this.tsFreesignObjDao.selectByExample(exampletmOrgVo);
            List<TsFreesignConfigVo> voList = this.getTsFreesignConfigByTsFreesignObj(objEntityList);
            if (!CollectionUtil.listNotEmptyNotSizeZero(voList)) continue;
            this.initTsFreesignConfigVo(voList);
            ajaxJson.setObjList(voList);
            return ajaxJson;
        }
        return ajaxJson;
    }

    private void initTsFreesignConfigVo(List<TsFreesignConfigVo> list) {
        for (TsFreesignConfigVo tsFreesignConfigVo : list) {
            Example exampleOrg = new Example(TsFreesignSignEntity.class);
            Example.Criteria criteriaOrg = exampleOrg.createCriteria();
            criteriaOrg.andEqualTo("otherId", (Object)tsFreesignConfigVo.getId());
            List entityList = this.tsFreesignSignDao.selectByExample(exampleOrg);
            tsFreesignConfigVo.setList(entityList);
        }
    }

    private List<TsFreesignConfigVo> getTsFreesignConfigByTsFreesignObj(List<TsFreesignObjEntity> tsFreesignObjEntities) {
        ArrayList<TsFreesignConfigVo> tsFreesignConfigVos = new ArrayList<TsFreesignConfigVo>();
        if (tsFreesignObjEntities != null && tsFreesignObjEntities.size() > 0) {
            ArrayList<String> ids = new ArrayList<String>();
            for (TsFreesignObjEntity tsFreesignObjEntity : tsFreesignObjEntities) {
                ids.add(tsFreesignObjEntity.getFreesignId() + "");
            }
            Example example1 = new Example(TsFreesignConfigEntity.class);
            Example.Criteria criteria1 = example1.createCriteria();
            criteria1.andIn("id", ids);
            List entities = this.tsFreesignConfigDao.selectByExample(example1);
            if (entities != null) {
                for (TsFreesignConfigEntity tsFreesignConfigEntity : entities) {
                    TsFreesignConfigVo tsFreesignConfigVo = new TsFreesignConfigVo();
                    BeanUtils.copyProperties((Object)tsFreesignConfigEntity, (Object)tsFreesignConfigVo);
                    tsFreesignConfigVo.setId(tsFreesignConfigEntity.getId() + "");
                    tsFreesignConfigVos.add(tsFreesignConfigVo);
                }
            }
        }
        return tsFreesignConfigVos;
    }

    @Override
    public AjaxJson<TsWorkSignVo> findHistoryWorkSign(TsWorkSignVo vo, String page, String rows) {
        AjaxJson ajaxJson = new AjaxJson();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        EuPage page1 = new EuPage();
        if (StringUtil.isEmpty((String)page)) {
            page = "1";
        }
        if (StringUtil.isEmpty((String)rows)) {
            rows = "15";
        }
        page1.setPage(page);
        page1.setRows(rows);
        Example example1 = new Example(TsWorkSignEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("createBy", (Object)userRedis.getId());
        if (StringUtil.isNotEmpty((CharSequence)vo.getBeginDate()) && StringUtil.isNotEmpty((CharSequence)vo.getEndDate())) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date beginDate = simpleDateFormat.parse(vo.getBeginDate());
                Date endDate = simpleDateFormat.parse(vo.getEndDate());
                Calendar c = Calendar.getInstance();
                c.setTime(endDate);
                c.add(5, 1);
                criteria1.andBetween("createDate", (Object)beginDate, (Object)c.getTime());
            }
            catch (ParseException e) {
                log.error("", (Throwable)e);
                ajaxJson.setErrMsg(e.getMessage());
                return ajaxJson;
            }
        }
        example1.setOrderByClause("create_date desc");
        List entities = this.tsWorkSignDao.selectByExample(example1);
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> entities, (Page)page1);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsLeaveEntity> findTsLeaveList(TsLeaveVo vo, String page, String rows) {
        AjaxJson ajaxJson = new AjaxJson();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        EuPage page1 = new EuPage();
        if (StringUtil.isEmpty((String)page)) {
            page = "1";
        }
        if (StringUtil.isEmpty((String)rows)) {
            rows = "15";
        }
        page1.setPage(page);
        page1.setRows(rows);
        Example example1 = new Example(TsLeaveEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("createBy", (Object)userRedis.getId());
        example1.orderBy("createDate").desc();
        List entities = this.tsLeaveDao.selectByExample(example1);
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> entities, (Page)page1);
        Map map = Constant.tsleaveType.getEnumMap();
        if (pageInfo != null && pageInfo.getList() != null && pageInfo.getList().size() > 0) {
            for (TsLeaveEntity tsLeaveVo : pageInfo.getList()) {
                Constant.tsleaveType tsleaveTypeEnum = (Constant.tsleaveType)map.get(tsLeaveVo.getLeaveType());
                if (tsleaveTypeEnum == null) continue;
                String desc = tsleaveTypeEnum.getDesc();
                tsLeaveVo.setLeaveType(desc);
            }
        }
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @Override
    public AjaxJson deleteTsLeave(TsLeaveVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getId())) {
            ajaxJson.setErrMsg("id\u7f3a\u5931");
            return ajaxJson;
        }
        Example example1 = new Example(TsLeaveEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("id", (Object)vo.getId());
        this.tsLeaveDao.deleteByExample(example1);
        Example exampleApproval = new Example(TsApprovalRecordEntity.class);
        Example.Criteria criteria1Approval = exampleApproval.createCriteria();
        criteria1Approval.andEqualTo("businessId", (Object)vo.getId());
        criteria1Approval.andEqualTo("businessType", (Object)Constant.businessType.leave.getValue());
        this.tsApprovalRecordDao.deleteByExample(exampleApproval);
        return ajaxJson;
    }

    @Override
    public AjaxJson addTsLeave(TsLeaveVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getLeaveType())) {
            ajaxJson.setErrMsg("\u8bf7\u5047\u7c7b\u578b\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getBeginTime())) {
            ajaxJson.setErrMsg("\u5f00\u59cb\u65f6\u95f4\u5fc5\u586b");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getEndTime())) {
            ajaxJson.setErrMsg("\u7ed3\u675f\u65f6\u95f4\u5fc5\u586b");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getLeaveReason())) {
            ajaxJson.setErrMsg("\u8bf7\u5047\u539f\u56e0\u5fc5\u4f20");
            return ajaxJson;
        }
        AjaxJson userVoAjaxJson = this.mdmApiFeign.findUpPositionUser(userRedis.getPosId());
        if (userVoAjaxJson == null || userVoAjaxJson.getObj() == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u4e0a\u7ea7\u7528\u6237\u5931\u8d25");
            return ajaxJson;
        }
        if (StringUtil.equals((String)((TmUserVo)userVoAjaxJson.getObj()).getUsername(), (String)userRedis.getUsername())) {
            ajaxJson.setErrMsg("\u6ca1\u6709\u76f4\u63a5\u4e0a\u7ea7\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6279");
            return ajaxJson;
        }
        TsLeaveEntity tsLeaveEntity = new TsLeaveEntity();
        BeanUtils.copyProperties((Object)vo, (Object)tsLeaveEntity);
        tsLeaveEntity.setBpmStatus(Constant.leaveBpmStatus.COMMIT.getValue());
        tsLeaveEntity.setApprovelUserBy(((TmUserVo)userVoAjaxJson.getObj()).getUsername());
        tsLeaveEntity.setApprovelUserName(((TmUserVo)userVoAjaxJson.getObj()).getFullname());
        this.tsLeaveDao.insertSelective(tsLeaveEntity);
        TsApprovalRecordEntity tsApprovalRecordEntity = new TsApprovalRecordEntity();
        tsApprovalRecordEntity.setBusinessType(Constant.businessType.leave.getValue());
        tsApprovalRecordEntity.setBusinessId(tsLeaveEntity.getId());
        tsApprovalRecordEntity.setApprovalUserBy(((TmUserVo)userVoAjaxJson.getObj()).getUsername());
        tsApprovalRecordEntity.setApprovalUserName(((TmUserVo)userVoAjaxJson.getObj()).getFullname());
        tsApprovalRecordEntity.setBpmStatus(Constant.leaveBpmStatus.COMMIT.getValue());
        this.tsApprovalRecordDao.insertSelective(tsApprovalRecordEntity);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsLeaveVo> findTsLeaveInfo(TsLeaveVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getId())) {
            ajaxJson.setErrMsg("id\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        TsLeaveEntity leaveEntity = (TsLeaveEntity)this.tsLeaveDao.selectByPrimaryKey(vo.getId());
        Example example1 = new Example(TsApprovalRecordEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("businessId", (Object)(leaveEntity.getId() + ""));
        List entities = this.tsApprovalRecordDao.selectByExample(example1);
        TsLeaveVo tsLeaveVo = new TsLeaveVo();
        BeanUtils.copyProperties((Object)leaveEntity, (Object)tsLeaveVo);
        tsLeaveVo.setId(leaveEntity.getId() + "");
        Map map = Constant.tsleaveType.getEnumMap();
        Constant.tsleaveType tsleaveTypeEnum = (Constant.tsleaveType)map.get(tsLeaveVo.getLeaveType());
        if (tsleaveTypeEnum != null) {
            String desc = tsleaveTypeEnum.getDesc();
            tsLeaveVo.setLeaveType(desc);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entities)) {
            tsLeaveVo.setApprovalContent(((TsApprovalRecordEntity)entities.get(0)).getApprovalContent());
        }
        ajaxJson.setObj((Object)tsLeaveVo);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsTravelVo> findTsTravelList(TsTravelVo vo, String page, String rows) {
        AjaxJson ajaxJson = new AjaxJson();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        EuPage page1 = new EuPage();
        if (StringUtil.isEmpty((String)page)) {
            page = "1";
        }
        if (StringUtil.isEmpty((String)rows)) {
            rows = "15";
        }
        page1.setPage(page);
        page1.setRows(rows);
        Example example1 = new Example(TsTravelEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("createBy", (Object)userRedis.getId());
        example1.orderBy("createDate").desc();
        List entities = this.tsTravelDao.selectByExample(example1);
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> entities, (Page)page1);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @Override
    public AjaxJson addTsTravel(TsTravelVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getBeginTime()) || StringUtil.isEmpty((String)vo.getEndTime())) {
            ajaxJson.setErrMsg("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getTravelObjective())) {
            ajaxJson.setErrMsg("\u51fa\u5dee\u76ee\u7684\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getAddress())) {
            ajaxJson.setErrMsg("\u51fa\u5dee\u5730\u5740\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getIsStay())) {
            ajaxJson.setErrMsg("\u662f\u5426\u4f4f\u5bbf\u5fc5\u9009");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getGpsAddress())) {
            ajaxJson.setErrMsg("\u5b9a\u4f4d\u5730\u5740\u5fc5\u586b");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getLat())) {
            ajaxJson.setErrMsg("\u7eac\u5ea6\u5fc5\u4f20");
            return ajaxJson;
        }
        if (vo.getLng() == null) {
            ajaxJson.setErrMsg("\u7ecf\u5ea6\u5fc5\u4f20");
            return ajaxJson;
        }
        AjaxJson userVoAjaxJson = this.mdmApiFeign.findUpPositionUser(userRedis.getPosId());
        if (userVoAjaxJson == null || userVoAjaxJson.getObj() == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u4e0a\u7ea7\u7528\u6237\u5931\u8d25");
            return ajaxJson;
        }
        if (StringUtil.equals((String)((TmUserVo)userVoAjaxJson.getObj()).getUsername(), (String)userRedis.getUsername())) {
            ajaxJson.setErrMsg("\u6ca1\u6709\u76f4\u63a5\u4e0a\u7ea7\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6279");
            return ajaxJson;
        }
        TsTravelEntity tsLeaveEntity = new TsTravelEntity();
        BeanUtils.copyProperties((Object)vo, (Object)tsLeaveEntity);
        tsLeaveEntity.setBpmStatus(Constant.leaveBpmStatus.COMMIT.getValue());
        tsLeaveEntity.setApprovelUserBy(((TmUserVo)userVoAjaxJson.getObj()).getUsername());
        tsLeaveEntity.setApprovelUserName(((TmUserVo)userVoAjaxJson.getObj()).getFullname());
        this.tsTravelDao.insertSelective(tsLeaveEntity);
        TsApprovalRecordEntity tsApprovalRecordEntity = new TsApprovalRecordEntity();
        tsApprovalRecordEntity.setBusinessType(Constant.businessType.travel.getValue());
        tsApprovalRecordEntity.setBusinessId(tsLeaveEntity.getId());
        tsApprovalRecordEntity.setApprovalUserBy(((TmUserVo)userVoAjaxJson.getObj()).getUsername());
        tsApprovalRecordEntity.setApprovalUserName(((TmUserVo)userVoAjaxJson.getObj()).getFullname());
        tsApprovalRecordEntity.setBpmStatus(Constant.leaveBpmStatus.COMMIT.getValue());
        this.tsApprovalRecordDao.insertSelective(tsApprovalRecordEntity);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsTravelVo> findTsTravelInfo(TsTravelVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getId())) {
            ajaxJson.setErrMsg("id\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        TsTravelEntity tsTravelEntity = (TsTravelEntity)this.tsTravelDao.selectByPrimaryKey(vo.getId());
        Example example1 = new Example(TsApprovalRecordEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("businessId", (Object)(tsTravelEntity.getId() + ""));
        List entities = this.tsApprovalRecordDao.selectByExample(example1);
        TsTravelVo tsTravelVo = new TsTravelVo();
        BeanUtils.copyProperties((Object)tsTravelEntity, (Object)tsTravelVo);
        tsTravelVo.setId(tsTravelEntity.getId() + "");
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entities)) {
            tsTravelVo.setApprovalContent(((TsApprovalRecordEntity)entities.get(0)).getApprovalContent());
        }
        ajaxJson.setObj((Object)tsTravelVo);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsApprovalRecordVo> findTsApprovalList(TsApprovalRecordVo vo, String page, String rows) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getBpmStatus())) {
            ajaxJson.setErrMsg("\u8bf7\u4f20\u5165\u5ba1\u6279\u72b6\u6001\u67e5\u8be2");
            return ajaxJson;
        }
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            ajaxJson.setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return ajaxJson;
        }
        EuPage page1 = new EuPage();
        if (StringUtil.isEmpty((String)page)) {
            page = "1";
        }
        if (StringUtil.isEmpty((String)rows)) {
            rows = "15";
        }
        page1.setPage(page);
        page1.setRows(rows);
        Example example1 = new Example(TsApprovalRecordEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("approvalUserBy", (Object)userRedis.getUsername());
        if (StringUtil.equals((String)"1", (String)vo.getBpmStatus())) {
            criteria1.andEqualTo("bpmStatus", (Object)Constant.leaveBpmStatus.PASS.getValue());
            criteria1.orEqualTo("bpmStatus", (Object)Constant.leaveBpmStatus.REJECT.getValue());
        } else {
            criteria1.andEqualTo("bpmStatus", (Object)Constant.leaveBpmStatus.COMMIT.getValue());
        }
        example1.orderBy("createDate").desc();
        List entities = this.tsApprovalRecordDao.selectByExample(example1);
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> entities, (Page)page1);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @Override
    public AjaxJson commitTsApproval(TsApprovalRecordVo vo) {
        TsTravelEntity tsTravelEntity;
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getBpmStatus())) {
            ajaxJson.setErrMsg("\u5ba1\u6279\u72b6\u6001\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getApprovalContent())) {
            ajaxJson.setErrMsg("\u5ba1\u6279\u610f\u89c1\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getId())) {
            ajaxJson.setErrMsg("id\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((Object)vo.getBusinessId())) {
            ajaxJson.setErrMsg("\u4e1a\u52a1id\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)vo.getBusinessType())) {
            ajaxJson.setErrMsg("\u5ba1\u6279\u4e1a\u52a1\u7c7b\u578b\u5fc5\u4f20");
            return ajaxJson;
        }
        TsApprovalRecordEntity tsApprovalRecordEntity = (TsApprovalRecordEntity)this.tsApprovalRecordDao.selectByPrimaryKey(vo.getId());
        tsApprovalRecordEntity.setBpmStatus(vo.getBpmStatus());
        tsApprovalRecordEntity.setApprovalContent(vo.getApprovalContent());
        tsApprovalRecordEntity.setApprovalTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        this.tsApprovalRecordDao.updateByPrimaryKeySelective(tsApprovalRecordEntity);
        if (StringUtil.equals((String)vo.getBusinessType(), (String)Constant.businessType.leave.getValue())) {
            TsLeaveEntity tsLeaveEntity = (TsLeaveEntity)this.tsLeaveDao.selectByPrimaryKey(vo.getBusinessId());
            if (tsLeaveEntity != null) {
                tsLeaveEntity.setBpmStatus(vo.getBpmStatus());
                this.tsLeaveDao.updateByPrimaryKeySelective(tsLeaveEntity);
            }
        } else if (StringUtil.equals((String)vo.getBusinessType(), (String)Constant.businessType.travel.getValue()) && (tsTravelEntity = (TsTravelEntity)this.tsTravelDao.selectByPrimaryKey(vo.getBusinessId())) != null) {
            tsTravelEntity.setBpmStatus(vo.getBpmStatus());
            this.tsTravelDao.updateByPrimaryKeySelective(tsTravelEntity);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson deleteTsTravel(TsLeaveVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getId())) {
            ajaxJson.setErrMsg("id\u7f3a\u5931");
            return ajaxJson;
        }
        Example example1 = new Example(TsTravelEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("id", (Object)vo.getId());
        this.tsTravelDao.deleteByExample(example1);
        Example exampleApproval = new Example(TsApprovalRecordEntity.class);
        Example.Criteria criteria1Approval = exampleApproval.createCriteria();
        criteria1Approval.andEqualTo("businessId", (Object)vo.getId());
        criteria1Approval.andEqualTo("businessType", (Object)Constant.businessType.travel.getValue());
        this.tsApprovalRecordDao.deleteByExample(exampleApproval);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TsWorkSignVo> getSignInfoById(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)id)) {
            ajaxJson.setErrMsg("id\u5fc5\u4f20");
            return ajaxJson;
        }
        TsWorkSignEntity tsWorkSignEntity = (TsWorkSignEntity)this.tsWorkSignDao.selectByPrimaryKey(id);
        TsWorkSignVo vo = new TsWorkSignVo();
        BeanUtils.copyProperties((Object)tsWorkSignEntity, (Object)vo);
        vo.setId(tsWorkSignEntity.getId() + "");
        Example picExample = new Example(TsPictureEntity.class);
        Example.Criteria criteria1Approval = picExample.createCriteria();
        criteria1Approval.andEqualTo("businessId", (Object)vo.getId());
        criteria1Approval.andEqualTo("imgType", (Object)Constant.imgType.kq.getValue());
        List pictureEntities = this.tsPictureDao.selectByExample(picExample);
        vo.setImgList(pictureEntities);
        ajaxJson.setObj((Object)vo);
        return ajaxJson;
    }

    @Override
    public PageInfo<TsWorkSignEntity> findWorkSignReportList(TsWorkSignVo vo, Page page) {
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tsWorkSignDao.selectReportList(vo), (Page)page);
        return pageInfo;
    }

    @Override
    public PageInfo<TsLeaveEntity> findLeaveReportList(TsLeaveVo vo, Page page) {
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tsLeaveDao.findLeaveReportList(vo), (Page)page);
        return pageInfo;
    }

    @Override
    public PageInfo<TsTravelEntity> findTravelReportList(TsTravelVo vo, Page page) {
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tsTravelDao.findTravelReportList(vo), (Page)page);
        return pageInfo;
    }
}

