/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.collection.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.BaseController;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.collection.entity.TsDirectoryConfigEntity;
import com.biz.eisp.collection.entity.TsInputConfigEntity;
import com.biz.eisp.collection.service.TsDirectoryConfigService;
import com.biz.eisp.collection.vo.TsDirectoryConfigVo;
import com.biz.eisp.collection.vo.TsInputConfigVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/tsDirectoryConfigController"})
public class TsDirectoryConfigController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TsDirectoryConfigController.class);
    @Autowired
    private TsDirectoryConfigService tsDirectoryConfigService;

    @RequestMapping(value={"goTsDirectoryConfigMain"})
    public ModelAndView goTsDirectoryConfigMain(HttpServletRequest request) {
        ModelAndView view = new ModelAndView("com/biz/eisp/sfa/collection/tsDirectoryConfigMain");
        view.addObject("extendTableName", (Object)Globals.TABLE_COST_TYPE);
        return view;
    }

    @RequestMapping(value={"findTsDirectoryConfigList"})
    @ResponseBody
    public DataGrid findTsDirectoryConfigList(TsDirectoryConfigVo tsDirectoryConfigVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<TsDirectoryConfigVo> pageInfo = this.tsDirectoryConfigService.findTsDirectoryConfigVoList(tsDirectoryConfigVo, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goTsDirectoryConfigForm"})
    public ModelAndView goTsDirectoryConfigForm(TsDirectoryConfigVo tsDirectoryConfigVo, String type, HttpServletRequest req) {
        try {
            if (!StringUtil.isEmpty((Object)tsDirectoryConfigVo.getId())) {
                TsDirectoryConfigEntity entity = (TsDirectoryConfigEntity)this.tsDirectoryConfigService.selectByPrimaryKey(tsDirectoryConfigVo.getId());
                if (entity != null) {
                    List<TsInputConfigEntity> configList = this.tsDirectoryConfigService.getConfigList(tsDirectoryConfigVo.getId());
                    req.setAttribute("configList", configList);
                }
                req.setAttribute("vo", (Object)entity);
            }
            req.setAttribute("type", (Object)type);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return new ModelAndView("com/biz/eisp/sfa/collection/tsDirectoryConfigFrom");
    }

    @RequestMapping(value={"saveTsDirectoryConfig"})
    @ResponseBody
    public AjaxJson saveTsDirectoryConfig(TsDirectoryConfigVo tsDirectoryConfigVo) {
        AjaxJson j = new AjaxJson();
        try {
            this.tsDirectoryConfigService.saveTsDirectoryConfig(tsDirectoryConfigVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            log.error("", (Throwable)e);
        }
        return j;
    }

    @RequestMapping(value={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tsDirectoryConfigService.doBatchDel(ids);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            ajaxJson.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(value={"goLogMain"})
    public ModelAndView goLogMain(TsDirectoryConfigVo vo, HttpServletRequest request) {
        String id = request.getParameter("id");
        String url = "tsDirectoryConfigController.do?findLogs&id=" + id;
        request.setAttribute("actionUrl", (Object)url);
        return new ModelAndView("com/biz/eisp/log/tmLogDetailMain");
    }

    @RequestMapping(value={"findTsInputConfigListByDirectId"})
    @ResponseBody
    public DataGrid findTsInputConfigListByDirectId(TsInputConfigVo tsInputConfigVo, String directId, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<Object> result = new ArrayList();
        if (directId != null && directId.length() > 0) {
            result = this.tsDirectoryConfigService.findTsInputConfigListByDirectId(tsInputConfigVo, (Page)page, directId);
        }
        return new DataGrid(result, (Page)page);
    }

    @RequestMapping(value={"updateStatus"})
    @ResponseBody
    public AjaxJson updateStatus(String id, String enableStatus) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tsDirectoryConfigService.updateStatus(id, enableStatus);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxJson;
    }
}

