/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.common;

import com.biz.eisp.base.common.util.OConvertUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static String getExtend(String filename) {
        return FileUtils.getExtend(filename, "");
    }

    public static String getExtend(String filename, String defExt) {
        int i;
        if (filename != null && filename.length() > 0 && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return defExt.toLowerCase();
    }

    public static String getFilePrefix(String fileName) {
        int splitIndex = fileName.lastIndexOf(".");
        return fileName.substring(0, splitIndex).replaceAll("\\s*", "");
    }

    public static String getFilePrefix2(String fileName) {
        int splitIndex = fileName.lastIndexOf(".");
        return fileName.substring(0, splitIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String inputFile, String outputFile) throws FileNotFoundException {
        File sFile = new File(inputFile);
        File tFile = new File(outputFile);
        FileInputStream fis = new FileInputStream(sFile);
        FileOutputStream fos = new FileOutputStream(tFile);
        int temp = 0;
        byte[] buf = new byte[10240];
        try {
            while ((temp = fis.read(buf)) != -1) {
                fos.write(buf, 0, temp);
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        finally {
            try {
                fis.close();
                fos.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public static boolean isPicture(String filename) {
        if (OConvertUtils.isEmpty((Object)filename)) {
            return false;
        }
        String tmpName = filename;
        String[][] imgeArray = new String[][]{{"bmp", "0"}, {"dib", "1"}, {"gif", "2"}, {"jfif", "3"}, {"jpe", "4"}, {"jpeg", "5"}, {"jpg", "6"}, {"png", "7"}, {"tif", "8"}, {"tiff", "9"}, {"ico", "10"}};
        for (int i = 0; i < imgeArray.length; ++i) {
            if (!imgeArray[i][0].equals(tmpName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDwg(String filename) {
        if (OConvertUtils.isEmpty((Object)filename)) {
            return false;
        }
        String tmpName = FileUtils.getExtend(filename);
        return tmpName.equals("dwg");
    }

    public static boolean delete(String strFileName) {
        File fileDelete = new File(strFileName);
        if (!fileDelete.exists() || !fileDelete.isFile()) {
            return false;
        }
        return fileDelete.delete();
    }

    public static String encodingFileName(String fileName) {
        String returnFileName = "";
        try {
            returnFileName = URLEncoder.encode(fileName, "UTF-8");
            returnFileName = StringUtils.replace((String)returnFileName, (String)"+", (String)"%20");
            if (returnFileName.length() > 150) {
                returnFileName = new String(fileName.getBytes("GB2312"), "ISO8859-1");
                returnFileName = StringUtils.replace((String)returnFileName, (String)" ", (String)"%20");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        return returnFileName;
    }
}

