/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.picture.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.common.FileUtils;
import com.biz.eisp.picture.UploadService;
import com.biz.eisp.picture.vo.TsPictureVo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class UploadServiceImpl
implements UploadService {
    private static final Logger log = LoggerFactory.getLogger(UploadServiceImpl.class);
    private static String FILE_SEPARATOR = File.separator;
    private static final String pointFolderField = "";
    @Value(value="${upload.win-path}")
    private String WIN_UPLOAD_ROOT;
    @Value(value="${upload.linux-path}")
    private String LINUX_UPLOAD_ROOT;
    @Value(value="${upload.base-path}")
    private String UPLOAD_BASE_PATH;
    @Value(value="${upload.url-path}")
    private String UPLOAD_URL_PATH;

    @Override
    public List<TsPictureVo> saveMoreFile(HttpServletRequest request) {
        ArrayList<TsPictureVo> savePaths = new ArrayList<TsPictureVo>();
        String pointFolderFieldTemp = this.getThePointFolderField(request);
        try {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            multipartRequest.setCharacterEncoding("UTF-8");
            List files = ((MultipartHttpServletRequest)request).getFiles("files");
            String basePath = this.createAndReturnBasePath(pointFolderFieldTemp);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)files)) {
                files.forEach(mf -> {
                    TsPictureVo fileVo = new TsPictureVo();
                    String fileName = mf.getOriginalFilename();
                    fileVo.setFileName(fileName);
                    String extend = FileUtils.getExtend(fileName);
                    fileVo.setExtend(extend);
                    String newFileName = this.getNewFileName(extend);
                    String savePath = this.getRealPath(basePath, newFileName);
                    System.out.println(savePath);
                    this.saveFile((MultipartFile)mf, savePath, extend);
                    fileVo.setImgPath(this.getRealPath_(basePath, newFileName));
                    fileVo.setImgUrl(this.getUrlPath(basePath, newFileName));
                    savePaths.add(fileVo);
                });
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error(pointFolderField, (Throwable)e);
            throw new RuntimeException(e);
        }
        return savePaths;
    }

    private String getThePointFolderField(HttpServletRequest request) {
        String obj = request.getParameter(pointFolderField);
        if (StringUtil.isNotEmpty((Object)obj)) {
            return obj;
        }
        return pointFolderField;
    }

    public String saveFile(MultipartFile mf, String savePath, String extend) {
        if ("txt".equals(extend)) {
            this.copyToDisk(mf, savePath);
        } else {
            File savefile = new File(savePath);
            try {
                FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
            }
            catch (IOException e) {
                log.error(pointFolderField, (Throwable)e);
                throw new RuntimeException("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff01");
            }
        }
        return pointFolderField;
    }

    private void copyToDisk(MultipartFile mf, String savePath) {
        try {
            byte[] allbytes = mf.getBytes();
            String head1 = this.toHexString(allbytes[0]);
            String head2 = this.toHexString(allbytes[1]);
            if ("ef".equals(head1) && "bb".equals(head2)) {
                String contents = new String(mf.getBytes(), "UTF-8");
                if (StringUtil.isNotBlank((CharSequence)contents)) {
                    FileOutputStream out = new FileOutputStream(savePath);
                    ((OutputStream)out).write(contents.getBytes());
                    ((OutputStream)out).close();
                }
            } else {
                String contents = new String(mf.getBytes(), "GBK");
                FileOutputStream out = new FileOutputStream(savePath);
                ((OutputStream)out).write(contents.getBytes());
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            try {
                String contents = new String(mf.getBytes(), "UTF-8");
                if (StringUtil.isNotBlank((CharSequence)contents)) {
                    FileOutputStream out = new FileOutputStream(savePath);
                    ((OutputStream)out).write(contents.getBytes());
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private String toHexString(int index) {
        String hexString = Integer.toHexString(index);
        hexString = hexString.substring(hexString.length() - 2);
        return hexString;
    }

    private String getNewFileName(String extend) {
        return DateUtils.getDataString((SimpleDateFormat)DateUtils.yyyymmddhhmmss) + UUIDGenerator.generate() + "." + extend;
    }

    private String createAndReturnBasePath(String pointFolder) {
        String basePath = this.getBasePath(pointFolder);
        File file = new File(this.getRealPath(basePath, pointFolderField));
        if (!file.exists()) {
            file.mkdirs();
        }
        return basePath;
    }

    private String getRootPath() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return this.WIN_UPLOAD_ROOT;
        }
        return this.LINUX_UPLOAD_ROOT;
    }

    public String getCouldDownloadPath() {
        return this.getRootPath() + this.UPLOAD_BASE_PATH;
    }

    private String getBasePath(String pointFolder) {
        return this.UPLOAD_BASE_PATH + FILE_SEPARATOR + this.checkAndRturnPointFolder(pointFolder) + DateUtils.getDataString((SimpleDateFormat)DateUtils.date_sdf);
    }

    private String checkAndRturnPointFolder(String pointFolder) {
        if (StringUtil.isNotEmpty((CharSequence)pointFolder)) {
            return pointFolder.replace("/", FILE_SEPARATOR) + FILE_SEPARATOR;
        }
        return pointFolderField;
    }

    private String getRealPath(String basePath, String fileName) {
        return this.getRootPath() + basePath + FILE_SEPARATOR + fileName;
    }

    private String getRealPath_(String basePath, String fileName) {
        return basePath + FILE_SEPARATOR + fileName;
    }

    private String getUrlPath(String basePath, String fileName) {
        return this.UPLOAD_URL_PATH + basePath + FILE_SEPARATOR + fileName;
    }
}

