/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.visit;

import com.biz.eisp.attendance.picture.dao.TsPictureDao;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.collection.dao.TsDirectoryInputDao;
import com.biz.eisp.collection.entity.TsDirectoryInputEntity;
import com.biz.eisp.collection.service.TsDirectoryConfigService;
import com.biz.eisp.collection.service.TsInputConfigService;
import com.biz.eisp.collection.vo.TsDirectoryApiVo;
import com.biz.eisp.params.Constant;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.utils.Result;
import com.biz.eisp.visitnote.vo.TsDirectoryApiHisQueryVo;
import com.biz.eisp.visitnote.vo.TsDirectoryApiQueryVo;
import com.biz.eisp.visitnote.vo.TsDirectoryApiResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@Api(tags={"\u62dc\u8bbf\u6b65\u9aa4\u67e5\u8be2"})
@RestController
@RequestMapping(value={"/sfaApi/tsVisitDirectoryApiController"})
public class TsVisitDirectoryApiController {
    private static final Logger log = LoggerFactory.getLogger(TsVisitDirectoryApiController.class);
    @Autowired
    private TsDirectoryConfigService tsDirectoryConfigService;
    @Autowired
    private TsDirectoryInputDao tsDirectoryInputDao;
    @Autowired
    private TsPictureDao tsPictureDao;
    @Value(value="${upload.url-path}")
    private String UPLOAD_URL_PATH;
    @Autowired
    private TsInputConfigService tsInputConfigService;

    @PostMapping(value={"findTsDirectoryByCon"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u53ef\u663e\u793a\u7684\u6b65\u9aa4\u5217\u8868", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u53ef\u663e\u793a\u7684\u6b65\u9aa4\u5217\u8868,\u8fd4\u56de\u503c\u5728objList", httpMethod="POST")
    public Result<TsDirectoryApiResultVo> findTsDirectoryByCon(@RequestBody TsDirectoryApiQueryVo vo) {
        Result<TsDirectoryApiResultVo> j = new Result<TsDirectoryApiResultVo>();
        List<TsDirectoryApiResultVo> list = this.tsDirectoryConfigService.findTsDirectoryByCon(vo);
        j.setObjList(list);
        return j;
    }

    @PostMapping(value={"doSave"})
    @ApiOperation(value="\u63d0\u4ea4\u7ebf\u8def\u6b65\u9aa4\u6267\u884c\u6570\u636e", notes="\u63d0\u4ea4\u7ebf\u8def\u6b65\u9aa4\u6267\u884c\u6570\u636e,success", httpMethod="POST")
    public Result doSave(@RequestBody TsDirectoryApiVo vo) {
        Result j = new Result();
        try {
            this.tsDirectoryConfigService.saveTsDirectoryInput(vo);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u63d0\u4ea4\u5931\u8d25");
        }
        return j;
    }

    @PostMapping(value={"getDirectoryInputHisDetail"})
    @ApiOperation(value="\u83b7\u53d6\u62dc\u8bbf\u6267\u884c\u5386\u53f2\u660e\u7ec6", notes="\u83b7\u53d6\u62dc\u8bbf\u6267\u884c\u5386\u53f2\u660e\u7ec6\uff0c\u5982\u679cobjList\u4e3a\u7a7a\u8868\u793a\u6ca1\u5f97\u8bb0\u5f55", httpMethod="POST")
    public Result<TsDirectoryInputEntity> getDirectoryInputHisDetail(@RequestBody TsDirectoryApiHisQueryVo vo) {
        Result<TsDirectoryInputEntity> j = new Result<TsDirectoryInputEntity>();
        try {
            Example example = new Example(TsDirectoryInputEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("visitId", (Object)vo.getVisitId());
            criteria.andEqualTo("visitType", (Object)vo.getVisitType());
            criteria.andEqualTo("directoryCode", (Object)vo.getDirectoryCode());
            List list = this.tsDirectoryInputDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                list.stream().filter(tt -> "T11".equals(this.tsInputConfigService.getInputType(tt.getLableId()))).forEach(item -> {
                    Example example1 = new Example(TsPictureEntity.class);
                    Example.Criteria criteria1 = example1.createCriteria();
                    criteria1.andEqualTo("businessId", (Object)item.getId());
                    criteria1.andEqualTo("imgType", (Object)(Constant.imgType.exec.getValue() + item.getLableCode()));
                    List pics = this.tsPictureDao.selectByExample(example1);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)pics)) {
                        ArrayList plist = new ArrayList();
                        pics.forEach(pc -> plist.add(this.UPLOAD_URL_PATH + pc.getImgPath()));
                        item.setLableValue(StringUtils.join(plist, (String)","));
                    }
                });
                j.setObjList(list);
            }
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u67e5\u8be2\u5931\u8d25");
        }
        return j;
    }
}

