/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.visit;

import com.biz.eisp.attendance.picture.dao.TsPictureDao;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.common.SfaConstantEnum;
import com.biz.eisp.params.Constant;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.utils.Result;
import com.biz.eisp.visitnote.entity.VisitInfoEntity;
import com.biz.eisp.visitnote.service.VisitInfoService;
import com.biz.eisp.visitnote.vo.VisitInfoApiOutVo;
import com.biz.eisp.visitnote.vo.VisitInfoApiVo;
import com.biz.eisp.visitnote.vo.VisitInfoHisApiVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@Api(tags={"\u7ebf\u8def\u62dc\u8bbf\u8fdb\u79bb\u5e97\u6570\u636e"})
@RestController
@RequestMapping(value={"/sfaApi/tsVisitInfoController"})
public class TsVisitInfoController {
    private static final Logger log = LoggerFactory.getLogger(TsVisitInfoController.class);
    @Autowired
    private TsPictureDao tsPictureDao;
    @Autowired
    private VisitInfoService visitInfoService;

    @PostMapping(value={"doSaveVisitInfo"})
    @ApiOperation(value="\u63d0\u4ea4\u8fdb\u79bb\u5e97\u6570\u636e", notes="\u63d0\u4ea4\u8fdb\u79bb\u5e97\u6570\u636e", httpMethod="POST")
    public Result doSaveVisitInfo(@RequestBody VisitInfoApiVo vo) {
        Result j = new Result();
        try {
            this.visitInfoService.doSaveVisitInfo(vo);
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u63d0\u4ea4\u5931\u8d25");
        }
        return j;
    }

    @PostMapping(value={"getVisitInfoHis"})
    @ApiOperation(value="\u83b7\u53d6\u62dc\u8bbf\u8fdb\u79bb\u5e97\u5386\u53f2\u660e\u7ec6", notes="\u83b7\u53d6\u62dc\u8bbf\u8fdb\u79bb\u5e97\u5386\u53f2\u660e\u7ec6\uff0c\u5982\u679cobj\u4e3a\u7a7a\u8868\u793a\u6ca1\u5f97\u8bb0\u5f55", httpMethod="POST")
    public Result<VisitInfoApiOutVo> getVisitInfoHis(@RequestBody VisitInfoHisApiVo vo) {
        Result<VisitInfoApiOutVo> j = new Result<VisitInfoApiOutVo>();
        try {
            Example example = new Example(VisitInfoEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("visitId", (Object)vo.getVisitId());
            criteria.andEqualTo("visitType", (Object)vo.getVisitType());
            if (vo.getVisitAction().equals(SfaConstantEnum.VisitAction.in.getVal())) {
                criteria.andIsNotNull("inSubTime");
            } else {
                criteria.andIsNotNull("outSubTime");
            }
            List list = this.visitInfoService.selectExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                VisitInfoEntity info = (VisitInfoEntity)list.get(0);
                Example example1 = new Example(TsPictureEntity.class);
                Example.Criteria criteria1 = example1.createCriteria();
                criteria1.andEqualTo("businessId", (Object)info.getId());
                criteria1.andEqualTo("imgType", (Object)(Constant.imgType.inout.getValue() + vo.getVisitAction()));
                VisitInfoApiOutVo outVo = new VisitInfoApiOutVo();
                MyBeanUtils.copyBeanNotNull2Bean((Object)info, (Object)outVo);
                List pics = this.tsPictureDao.selectByExample(example1);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)pics)) {
                    outVo.setPics(pics.stream().map(TsPictureEntity::getImgUrl).collect(Collectors.toList()));
                }
                if (vo.getVisitAction().equals(SfaConstantEnum.VisitAction.in.getVal())) {
                    outVo.setSubTime(info.getInSubTime());
                } else {
                    outVo.setSubTime(info.getOutSubTime());
                }
                outVo.setAddress(StringUtils.isNotBlank((CharSequence)info.getInAddress()) ? info.getInAddress() : info.getOutAddress());
                j.setObj(outVo);
            }
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u52a0\u8f7d\u5931\u8d25");
        }
        return j;
    }
}

