/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.visit;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.common.SfaConstantEnum;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.utils.Result;
import com.biz.eisp.visitnote.entity.VisitInfoEntity;
import com.biz.eisp.visitnote.entity.VisitNoteEntity;
import com.biz.eisp.visitnote.service.VisitInfoService;
import com.biz.eisp.visitnote.service.VisitNoteService;
import com.biz.eisp.visitnote.vo.PageVo;
import com.biz.eisp.visitnote.vo.TsVisitApiQueryVo;
import com.biz.eisp.visitnote.vo.TsVisitClientApiVo;
import com.biz.eisp.visitnote.vo.TsVisitHisApiVo;
import com.biz.eisp.visitnote.vo.VisitNoteVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@Api(tags={"\u7ebf\u8def\u62dc\u8bbf"})
@RestController
@RequestMapping(value={"/sfaApi/tsVisitListController"})
public class TsVisitListController {
    private static final Logger log = LoggerFactory.getLogger(TsVisitListController.class);
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private VisitNoteService visitNoteService;
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private VisitInfoService visitInfoService;

    @PostMapping(value={"getVisitNoteByCon"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ebf\u8def\u5217\u8868", notes="userId \u4f20\u53c2\u6570\u65f6\u8868\u793a\u67e5\u8be2\u534f\u8bae\u4eba\u5458\u5bf9\u5e94\u7684\u7ebf\u8def\uff0c\u5206\u9875\u67e5\u8be2\u7ebf\u8def\u5217\u8868,page\u548crows\u8981\u4f20", httpMethod="POST")
    public Result getVisitNoteByCon(@RequestBody TsVisitApiQueryVo vo) {
        Result<PageInfo<VisitNoteVo>> j = new Result<PageInfo<VisitNoteVo>>();
        try {
            String userId = vo.getUserId();
            String visitType = "";
            if (StringUtils.isBlank((CharSequence)userId)) {
                UserRedis user = UserUtils.getUser();
                if (user == null) {
                    j.setSuccess(false);
                    j.setMsg("\u7528\u6237\u4fe1\u606f\u9519\u8bef");
                    return j;
                }
                userId = user.getId();
            } else {
                visitType = SfaConstantEnum.VisitType.assit_type.getVal();
            }
            List pos = ApiResultUtil.listResult((AjaxJson)this.tmPositionFeign.getUserPositons("", userId));
            if (CollectionUtil.listNotEmptyNotSizeZero((List)pos)) {
                List<String> ps = pos.stream().map(TmPositionVo::getId).collect(Collectors.toList());
                EuPage page_ = new EuPage();
                page_.setPage(vo.getPage());
                page_.setRows(vo.getRows());
                PageInfo<VisitNoteVo> pageInfo = this.visitNoteService.getVisitInfo(vo, ps, DateUtils.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd"), vo.getClientName(), (Page)page_);
                if (visitType.equals(SfaConstantEnum.VisitType.assit_type.getVal())) {
                    this.checkVisitAssit(pageInfo);
                }
                j.setObj(pageInfo);
            } else {
                j.setSuccess(false);
                j.setMsg("\u672a\u914d\u7f6e\u804c\u4f4d\uff0c\u67e5\u8be2\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u67e5\u8be2\u5931\u8d25");
        }
        return j;
    }

    private void checkVisitAssit(PageInfo<VisitNoteVo> pageInfo) {
        if (pageInfo != null && CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            pageInfo.getList().forEach(item -> {
                item.setVisitStatus("0");
                Example example = new Example(VisitInfoEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("visitId", (Object)item.getId());
                criteria.andEqualTo("clientId", (Object)item.getClientId());
                criteria.andEqualTo("visitType", (Object)SfaConstantEnum.VisitType.assit_type.getVal());
                ArrayList<String> vacts = new ArrayList<String>();
                vacts.add(SfaConstantEnum.VisitAction.in.getVal());
                vacts.add(SfaConstantEnum.VisitAction.out.getVal());
                criteria.andIn("visitAction", vacts);
                List list = this.visitInfoService.selectExample(example);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                    item.setVisitStatus(((VisitInfoEntity)list.get(0)).getVisitAction());
                }
            });
        }
    }

    @PostMapping(value={"getVisitClientList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4e34\u65f6\u7ebf\u8def\u7f51\u70b9", notes="\u5206\u9875\u67e5\u8be2\u4e34\u65f6\u7ebf\u8def\u7f51\u70b9,page\u548crows\u8981\u4f20", httpMethod="POST")
    public Result<PageInfo<VisitNoteVo>> getVisitClientList(@RequestBody TsVisitClientApiVo apiVo) {
        Result<PageInfo<VisitNoteVo>> j = new Result<PageInfo<VisitNoteVo>>();
        UserRedis user = UserUtils.getUser();
        if (user == null || StringUtils.isBlank((CharSequence)user.getId())) {
            j.setMsg("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25");
            j.setSuccess(false);
            return j;
        }
        PageInfo pageInfo = null;
        List pos = ApiResultUtil.listResult((AjaxJson)this.tmPositionFeign.getUserPositons("", user.getId()));
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pos)) {
            List resultVos;
            List ps = pos.stream().map(TmPositionVo::getId).collect(Collectors.toList());
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("page", apiVo.getPage());
            param.put("rows", apiVo.getRows());
            param.put("customerName", apiVo.getClientName());
            param.put("posId", StringUtils.join(ps, (String)","));
            pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.mdmApiFeign.getCustomerByPosIdPage(param));
            if (pageInfo != null && CollectionUtil.listNotEmptyNotSizeZero((List)(resultVos = pageInfo.getList()))) {
                pageInfo.setList(this.visitNoteService.getCheckCustomerVisit(resultVos, apiVo));
            }
        } else {
            j.setSuccess(false);
            j.setMsg("\u672a\u914d\u7f6e\u804c\u4f4d\uff0c\u67e5\u8be2\u5931\u8d25");
        }
        j.setObj(pageInfo);
        return j;
    }

    @GetMapping(value={"addLineTemp"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="clientId", value="\u7f51\u70b9id", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="clientType", value="\u7f51\u70b9\u7c7b\u578b", required=true, dataType="String", paramType="query")})
    @ApiOperation(value="\u624b\u673a\u7aef\u6dfb\u52a0\u62dc\u8bbf\u7ebf\u8def(\u4e34\u65f6\u7ebf\u8def)", notes="\u624b\u673a\u7aef\u6dfb\u52a0\u62dc\u8bbf\u7ebf\u8def(\u4e34\u65f6\u7ebf\u8def)", httpMethod="GET")
    public Result<VisitNoteEntity> addLineTemp(@RequestParam(value="clientId") String clientId, @RequestParam(value="clientType") String clientType) {
        Result<VisitNoteEntity> j = new Result<VisitNoteEntity>();
        try {
            VisitNoteEntity entity = this.visitNoteService.addLIneTemp(clientId, clientType);
            j.setObj(entity);
        }
        catch (BusinessException e) {
            j.setMsg(e.getMessage());
            j.setSuccess(false);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setMsg("\u6dfb\u52a0\u4e34\u65f6\u7ebf\u8def\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @PostMapping(value={"getDownUserByCon"})
    @ApiOperation(value="\u67e5\u4e0b\u7ea7\u4eba\u5458\u53ca\u5c97\u4f4d", notes="\u67e5\u4e0b\u7ea7\u4eba\u5458\u53ca\u5c97\u4f4d,page\u548crows\u8981\u4f20", httpMethod="POST")
    public Result getDownUserByCon(@RequestBody PageVo pageVo) {
        Result<PageInfo> j = new Result<PageInfo>();
        UserRedis user = UserUtils.getUser();
        if (user == null || StringUtils.isBlank((CharSequence)user.getId())) {
            j.setSuccess(false);
            j.setMsg("\u7528\u6237\u65e0\u6743\u9650");
            return j;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", user.getId());
        map.put("page", pageVo.getPage());
        map.put("rows", pageVo.getRows());
        j.setObj(ApiResultUtil.pageInfoResult((AjaxJson)this.tmUserFeign.getDownUserByCon(map)));
        return j;
    }

    @PostMapping(value={"findHistoryVisit"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5386\u53f2\u62dc\u8bbf\u7ebf\u8def\u7f51\u70b9", notes="\u5206\u9875\u67e5\u8be2\u5386\u53f2\u4e34\u65f6\u7ebf\u8def\u7f51\u70b9,page\u548crows\u8981\u4f20", httpMethod="POST")
    public Result findHistoryVisit(@RequestBody TsVisitHisApiVo vo) {
        Result<PageInfo<VisitNoteVo>> j = new Result<PageInfo<VisitNoteVo>>();
        UserRedis user = UserUtils.getUser();
        if (user == null) {
            j.setSuccess(false);
            j.setMsg("\u7528\u6237\u4fe1\u606f\u9519\u8bef");
            return j;
        }
        String userId = user.getId();
        List pos = ApiResultUtil.listResult((AjaxJson)this.tmPositionFeign.getUserPositons("", userId));
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pos)) {
            List<String> ps = pos.stream().map(TmPositionVo::getId).collect(Collectors.toList());
            EuPage page_ = new EuPage();
            page_.setPage(vo.getPage());
            page_.setRows(vo.getRows());
            PageInfo<VisitNoteVo> pageInfo = this.visitNoteService.getVisitHisInfo(ps, vo, (Page)page_);
            j.setObj(pageInfo);
        } else {
            j.setSuccess(false);
            j.setMsg("\u672a\u914d\u7f6e\u804c\u4f4d\uff0c\u67e5\u8be2\u5931\u8d25");
        }
        return j;
    }
}

