/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.visitnote;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.BaseController;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.visitnote.entity.VisitGroupEntity;
import com.biz.eisp.visitnote.entity.VisitclientRelEntity;
import com.biz.eisp.visitnote.service.VisitGroupServiceI;
import com.biz.eisp.visitnote.vo.SFACustomerVo;
import com.biz.eisp.visitnote.vo.VisitGroupVo;
import com.biz.eisp.visitnote.vo.VisitclientRelVo;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/visitGroupController"})
public class VisitGroupController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(VisitGroupController.class);
    @Autowired
    private VisitGroupServiceI visitGroupService;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private MdmApiFeign mdmApiFeign;

    @RequestMapping(value={"findVisitGroupPage"})
    @ResponseBody
    public DataGrid findVisitGroupPage(VisitGroupEntity visitGroup, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<VisitGroupEntity> pageInfo = null;
        try {
            pageInfo = this.visitGroupService.findVisitGroupPage(visitGroup, (Page)page);
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u7ebf\u8def\u7ec4\u5931\u8d25");
        }
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveOrUpdateVisitGroup"})
    @ResponseBody
    public AjaxJson saveOrUpdateVisitGroup(VisitGroupVo visitGroupVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.visitGroupService.saveOrUpdateVisitGroup(visitGroupVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            log.error("", (Throwable)e);
        }
        return j;
    }

    @RequestMapping(value={"/startVisitGroup"})
    @ResponseBody
    public AjaxJson startVisitGroup(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.visitGroupService.startVisitGroup(ids);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u542f\u7528\u5931\u8d25");
            log.error("", (Throwable)e);
        }
        return j;
    }

    @RequestMapping(value={"/stopVisitGroup"})
    @ResponseBody
    public AjaxJson stopVisitGroup(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.visitGroupService.stopVisitGroup(ids);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u505c\u7528\u5931\u8d25");
            log.error("", (Throwable)e);
        }
        return j;
    }

    @RequestMapping(value={"/deleteVisitGroup"})
    @ResponseBody
    public AjaxJson deleteVisitGroup(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.visitGroupService.deleteVisitGroup(ids);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
            log.error("", (Throwable)e);
        }
        return j;
    }

    @RequestMapping(value={"findVisitClientPage"})
    @ResponseBody
    public DataGrid findVisitClientPage(VisitclientRelEntity visitclientRel, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<VisitclientRelEntity> pageInfo = null;
        try {
            pageInfo = this.visitGroupService.findVisitClientPage(visitclientRel, (Page)page);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new BusinessException("\u83b7\u53d6\u7f51\u70b9\u5931\u8d25");
        }
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"/addVisitClient"})
    @ResponseBody
    public AjaxJson addVisitClient(VisitclientRelVo visitclientRelVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.visitGroupService.addVisitClient(visitclientRelVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
            log.error("", (Throwable)e);
        }
        return j;
    }

    @RequestMapping(value={"/delVisitClient"})
    @ResponseBody
    public AjaxJson delVisitClient(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.visitGroupService.delVisitClient(ids);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
            log.error("", (Throwable)e);
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"getCustomerByPosId"})
    public DataGrid getCustomerByPosId(SFACustomerVo sfaCustomerVo, HttpServletRequest request) {
        VisitGroupVo vo;
        String groupId = OConvertUtils.getString((String)request.getParameter("groupId"));
        String userId = "";
        StringBuffer notIdBuffer = new StringBuffer();
        if (StringUtil.isNotEmpty((CharSequence)groupId) && null != (vo = this.visitGroupService.getVisitGroupById(groupId))) {
            userId = vo.getUserId();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)vo.getVisitclients())) {
                vo.getVisitclients().forEach(item -> {
                    if (notIdBuffer.length() > 0) {
                        notIdBuffer.append(",");
                    }
                    notIdBuffer.append(item.getClientId());
                });
            }
        }
        String posId = null;
        String customerName = OConvertUtils.getString((String)request.getParameter("customerName"));
        String customerCode = OConvertUtils.getString((String)request.getParameter("customerCode"));
        EuPage page = new EuPage(request);
        PageInfo pageInfo = null;
        try {
            TmPositionVo pvo;
            if (StringUtil.isNotEmpty((CharSequence)userId) && (pvo = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId))) != null) {
                posId = pvo.getId();
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("page", page.getPage());
            param.put("rows", page.getRows());
            param.put("customerName", customerName);
            param.put("customerCode", customerCode);
            param.put("posId", posId);
            if (notIdBuffer.length() > 0) {
                param.put("notIds", notIdBuffer.toString());
            }
            pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.mdmApiFeign.getCustomerByPosIdPage(param));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            if (StringUtil.isEmpty(posId)) {
                throw new BusinessException("\u7528\u6237\u6ca1\u6709\u5206\u914d\u804c\u4f4d");
            }
            throw new BusinessException("\u83b7\u53d6\u7f51\u70b9\u6570\u636e\u5931\u8d25");
        }
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"datagrid"})
    @ResponseBody
    public DataGrid datagrid(VisitGroupEntity visitGroup, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<VisitGroupEntity> pageInfo = null;
        try {
            String user = OConvertUtils.getString((String)request.getParameter("user"));
            if (StringUtil.isNotEmpty((CharSequence)user)) {
                visitGroup.setUserId(user);
            }
            if ((pageInfo = this.visitGroupService.findVisitGroupPage(visitGroup, (Page)page)) != null && CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
                for (VisitGroupEntity visitGroupEntity : pageInfo.getList()) {
                    int visitclientCount = 0;
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)visitGroupEntity.getVisitclients())) {
                        for (int i = 0; i < visitGroupEntity.getVisitclients().size(); ++i) {
                            if (!StringUtil.isNotEmpty((CharSequence)((VisitclientRelEntity)visitGroupEntity.getVisitclients().get(i)).getClientId())) continue;
                            ++visitclientCount;
                        }
                    }
                    visitGroupEntity.setVisitclientCount(Integer.valueOf(visitclientCount));
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u7ebf\u8def\u7ec4\u5931\u8d25");
        }
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(VisitGroupEntity visitGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "";
        try {
            message = this.visitGroupService.saveGroupAndDetail(visitGroup);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            message = "\u7ebf\u8def\u7ec4\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @GetMapping(value={"/findVisitGroupList"})
    @ResponseBody
    public AjaxJson<VisitGroupEntity> findVisitGroupList(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="posId") String posId, @RequestParam(value="orgId") String orgId) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ajaxJson.setObjList(this.visitGroupService.findVisitGroupList(userId, posId, orgId, null));
        }
        catch (Exception e) {
            ajaxJson.setErrMsg(e.getMessage());
        }
        return ajaxJson;
    }
}

