/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.visitnote;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.visitnote.entity.VisitGroupEntity;
import com.biz.eisp.visitnote.entity.VisitNoteEntity;
import com.biz.eisp.visitnote.entity.VisitclientRelEntity;
import com.biz.eisp.visitnote.service.VisitGroupServiceI;
import com.biz.eisp.visitnote.service.VisitNoteService;
import com.biz.eisp.visitnote.vo.SFACustomerVo;
import com.biz.eisp.visitnote.vo.VisitGroupApiVo;
import com.biz.eisp.visitnote.vo.VisitNoteVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/visitNoteApiController"})
@Api(tags={"\u7ebf\u8def\u5236\u5b9a"})
public class VisitNoteApiController {
    private static final Logger log = LoggerFactory.getLogger(VisitNoteApiController.class);
    @Autowired
    private VisitNoteService visitNoteService;
    @Autowired
    private VisitGroupServiceI visitGroupService;
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private TmPositionFeign tmPositionFeign;

    @PostMapping(value={"/getChildUserForWeb"})
    public DataGrid findChildUserForWeb(@RequestBody TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage euPage = new EuPage(request);
        PageInfo pageInfo = null;
        String orgName = tmUserVo.getOrgName();
        String posName = tmUserVo.getPosName();
        String realName = tmUserVo.getFullname();
        String posId = tmUserVo.getPosId();
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            if (StringUtil.isNotEmpty((CharSequence)tmUserVo.getPage())) {
                param.put("page", tmUserVo.getPage());
            } else {
                param.put("page", euPage.getPage());
            }
            if (StringUtil.isNotEmpty((CharSequence)tmUserVo.getPageSize())) {
                param.put("rows", tmUserVo.getPageSize());
            } else {
                param.put("rows", euPage.getRows());
            }
            param.put("realName", realName);
            param.put("posName", posName);
            param.put("orgName", orgName);
            param.put("posId", posId);
            pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.tmUserFeign.getAllUserAndPositionList(param));
            if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
                ArrayList pageInfoList = new ArrayList();
                pageInfo.getList().forEach(item -> {
                    item.setUserId(item.getId());
                    String id = item.getId() + "," + item.getPosId();
                    item.setId(id);
                    pageInfoList.add(item);
                });
                pageInfo.setList(pageInfoList);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new BusinessException("\u83b7\u53d6\u4eba\u5458\u5931\u8d25");
        }
        return new DataGrid(pageInfo);
    }

    @PostMapping(value={"/getCustomerByPosId"})
    public DataGrid getCustomerByPosId(@RequestBody SFACustomerVo sfaCustomerVo, HttpServletRequest request) {
        String userId = sfaCustomerVo.getUserId();
        String posId = sfaCustomerVo.getPosId();
        String customerName = sfaCustomerVo.getCustomerName();
        String customerCode = sfaCustomerVo.getCustomerCode();
        EuPage page = new EuPage(request);
        PageInfo pageInfo = null;
        try {
            TmPositionVo pvo;
            if (StringUtil.isNotEmpty((CharSequence)userId) && StringUtil.isEmpty((String)posId) && (pvo = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId))) != null) {
                posId = pvo.getId();
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            if (StringUtil.isNotEmpty((Object)sfaCustomerVo.getPage())) {
                param.put("page", sfaCustomerVo.getPage());
            } else {
                param.put("page", page.getPage());
            }
            if (StringUtil.isNotEmpty((CharSequence)sfaCustomerVo.getPageSize())) {
                param.put("rows", sfaCustomerVo.getPageSize());
            } else {
                param.put("rows", page.getRows());
            }
            param.put("customerName", customerName);
            param.put("customerCode", customerCode);
            param.put("posId", posId);
            pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.mdmApiFeign.getCustomerByPosIdPage(param));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            if (StringUtil.isEmpty((String)posId)) {
                throw new BusinessException("\u7528\u6237\u6ca1\u6709\u5206\u914d\u804c\u4f4d");
            }
            throw new BusinessException("\u83b7\u53d6\u7f51\u70b9\u6570\u636e\u5931\u8d25");
        }
        return new DataGrid(pageInfo);
    }

    @PostMapping(value={"/doAdd"})
    public AjaxJson doAdd(@RequestBody VisitNoteVo visitNoteVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "";
        String custIds = visitNoteVo.getCustIds();
        String userId = visitNoteVo.getUserId();
        String posId = String.valueOf(visitNoteVo.getPosId());
        String lvUserId = visitNoteVo.getUserId();
        String status = visitNoteVo.getAuditStatus();
        String customerTypes = visitNoteVo.getCustomerTypes();
        String startDate = visitNoteVo.getStartDate();
        String endDate = visitNoteVo.getEndDate();
        String notWeeks = visitNoteVo.getNotWeeks();
        try {
            VisitNoteEntity visitNote = new VisitNoteEntity();
            MyBeanUtils.copyBeanNotNull2Bean((Object)visitNoteVo, (Object)visitNote);
            TmPositionVo posLv = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", lvUserId));
            String lvPosId = posLv != null ? posLv.getId() : "";
            Integer auditStatus = Integer.parseInt(status);
            if (StringUtil.isNotEmpty((CharSequence)posId)) {
                TmUserVo userVo = (TmUserVo)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.findPositionUser(posId + ""));
                if (userVo != null) {
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)userVo.getPosId()) ? Integer.valueOf(userVo.getPosId()) : 0));
                    visitNote.setUserName(userVo.getFullname());
                    visitNote.setPosName(userVo.getPosName());
                    visitNote.setVisitPosId(Integer.valueOf(userVo.getPosId()));
                    visitNote.setVisitUserId(userId);
                }
            } else {
                TmPositionVo pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId));
                if (pos != null) {
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)pos.getId()) ? Integer.valueOf(pos.getId()) : 0));
                    visitNote.setUserName(pos.getFullname());
                    visitNote.setPosName(pos.getPositionName());
                    visitNote.setVisitPosId(Integer.valueOf(pos.getId()));
                    visitNote.setVisitUserId(userId);
                }
            }
            visitNote.setStatus("009");
            String[] custArray = null;
            if (StringUtil.isNotEmpty((CharSequence)custIds)) {
                custArray = custIds.split(",");
            }
            String[] custTypeArray = null;
            if (StringUtil.isNotEmpty((CharSequence)customerTypes)) {
                custTypeArray = customerTypes.split(",");
            }
            if ((message = StringUtil.isNotEmpty((CharSequence)startDate) && StringUtil.isNotEmpty((CharSequence)endDate) ? this.visitNoteService.addLIneAll(visitNote, custArray, custTypeArray, lvPosId, auditStatus, startDate, endDate, notWeeks) : this.visitNoteService.addLIne(visitNote, custArray, custTypeArray, lvPosId, auditStatus)).equals("\u8be5\u5929\u5df2\u7ecf\u521b\u5efa\u534f\u8bbf\u8ba1\u5212\u65e0\u9700\u518d\u6b21\u6dfb\u52a0")) {
                j.setMsg(message);
                j.setSuccess(false);
            }
            if (!("\u6dfb\u52a0\u534f\u8bbf\u8ba1\u5212\u6210\u529f".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f,\u5df2\u81ea\u52a8\u8fc7\u6ee4\u91cd\u590d\u7f51\u70b9".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f".equals(message))) {
                j.setMsg(message);
                j.setSuccess(false);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            message = "\u6dfb\u52a0\u7ebf\u8def\u8ba1\u5212\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @PostMapping(value={"/findVisitGroupList"})
    public DataGrid findVisitGroupList(@RequestBody VisitGroupApiVo visitGroupApiVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<VisitGroupEntity> pageInfo = null;
        try {
            if (StringUtil.isNotEmpty((CharSequence)visitGroupApiVo.getUserId())) {
                VisitGroupEntity visitGroup = new VisitGroupEntity();
                visitGroup.setUserId(visitGroupApiVo.getUserId());
                visitGroup.setPosId(visitGroupApiVo.getPosId());
                visitGroup.setOrgId(visitGroupApiVo.getOrgId());
                visitGroup.setGroupName(visitGroupApiVo.getGroupName());
                visitGroup.setStatus("009");
                if (StringUtil.isNotEmpty((CharSequence)visitGroupApiVo.getPage())) {
                    page.setPage(visitGroupApiVo.getPage());
                }
                if (StringUtil.isNotEmpty((CharSequence)visitGroupApiVo.getPageSize())) {
                    page.setRows(visitGroupApiVo.getPageSize());
                }
                pageInfo = this.visitGroupService.findVisitGroupPage(visitGroup, (Page)page);
            } else {
                pageInfo = new PageInfo<VisitGroupEntity>();
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u7ebf\u8def\u7ec4\u5931\u8d25");
        }
        return new DataGrid((PageInfo)pageInfo);
    }

    @PostMapping(value={"/doVgAdd"})
    public AjaxJson doVgAdd(@RequestBody VisitNoteVo visitNoteVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "";
        String lvUserId = visitNoteVo.getUserId();
        String visitGroups = visitNoteVo.getVisitGroups();
        String userId = visitNoteVo.getUserId();
        String posId = String.valueOf(visitNoteVo.getPosId());
        String status = visitNoteVo.getAuditStatus();
        String startDate = visitNoteVo.getStartDate();
        String endDate = visitNoteVo.getEndDate();
        String notWeeks = visitNoteVo.getNotWeeks();
        try {
            VisitNoteEntity visitNote = new VisitNoteEntity();
            MyBeanUtils.copyBeanNotNull2Bean((Object)visitNoteVo, (Object)visitNote);
            TmPositionVo posLv = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", lvUserId));
            String lvPosId = posLv != null ? posLv.getId() : "";
            Integer auditStatus = Integer.parseInt(status);
            if (StringUtil.isNotEmpty((CharSequence)posId)) {
                TmUserVo userVo = (TmUserVo)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.findPositionUser(posId + ""));
                if (userVo != null) {
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)userVo.getPosId()) ? Integer.valueOf(userVo.getPosId()) : 0));
                    visitNote.setUserName(userVo.getFullname());
                    visitNote.setPosName(userVo.getPosName());
                    visitNote.setVisitPosId(Integer.valueOf(userVo.getPosId()));
                    visitNote.setVisitUserId(userId);
                }
            } else {
                TmPositionVo pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon("", userId));
                if (pos != null) {
                    visitNote.setPosId(Integer.valueOf(StringUtils.isNotBlank((CharSequence)pos.getId()) ? Integer.valueOf(pos.getId()) : 0));
                    visitNote.setUserName(pos.getFullname());
                    visitNote.setPosName(pos.getPositionName());
                    visitNote.setVisitPosId(Integer.valueOf(pos.getId()));
                    visitNote.setVisitUserId(userId);
                }
            }
            visitNote.setStatus("009");
            String[] visitGroupArray = null;
            if (!StringUtil.isNotEmpty((CharSequence)visitGroups)) {
                j.setMsg("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u7ebf\u8def\u7ec4");
                j.setSuccess(false);
                return j;
            }
            visitGroupArray = visitGroups.split(",");
            message = this.visitNoteService.addGvLIneAll(visitNote, visitGroupArray, lvPosId, auditStatus, startDate, endDate, notWeeks);
            if (message.equals("\u8be5\u5929\u5df2\u7ecf\u521b\u5efa\u534f\u8bbf\u8ba1\u5212\u65e0\u9700\u518d\u6b21\u6dfb\u52a0")) {
                j.setMsg(message);
                j.setSuccess(false);
            }
            if (!("\u6dfb\u52a0\u534f\u8bbf\u8ba1\u5212\u6210\u529f".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f,\u5df2\u81ea\u52a8\u8fc7\u6ee4\u91cd\u590d\u7f51\u70b9".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f".equals(message))) {
                j.setMsg(message);
                j.setSuccess(false);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            message = "\u6dfb\u52a0\u7ebf\u8def\u8ba1\u5212\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @PostMapping(value={"/findVisitClientList"})
    public AjaxJson findVisitClientList(@RequestBody VisitclientRelEntity visitclientRel, HttpServletRequest request) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            if (StringUtil.isNotEmpty((Object)visitclientRel.getGroupId())) {
                ajaxJson.setObjList(this.visitGroupService.findVisitClientList(visitclientRel));
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u7ebf\u8def\u7ec4\u7f51\u70b9\u67e5\u8be2\u5931\u8d25");
        }
        return ajaxJson;
    }

    @PostMapping(value={"/delVisitClient"})
    public AjaxJson delVisitClient(@RequestBody VisitclientRelEntity visitclientRel, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            String ids = null != visitclientRel.getId() ? String.valueOf(visitclientRel.getId()) : "";
            j = this.visitGroupService.delVisitClient(ids);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
            log.error("", (Throwable)e);
        }
        return j;
    }

    @PostMapping(value={"/findAppByVisitNotePage"})
    public DataGrid findAppByVisitNotePage(@RequestBody VisitNoteVo visitNoteVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<VisitNoteVo> pageInfo = null;
        try {
            if (StringUtil.isNotEmpty((CharSequence)visitNoteVo.getPage())) {
                page.setPage(visitNoteVo.getPage());
            }
            if (StringUtil.isNotEmpty((CharSequence)visitNoteVo.getPageSize())) {
                page.setRows(visitNoteVo.getPageSize());
            }
            pageInfo = this.visitNoteService.findAppByVisitNotePage(visitNoteVo, (Page)page);
        }
        catch (Exception e) {
            throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u67e5\u8be2\u5931\u8d25");
        }
        return new DataGrid(pageInfo);
    }
}

