/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.visitnote.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.attendance.picture.dao.TsPictureDao;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.common.FilePathUtil;
import com.biz.eisp.common.SfaConstantEnum;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.params.Constant;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.visitnote.dao.TsWeekPlanDao;
import com.biz.eisp.visitnote.dao.VisitInfoDao;
import com.biz.eisp.visitnote.dao.VisitNoteDao;
import com.biz.eisp.visitnote.entity.VisitInfoEntity;
import com.biz.eisp.visitnote.entity.VisitNoteEntity;
import com.biz.eisp.visitnote.service.VisitInfoService;
import com.biz.eisp.visitnote.vo.VisitInfoApiVo;
import com.biz.eisp.visitnote.vo.VisitInfoVo;
import com.biz.eisp.weekplan.entity.TsWeekPlanEntity;
import com.biz.eisp.weekplan.vo.MonthImportVo;
import com.biz.eisp.weekplan.vo.TsWeekPlanVo;
import com.biz.eisp.weekplan.vo.WeekImportVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class VisitInfoServiceImpl
extends BaseServiceImpl<VisitInfoEntity>
implements VisitInfoService {
    private static final Logger log = LoggerFactory.getLogger(VisitInfoServiceImpl.class);
    @Autowired
    private TsPictureDao tsPictureDao;
    @Autowired
    private VisitNoteDao visitNoteDao;
    @Autowired
    private TsWeekPlanDao tsWeekPlanDao;
    @Autowired
    private VisitInfoDao visitInfoDao;
    @Autowired
    FilePathUtil filePathUtil;

    @Override
    public void doSaveVisitInfo(VisitInfoApiVo vo) throws Exception {
        List pictureList;
        UserRedis user = UserUtils.getUser();
        if (user == null || StringUtils.isBlank((CharSequence)user.getPosId())) {
            throw new BusinessException("\u672a\u914d\u7f6e\u804c\u4f4d\u4fe1\u606f");
        }
        String posid_ = StringUtils.isNotBlank((CharSequence)user.getPosId()) ? user.getPosId() : "0";
        int posId = Integer.parseInt(posid_);
        this.checkData(vo);
        Example example = new Example(VisitInfoEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("visitId", (Object)vo.getVisitId());
        criteria.andEqualTo("visitType", (Object)vo.getVisitType());
        String visitDate = DateUtils.getDate((String)"yyyy-MM-dd");
        criteria.andEqualTo("visitDate", (Object)visitDate);
        List infos = this.selectExample(example);
        VisitInfoEntity info = new VisitInfoEntity();
        VisitNoteEntity entity = new VisitNoteEntity();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)infos)) {
            info = (VisitInfoEntity)infos.get(0);
        }
        MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)info);
        if (vo.getVisitAction().equals(SfaConstantEnum.VisitAction.in.getVal())) {
            if (info.getId() != null) {
                throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u8fdb\u5e97");
            }
            info.setInSubTime(vo.getSubTime());
            info.setVisitInLatitude(vo.getLatitude());
            info.setVisitInLongitude(vo.getLongitude());
            info.setVisitStatus(SfaConstantEnum.VisitStatus.V2.getVal());
            info.setClientType(vo.getClientType());
            entity.setVisitStatus(SfaConstantEnum.VisitStatus.V2.getVal());
            info.setInAddress(vo.getAddress());
            info.setClientName(vo.getClientName());
        } else if (vo.getVisitAction().equals(SfaConstantEnum.VisitAction.out.getVal())) {
            if (info.getId() == null) {
                throw new BusinessException("\u672a\u8fdb\u5e97\u4e0d\u80fd\u79bb\u5e97");
            }
            info.setOutSubTime(vo.getSubTime());
            info.setVisitOutLatitud(vo.getLatitude());
            info.setVisitOutLongitude(vo.getLongitude());
            info.setVisitStatus(SfaConstantEnum.VisitStatus.V3.getVal());
            info.setOutAddress(vo.getAddress());
            entity.setVisitStatus(SfaConstantEnum.VisitStatus.V3.getVal());
            info.setPosId(Integer.valueOf(posId));
            info.setClientName(vo.getClientName());
        }
        if (info.getId() != null) {
            this.updateByPrimaryKeySelective(info);
        } else {
            this.insertSelective(info);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getVisitType()) && !vo.getVisitType().equals(SfaConstantEnum.VisitType.assit_type.getVal())) {
            this.updateVisitStatus(info.getVisitId(), entity);
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)(pictureList = vo.getPictureList()))) {
            throw new BusinessException("\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        VisitInfoEntity finalInfo = info;
        pictureList.forEach(item -> {
            item.setBusinessId(finalInfo.getId());
            item.setImgType(Constant.imgType.inout.getValue() + finalInfo.getVisitAction());
            this.filePathUtil.getChangePicturePath((TsPictureEntity)item);
        });
        this.tsPictureDao.insertList(pictureList);
    }

    private void updateVisitStatus(String id, VisitNoteEntity entity) {
        Example example = new Example(VisitNoteEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", (Object)id);
        this.visitNoteDao.updateByExampleSelective(entity, example);
    }

    private void checkData(VisitInfoApiVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getVisitId())) {
            throw new BusinessException("\u7ebf\u8def\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)vo.getClientId())) {
            throw new BusinessException("\u62dc\u8bbf\u7f51\u70b9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)vo.getVisitDate())) {
            throw new BusinessException("\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)vo.getVisitType())) {
            throw new BusinessException("\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)vo.getVisitAction())) {
            throw new BusinessException("\u62dc\u8bbf\u52a8\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)vo.getSubTime())) {
            throw new BusinessException("\u62dc\u8bbf\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public PageInfo<VisitInfoEntity> findVisitInfoList(VisitInfoVo vo, Page page) {
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.visitInfoDao.findVisitInfoList(vo), (Page)page);
        return pageInfo;
    }

    @Override
    public List<Map<String, String>> findMonthPointList(TsWeekPlanVo vo, Page page) {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        PageInfo list = PageAutoHelperUtil.generatePage(() -> this.tsWeekPlanDao.findMonthPointList(vo), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list.getList())) {
            for (TsWeekPlanEntity entity : list.getList()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fullName", entity.getFullName());
                map.put("userOrgName", entity.getUserOrgName());
                map.put("year", entity.getYear());
                int total = 0;
                if (StringUtil.isNotEmpty((CharSequence)entity.getMonthJson())) {
                    List monthValue = JSONArray.parseArray((String)entity.getMonthJson(), String.class);
                    for (int i = 0; i < monthValue.size(); ++i) {
                        if (StringUtil.isNotEmpty((CharSequence)((CharSequence)monthValue.get(i))) && StringUtil.isNumeric((String)((String)monthValue.get(i)))) {
                            total += Integer.valueOf((String)monthValue.get(i)).intValue();
                        }
                        map.put(String.valueOf(i + 1), (String)monthValue.get(i));
                    }
                    map.put("total", total + "");
                }
                maps.add(map);
            }
        }
        return maps;
    }

    @Override
    public List<Map<String, String>> findWeekPointList(TsWeekPlanVo vo, Page page) {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        PageInfo list = PageAutoHelperUtil.generatePage(() -> this.tsWeekPlanDao.findWeekPointList(vo), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list.getList())) {
            for (TsWeekPlanEntity entity : list.getList()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fullName", entity.getFullName());
                map.put("userOrgName", entity.getUserOrgName());
                map.put("year", entity.getYear());
                int total = 0;
                if (StringUtil.isNotEmpty((CharSequence)entity.getWeekJson())) {
                    List monthValue = JSONArray.parseArray((String)entity.getWeekJson(), String.class);
                    for (int i = 0; i < monthValue.size(); ++i) {
                        if (StringUtil.isNotEmpty((CharSequence)((CharSequence)monthValue.get(i))) && StringUtil.isNumeric((String)((String)monthValue.get(i)))) {
                            total += Integer.valueOf((String)monthValue.get(i)).intValue();
                        }
                        map.put(String.valueOf(i + 1), (String)monthValue.get(i));
                    }
                    map.put("total", total + "");
                }
                maps.add(map);
            }
        }
        return maps;
    }

    @Override
    public AjaxJson checkWeekList(List list) {
        AjaxJson ajaxJson = new AjaxJson();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                WeekImportVo importVo = (WeekImportVo)list.get(i);
                if (StringUtil.isEmpty((String)importVo.getFullName())) {
                    ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\u4eba\u5458\u540d\u5b57\u5fc5\u987b\u586b\u5199");
                    return ajaxJson;
                }
                if (StringUtil.isEmpty((String)importVo.getUserName())) {
                    ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\u4eba\u5458\u8d26\u53f7\u5fc5\u987b\u586b\u5199");
                    return ajaxJson;
                }
                if (StringUtil.isEmpty((String)importVo.getUserOrgCode())) {
                    ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\u7ec4\u7ec7\u7f16\u7801\u5fc5\u987b\u586b\u5199");
                    return ajaxJson;
                }
                if (!StringUtil.isEmpty((String)importVo.getUserOrgName())) continue;
                ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\u7ec4\u7ec7\u540d\u79f0\u5fc5\u987b\u586b\u5199");
                return ajaxJson;
            }
        } else {
            ajaxJson.setErrMsg("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson saveWeekInfo(List list) {
        AjaxJson ajaxJson = new AjaxJson();
        for (WeekImportVo importVo : list) {
            Example example = new Example(TsWeekPlanEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("userName", (Object)importVo.getUserName());
            criteria.andEqualTo("userOrgCode", (Object)importVo.getUserOrgCode());
            criteria.andEqualTo("year", (Object)importVo.getYear());
            criteria.andEqualTo("type", (Object)"0");
            this.tsWeekPlanDao.deleteByExample(example);
            TsWeekPlanEntity tsWeekPlanEntity = new TsWeekPlanEntity();
            tsWeekPlanEntity.setFullName(importVo.getFullName());
            tsWeekPlanEntity.setUserName(importVo.getUserName());
            tsWeekPlanEntity.setWeekJson(this.getWeekJson(importVo));
            tsWeekPlanEntity.setMonthJson("");
            tsWeekPlanEntity.setType("0");
            tsWeekPlanEntity.setYear(importVo.getYear());
            tsWeekPlanEntity.setUserOrgCode(importVo.getUserOrgCode());
            tsWeekPlanEntity.setUserOrgName(importVo.getUserOrgName());
            this.tsWeekPlanDao.insert(tsWeekPlanEntity);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson checkMonthList(List list) {
        AjaxJson ajaxJson = new AjaxJson();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                MonthImportVo importVo = (MonthImportVo)list.get(i);
                if (StringUtil.isEmpty((String)importVo.getFullName())) {
                    ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\u4eba\u5458\u540d\u5b57\u5fc5\u987b\u586b\u5199");
                    return ajaxJson;
                }
                if (StringUtil.isEmpty((String)importVo.getUserName())) {
                    ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\u4eba\u5458\u8d26\u53f7\u5fc5\u987b\u586b\u5199");
                    return ajaxJson;
                }
                if (StringUtil.isEmpty((String)importVo.getUserOrgCode())) {
                    ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\u7ec4\u7ec7\u7f16\u7801\u5fc5\u987b\u586b\u5199");
                    return ajaxJson;
                }
                if (!StringUtil.isEmpty((String)importVo.getUserOrgName())) continue;
                ajaxJson.setErrMsg("\u7b2c" + (i + 1) + "\u884c\u7ec4\u7ec7\u540d\u79f0\u5fc5\u987b\u586b\u5199");
                return ajaxJson;
            }
        } else {
            ajaxJson.setErrMsg("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson saveMonthInfo(List list) {
        AjaxJson ajaxJson = new AjaxJson();
        for (MonthImportVo importVo : list) {
            Example example = new Example(TsWeekPlanEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("userName", (Object)importVo.getUserName());
            criteria.andEqualTo("userOrgCode", (Object)importVo.getUserOrgCode());
            criteria.andEqualTo("year", (Object)importVo.getYear());
            criteria.andEqualTo("type", (Object)"1");
            this.tsWeekPlanDao.deleteByExample(example);
            TsWeekPlanEntity tsWeekPlanEntity = new TsWeekPlanEntity();
            tsWeekPlanEntity.setFullName(importVo.getFullName());
            tsWeekPlanEntity.setUserName(importVo.getUserName());
            tsWeekPlanEntity.setMonthJson(this.getMonthJson(importVo));
            tsWeekPlanEntity.setWeekJson("");
            tsWeekPlanEntity.setType("1");
            tsWeekPlanEntity.setYear(importVo.getYear());
            tsWeekPlanEntity.setUserOrgCode(importVo.getUserOrgCode());
            tsWeekPlanEntity.setUserOrgName(importVo.getUserOrgName());
            this.tsWeekPlanDao.insert(tsWeekPlanEntity);
        }
        return ajaxJson;
    }

    private String getMonthJson(MonthImportVo importVo) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(StringUtil.isEmpty((String)importVo.getWeek1()) ? "0" : importVo.getWeek1());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek2()) ? "0" : importVo.getWeek2());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek3()) ? "0" : importVo.getWeek3());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek4()) ? "0" : importVo.getWeek4());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek5()) ? "0" : importVo.getWeek5());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek6()) ? "0" : importVo.getWeek6());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek7()) ? "0" : importVo.getWeek7());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek8()) ? "0" : importVo.getWeek8());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek9()) ? "0" : importVo.getWeek9());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek10()) ? "0" : importVo.getWeek10());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek11()) ? "0" : importVo.getWeek11());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek12()) ? "0" : importVo.getWeek12());
        return JSON.toJSONString(strings);
    }

    private String getWeekJson(WeekImportVo importVo) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(StringUtil.isEmpty((String)importVo.getWeek1()) ? "0" : importVo.getWeek1());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek2()) ? "0" : importVo.getWeek2());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek3()) ? "0" : importVo.getWeek3());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek4()) ? "0" : importVo.getWeek4());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek5()) ? "0" : importVo.getWeek5());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek6()) ? "0" : importVo.getWeek6());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek7()) ? "0" : importVo.getWeek7());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek8()) ? "0" : importVo.getWeek8());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek9()) ? "0" : importVo.getWeek9());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek10()) ? "0" : importVo.getWeek10());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek11()) ? "0" : importVo.getWeek11());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek12()) ? "0" : importVo.getWeek12());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek13()) ? "0" : importVo.getWeek13());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek14()) ? "0" : importVo.getWeek14());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek15()) ? "0" : importVo.getWeek15());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek16()) ? "0" : importVo.getWeek16());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek17()) ? "0" : importVo.getWeek17());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek18()) ? "0" : importVo.getWeek18());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek19()) ? "0" : importVo.getWeek19());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek20()) ? "0" : importVo.getWeek20());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek21()) ? "0" : importVo.getWeek21());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek22()) ? "0" : importVo.getWeek22());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek23()) ? "0" : importVo.getWeek23());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek24()) ? "0" : importVo.getWeek24());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek25()) ? "0" : importVo.getWeek25());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek26()) ? "0" : importVo.getWeek26());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek27()) ? "0" : importVo.getWeek27());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek28()) ? "0" : importVo.getWeek28());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek29()) ? "0" : importVo.getWeek29());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek30()) ? "0" : importVo.getWeek30());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek31()) ? "0" : importVo.getWeek31());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek32()) ? "0" : importVo.getWeek32());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek33()) ? "0" : importVo.getWeek33());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek34()) ? "0" : importVo.getWeek34());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek35()) ? "0" : importVo.getWeek35());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek36()) ? "0" : importVo.getWeek36());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek37()) ? "0" : importVo.getWeek37());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek38()) ? "0" : importVo.getWeek38());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek39()) ? "0" : importVo.getWeek39());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek40()) ? "0" : importVo.getWeek40());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek41()) ? "0" : importVo.getWeek41());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek42()) ? "0" : importVo.getWeek42());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek43()) ? "0" : importVo.getWeek43());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek44()) ? "0" : importVo.getWeek44());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek45()) ? "0" : importVo.getWeek45());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek46()) ? "0" : importVo.getWeek46());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek47()) ? "0" : importVo.getWeek47());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek48()) ? "0" : importVo.getWeek48());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek49()) ? "0" : importVo.getWeek49());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek50()) ? "0" : importVo.getWeek50());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek51()) ? "0" : importVo.getWeek51());
        strings.add(StringUtil.isEmpty((String)importVo.getWeek52()) ? "0" : importVo.getWeek52());
        return JSON.toJSONString(strings);
    }

    @Override
    public List<Map<String, String>> findWeekProgressList(TsWeekPlanVo vo, Page page) {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        if (StringUtil.isEmpty((String)vo.getYear())) {
            vo.setYear(new SimpleDateFormat("yyyy").format(new Date()));
        }
        List<VisitInfoEntity> visitInfoEntities = this.visitInfoDao.selectInfoList(vo);
        Map<String, Map<String, Integer>> coverMap = this.coverVisitInfo(visitInfoEntities);
        PageInfo list = PageAutoHelperUtil.generatePage(() -> this.tsWeekPlanDao.findWeekPointList(vo), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list.getList())) {
            for (TsWeekPlanEntity entity : list.getList()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fullName", entity.getFullName());
                map.put("userOrgName", entity.getUserOrgName());
                map.put("year", entity.getYear());
                int total = 0;
                int realTotal = 0;
                Map<String, Integer> weekValueMap = coverMap.get(entity.getFullName() + "-" + entity.getYear());
                if (weekValueMap == null) {
                    weekValueMap = new HashMap<String, Integer>();
                }
                if (StringUtil.isNotEmpty((CharSequence)entity.getWeekJson())) {
                    List monthValue = JSONArray.parseArray((String)entity.getWeekJson(), String.class);
                    for (int i = 0; i < monthValue.size(); ++i) {
                        if (StringUtil.isNotEmpty((CharSequence)((CharSequence)monthValue.get(i))) && StringUtil.isNumeric((String)((String)monthValue.get(i)))) {
                            total += Integer.valueOf((String)monthValue.get(i)).intValue();
                        }
                        map.put("point_" + String.valueOf(i + 1), (String)monthValue.get(i));
                        Integer realValue = weekValueMap.get(String.valueOf(i + 1)) == null ? Integer.valueOf(0) : weekValueMap.get(String.valueOf(i + 1));
                        realTotal += realValue.intValue();
                        map.put("real_" + String.valueOf(i + 1), realValue == null ? "0" : realValue + "");
                        if (StringUtil.isEmpty((String)((String)monthValue.get(i)))) {
                            map.put("ratio_" + String.valueOf(i + 1), "0");
                            continue;
                        }
                        BigDecimal bigDecimal = new BigDecimal(realValue).divide(new BigDecimal((String)monthValue.get(i)), 1);
                        map.put("ratio_" + String.valueOf(i + 1), bigDecimal.toPlainString());
                    }
                    map.put("pointTotal", total + "");
                    map.put("realTotal", realTotal + "");
                    if (total != 0) {
                        map.put("pointRatio", new BigDecimal(realTotal).divide(new BigDecimal(total), 1).toPlainString());
                    } else {
                        map.put("pointRatio", "0");
                    }
                }
                maps.add(map);
            }
        }
        return maps;
    }

    private Map<String, Map<String, Integer>> coverVisitInfo(List<VisitInfoEntity> list) {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            for (VisitInfoEntity visitInfoEntity : list) {
                String createName = visitInfoEntity.getCreateName();
                String year = visitInfoEntity.getVisitDate().split("-")[0];
                String key = createName + "-" + year;
                if (map.containsKey(key)) {
                    String valueKey;
                    Map valueMap = (Map)map.get(key);
                    if (valueMap.containsKey(valueKey = this.getWeekOfYearIndex(visitInfoEntity.getVisitDate()) + "")) {
                        Integer count = valueMap.get(valueKey) == null ? Integer.valueOf(0) : (Integer)valueMap.get(valueKey);
                        valueMap.put(valueKey, count + 1);
                        continue;
                    }
                    valueMap.put(valueKey, 0);
                    continue;
                }
                map.put(key, new HashMap());
            }
        }
        return map;
    }

    private Map<String, Map<String, Integer>> coverVisitMonthInfo(List<VisitInfoEntity> list) {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            for (VisitInfoEntity visitInfoEntity : list) {
                String createName = visitInfoEntity.getCreateName();
                String year = visitInfoEntity.getVisitDate().split("-")[0];
                String key = createName + "-" + year;
                if (map.containsKey(key)) {
                    String valueKey;
                    Map valueMap = (Map)map.get(key);
                    if (valueMap.containsKey(valueKey = this.getMonthOfYearIndex(visitInfoEntity.getVisitDate()) + "")) {
                        Integer count = valueMap.get(valueKey) == null ? Integer.valueOf(0) : (Integer)valueMap.get(valueKey);
                        valueMap.put(valueKey, count + 1);
                        continue;
                    }
                    valueMap.put(valueKey, 0);
                    continue;
                }
                map.put(key, new HashMap());
            }
        }
        return map;
    }

    private int getWeekOfYearIndex(String today) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = format.parse(today);
        }
        catch (ParseException e) {
            log.error("", (Throwable)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        return calendar.get(3);
    }

    private int getMonthOfYearIndex(String today) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = format.parse(today);
        }
        catch (ParseException e) {
            log.error("", (Throwable)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    @Override
    public List<Map<String, String>> findMonthProgressList(TsWeekPlanVo vo, Page page) {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        if (StringUtil.isEmpty((String)vo.getYear())) {
            vo.setYear(new SimpleDateFormat("yyyy").format(new Date()));
        }
        List<VisitInfoEntity> visitInfoEntities = this.visitInfoDao.selectInfoList(vo);
        Map<String, Map<String, Integer>> coverMap = this.coverVisitMonthInfo(visitInfoEntities);
        PageInfo list = PageAutoHelperUtil.generatePage(() -> this.tsWeekPlanDao.findMonthPointList(vo), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list.getList())) {
            for (TsWeekPlanEntity entity : list.getList()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fullName", entity.getFullName());
                map.put("userOrgName", entity.getUserOrgName());
                map.put("year", entity.getYear());
                int total = 0;
                int realTotal = 0;
                Map<String, Integer> weekValueMap = coverMap.get(entity.getFullName() + "-" + entity.getYear());
                if (weekValueMap == null) {
                    weekValueMap = new HashMap<String, Integer>();
                }
                if (StringUtil.isNotEmpty((CharSequence)entity.getMonthJson())) {
                    List monthValue = JSONArray.parseArray((String)entity.getMonthJson(), String.class);
                    for (int i = 0; i < monthValue.size(); ++i) {
                        if (StringUtil.isNotEmpty((CharSequence)((CharSequence)monthValue.get(i))) && StringUtil.isNumeric((String)((String)monthValue.get(i)))) {
                            total += Integer.valueOf((String)monthValue.get(i)).intValue();
                        }
                        map.put("point_" + String.valueOf(i + 1), (String)monthValue.get(i));
                        Integer realValue = weekValueMap.get(String.valueOf(i + 1)) == null ? Integer.valueOf(0) : weekValueMap.get(String.valueOf(i + 1));
                        realTotal += realValue.intValue();
                        map.put("real_" + String.valueOf(i + 1), realValue == null ? "0" : realValue + "");
                        if (StringUtil.isEmpty((String)((String)monthValue.get(i)))) {
                            map.put("ratio_" + String.valueOf(i + 1), "0");
                            continue;
                        }
                        BigDecimal bigDecimal = new BigDecimal(realValue).divide(new BigDecimal((String)monthValue.get(i)), 1);
                        map.put("ratio_" + String.valueOf(i + 1), bigDecimal.toPlainString());
                    }
                    map.put("pointTotal", total + "");
                    map.put("realTotal", realTotal + "");
                    if (total != 0) {
                        map.put("pointRatio", new BigDecimal(realTotal).divide(new BigDecimal(total), 1).toPlainString());
                    } else {
                        map.put("pointRatio", "0");
                    }
                }
                maps.add(map);
            }
        }
        return maps;
    }
}

