/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.visitnote.service.impl;

import com.biz.eisp.api.feign.CustomerFeign;
import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmTerminalFeign;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.common.BaseTsEntity;
import com.biz.eisp.common.SfaConstantEnum;
import com.biz.eisp.customer.TmCustomerResultVo;
import com.biz.eisp.customer.TmCustomerVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.terminal.TmTerminalVo;
import com.biz.eisp.user.TmUserQueryVo;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.utils.GpsUtil;
import com.biz.eisp.visitnote.dao.VisitGroupDao;
import com.biz.eisp.visitnote.dao.VisitNoteDao;
import com.biz.eisp.visitnote.entity.VisitGroupEntity;
import com.biz.eisp.visitnote.entity.VisitNoteEntity;
import com.biz.eisp.visitnote.entity.VisitclientRelEntity;
import com.biz.eisp.visitnote.service.VisitGroupServiceI;
import com.biz.eisp.visitnote.service.VisitNoteService;
import com.biz.eisp.visitnote.vo.TsVisitApiQueryVo;
import com.biz.eisp.visitnote.vo.TsVisitClientApiVo;
import com.biz.eisp.visitnote.vo.TsVisitHisApiVo;
import com.biz.eisp.visitnote.vo.VisitNoteVo;
import com.biz.eisp.visitnote.vo.VisitParam;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Component(value="visitNoteService")
@Service
@Transactional
public class VisitNoteServiceImpl
extends BaseServiceImpl<VisitNoteEntity>
implements VisitNoteService {
    private static final Logger log = LoggerFactory.getLogger(VisitNoteServiceImpl.class);
    @Autowired
    private VisitNoteDao visitNoteDao;
    @Autowired
    private VisitGroupDao visitGroupDao;
    @Autowired
    private VisitGroupServiceI visitGroupService;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private TmTerminalFeign tmTerminalFeign;
    @Autowired
    private CustomerFeign customerFeign;
    @Autowired
    private MdmApiFeign mdmApiFeign;

    @Override
    public PageInfo<VisitNoteVo> getVisitInfo(TsVisitApiQueryVo vo, List<String> pos, String visitDate, String clientName, Page page) {
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.visitNoteDao.getVisitInfo(pos, visitDate, clientName), (Page)page);
        List list = pageInfo.getList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(item -> {
                TmTerminalVo tmTerminalVo;
                String clientId = item.getClientId();
                if (StringUtils.isNotBlank((CharSequence)item.getClientType()) && item.getClientType().equals(SfaConstantEnum.CusType.channel.getVal())) {
                    TmCustomerVo customerVo = (TmCustomerVo)ApiResultUtil.objResult((AjaxJson)this.customerFeign.getCustomerByIdOrCode(clientId, ""));
                    if (customerVo != null) {
                        if (StringUtils.isBlank((CharSequence)item.getClientName())) {
                            Example example = new Example(VisitNoteEntity.class);
                            Example.Criteria criteria = example.createCriteria();
                            criteria.andEqualTo("clientId", (Object)clientId);
                            VisitNoteEntity vt = new VisitNoteEntity();
                            vt.setClientName(customerVo.getCustomerName());
                            this.visitNoteDao.updateByExampleSelective(vt, example);
                        }
                        item.setCustAddr(customerVo.getAddress());
                        item.setCustId(clientId);
                        item.setCustName(customerVo.getCustomerName());
                        item.setCustCode(customerVo.getCustomerCode());
                        item.setCustPer(customerVo.getLinkman());
                        item.setCustPh(customerVo.getLinkmanPhone());
                        item.setClassification(customerVo.getChannelType());
                        if (vo != null && vo.getLat() != null && vo.getLng() != null && customerVo.getExtNumber4() != null && customerVo.getExtNumber5() != null) {
                            item.setDisNum(GpsUtil.GetDistance(vo.getLat(), vo.getLng(), customerVo.getExtNumber4().intValue(), customerVo.getExtNumber5().intValue()));
                            item.setDisNumStr(item.getDisNum() + "m");
                        } else {
                            item.setDisNumStr("\u6682\u65e0\u8ddd\u79bb\u6570\u636e");
                        }
                    }
                } else if (StringUtils.isNotBlank((CharSequence)item.getClientType()) && item.getClientType().equals(SfaConstantEnum.CusType.terminal_type.getVal()) && (tmTerminalVo = (TmTerminalVo)ApiResultUtil.objResult((AjaxJson)this.tmTerminalFeign.getTerminalById(clientId))) != null) {
                    if (StringUtils.isBlank((CharSequence)item.getClientName())) {
                        Example example = new Example(VisitNoteEntity.class);
                        Example.Criteria criteria = example.createCriteria();
                        criteria.andEqualTo("clientId", (Object)clientId);
                        VisitNoteEntity vt = new VisitNoteEntity();
                        vt.setClientName(tmTerminalVo.getTerminalName());
                        this.visitNoteDao.updateByExampleSelective(vt, example);
                    }
                    item.setCustAddr(tmTerminalVo.getAddress());
                    item.setCustId(clientId);
                    item.setCustName(tmTerminalVo.getTerminalName());
                    item.setCustCode(tmTerminalVo.getTerminalCode());
                    item.setCustPer(tmTerminalVo.getLinkman());
                    item.setCustPh(tmTerminalVo.getLinkmanPhone());
                    item.setClassification(tmTerminalVo.getTerminalType());
                    if (vo != null && vo.getLat() != null && vo.getLng() != null && tmTerminalVo.getExtNumber4() != null && tmTerminalVo.getExtNumber5() != null) {
                        item.setDisNum(GpsUtil.GetDistance(vo.getLat(), vo.getLng(), tmTerminalVo.getExtNumber4().intValue(), tmTerminalVo.getExtNumber5().intValue()));
                        item.setDisNumStr(item.getDisNum() + "m");
                    } else {
                        item.setDisNumStr("\u6682\u65e0\u8ddd\u79bb\u6570\u636e");
                    }
                }
            });
            Collections.sort(list, Comparator.comparing(VisitNoteVo::getDisNum));
        }
        return pageInfo;
    }

    @Override
    public PageInfo<VisitNoteVo> getVisitHisInfo(List<String> pos, TsVisitHisApiVo vo, Page page) {
        PageInfo list = null;
        list = SfaConstantEnum.VisitType.assit_type.equals(vo.getVisitType()) ? PageAutoHelperUtil.generatePage(() -> this.visitNoteDao.getVisitHisInfoAssit(pos, vo), (Page)page) : PageAutoHelperUtil.generatePage(() -> this.visitNoteDao.getVisitHisInfo(pos, vo), (Page)page);
        if (list != null && CollectionUtil.listNotEmptyNotSizeZero((List)list.getList())) {
            list.getList().forEach(item -> {
                TmTerminalVo tmTerminalVo;
                String clientId = item.getClientId();
                if (StringUtils.isNotBlank((CharSequence)item.getClientType()) && item.getClientType().equals(SfaConstantEnum.CusType.channel.getVal())) {
                    TmCustomerVo customerVo = (TmCustomerVo)ApiResultUtil.objResult((AjaxJson)this.customerFeign.getCustomerByIdOrCode(clientId, ""));
                    if (customerVo != null) {
                        if (StringUtils.isBlank((CharSequence)item.getClientName())) {
                            Example example = new Example(VisitNoteEntity.class);
                            Example.Criteria criteria = example.createCriteria();
                            criteria.andEqualTo("clientId", (Object)clientId);
                            VisitNoteEntity vt = new VisitNoteEntity();
                            vt.setClientName(customerVo.getCustomerName());
                            this.visitNoteDao.updateByExampleSelective(vt, example);
                        }
                        item.setCustAddr(customerVo.getAddress());
                        item.setCustId(clientId);
                        item.setCustName(customerVo.getCustomerName());
                        item.setCustCode(customerVo.getCustomerCode());
                        item.setCustPer(customerVo.getLinkman());
                        item.setCustPh(customerVo.getLinkmanPhone());
                        item.setClassification(customerVo.getChannelType());
                    }
                } else if (StringUtils.isNotBlank((CharSequence)item.getClientType()) && item.getClientType().equals(SfaConstantEnum.CusType.terminal_type.getVal()) && (tmTerminalVo = (TmTerminalVo)ApiResultUtil.objResult((AjaxJson)this.tmTerminalFeign.getTerminalById(clientId))) != null) {
                    if (StringUtils.isBlank((CharSequence)item.getClientName())) {
                        Example example = new Example(VisitNoteEntity.class);
                        Example.Criteria criteria = example.createCriteria();
                        criteria.andEqualTo("clientId", (Object)clientId);
                        VisitNoteEntity vt = new VisitNoteEntity();
                        vt.setClientName(tmTerminalVo.getTerminalName());
                        this.visitNoteDao.updateByExampleSelective(vt, example);
                    }
                    item.setCustAddr(tmTerminalVo.getAddress());
                    item.setCustId(clientId);
                    item.setCustName(tmTerminalVo.getTerminalName());
                    item.setCustCode(tmTerminalVo.getTerminalCode());
                    item.setCustPer(tmTerminalVo.getLinkman());
                    item.setCustPh(tmTerminalVo.getLinkmanPhone());
                    item.setClassification(tmTerminalVo.getTerminalType());
                }
            });
        }
        return list;
    }

    private int getCount(String planType, String visitDate, Integer posId, String status, String custId, String userId) {
        Example example = new Example(VisitNoteEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)planType)) {
            criteria.andEqualTo("planType", (Object)planType);
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            criteria.andEqualTo("status", (Object)status);
        }
        if (StringUtils.isNotBlank((CharSequence)visitDate)) {
            criteria.andEqualTo("visitDate", (Object)visitDate);
        }
        if (posId != null) {
            criteria.andEqualTo("posId", (Object)posId);
        }
        if (StringUtils.isNotBlank((CharSequence)custId)) {
            criteria.andEqualTo("clientId", (Object)custId);
        }
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            criteria.andEqualTo("userId", (Object)userId);
        }
        return this.visitNoteDao.selectCountByExample(example);
    }

    private int getCountAssist(String planType, String visitDate, Integer posId, String status, String custId) {
        List visits;
        Example example = new Example(VisitNoteEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)planType)) {
            criteria.andEqualTo("planType", (Object)planType);
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            criteria.andEqualTo("status", (Object)status);
        }
        if (StringUtils.isNotBlank((CharSequence)visitDate)) {
            criteria.andEqualTo("visitDate", (Object)visitDate);
        }
        if (posId != null) {
            criteria.andEqualTo("posId", (Object)posId);
        }
        if (StringUtils.isNotBlank((CharSequence)custId)) {
            criteria.andEqualTo("clientId", (Object)custId);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(visits = this.visitNoteDao.selectByExample(example)))) {
            List ids = visits.stream().map(BaseTsEntity::getId).collect(Collectors.toList());
            Example exampleAssist = new Example(VisitNoteEntity.class);
            Example.Criteria criteriaAssist = example.createCriteria();
            criteriaAssist.andIn("assistId", ids);
            return this.visitNoteDao.selectCountByExample(exampleAssist);
        }
        return 0;
    }

    @Override
    public String addLIne(VisitNoteEntity noteEntity, String[] clienIdArray, String[] custTypeArray, String lvPosId, int auditStatus) throws Exception {
        VisitNoteEntity newNoteEntity = null;
        String message = "";
        boolean flag = false;
        if (StringUtil.isNotEmpty((Object)clienIdArray)) {
            message = "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f";
            int sfaOrder = this.getCount(SfaConstantEnum.VisitType.plan_visit.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), "", "");
            int assisOrder = this.getCount(SfaConstantEnum.VisitType.assit_type.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), "", "");
            for (int i = 0; i < clienIdArray.length; ++i) {
                int IsExist;
                String custId = clienIdArray[i];
                if (StringUtil.isEmpty((String)custId)) continue;
                long count = this.getCount(SfaConstantEnum.VisitType.plan_visit.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), custId, "");
                if (count == 0L) {
                    noteEntity.setClientType(custTypeArray[i]);
                    noteEntity.setClientId(custId);
                    noteEntity.setAuditStatus(String.valueOf(auditStatus));
                    noteEntity.setSfaOrder(String.valueOf(++sfaOrder));
                    noteEntity.setType("1");
                    newNoteEntity = new VisitNoteEntity();
                    MyBeanUtils.copyBeanNotNull2Bean((Object)noteEntity, (Object)newNoteEntity);
                    newNoteEntity.setVisitPosId(newNoteEntity.getPosId());
                    newNoteEntity.setVisitUserId(newNoteEntity.getUserId());
                    this.visitNoteDao.insertSelective(newNoteEntity);
                } else {
                    Example example = new Example(VisitNoteEntity.class);
                    Example.Criteria criteria = example.createCriteria();
                    criteria.andEqualTo("posId", (Object)noteEntity.getPosId());
                    criteria.andEqualTo("clientId", (Object)custId);
                    criteria.andEqualTo("planType", (Object)SfaConstantEnum.VisitType.plan_visit.getVal());
                    criteria.andEqualTo("status", (Object)ConstantEnum.StatusEnum.NEW.getValue());
                    List visitNotes = this.visitNoteDao.selectByExample(example);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)visitNotes)) {
                        newNoteEntity = (VisitNoteEntity)visitNotes.get(0);
                    }
                    message = "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f,\u5df2\u81ea\u52a8\u8fc7\u6ee4\u91cd\u590d\u7f51\u70b9";
                }
                TmUserQueryVo queryVo = new TmUserQueryVo();
                queryVo.setId(noteEntity.getUserId());
                TmUserVo user = (TmUserVo)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.getTmUser(queryVo));
                String superPosId = null;
                if (user != null && StringUtils.isNotBlank((CharSequence)user.getUserType()) && !user.getUserType().equals("2")) {
                    TmPositionVo pvo = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getPosition(String.valueOf(noteEntity.getPosId()), null));
                    superPosId = pvo != null ? pvo.getParentId() : "";
                }
                TmPositionVo pos = null;
                if (StringUtils.isNotBlank(superPosId)) {
                    pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon(superPosId, ""));
                    List<VisitParam> list = this.visitNoteDao.getCustomerVisitPosIdForChargeVisit(superPosId, noteEntity.getVisitDate());
                    if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                        for (VisitParam visitParam : list) {
                            if (noteEntity.getPosId() == null || visitParam.getPosId() == null || noteEntity.getPosId() != Integer.parseInt(visitParam.getPosId())) continue;
                            flag = true;
                            break;
                        }
                    } else {
                        flag = true;
                    }
                }
                if (!flag || pos == null || (IsExist = this.getCount(SfaConstantEnum.VisitType.assit_type.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), custId, "")) != 0) continue;
                VisitNoteEntity assitNote = new VisitNoteEntity();
                MyBeanUtils.copyBeanNotNull2Bean((Object)noteEntity, (Object)assitNote);
                assitNote.setId(null);
                assitNote.setClientType(custTypeArray[i]);
                assitNote.setPosName(pos.getPositionName());
                assitNote.setUserId(pos.getUserName());
                assitNote.setUserName(pos.getFullname());
                assitNote.setPlanType(SfaConstantEnum.VisitType.assit_type.getVal());
                assitNote.setPosId(Integer.valueOf(pos.getId()));
                assitNote.setSfaOrder(String.valueOf(++assisOrder));
                assitNote.setAssistId(newNoteEntity.getId());
                assitNote.setVisitUserId(assitNote.getUserId());
                assitNote.setVisitPosId(assitNote.getPosId());
                assitNote.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.visitNoteDao.insertSelective(assitNote);
            }
        } else {
            long checkChargeCount = this.getCountAssist(SfaConstantEnum.VisitType.plan_visit.getVal(), noteEntity.getVisitDate(), Integer.valueOf(lvPosId), ConstantEnum.StatusEnum.NEW.getValue(), "");
            if (checkChargeCount == 0L) {
                message = "\u6dfb\u52a0\u534f\u8bbf\u8ba1\u5212\u6210\u529f";
                Example example = new Example(VisitNoteEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("planType", (Object)SfaConstantEnum.VisitType.plan_visit.getVal());
                criteria.andEqualTo("status", (Object)ConstantEnum.StatusEnum.NEW.getValue());
                criteria.andEqualTo("visitDate", (Object)noteEntity.getVisitDate());
                criteria.andEqualTo("posId", (Object)lvPosId);
                List notes = this.selectExample(example);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)notes)) {
                    int sfaOrder = this.getCount(SfaConstantEnum.VisitType.assit_type.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), "", "");
                    for (VisitNoteEntity visitNoteEntity : notes) {
                        long chargeCount;
                        if (StringUtil.isEmpty((String)visitNoteEntity.getClientId()) || (chargeCount = (long)this.getCount(SfaConstantEnum.VisitType.assit_type.getVal(), noteEntity.getVisitDate(), Integer.valueOf(lvPosId), ConstantEnum.StatusEnum.NEW.getValue(), visitNoteEntity.getClientId(), noteEntity.getUserId())) != 0L) continue;
                        noteEntity.setClientType(visitNoteEntity.getClientType());
                        noteEntity.setClientId(visitNoteEntity.getClientId());
                        noteEntity.setSfaOrder(String.valueOf(++sfaOrder));
                        noteEntity.setAssistId(visitNoteEntity.getId());
                        noteEntity.setType("1");
                        noteEntity.setAuditStatus(String.valueOf(auditStatus));
                        newNoteEntity = new VisitNoteEntity();
                        try {
                            MyBeanUtils.copyBeanNotNull2Bean((Object)noteEntity, (Object)newNoteEntity);
                        }
                        catch (Exception e) {
                            message = "\u6dfb\u52a0\u534f\u8bbf\u8ba1\u5212\u5931\u8d25";
                        }
                        newNoteEntity.setVisitUserId(newNoteEntity.getUserId());
                        newNoteEntity.setVisitPosId(newNoteEntity.getPosId());
                        this.visitNoteDao.insertSelective(newNoteEntity);
                    }
                } else {
                    message = "\u8be5\u4e0b\u5c5e\u65e0\u5ba2\u6237\u62dc\u8bbf\u8ba1\u5212";
                }
            } else {
                message = "\u8be5\u5929\u5df2\u7ecf\u521b\u5efa\u534f\u8bbf\u8ba1\u5212";
            }
        }
        return message;
    }

    @Override
    public String addLIneAll(VisitNoteEntity noteEntity, String[] clienIdArray, String[] custTypeArray, String lvPosId, int auditStatus, String startDate, String endDate, String notWeeks) throws Exception {
        String message = "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f";
        Date start = DateUtils.date_sdf.parse(startDate);
        Date end = DateUtils.date_sdf.parse(endDate);
        String[] weekDays = new String[]{"7", "1", "2", "3", "4", "5", "6"};
        HashSet<String> notWeekSet = new HashSet<String>();
        if (StringUtil.isNotEmpty((CharSequence)notWeeks)) {
            for (String notWeek : notWeeks.split(",")) {
                notWeekSet.add(notWeek);
            }
        }
        ArrayList<VisitNoteEntity> visitNoteList = new ArrayList<VisitNoteEntity>();
        while (start.getTime() <= end.getTime()) {
            String week;
            Calendar c = Calendar.getInstance();
            c.setTime(start);
            int w = c.get(7) - 1;
            if (w < 0) {
                w = 0;
            }
            if (notWeekSet.contains(week = weekDays[w])) {
                c.add(5, 1);
                start = c.getTime();
                continue;
            }
            noteEntity.setVisitDate(DateUtils.date_sdf.format(start));
            List<VisitNoteEntity> visitNotes = this.addLIneAllList(noteEntity, clienIdArray, custTypeArray, lvPosId, auditStatus);
            if (CollectionUtil.listNotEmptyNotSizeZero(visitNotes)) {
                visitNoteList.addAll(visitNotes);
            }
            c.add(5, 1);
            start = c.getTime();
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(visitNoteList)) {
            this.visitNoteDao.insertList(visitNoteList);
        }
        return message;
    }

    public List<VisitNoteEntity> addLIneAllList(VisitNoteEntity noteEntity, String[] clienIdArray, String[] custTypeArray, String lvPosId, int auditStatus) throws Exception {
        ArrayList<VisitNoteEntity> visitNoteList = new ArrayList<VisitNoteEntity>();
        VisitNoteEntity newNoteEntity = null;
        String message = "";
        boolean flag = false;
        if (StringUtil.isNotEmpty((Object)clienIdArray)) {
            int sfaOrder = this.getCount(SfaConstantEnum.VisitType.plan_visit.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), "", "");
            int assisOrder = this.getCount(SfaConstantEnum.VisitType.assit_type.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), "", "");
            message = "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f";
            for (int i = 0; i < clienIdArray.length; ++i) {
                long IsExist;
                String custId = clienIdArray[i];
                if (StringUtil.isEmpty((String)custId)) continue;
                long count = this.getCount(SfaConstantEnum.VisitType.plan_visit.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), custId, "");
                if (count == 0L) {
                    noteEntity.setClientType(custTypeArray[i]);
                    noteEntity.setClientId(custId);
                    noteEntity.setAuditStatus(String.valueOf(auditStatus));
                    noteEntity.setSfaOrder(String.valueOf(++sfaOrder));
                    noteEntity.setType("1");
                    newNoteEntity = new VisitNoteEntity();
                    MyBeanUtils.copyBeanNotNull2Bean((Object)noteEntity, (Object)newNoteEntity);
                    newNoteEntity.setVisitPosId(newNoteEntity.getPosId());
                    newNoteEntity.setVisitUserId(newNoteEntity.getUserId());
                    visitNoteList.add(newNoteEntity);
                } else {
                    Example example = new Example(VisitNoteEntity.class);
                    Example.Criteria criteria = example.createCriteria();
                    criteria.andEqualTo("posId", (Object)noteEntity.getPosId());
                    criteria.andEqualTo("clientId", (Object)custId);
                    criteria.andEqualTo("planType", (Object)SfaConstantEnum.VisitType.plan_visit.getVal());
                    criteria.andEqualTo("status", (Object)ConstantEnum.StatusEnum.NEW.getValue());
                    List visitNotes = this.visitNoteDao.selectByExample(example);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)visitNotes)) {
                        newNoteEntity = (VisitNoteEntity)visitNotes.get(0);
                    }
                    message = "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f,\u5df2\u81ea\u52a8\u8fc7\u6ee4\u91cd\u590d\u7f51\u70b9";
                }
                TmUserQueryVo queryVo = new TmUserQueryVo();
                queryVo.setId(noteEntity.getUserId());
                TmUserVo user = (TmUserVo)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.getTmUser(queryVo));
                String superPosId = null;
                if (user != null && StringUtils.isNotBlank((CharSequence)user.getUserType()) && !user.getUserType().equals("2")) {
                    TmPositionVo pvo = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getPosition(String.valueOf(noteEntity.getPosId()), null));
                    superPosId = pvo != null ? pvo.getParentId() : "";
                }
                TmPositionVo pos = null;
                if (StringUtils.isNotBlank(superPosId)) {
                    pos = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserMainPositon(null, superPosId));
                    List<VisitParam> list = this.visitNoteDao.getCustomerVisitPosIdForChargeVisit(superPosId, noteEntity.getVisitDate());
                    if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                        for (VisitParam visitParam : list) {
                            if (noteEntity.getPosId() == null || visitParam.getPosId() == null || noteEntity.getPosId() != Integer.parseInt(visitParam.getPosId())) continue;
                            flag = true;
                            break;
                        }
                    } else {
                        flag = true;
                    }
                }
                if (!flag || pos == null || (IsExist = (long)this.getCount(SfaConstantEnum.VisitType.assit_type.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), custId, "")) != 0L) continue;
                VisitNoteEntity assitNote = new VisitNoteEntity();
                MyBeanUtils.copyBeanNotNull2Bean((Object)noteEntity, (Object)assitNote);
                assitNote.setId(null);
                assitNote.setClientType(custTypeArray[i]);
                assitNote.setPosName(pos.getPositionName());
                assitNote.setUserId(pos.getUserName());
                assitNote.setUserName(pos.getFullname());
                assitNote.setPlanType(SfaConstantEnum.VisitType.assit_type.getVal());
                assitNote.setPosId(Integer.valueOf(pos.getId()));
                assitNote.setSfaOrder(String.valueOf(++assisOrder));
                assitNote.setAssistId(newNoteEntity.getId());
                assitNote.setVisitUserId(assitNote.getUserId());
                assitNote.setVisitPosId(assitNote.getPosId());
                assitNote.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.insertSelective(assitNote);
                visitNoteList.add(assitNote);
            }
        } else {
            long checkChargeCount = this.getCountAssist(SfaConstantEnum.VisitType.plan_visit.getVal(), noteEntity.getVisitDate(), Integer.valueOf(lvPosId), ConstantEnum.StatusEnum.NEW.getValue(), "");
            if (checkChargeCount == 0L) {
                message = "\u6dfb\u52a0\u534f\u8bbf\u8ba1\u5212\u6210\u529f";
                Example example = new Example(VisitNoteEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("planType", (Object)SfaConstantEnum.VisitType.plan_visit.getVal());
                criteria.andEqualTo("status", (Object)ConstantEnum.StatusEnum.NEW.getValue());
                criteria.andEqualTo("visitDate", (Object)noteEntity.getVisitDate());
                criteria.andEqualTo("posId", (Object)lvPosId);
                List notes = this.selectExample(example);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)notes)) {
                    int sfaOrder = this.getCount(SfaConstantEnum.VisitType.assit_type.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), "", "");
                    for (VisitNoteEntity visitNoteEntity : notes) {
                        long chargeCount;
                        if (StringUtil.isEmpty((String)visitNoteEntity.getClientId()) || (chargeCount = (long)this.getCount(SfaConstantEnum.VisitType.assit_type.getVal(), noteEntity.getVisitDate(), Integer.valueOf(lvPosId), ConstantEnum.StatusEnum.NEW.getValue(), visitNoteEntity.getClientId(), noteEntity.getUserId())) != 0L) continue;
                        noteEntity.setClientType(visitNoteEntity.getClientType());
                        noteEntity.setClientId(visitNoteEntity.getClientId());
                        noteEntity.setSfaOrder(String.valueOf(sfaOrder + 1));
                        noteEntity.setAssistId(visitNoteEntity.getId());
                        noteEntity.setType("1");
                        noteEntity.setAuditStatus(String.valueOf(auditStatus));
                        newNoteEntity = new VisitNoteEntity();
                        try {
                            MyBeanUtils.copyBeanNotNull2Bean((Object)noteEntity, (Object)newNoteEntity);
                        }
                        catch (Exception e) {
                            message = "\u6dfb\u52a0\u534f\u8bbf\u8ba1\u5212\u5931\u8d25";
                        }
                        newNoteEntity.setVisitUserId(newNoteEntity.getUserId());
                        newNoteEntity.setVisitPosId(newNoteEntity.getPosId());
                        visitNoteList.add(newNoteEntity);
                    }
                } else {
                    message = "\u8be5\u4e0b\u5c5e\u65e0\u5ba2\u6237\u62dc\u8bbf\u8ba1\u5212";
                }
            } else {
                message = "\u8be5\u5929\u5df2\u7ecf\u521b\u5efa\u534f\u8bbf\u8ba1\u5212";
            }
        }
        if (!("\u6dfb\u52a0\u534f\u8bbf\u8ba1\u5212\u6210\u529f".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f,\u5df2\u81ea\u52a8\u8fc7\u6ee4\u91cd\u590d\u7f51\u70b9".equals(message) || "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f".equals(message))) {
            throw new BusinessException(message);
        }
        return visitNoteList;
    }

    @Override
    public String addGvLIneAll(VisitNoteEntity noteEntity, String[] visitGroupArray, String lvPosId, int auditStatus, String startDate, String endDate, String notWeeks) throws Exception {
        String message = "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f";
        Date start = DateUtils.date_sdf.parse(startDate);
        Date end = DateUtils.date_sdf.parse(endDate);
        HashMap<String, List<Object>> visitclientMap = new HashMap<String, List<Object>>();
        String[] weekDays = new String[]{"7", "1", "2", "3", "4", "5", "6"};
        HashSet<String> notWeekSet = new HashSet<String>();
        if (StringUtil.isNotEmpty((CharSequence)notWeeks)) {
            for (String notWeek : notWeeks.split(",")) {
                notWeekSet.add(notWeek);
            }
        }
        ArrayList<VisitNoteEntity> visitNoteList = new ArrayList<VisitNoteEntity>();
        int con = 0;
        while (start.getTime() <= end.getTime()) {
            String week;
            Calendar c = Calendar.getInstance();
            c.setTime(start);
            int w = c.get(7) - 1;
            if (w < 0) {
                w = 0;
            }
            if (notWeekSet.contains(week = weekDays[w])) {
                c.add(5, 1);
                start = c.getTime();
                continue;
            }
            String visitGroup = visitGroupArray[con];
            List<Object> visitclientRelList = new ArrayList();
            if (visitclientMap.containsKey(visitGroup)) {
                visitclientRelList = (List)visitclientMap.get(visitGroup);
            } else {
                visitclientRelList = this.visitGroupService.findVisitclientRelListByGroupId(visitGroup);
                if (!CollectionUtil.listNotEmptyNotSizeZero(visitclientRelList)) {
                    throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7ebf\u8def\u7ec4" + con + ",\u5bf9\u5e94\u7684\u7f51\u70b9\u3002");
                }
                visitclientMap.put(visitGroup, visitclientRelList);
            }
            String[] clienIdArray = new String[visitclientRelList.size()];
            String[] custTypeArray = new String[visitclientRelList.size()];
            int i = 0;
            for (VisitclientRelEntity visitclientRelEntity : visitclientRelList) {
                clienIdArray[i] = visitclientRelEntity.getClientId();
                custTypeArray[i] = visitclientRelEntity.getClientType();
                ++i;
            }
            noteEntity.setVisitDate(DateUtils.date_sdf.format(start));
            List<VisitNoteEntity> visitNotes = this.addLIneAllList(noteEntity, clienIdArray, custTypeArray, lvPosId, auditStatus);
            if (CollectionUtil.listNotEmptyNotSizeZero(visitNotes)) {
                visitNoteList.addAll(visitNotes);
            }
            c.add(5, 1);
            start = c.getTime();
            if (++con < visitGroupArray.length) continue;
            con = 0;
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(visitNoteList)) {
            this.visitNoteDao.insertList(visitNoteList);
        }
        return message;
    }

    @Override
    public List<String> getAlreadyPlan(Map<String, Object> param) {
        Example example = new Example(VisitNoteEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status", (Object)ConstantEnum.StatusEnum.NEW.getValue());
        criteria.andEqualTo("posId", param.get("posId"));
        criteria.andEqualTo("userId", param.get("userId"));
        criteria.andEqualTo("planType", (Object)SfaConstantEnum.VisitType.plan_visit);
        criteria.andBetween("visitDate", param.get("startDate"), param.get("endDate"));
        List visits = this.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)visits)) {
            return visits.stream().map(VisitNoteEntity::getVisitDate).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public void autoVisit(VisitNoteEntity visitNoteEntity, String startDate, String endDate, String flag) throws ParseException, Exception {
        if (StringUtil.isNotEmpty((CharSequence)flag)) {
            Example example = new Example(VisitNoteEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("status", (Object)ConstantEnum.StatusEnum.NEW.getValue());
            criteria.andEqualTo("posId", (Object)visitNoteEntity.getPosId());
            criteria.andEqualTo("planType", (Object)SfaConstantEnum.VisitType.plan_visit);
            criteria.andBetween("visitDate", (Object)startDate, (Object)endDate);
            this.deleteByExample(example);
        }
        ArrayList<String> detailDates = new ArrayList<String>();
        VisitNoteEntity newVistiNote = null;
        String sql = "";
        long otherDay = (DateUtils.getMillis((Date)DateUtils.getDateYYYYMD((String)endDate)) - DateUtils.getMillis((Date)DateUtils.getDateYYYYMD((String)startDate))) / 86400000L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.getDateYYYYMD((String)startDate));
        String newDate = DateUtils.getYYYYMMDD((Date)calendar.getTime());
        detailDates.add(newDate);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(DateUtils.getDateYYYYMD((String)endDate));
        int i = 0;
        while ((long)i < otherDay) {
            calendar.add(5, 1);
            if (calendar.getTime().before(endTime.getTime()) || calendar.getTime().equals(endTime.getTime())) {
                detailDates.add(DateUtils.getYYYYMMDD((Date)calendar.getTime()));
            }
            ++i;
        }
        Example example = new Example(VisitGroupEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userId", (Object)visitNoteEntity.getUserId());
        criteria.andEqualTo("posId", (Object)visitNoteEntity.getPosId());
        example.orderBy("groupOrder").asc();
        List groupEntitys = this.visitGroupDao.selectByExample(example);
        Integer groupCount = groupEntitys.size();
        Integer oneOfGroup = 0;
        Integer order = 1;
        if (CollectionUtil.listNotEmptyNotSizeZero(detailDates)) {
            for (int i2 = 0; i2 < detailDates.size(); ++i2) {
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)groupEntitys)) continue;
                List rels = ((VisitGroupEntity)groupEntitys.get(oneOfGroup)).getVisitclients();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)rels)) {
                    for (VisitclientRelEntity visitclientRelEntity : rels) {
                        if (StringUtil.isEmpty((String)visitclientRelEntity.getClientId())) continue;
                        long count = this.getCount(SfaConstantEnum.VisitType.plan_visit.getVal(), (String)detailDates.get(i2), visitNoteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), visitNoteEntity.getClientId(), "");
                        if (count == 0L) {
                            newVistiNote = new VisitNoteEntity();
                            MyBeanUtils.copyBeanNotNull2Bean((Object)visitNoteEntity, (Object)newVistiNote);
                            newVistiNote.setVisitDate((String)detailDates.get(i2));
                            newVistiNote.setClientId(visitclientRelEntity.getClientId());
                            newVistiNote.setSfaOrder(order.toString());
                            newVistiNote.setAuditStatus("1");
                            newVistiNote.setType("1");
                            newVistiNote.setVisitUserId(newVistiNote.getUserId());
                            newVistiNote.setVisitPosId(newVistiNote.getPosId());
                            newVistiNote.setVisitStatus(SfaConstantEnum.VisitStatus.V1.getVal());
                            this.insertSelective(newVistiNote);
                        }
                        Integer n = order;
                        Integer n2 = order = Integer.valueOf(order + 1);
                    }
                }
                Integer n = oneOfGroup;
                Integer n3 = oneOfGroup = Integer.valueOf(oneOfGroup + 1);
                if (oneOfGroup.intValue() != groupCount.intValue()) continue;
                oneOfGroup = 0;
                order = 1;
            }
        }
    }

    @Override
    public void addVisitRemind(VisitNoteEntity visitNoteEntity, String ids) {
        if (StringUtil.isNotEmpty((CharSequence)ids)) {
            for (int i = 0; i < ids.split(",").length; ++i) {
                VisitNoteEntity entity = (VisitNoteEntity)this.selectByPrimaryKey(ids.split(",")[i]);
                entity.setVisitRemind(visitNoteEntity.getVisitRemind());
                this.updateByPrimaryKeySelective(entity);
            }
        }
    }

    @Override
    public String getVisitInfoMap(String userId, String posId, String visitDate) {
        return null;
    }

    @Override
    public List<VisitNoteVo> getCalenderDate(String month, String posId) {
        return this.visitNoteDao.getCalenderDate(month, posId);
    }

    @Override
    public VisitNoteEntity addLIneTemp(String clientId, String custType) throws Exception {
        UserRedis user = UserUtils.getUser();
        if (user == null || StringUtils.isBlank((CharSequence)user.getPosId())) {
            throw new BusinessException("\u672a\u914d\u7f6e\u804c\u4f4d\u4fe1\u606f");
        }
        String posid_ = StringUtils.isNotBlank((CharSequence)user.getPosId()) ? user.getPosId() : "0";
        int posId = Integer.parseInt(posid_);
        String visitDate = DateUtils.getDate((String)"yyyy-MM-dd");
        Example example = new Example(VisitNoteEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status", (Object)ConstantEnum.StatusEnum.NEW.getValue());
        criteria.andEqualTo("posId", (Object)user.getPosId());
        criteria.andEqualTo("planType", (Object)SfaConstantEnum.VisitType.temp_visit);
        criteria.andEqualTo("visitDate", (Object)visitDate);
        criteria.andEqualTo("clientId", (Object)clientId);
        List visits = this.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)visits)) {
            return (VisitNoteEntity)visits.get(0);
        }
        VisitNoteEntity noteEntity = new VisitNoteEntity();
        noteEntity.setClientType(custType);
        noteEntity.setClientId(clientId);
        noteEntity.setAuditStatus("1");
        noteEntity.setSfaOrder(this.getCount(SfaConstantEnum.VisitType.plan_visit.getVal(), noteEntity.getVisitDate(), noteEntity.getPosId(), ConstantEnum.StatusEnum.NEW.getValue(), "", "") + 1 + "");
        noteEntity.setType("1");
        noteEntity.setVisitPosId(Integer.valueOf(posId));
        noteEntity.setVisitUserId(user.getId());
        noteEntity.setVisitStatus(SfaConstantEnum.VisitStatus.V1.getVal());
        noteEntity.setRouteType(SfaConstantEnum.VisitType.temp_visit.getVal());
        noteEntity.setPlanType(SfaConstantEnum.VisitType.temp_visit.getVal());
        noteEntity.setVisitDate(visitDate);
        noteEntity.setUserId(user.getId());
        noteEntity.setUserName(user.getRealname());
        noteEntity.setPosId(Integer.valueOf(posId));
        noteEntity.setPosName(user.getPosName());
        noteEntity.setStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.visitNoteDao.insertSelective(noteEntity);
        return noteEntity;
    }

    @Override
    public List<VisitNoteVo> getCheckCustomerVisit(List<TmCustomerResultVo> resultVos, TsVisitClientApiVo apiVo) {
        ArrayList<VisitNoteVo> outVisit = new ArrayList<VisitNoteVo>();
        resultVos.forEach(item -> {
            VisitNoteVo vo = new VisitNoteVo();
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)vo);
                vo.setClientId(item.getId());
                vo.setClientType(item.getCustomerType());
                vo.setCustName(item.getCustomerName());
                vo.setCustCode(item.getCustomerCode());
                vo.setCustPh(item.getLinkmanPhone());
                vo.setCustAddr(item.getAddress());
                vo.setCustPer(item.getLinkman());
                if (apiVo.getLat() != null && apiVo.getLng() != null) {
                    vo.setDisNum(GpsUtil.GetDistance(apiVo.getLat(), apiVo.getLng(), item.getLat(), item.getLng()));
                    vo.setDisNumStr(vo.getDisNum() + "m");
                } else {
                    vo.setDisNumStr("\u6682\u65e0\u6570\u636e");
                }
                outVisit.add(vo);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        });
        Collections.sort(outVisit, Comparator.comparing(VisitNoteVo::getDisNum));
        List ids = resultVos.stream().map(TmCustomerResultVo::getId).collect(Collectors.toList());
        Example example = new Example(VisitNoteEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("clientId", ids);
        criteria.andEqualTo("visitDate", (Object)DateUtils.getDate((String)"yyyy-MM-dd"));
        criteria.andEqualTo("planType", (Object)SfaConstantEnum.VisitType.temp_visit.getVal());
        List notes = this.selectExample(example);
        Map<Object, Object> noteMap = new HashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)notes)) {
            noteMap = notes.stream().collect(Collectors.groupingBy(VisitNoteEntity::getClientId));
        }
        HashMap finalNoteMap = noteMap;
        outVisit.stream().filter(ft -> finalNoteMap.containsKey(ft.getClientId())).forEach(item -> {
            VisitNoteEntity entity = (VisitNoteEntity)((List)finalNoteMap.get(item.getClientId())).get(0);
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)entity, (Object)item);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        });
        return outVisit;
    }

    @Override
    public PageInfo<VisitNoteVo> findAppByVisitNotePage(VisitNoteVo visitNoteVo, Page page) {
        visitNoteVo.setStatus("009");
        visitNoteVo.setVisitDateBegin(DateUtils.date_sdf.format(new Date()));
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.visitNoteDao.findVisitNoteList(visitNoteVo), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            StringBuffer inIdBuffer = new StringBuffer();
            pageInfo.getList().forEach(item -> {
                if (inIdBuffer.length() > 0) {
                    inIdBuffer.append(",");
                }
                inIdBuffer.append(item.getClientId());
            });
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("page", page.getPage());
            param.put("rows", page.getRows());
            if (inIdBuffer.length() > 0) {
                param.put("inIds", inIdBuffer.toString());
                List customerResultList = ApiResultUtil.pageInfoResult((AjaxJson)this.mdmApiFeign.getCustomerByPosIdPage(param)).getList();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)customerResultList)) {
                    HashMap customerMap = new HashMap();
                    customerResultList.forEach(item -> customerMap.put(item.getId(), item));
                    pageInfo.getList().forEach(item -> {
                        if (customerMap.containsKey(item.getClientId())) {
                            TmCustomerResultVo customer = (TmCustomerResultVo)customerMap.get(item.getClientId());
                            item.setClientCode(customer.getCustomerCode());
                            item.setClientAddress(customer.getAddress());
                        }
                    });
                }
            }
        }
        return pageInfo;
    }

    @Override
    public String addVPLIneAll(VisitNoteEntity visitNote, String[] custArray, String[] custTypeArray, String lvPosId, Integer auditStatus, String startDate, String endDate, String notWeeks, String[] frquencyArray, String[] firstDayArray) throws Exception {
        String message = "\u6dfb\u52a0\u7ebf\u8def\u6210\u529f";
        Set<String> notWeekSet = this.getNotWeek(notWeeks);
        Date start = DateUtils.date_sdf.parse(startDate);
        Date end = DateUtils.date_sdf.parse(endDate);
        ArrayList<VisitNoteEntity> visitNoteList = new ArrayList<VisitNoteEntity>();
        for (int i = 0; i < custArray.length; ++i) {
            Date startCustDate = DateUtils.date_sdf.parse(firstDayArray[i]);
            int frquency = Integer.parseInt(frquencyArray[i]);
            String[] clienIdArray = new String[]{custArray[i]};
            String[] custTypesArray = new String[]{custTypeArray[i]};
            List<VisitNoteEntity> visitNotes = this.getVisitNoteEntities(startCustDate, end, frquency, visitNote, notWeekSet, lvPosId, auditStatus, clienIdArray, custTypesArray);
            if (!CollectionUtil.listNotEmptyNotSizeZero(visitNotes)) continue;
            visitNoteList.addAll(visitNotes);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(visitNoteList)) {
            this.visitNoteDao.insertList(visitNoteList);
        }
        return message;
    }

    private List<VisitNoteEntity> getVisitNoteEntities(Date startCustDate, Date end, int frquency, VisitNoteEntity visitNote, Set<String> notWeekSet, String lvPosId, int auditStatus, String[] clienIdArray, String[] custTypeArray) throws Exception {
        String[] weekDays = new String[]{"7", "1", "2", "3", "4", "5", "6"};
        ArrayList<VisitNoteEntity> result = new ArrayList<VisitNoteEntity>();
        while (startCustDate.getTime() <= end.getTime()) {
            String week;
            Calendar c = Calendar.getInstance();
            c.setTime(startCustDate);
            int w = c.get(7) - 1;
            if (w < 0) {
                w = 0;
            }
            if (notWeekSet.contains(week = weekDays[w])) {
                c.add(5, 1);
                startCustDate = c.getTime();
                continue;
            }
            visitNote.setVisitDate(DateUtils.date_sdf.format(startCustDate));
            List<VisitNoteEntity> visitNotes = this.addLIneAllList(visitNote, clienIdArray, custTypeArray, lvPosId, auditStatus);
            if (CollectionUtil.listNotEmptyNotSizeZero(visitNotes)) {
                result.addAll(visitNotes);
            }
            c.add(5, frquency);
            startCustDate = c.getTime();
        }
        return result;
    }

    private Set<String> getNotWeek(String notWeeks) {
        HashSet<String> notWeekSet = new HashSet<String>();
        if (StringUtil.isNotEmpty((CharSequence)notWeeks)) {
            for (String notWeek : notWeeks.split(",")) {
                notWeekSet.add(notWeek);
            }
        }
        return notWeekSet;
    }
}

