/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.worktrack.core;

import com.biz.eisp.worktrack.util.CommonUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    public static boolean isEnableHttps = false;

    public static String sendRequest(String action, String parameters, String method) {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = isEnableHttps ? HttpClient.initHttps(action, parameters, method) : HttpClient.initHttp(action, parameters, method);
        }
        catch (IOException e) {
            StringBuilder result = new StringBuilder();
            result.append("{\"status\":").append(-1).append(",").append("\"message\":").append("\"").append(CommonUtils.transExceptionToString(e)).append("\"}");
            return result.toString();
        }
        String result = null;
        switch (method) {
            case "POST": {
                result = HttpClient.sendPostRequest(urlConnection, parameters);
                break;
            }
            case "GET": {
                result = HttpClient.sendGetRequest(urlConnection);
                break;
            }
        }
        return result;
    }

    private static HttpsURLConnection initHttps(String action, String parameters, String method) throws IOException {
        StringBuilder path = new StringBuilder("https://yingyan.baidu.com/api/v3/");
        path.append(action);
        URL url = HttpClient.initURL(path.toString(), parameters, method);
        HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
        HttpClient.initConnection(urlConnection, method);
        urlConnection.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                HostnameVerifier hVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                return hVerifier.verify(hostname, session);
            }
        });
        return urlConnection;
    }

    private static HttpURLConnection initHttp(String action, String parameters, String method) throws IOException {
        StringBuilder path = new StringBuilder("http://yingyan.baidu.com/api/v3/");
        path.append(action);
        URL url = HttpClient.initURL(path.toString(), parameters, method);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        HttpClient.initConnection(urlConnection, method);
        return urlConnection;
    }

    private static URL initURL(String path, String parameters, String method) throws MalformedURLException {
        URL url = null;
        url = METHOD_GET.equalsIgnoreCase(method) ? new URL(path + "?" + parameters) : new URL(path);
        return url;
    }

    private static void initConnection(HttpURLConnection urlConnection, String method) throws ProtocolException {
        urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        urlConnection.setRequestMethod(method);
        urlConnection.setConnectTimeout(5000);
        urlConnection.setReadTimeout(5000);
        urlConnection.setUseCaches(false);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendGetRequest(HttpURLConnection urlConnection) {
        InputStream inStream = null;
        try {
            int responseCode = urlConnection.getResponseCode();
            if (200 == responseCode) {
                inStream = urlConnection.getInputStream();
                String string = HttpClient.handleInputStream(inStream);
                return string;
            }
            String string = HttpClient.handleHttpResponseCode(responseCode, urlConnection.getResponseMessage());
            return string;
        }
        catch (IOException ex) {
            String string = HttpClient.handleIOException(ex);
            return string;
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendPostRequest(HttpURLConnection urlConnection, String parameters) {
        OutputStream outStream = null;
        InputStream inStream = null;
        try {
            outStream = urlConnection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outStream, "UTF-8"));
            writer.write(parameters);
            writer.flush();
            writer.close();
            urlConnection.connect();
            int responseCode = urlConnection.getResponseCode();
            if (200 == responseCode) {
                inStream = urlConnection.getInputStream();
                String string = HttpClient.handleInputStream(inStream);
                return string;
            }
            String string = HttpClient.handleHttpResponseCode(responseCode, urlConnection.getResponseMessage());
            return string;
        }
        catch (IOException ex) {
            String string = HttpClient.handleIOException(ex);
            return string;
        }
        finally {
            try {
                if (null != outStream) {
                    outStream.close();
                }
                if (null != inStream) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String handleInputStream(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer result = new StringBuffer("");
        try {
            String line;
            while (null != (line = bufferedReader.readLine())) {
                result.append(line);
            }
            return result.toString();
        }
        catch (IOException ex) {
            String string = HttpClient.handleIOException(ex);
            return string;
        }
        finally {
            if (null != bufferedReader) {
                try {
                    try {
                        bufferedReader.close();
                        bufferedReader = null;
                    }
                    catch (IOException e) {
                        log.error("", (Throwable)e);
                        bufferedReader = null;
                    }
                }
                catch (Throwable throwable) {
                    bufferedReader = null;
                    throw throwable;
                }
            }
        }
    }

    private static String handleIOException(IOException ex) {
        StringBuilder result = new StringBuilder();
        result.append("{\"status\":").append(-1).append(",").append("\"message\":").append("\"").append(CommonUtils.transExceptionToString(ex)).append("\"}");
        return result.toString();
    }

    private static String handleHttpResponseCode(int responseCode, String responseString) {
        StringBuilder result = new StringBuilder();
        result.append("{\"status\":").append(String.valueOf(responseCode)).append(",").append("\"message\":").append("\"").append(responseString).append("\"}");
        return result.toString();
    }
}

