/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.collection.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.attendance.picture.dao.TsPictureDao;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.collection.dao.TsDirectoryConfigDao;
import com.biz.eisp.collection.dao.TsDirectoryInputDao;
import com.biz.eisp.collection.dao.TsInputConfigDao;
import com.biz.eisp.collection.dao.TsRDirectoryInputDao;
import com.biz.eisp.collection.entity.TsDirectoryConfigEntity;
import com.biz.eisp.collection.entity.TsDirectoryInputEntity;
import com.biz.eisp.collection.entity.TsInputConfigEntity;
import com.biz.eisp.collection.entity.TsRDirectoryInputEntity;
import com.biz.eisp.collection.service.TsDirectoryConfigService;
import com.biz.eisp.collection.service.TsInputConfigService;
import com.biz.eisp.collection.transformer.TsDirectoryConfigVoToTsDirectoryConfigEntity;
import com.biz.eisp.collection.vo.TsDirectoryApiVo;
import com.biz.eisp.collection.vo.TsDirectoryConfigVo;
import com.biz.eisp.collection.vo.TsDirectoryInputVo;
import com.biz.eisp.collection.vo.TsInputConfigVo;
import com.biz.eisp.common.FilePathUtil;
import com.biz.eisp.common.SfaConstantEnum;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.params.Constant;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.visitnote.vo.TsDictApiResultVo;
import com.biz.eisp.visitnote.vo.TsDirectoryApiQueryVo;
import com.biz.eisp.visitnote.vo.TsDirectoryApiResultVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="tsDirectoryConfigService")
@Transactional
public class TsDirectoryConfigServiceImpl
extends BaseServiceImpl<TsDirectoryConfigEntity>
implements TsDirectoryConfigService {
    @Autowired
    private TsDirectoryConfigDao tsDirectoryConfigDao;
    @Autowired
    private TsInputConfigDao tsInputConfigDao;
    @Autowired
    private TsRDirectoryInputDao tsRDirectoryInputDao;
    @Autowired
    private TsDirectoryInputDao tsDirectoryInputDao;
    @Autowired
    private TsPictureDao tsPictureDao;
    @Autowired
    private TsInputConfigService tsInputConfigService;
    @Autowired
    FilePathUtil filePathUtil;

    @Override
    public PageInfo<TsDirectoryConfigVo> findTsDirectoryConfigVoList(TsDirectoryConfigVo tsDirectoryConfigVo, Page page) {
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tsDirectoryConfigDao.findTsDirectoryConfigVoList(tsDirectoryConfigVo), (Page)page);
        if (pageInfo != null && CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            pageInfo.getList().forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getSfacusType()) && StringUtils.isNotBlank((CharSequence)item.getClassification())) {
                    if (item.getSfacusType().equals(SfaConstantEnum.CusType.channel.getVal())) {
                        item.setClassification(DictUtil.getDictDataVal((String)SfaConstantEnum.CusType.channel.name(), (String)item.getClassification()));
                    } else {
                        item.setClassification(DictUtil.getDictDataVal((String)SfaConstantEnum.CusType.terminal_type.name(), (String)item.getClassification()));
                    }
                }
            });
        }
        return pageInfo;
    }

    @Override
    public void saveTsDirectoryConfig(TsDirectoryConfigVo tsDirectoryConfigVo) {
        TsDirectoryConfigEntity entity = new TsDirectoryConfigVoToTsDirectoryConfigEntity(this).apply(tsDirectoryConfigVo);
        if (StringUtil.isEmpty((Object)entity.getId())) {
            entity.setDirectoryCode(CodeRuleUtil.getKnlCodingRulesString((String)"directory_code"));
            this.save(entity);
        } else {
            this.updateByPrimaryKeySelective(entity);
        }
        if (tsDirectoryConfigVo.getInputConfigInfo() != null && tsDirectoryConfigVo.getInputConfigInfo().length() > 0) {
            List newEntities = JSONArray.parseArray((String)tsDirectoryConfigVo.getInputConfigInfo(), TsInputConfigVo.class);
            Example example = new Example(TsRDirectoryInputEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("directoryId", (Object)entity.getId());
            this.tsRDirectoryInputDao.deleteByExample(example);
            for (TsInputConfigVo ne : newEntities) {
                TsRDirectoryInputEntity di = new TsRDirectoryInputEntity();
                di.setDirectoryCode(entity.getDirectoryCode());
                di.setDirectoryId(entity.getId());
                di.setDirectoryName(entity.getDirectoryName());
                di.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                di.setSort(ne.getSort());
                di.setLableId(ne.getId());
                di.setLableCode(ne.getLableCode());
                di.setLableName(ne.getLableName());
                di.setIsNeed(ne.getIsNeed());
                this.tsRDirectoryInputDao.insert(di);
            }
        }
    }

    @Override
    public List<TsInputConfigEntity> getConfigList(Integer id) {
        return this.tsInputConfigDao.getConfigList(id);
    }

    @Override
    public void doBatchDel(String ids) {
        if (StringUtil.isNotEmpty((CharSequence)ids)) {
            String[] idsList;
            String[] arr$ = idsList = ids.split(",");
            int len$ = idsList.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String id = arr$[i$];
                TsDirectoryConfigEntity entity = (TsDirectoryConfigEntity)this.selectByPrimaryKey(id);
                if (entity != null && StringUtil.isNotEmpty((Object)entity.getId())) {
                    this.delete(entity);
                }
                Example example = new Example(TsRDirectoryInputEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("directoryId", (Object)id);
                this.tsRDirectoryInputDao.deleteByExample(example);
            }
        }
    }

    @Override
    public List<TsDirectoryConfigEntity> getListByPrimaryDirectoryCodeAndBusinessUnitCode(String primaryDirectoryCode, String businessUnitCode, String visitObjectCode, String type) {
        return this.tsDirectoryConfigDao.getListByPrimaryDirectoryCodeAndBusinessUnitCode(primaryDirectoryCode, businessUnitCode, visitObjectCode, type);
    }

    @Override
    public List<TsDirectoryConfigEntity> getListByVisitObject(String visitObjectCode) {
        return this.tsDirectoryConfigDao.getListByVisitObject(visitObjectCode);
    }

    @Override
    public List<TsInputConfigEntity> getListByDirectoryCode(String directoryCode) {
        return this.tsInputConfigDao.getListByDirectoryCode(directoryCode);
    }

    @Override
    public List<TsDirectoryInputVo> findTsDirectoryInputVoList(TsDirectoryInputVo tsDirectoryInputVo, Page page) {
        return null;
    }

    @Override
    public List<TsDirectoryInputVo> findTsDirectoryInputVoLastList(TsDirectoryInputVo tsDirectoryInputVo, Page page) {
        return null;
    }

    @Override
    public List<TsDirectoryInputVo> getInputList(String infoUuid) {
        return this.tsInputConfigDao.getInputList(infoUuid);
    }

    @Override
    public List<TsInputConfigVo> findTsInputConfigListByDirectId(TsInputConfigVo tsInputConfigVo, Page page, String directId) {
        return this.tsInputConfigDao.findTsInputConfigListByDirectId(directId);
    }

    @Override
    public void updateStatus(String id, String enableStatus2) {
        TsDirectoryConfigEntity entity = (TsDirectoryConfigEntity)this.selectByPrimaryKey(id);
        entity.setEnableStatus(enableStatus2);
        this.updateByPrimaryKeySelective(entity);
    }

    @Override
    public void saveTsDirectoryInput(TsDirectoryApiVo vo) {
        List vos = vo.getVos();
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)vos)) {
            throw new BusinessException("\u6570\u636e\u4e3a\u7a7a!");
        }
        vos.stream().forEach(item -> {
            String pics;
            TsDirectoryInputEntity entity = this.switchEntity((TsDirectoryInputVo)item, vo);
            if (entity.getId() != null) {
                this.tsDirectoryInputDao.updateByPrimaryKeySelective(entity);
            } else {
                this.tsDirectoryInputDao.insert(entity);
            }
            if ("T11".equals(this.tsInputConfigService.getInputType(entity.getLableId())) && StringUtils.isNotBlank((CharSequence)(pics = item.getLableValue()))) {
                String[] arrpic = pics.split(",");
                ArrayList<TsPictureEntity> list = new ArrayList<TsPictureEntity>();
                for (int i = 0; i < arrpic.length; ++i) {
                    TsPictureEntity pictureEntity = new TsPictureEntity();
                    pictureEntity.setImgType(Constant.imgType.exec.getValue() + entity.getLableCode());
                    pictureEntity.setImgPath(arrpic[i]);
                    pictureEntity.setBusinessId(entity.getId());
                    this.filePathUtil.getChangePicturePath(pictureEntity);
                    list.add(pictureEntity);
                }
                this.tsPictureDao.insertList(list);
            }
        });
    }

    private TsDirectoryInputEntity switchEntity(TsDirectoryInputVo vo, TsDirectoryApiVo vo_) {
        TsDirectoryInputEntity entity = new TsDirectoryInputEntity();
        MyBeanUtils.apply((Object)vo, (Object)entity);
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo_, (Object)entity);
            entity.setCollectionDate(DateUtils.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        entity.setId(null);
        return entity;
    }

    @Override
    public List<TsDirectoryApiResultVo> findTsDirectoryByCon(TsDirectoryApiQueryVo vo) {
        List<TsDirectoryApiResultVo> result = this.tsDirectoryConfigDao.findTsDirectoryByCon(vo);
        if (CollectionUtil.listNotEmptyNotSizeZero(result)) {
            result.forEach(item_ -> {
                List apiResultVos = item_.getInputResults();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)apiResultVos)) {
                    apiResultVos.forEach(item -> {
                        List list;
                        if (StringUtils.isNotBlank((CharSequence)item.getDictionaryCode()) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = DictUtil.getDictList((String)item.getDictionaryCode())))) {
                            ArrayList dicts = new ArrayList();
                            list.forEach(rt -> {
                                TsDictApiResultVo rvo = new TsDictApiResultVo();
                                try {
                                    MyBeanUtils.copyBeanNotNull2Bean((Object)rt, (Object)rvo);
                                    dicts.add(rvo);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            });
                            item.setDicts(dicts);
                        }
                    });
                }
            });
        }
        return result;
    }
}

