/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.advance.controller;

import com.biz.eisp.act.advance.entity.TtActAdvanceDetailEntity;
import com.biz.eisp.act.advance.entity.TtActAdvanceEntity;
import com.biz.eisp.act.advance.service.TtActAdvanceDetailService;
import com.biz.eisp.act.advance.service.TtActAdvanceService;
import com.biz.eisp.act.advance.vo.TtActAdvanceVo;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import tk.mybatis.mapper.entity.Example;

@RequestMapping(value={"ttActAdvanceController"})
@Controller
public class TtActAdvanceController {
    @Autowired
    private TtActAdvanceService ttActAdvanceService;
    @Autowired
    private TtActAdvanceDetailService ttActAdvanceDetailService;
    @Autowired
    private TtActService ttActService;

    @RequestMapping(value={"goTtActAdvanceMain"})
    public ModelAndView goTtSalesPlansMain(HttpServletRequest request, String id) {
        return new ModelAndView("com/biz/eisp/act/advance/TtActAdvanceMain");
    }

    @RequestMapping(value={"findTtActAdvancePage"})
    @ResponseBody
    public DataGrid findTtActAdvancePage(HttpServletRequest request, TtActAdvanceVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActAdvanceVo> ttActAdvanceVoPageInfo = this.ttActAdvanceService.findTtActAdvancePage(vo, (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ttActAdvanceVoPageInfo.getList())) {
            ttActAdvanceVoPageInfo.getList().forEach(ttActAdvanceVo -> {
                BigDecimal applyPrice = new BigDecimal(0);
                BigDecimal advancePrice = new BigDecimal(0);
                Example example = new Example(TtActAdvanceDetailEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("advanceCode", (Object)ttActAdvanceVo.getAdvanceCode());
                criteria.andEqualTo("tempUuid", (Object)ttActAdvanceVo.getTempUuid());
                List ttActAdvanceDetailEntities = this.ttActAdvanceDetailService.selectExample(example);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)ttActAdvanceDetailEntities)) {
                    for (TtActAdvanceDetailEntity entity : ttActAdvanceDetailEntities) {
                        applyPrice = applyPrice.add(entity.getApplyPrice() == null ? BigDecimal.ZERO : entity.getApplyPrice());
                        advancePrice = advancePrice.add(entity.getAdvancePrice() == null ? BigDecimal.ZERO : entity.getAdvancePrice());
                    }
                }
                ttActAdvanceVo.setAdvancePrice(advancePrice);
                ttActAdvanceVo.setApplyPrice(applyPrice);
            });
        }
        if (ttActAdvanceVoPageInfo != null) {
            return new DataGrid(ttActAdvanceVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"goSaveOrUpdateTtActAdvance"})
    public ModelAndView goSaveOrUpdateTtActAdvance(HttpServletRequest request, TtActAdvanceVo vo, String clickFunctionId) {
        request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        TtActAdvanceEntity entity = new TtActAdvanceEntity();
        String tempUuid = "";
        if (vo != null && StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.ttActAdvanceService.getTtActAdvanceEntity(vo.getId());
            tempUuid = entity.getTempUuid();
            String actCode = entity.getActCode();
            TtActEntity ttActEntity = this.ttActService.getTtActVoByActCode(actCode);
            request.setAttribute("ttActVo", (Object)ttActEntity);
        } else {
            tempUuid = "tempuuid" + UUIDGenerator.generate();
        }
        request.setAttribute("vo", (Object)entity);
        request.setAttribute("tempUuid", (Object)tempUuid);
        return new ModelAndView("com/biz/eisp/act/advance/TtActAdvanceForm");
    }

    @ResponseBody
    @RequestMapping(value={"saveTtActAdvance"})
    public AjaxJson saveTtActAdvance(HttpServletRequest request, TtActAdvanceVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                j.setSuccess(this.ttActAdvanceService.updateTtActAdvance(vo));
            } else {
                j.setSuccess(this.ttActAdvanceService.saveTtActAdvance(vo));
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtActAdvance"})
    public AjaxJson deleteTtActAdvance(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                this.ttActAdvanceService.delByIds(ids);
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }
}

