/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.act.dao.TtActDao;
import com.biz.eisp.act.dao.TtActDetailDao;
import com.biz.eisp.act.dao.TtActProductDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActProductEntity;
import com.biz.eisp.act.service.ActEndService;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActProductVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.activiti.vo.ActivitiCallBackVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.vo.FeeUseBudgutParam;
import com.biz.eisp.budget.used.service.TtBudgutDetailService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class TtActServiceImplImpl
extends BaseServiceImpl<TtActEntity>
implements TtActService {
    @Autowired
    private TtActDao ttActQuotaDao;
    @Autowired
    private TtActDetailDao ttActQuotaDetailDao;
    @Autowired
    private TtActProductDao ttActQuotaProductDao;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private ActEndService actEndService;
    @Autowired
    private TtBudgutDetailService ttBudgutDetailService;

    @Override
    public PageInfo<TtActVo> findTtActPage(TtActVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttActQuotaDao.findTtActList(vo), (Page)page);
    }

    @Override
    public PageInfo<TtActDetailVo> findTtActDetailPage(TtActDetailVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttActQuotaDetailDao.findTtActDetailList(vo), (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtActServiceImplImpl.class)
    public boolean save(TtActVo vo) throws Exception {
        if (StringUtils.isBlank((CharSequence)vo.getTempUuid())) {
            return false;
        }
        TtActEntity entity = new TtActEntity();
        MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
        entity.setBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue());
        entity.setActCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_quota.name()));
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.insertSelective(entity);
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)vo.getTempUuid());
        List details = this.ttActQuotaDetailDao.selectByExample(example);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)details)) {
            throw new RuntimeException("\u672a\u6dfb\u52a0\u6d3b\u52a8\u660e\u7ec6,\u4e0d\u80fd\u4fdd\u5b58");
        }
        details.stream().filter(dl -> StringUtils.isBlank((CharSequence)dl.getActDetailCode())).forEach(item -> {
            item.setActCode(entity.getActCode());
            item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            item.setActDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_quota_detail.name()).toString());
        });
        this.ttActQuotaDetailDao.updateBatchByPrimaryKeySelective(details);
        int need = this.ttActDetailService.checkShareProduct(vo.getTempUuid());
        if (need == 1) {
            String productId = vo.getProductJson();
            List productVos = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)productId)) {
                productVos = JSONArray.parseArray((String)productId, TtActProductVo.class);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(productVos)) {
                ArrayList products = new ArrayList();
                productVos.stream().forEach(item -> {
                    TtActProductEntity productEntity = new TtActProductEntity();
                    try {
                        MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)productEntity);
                        productEntity.setActCode(entity.getActCode());
                        productEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                        products.add(productEntity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                this.ttActQuotaProductDao.insertList(products);
                return true;
            }
            throw new BusinessException("\u5206\u644a\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return true;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtActServiceImplImpl.class)
    public boolean update(TtActVo vo) throws Exception {
        TtActEntity entity = (TtActEntity)this.selectByPrimaryKey(vo.getId());
        if (StringUtils.isBlank((CharSequence)entity.getTempUuid())) {
            return false;
        }
        if (!(entity.getBpmStatus().equals(ConstantEnum.bpmStatus.COMMIT.getValue()) || entity.getBpmStatus().equals(ConstantEnum.bpmStatus.REJECT.getValue()) || entity.getBpmStatus().equals(ConstantEnum.bpmStatus.BACK.getValue()))) {
            throw new RuntimeException("\u6570\u636e\u6d41\u7a0b\u4e2d\u4e0d\u80fd\u4fee\u6539\uff01");
        }
        MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.updateByPrimaryKeySelective(entity);
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)vo.getTempUuid());
        criteria.andIsNull("actDetailCode");
        List details = this.ttActQuotaDetailDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)details)) {
            details.forEach(item -> {
                item.setActCode(entity.getActCode());
                item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                item.setActDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_quota_detail.name()).toString());
            });
            this.ttActQuotaDetailDao.updateBatchByPrimaryKeySelective(details);
        }
        Example example_ = new Example(TtActProductEntity.class);
        Example.Criteria criteria_ = example.createCriteria();
        criteria_.andEqualTo("actCode", (Object)entity.getActCode());
        this.ttActQuotaProductDao.deleteByExample(example_);
        int need = this.ttActDetailService.checkShareProduct(vo.getTempUuid());
        if (need == 1) {
            List<TtActProductVo> productVos = vo.getProductVoList();
            if (CollectionUtil.listNotEmptyNotSizeZero(productVos)) {
                ArrayList products = new ArrayList();
                productVos.stream().forEach(item -> {
                    TtActProductEntity productEntity = new TtActProductEntity();
                    try {
                        MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)productEntity);
                        productEntity.setActCode(entity.getActCode());
                        productEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                        products.add(productEntity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                this.ttActQuotaProductDao.insertList(products);
                return true;
            }
            throw new BusinessException("\u5206\u644a\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return true;
    }

    @Override
    public TtActEntity getTtActVoByActCode(String actCode) {
        TtActEntity ttActEntity = null;
        Example example = new Example(TtActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)actCode);
        List entities = this.ttActQuotaDao.selectByExample(example);
        if (entities != null && entities.size() > 0) {
            ttActEntity = (TtActEntity)entities.get(0);
        }
        return ttActEntity;
    }

    @Override
    public List<TtActVo> findTtActList(TtActVo vo) {
        return this.ttActQuotaDao.findTtActList(vo);
    }

    @Override
    public void doQuotaBpmStatus(ActivitiCallBackVo activitiCallBackVo) {
        if (StringUtils.isEmpty((CharSequence)activitiCallBackVo.getBusinessObjId())) {
            return;
        }
        this.actEndService.actEnd(ConstantEnum.ACTTYPE.quota.getVal(), activitiCallBackVo.getBusinessObjId());
        this.updateTtActBpmStatus(activitiCallBackVo.getBpmStatus(), activitiCallBackVo.getBusinessObjId());
    }

    @Override
    public void doDepartCostCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        if (StringUtils.isEmpty((CharSequence)activitiCallBackVo.getBusinessObjId())) {
            return;
        }
        this.updateTtActBpmStatus(activitiCallBackVo.getBpmStatus(), activitiCallBackVo.getBusinessObjId());
    }

    @Override
    public void doActPriceCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        if (StringUtils.isEmpty((CharSequence)activitiCallBackVo.getBusinessObjId())) {
            return;
        }
        this.updateTtActBpmStatus(activitiCallBackVo.getBpmStatus(), activitiCallBackVo.getBusinessObjId());
    }

    @Override
    public void doPhysicalCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        if (StringUtils.isEmpty((CharSequence)activitiCallBackVo.getBusinessObjId())) {
            return;
        }
        this.updateTtActBpmStatus(activitiCallBackVo.getBpmStatus(), activitiCallBackVo.getBusinessObjId());
    }

    @Override
    public AjaxJson updateTtActBpmStatus(String status, String id) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)status)) {
            return ajaxJson;
        }
        ajaxJson = this.doUseBuget(status, id);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        TtActEntity ttActEntity = new TtActEntity();
        ttActEntity.setBpmStatus(status);
        ttActEntity.setId(id);
        if (StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.APPROVAL.getValue(), (CharSequence)status)) {
            ttActEntity.setApplyTime(DateUtils.dateNow2Str());
        }
        this.ttActQuotaDao.updateByPrimaryKeySelective(ttActEntity);
        return ajaxJson;
    }

    private AjaxJson doUseBuget(String bpmStatus2, String id) {
        AjaxJson ajaxJson = new AjaxJson();
        if (!(StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.APPROVAL.getValue(), (CharSequence)bpmStatus2) || StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.REJECT.getValue(), (CharSequence)bpmStatus2) || StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.BACK.getValue(), (CharSequence)bpmStatus2))) {
            return ajaxJson;
        }
        TtActEntity ttActEntity = (TtActEntity)this.ttActQuotaDao.selectByPrimaryKey(id);
        if ("2".equals(ttActEntity.getActType())) {
            Example example = new Example(TtActDetailEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("actCode", (Object)ttActEntity.getActCode());
            List detailEntities = this.ttActQuotaDetailDao.selectByExample(example);
            BigDecimal sumAmount = BigDecimal.ZERO;
            for (TtActDetailEntity item : detailEntities) {
                sumAmount = sumAmount.add(item.getAmount());
            }
            FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
            feeUseBudgutParam.setBugetCode(ttActEntity.getBudgetCode());
            feeUseBudgutParam.setAmount(sumAmount);
            feeUseBudgutParam.setFromAddress("tt_act");
            feeUseBudgutParam.setBusinessCode(ttActEntity.getActCode());
            feeUseBudgutParam.setBusinessName(ttActEntity.getActName());
            if (StringUtils.equals((CharSequence)ConstantEnum.bpmStatus.APPROVAL.getValue(), (CharSequence)bpmStatus2)) {
                feeUseBudgutParam.setNote("\u5b9a\u989d\u6d3b\u52a8\u5360\u7528");
                feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
                ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
                return ajaxJson;
            }
            feeUseBudgutParam.setNote("\u5b9a\u989d\u6d3b\u52a8\u9000\u56de");
            feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.BACK.getValue());
            ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
            return ajaxJson;
        }
        return ajaxJson;
    }

    @Override
    public void updateAuditStatus(List<String> detailCode) {
        List<TtActDetailEntity> actDetailEntities = this.ttActDetailService.findDetailByCodes(detailCode);
        List<String> actCode = actDetailEntities.stream().map(TtActDetailEntity::getActCode).distinct().collect(Collectors.toList());
        List<TtActDetailEntity> actDetailAll = this.ttActDetailService.findDetailByActCodes(actCode);
        HashMap<String, List> detailMap = new HashMap<String, List>();
        actDetailAll.stream().collect(Collectors.groupingBy(TtActDetailEntity::getActCode, Collectors.toList())).forEach((actCodeTemp, list) -> detailMap.put((String)actCodeTemp, (List)list));
        detailMap.forEach((k, v) -> {
            boolean flag = true;
            Example example = new Example(TtActEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("actCode", k);
            TtActEntity entity = new TtActEntity();
            for (TtActDetailEntity item : v) {
                if (!ConstantEnum.YesNoEnum.ZERO.getValue().equals(item.getAuditStatus())) continue;
                flag = false;
            }
            if (flag) {
                entity.setAuditStatus(ConstantEnum.YesNoEnum.ONE.getValue());
            } else {
                entity.setAuditStatus(ConstantEnum.YesNoEnum.ZERO.getValue());
            }
            this.ttActQuotaDao.updateByExampleSelective(entity, example);
        });
    }
}

