/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.audit.controller;

import com.biz.eisp.audit.service.TtAuditActService;
import com.biz.eisp.audit.vo.TtAuditActVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ttAuditActController"})
public class TtAuditActController {
    @Autowired
    private TtAuditActService ttAuditActService;

    @RequestMapping(value={"goTtAuditActMain"})
    public ModelAndView goTtAuditActMain(HttpServletRequest request, TtAuditActVo vo) {
        request.setAttribute("tempUuid", (Object)vo.getTempUuid());
        return new ModelAndView("com/biz/eisp/audit/TtActSelectMain");
    }

    @ResponseBody
    @RequestMapping(value={"findTtAuditActPage"})
    public DataGrid findTtAuditActPage(HttpServletRequest request, TtAuditActVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtAuditActVo> info = this.ttAuditActService.findTtAuditActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ResponseBody
    @RequestMapping(value={"saveAuditAct"})
    public AjaxJson saveAuditAct(HttpServletRequest request, String tempUuid, String acts) {
        AjaxJson j = new AjaxJson();
        try {
            this.ttAuditActService.saveAuditAct(tempUuid, acts);
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"delAuditAct"})
    public AjaxJson delAuditAct(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                this.ttAuditActService.delByIds(ids);
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }
}

