/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.audit.controller;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.api.common.ActivitiFeign;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.audit.service.TtAuditActService;
import com.biz.eisp.audit.service.TtAuditService;
import com.biz.eisp.audit.vo.TtAuditVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.BaseController;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ttAuditController"})
public class TtAuditController
extends BaseController {
    @Autowired
    private TtAuditService ttAuditService;
    @Autowired
    private TtAuditActService ttAuditActService;
    @Autowired
    private ActivitiFeign activitiFeign;

    @RequestMapping(value={"goTtAuditMain"})
    public ModelAndView goTtAuditMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/audit/TtAuditMain");
    }

    @RequestMapping(value={"findTtAuditPage"})
    @ResponseBody
    public DataGrid findTtAuditPage(HttpServletRequest request, TtAuditVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtAuditVo> info = this.ttAuditService.findTtAuditPage(vo, (Page)page);
        return new DataGrid(info);
    }

    @RequestMapping(value={"goUpdateOrAdd"})
    public ModelAndView goUpdateOrAdd(HttpServletRequest request, TtAuditVo vo) {
        TtAuditEntity entity = new TtAuditEntity();
        String tempUuid = "";
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtAuditEntity)this.ttAuditService.selectByPrimaryKey(vo.getId());
            tempUuid = entity.getTempUuid();
        } else {
            tempUuid = "tempuuid" + UUIDGenerator.generate();
        }
        request.setAttribute("vo", (Object)entity);
        request.setAttribute("tempUuid", (Object)tempUuid);
        return new ModelAndView("com/biz/eisp/audit/TtAuditForm");
    }

    @RequestMapping(value={"delSelectAct"})
    @ResponseBody
    public AjaxJson delSelectAct(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttAuditActService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"saveAudit"})
    public AjaxJson saveAudit(HttpServletRequest request, TtAuditVo vo) {
        AjaxJson j = new AjaxJson();
        this.ttAuditService.saveAudit(vo);
        return j;
    }

    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("callback_service", "tpmAuditActivitiFeign");
        activitiBusinessVo.setVariables(variables);
        TtAuditEntity entity = (TtAuditEntity)this.ttAuditService.selectByPrimaryKey(vo.getBusinessObjId());
        ajaxJson = this.ttAuditService.checkSubAuditAndUpdateAct(entity.getId());
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        ArrayList<TtAuditEntity> list = new ArrayList<TtAuditEntity>();
        list.add(entity);
        String json = JSONArray.toJSONString(list);
        activitiBusinessVo.setTargetText(json);
        ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        if (!ajaxJson.isSuccess()) {
            this.ttAuditService.backSubAuditAndUpdateAct(entity.getId());
            return ajaxJson;
        }
        ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + ajaxJson.getObj().toString());
        this.ttAuditService.updateAuditBpmStatus(ConstantEnum.bpmStatus.APPROVAL.getValue(), activitiBusinessVo.getBusinessObjId());
        return ajaxJson;
    }
}

