/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.fee.service.impl;

import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.fee.dao.TtFeePoolDetailDao;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.fee.service.TtFeeDetailPoolService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TtFeeDetailPoolServiceImpl
extends BaseServiceImpl<TtFeePoolDetailEntity>
implements TtFeeDetailPoolService {
    @Autowired
    private TtFeePoolDetailDao ttFeePoolDetailDao;

    @Override
    public PageInfo<TtFeePoolDetailEntity> getMainListPage(TtFeePoolDetailEntity entity, Page page) {
        Example example = new Example(TtFeePoolDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("poolCode", (Object)entity.getPoolCode());
        ArrayList<String> list = new ArrayList<String>();
        list.add(ConstantEnum.FeePoolTypeEnum.INCOME_FEE.getValue());
        list.add(ConstantEnum.FeePoolTypeEnum.INIT_FEE.getValue());
        criteria.andIn("feePoolType", list);
        return PageAutoHelperUtil.generatePage(() -> this.ttFeePoolDetailDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<TtFeePoolDetailEntity> getUsedMainListPage(TtFeePoolDetailEntity entity, Page page) {
        Example example = new Example(TtFeePoolDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("poolCode", (Object)entity.getPoolCode());
        ArrayList<String> list = new ArrayList<String>();
        list.add(ConstantEnum.FeePoolTypeEnum.INCOME_FEE.getValue());
        list.add(ConstantEnum.FeePoolTypeEnum.INIT_FEE.getValue());
        criteria.andNotIn("feePoolType", list);
        return PageAutoHelperUtil.generatePage(() -> this.ttFeePoolDetailDao.selectByExample(example), (Page)page);
    }
}

