<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>添加活动</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        .layout-split-north {
            border-bottom: 1px solid #0072ae00;
        }
    </style>
</head>
<body class="easyui-layout" fit="true">
<div data-options="region:'north',split:true" style="height:160px;">
    <t:formvalid action="/tpm/ttActDepartUseController/saveOrUpdate" beforeSubmit="checkproductSubmit" layout="div"
                 dialog="true" formid="detailId">
        <t:dgFormList layoutStyle="horizontal" expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
            <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                            defaultVal="${vo.id }"/>
            <t:dgFormColumn field="tempUuid" hidden="true" formClass="form" labelName="tempUuid" optionType="input" required="false"
                            defaultVal="${tempUuid }"/>
            <t:dgFormColumn field="productJson" hidden="true" formClass="form" labelName="productJson" optionType="input" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="actName" hidden="false" formClass="biz-col-50 mb5 form" labelName="活动名称" optionType="input"  required="true"
                            defaultVal="${vo.actName}"/>
            <t:dgFormColumn field="beginDate" extendField="endDate" extendFieldVal="${vo.endDate}" hidden="false" formClass="biz-col-50 mb5 form" labelName="起止时间" optionType="date_begin_end"  required="true"
                            defaultVal="${vo.beginDate}"/>
            <t:dgFormColumn field="budgetCode" hidden="false" formClass="biz-col-50 mb5 form" labelName="预算选择" optionType="choseDialog" required="true"
                            onclick="selectbudget()" defaultVal="${vo.budgetCode}" />
            <t:dgFormColumn field="budgetName" hidden="true" formClass="biz-col-50 mb5 form" labelName="budgetName" optionType="input" required="false"
                            defaultVal="${vo.budgetName}"/>
            <t:dgFormColumn field="receiptor" hidden="false" formClass="biz-col-50 mb5 form" labelName="领用人" optionType="input"  required="true"
                            defaultVal="${vo.receiptor}"/>

            <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 mb5 form" labelName="备注" optionType="textarea"  required="false"
                            rows="3" cols="5"    defaultVal="${vo.remarks}" style="width: 94%"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid name="departUseDetailList" checkbox="true" fitColumns="false" idField="id" fit="true"
                queryMode="group"
                actionUrl="/tpm/ttActDepartUseController/findTtActDepartUseDetailPage?tempUuid=${tempUuid}&id=${vo.id}"
                pagination="true"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="活动细类" field="actSubclassName" sortable="false"/>
        <t:dgCol title="客户名称" field="customerName" sortable="false"/>
        <t:dgCol title="物料编码" field="matnr" sortable="false"/>
        <t:dgCol title="物料名称" field="maktx" sortable="false"/>
        <t:dgCol title="单价" field="price" sortable="false"/>
        <t:dgCol title="数量" field="productNum" sortable="false"/>
        <t:dgCol title="单位" field="unit"  sortable="false" dictionary="unit"/>
        <t:dgCol title="最小包装量" field="miniPack" sortable="false"/>
        <t:dgCol title="申请金额" field="amount" sortable="false"/>
        <t:dgCol title="备注" field="remarks" sortable="false"/>
        <t:dgToolBar title="新增" funname="addDetail" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="编辑" funname="updateDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="导入" funname="add" icon="icon-dataIn"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="删除" funname="deleteALLSelect" icon="icon-remove"
                     url="/tpm/ttActDepartUseController/delDetail"></t:dgToolBar>
        <t:dgToolBar title="附件" funname="add" icon="icon-attach"
                     url=""></t:dgToolBar>
    </t:datagrid>
</div>

<script type="text/javascript">
    function addDetail(){
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算编码");
            return false;
        }else{
            id = "departUseDetailList";
            gridname = id;
            var addurl = "/tpm/ttActDepartUseController/goUpdateOrAddDetail?1=1&tempUuid=${tempUuid}&budgetCode="+budgetCode;
            createwindow("新增", addurl,  400, 400, {});
        }
    }
    function updateDetail() {
        var rowsData = $('#departUseDetailList').datagrid('getSelections');
        var myobj=eval(rowsData);
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算编码");
            return false;
        }else{
            id = "departUseDetailList";
            gridname = id;
            var addurl = "/tpm/ttActDepartUseController/goUpdateOrAddDetail?1=1&tempUuid=${tempUuid}&budgetCode="+budgetCode+"&id="+myobj[0].id;
            createwindow("编辑", addurl,  400, 400, {});
        }
    }

    $(document.body).css({
        "overflow-x": "auto",
        "overflow-y": "auto"
    });
    debugger
    var trId = 0;
    var cloneTrTemp = "";
    $(function () {
        setTimeout(function(){
            $("#departUseDetailList").datagrid("resize");
        },500)
    });

    //提交前处理
    function checkproductSubmit() {
        var b=checkTable()
        return b;
    }

    //校验table
    function checkTable() {
        var canSubmit = true;
        var tableData = [];
        $("#showTable tbody tr").each(function () {
            if (canSubmit) {
                var obj = {};
                $(this).find("td").each(function (index) {
                    if (canSubmit) {
                        $(this).find("input[field=formtable]").each(function () {
                            var inputName = $(this).attr("name");
                            obj[inputName] = $(this).val()
                            if (!$(this).val() && $(this).attr("type") !== "hidden") {
                                canSubmit = false;
                                $(this).focus();
                                var name = $("#showTable thead tr th").eq(index).text();
                                tip(name + "不能为空");
                                return false;
                            }
                        })

                    } else {
                        return false;
                    }
                });
                tableData.push(obj);
            } else {
                return false;
            }

        });
        if (canSubmit) {
            $("#productJson").val(JSON.stringify(tableData))
        }
        return canSubmit;
    }

    function selectbudget(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "budgetCode";
        triggerName = "budgetName";
        url = "/tpm/ttApiBudgetController/goApiBudgetMain";
        width = 1000;
        height = 450;
        id = "ttApibudgetList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#budgetCode").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetCode);
                    $("#" + triggerName).val(myobj[0].budgetName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

</script>
</body>
</html>