
/**
 * 增删改工具栏
 */
var iframe; // iframe操作对象
var win; // 窗口对象
var gridname = ""; // 操作datagrid对象名称
var windowapi = frameElement ? frameElement.api: undefined;
if (typeof(windowapi) != 'undefined') {
    var W = windowapi.opener; // 内容页中调用窗口实例对象接口
}

/**
 * 可以在嵌套的对话框页面中获jquery实例,无需担心其中的lhgDialog插件重入问题
 * @returns
 */
function getSafeJq() {
    if (typeof(windowapi) === 'undefined') {
        return $;
    } else {
        return W.$;
    }
}

/**
 * 可以在嵌套的对话框页面中弹出对话框,无需担心其中的lhgDialog插件重入问题
 * @returns
 */
function safeShowDialog(option) {
    if (typeof(windowapi) === 'undefined') {
        return $.dialog(option).zindex();
    } else {
        return W.$.dialog($.extend(option, {
            parent: windowapi
        })).zindex();
    }
}

/**
 * 添加事件打开窗口
 * 
 * @param title
 *            编辑框标题
 * @param addurl//目标页面地址
 */
function add(title, addurl, gname, width, height, params) {
    gridname = gname;
    //width = (width&&width!='null') ? width : 700;
    //height = (height&&height!='null') ? height : 400;

    if(typeof(gridname)!="undefined"){
    	var rowData = $('#' + gridname).datagrid('getSelected');
    	if (params != null && params != '') {
    		var paramsArr = params.split(",");
    		for (var i = 0; i < paramsArr.length; i++) {
    			addurl += "&" + paramsArr[i] + "=" + rowData[paramsArr[i]];
    		}
    	}
    }

    if (!width || width == "" || width == 'null' || !height || height == "" || height == 'null') createwindowSmall(title, addurl, width, height);
    else createwindow(title, addurl, width, height);
}

/**
 * 编辑事件打开窗口
 * 
 * @param title
 *            编辑框标题
 * @param addurl//目标页面地址
 * @param id//主键字段
 */
function update(title, url, id, width, height) {
    gridname = id;
    var rowsData = $('#' + id).datagrid('getSelections');
    if (!rowsData || rowsData.length == 0) {
        tip('请选择编辑项目');
        return;
    }
    if (rowsData.length > 1) {
        tip('请选择一条记录再编辑');
        return;
    }


    url += '&id=' + rowsData[0].id;
    if (!width || width == "" || width == 'null' || !height || height == "" || height == 'null') createwindowSmall(title, url, width, height);
    else createwindow(title, url, width, height);
}

/**
 * 查看详细事件打开窗口
 * 
 * @param title
 *            查看框标题
 * @param addurl//目标页面地址
 * @param id//主键字段
 */
function detail(title, url, id, width, height) {
    var rowsData = $('#' + id).datagrid('getSelections');
    // if (rowData.id == '') {
    // tip('请选择查看项目');
    // return;
    // }
    if (!rowsData || rowsData.length == 0) {
        tip('请选择查看项目');
        return;
    }
    if (rowsData.length > 1) {
        tip('请选择一条记录再查看');
        return;
    }
    url += '&load=detail&id=' + rowsData[0].id;
    createwindowExt(title, url, width, height, {
        ok: false,
        cancelVal: '关闭',
        cancel: true
    });
}

/**
 * 树列表添加事件打开窗口
 * 
 * @param title
 *            编辑框标题
 * @param addurl//目标页面地址
 */
function addTreeNode(title, addurl, gname) {
    if (rowid != '') {
        addurl += '&id=' + rowid;
    }
    gridname = gname;
    createwindow(title, addurl);
}

/**
 * 如果页面是详细查看页面，无效化所有表单元素，只能进行查看
 */
$(function() {
    detailExec();
});
function detailExec() {
    if (location.href.indexOf("load=detail") != -1) {
        $(":input").attr("disabled", "true");
        $(":input").css({
            "border": "0",
            "border-bottom": "1px solid #6b6b6b",
            "background": "none",
            "color": "black"
        });
        $(":input").each(function() {
            $(this).closest(".form").find(".combo").css({
                "border": "0",
                "border-bottom": "1px solid #6b6b6b",
                "background": "none",
                "color": "black"
            });
            $(this).closest(".form").find(".combo input").css({
                "border": "0"
            });
            $(this).closest(".form").find(".combo-arrow").hide();
            $(this).closest(".form").find(".easyui-linkbutton").hide();
        });
        $(":input").css({
            "appearance": "none"
        }); //select::-ms-expand{display:none;}
    }
}

/**
 * 多记录刪除請求
 * 
 * @param title
 * @param url
 * @param gname
 * @return
 */
function deleteALLSelect(title, url, gname) {
    gridname = gname;
    var ids = [];
    var rows = $("#" + gname).datagrid('getSelections');
    if (rows.length > 0) {
        getSafeJq().dialog.confirm("你确定永久删除该数据吗?",
        function(r) {
            if (r) {
                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].id);
                }
                $.ajax({
                    url: url,
                    type: 'post',
                    data: {
                        ids: ids.join(',')
                    },
                    cache: false,
                    success: function(data) {
                        var d = data;
                        if (d.success) {
                            var msg = d.msg;
                            tip(msg);
                            reloadTable();
                            $("#" + gname).datagrid('unselectAll');
                            ids = '';
                        }
                    }
                });
            }
        });
    } else {
        tip("请选择需要删除的数据");
    }
}

/**
 * Excel 导出 代入查询条件
 */
function excelExport(url, datagridId) {
    var queryParams = $('#' + datagridId).datagrid('options').queryParams;
    $('#' + datagridId + 'tb').find('*').each(function() {
        queryParams[$(this).attr('name')] = $(this).val();
    });
    var params = '&';
    $.each(queryParams,
    function(key, val) {
        params += '&' + key + '=' + val;
    });
    var fields = '&field=';
    $.each($('#' + datagridId).datagrid('options').columns[0],
    function(i, val) {
        if (val.field != 'opt') {
            fields += val.field + ',';
        }
    });
    window.location.href = url + encodeURI(fields + params);
    // window.open( url + encodeURI(fields + params) ) ;
}

function excelImport(title, url, datagrid) {
    // var html = '<div class=""><input class="" type="file" name="file" </div>'
    createwindowExt('导入', '/dmsback/import/goImportForm?url=' + url, 400, 500, {
        ok: false,
        cancel: function () {
            $('#' + datagrid).datagrid('reload');
        }
    })
}

/**
 * 全屏编辑
 * 
 * @param title
 *            编辑框标题
 * @param addurl//目标页面地址
 * @param id//主键字段
 */
function editfs(title, url) {
    var name = gridname;
    if (rowid == '') {
        tip('请选择编辑项目');
        return;
    }
    url += '&id=' + rowid;
    openwindow(title, url, name, 800, 500);
}

/**
 * 删除记录
 * @param url
 * @param name
 */
function delObj(url, name) {
    gridname = name;
    createdialog('删除确认 ', '确定删除该记录吗 ?', url, name);
}

/**
 * 删除附件
 * @param url
 * @param id
 */
function confuploadify(url, id) {
    getSafeJq().dialog.confirm('确定删除吗',
    function() {
        deluploadify(url, id);
    },
    function() {}).zindex();
}
/**
 * 执行删除附件
 * 
 * @param url
 * @param index
 */
function deluploadify(url, id) {
    $.ajax({
        async: false,
        cache: false,
        type: 'POST',
        url: url,
        // 请求的action路径
        error: function() { // 请求失败处理函数
        },
        success: function(data) {
            var d = $.parseJSON(data);
            if (d.success) {
                $("#" + id).remove(); // 移除SPAN
                m.remove(id); // 移除MAP对象内字符串
            }

        }
    });
}

/**
 * 普通询问操作调用函数
 * @param url
 * @param content
 * @param name
 */
function confirm(url, content, name) {
    createdialog('提示信息 ', content, url, name);
}

/**
 * 提示信息, 在整个屏幕的右下角弹出
 */
function newTip(msg) {
	top.tip(msg);
}

/**
 * 提示信息: 在当前的对话框右下角弹出
 * @param msg
 */
function tip(msg) {
    $.messager.show({
        title: '提示信息',
        msg: msg,
        timeout: 1000 * 6
    });
}
/**
 * 提示信息像alert一样
 */
function alertTip(msg, title) {
    //$.dialog.setting.zIndex = 1980;
    title = title ? title: "提示信息";
    top.$.dialog({
        title: title,
        icon: 'tips.gif',
        lock: true,
        content: msg
    }).zindex();
}
/**
 * 创建普通大小窗口
 * 
 * @param title
 * @param addurl
 * @param saveurl
 */
function createwindow(title, addurl, width, height) {
    createwindowExt(title, addurl, width, height, {});
}

/**
 * 创建小窗口
 * 
 * @param title
 * @param addurl
 * @param saveurl
 */
function createwindowSmall(title, addurl, width, height) {
    createwindowExt(title, addurl, 500, 400, {});
}

/**
 * 创建大窗口
 * 
 * @param title
 * @param addurl
 * @param saveurl
 */
function createwindowBig(title, addurl, width, height) {
    createwindowExt(title, addurl, 1000, 500, {});
}

/**
 * 创建上传页面窗口
 * 
 * @param title
 * @param addurl
 * @param saveurl
 */
function openUploadWin(title, url, name, width, height) {
    gridname = name;
    safeShowDialog({
        content: 'url:' + url,
        lock: true,
        cache: false,
        button: [{
            name: "开始上传",
            callback: function() {
                iframe = this.iframe.contentWindow;
                iframe.upload();
                return false;
            },
            focus: true
        },
        {
            name: "取消上传",
            callback: function() {
                iframe = this.iframe.contentWindow;
                iframe.cancel();
            }
        }]
    });
}
/**
 * 创建查询页面窗口
 * 
 * @param title
 * @param addurl
 * @param saveurl
 */
function openSearchWin(title, url, width, height) {
    safeShowDialog({
        content: 'url:' + url,
        title: title,
        lock: true,
        height: height,
        cache: false,
        width: width,
        opacity: 0.3,
        button: [{
            name: '查询',
            callback: function() {
                iframe = this.iframe.contentWindow;
                iframe.searchs();
            },
            focus: true
        },
        {
            name: '取消',
            callback: function() {

}
        }]
    });
}
/**
 * 创建不带按钮的窗口
 * 
 * @param title
 * @param addurl
 * @param saveurl
 */
function openwindow(title, url, name, width, height) {
    gridname = name;
    width = width || 'auto';
    height = height || 'auto';

    safeShowDialog({
        content: 'url:' + url,
        title: title,
        cache: false,
        lock: true,
        width: width,
        height: height
    });
}

function view(title, url, name, width, height, params) {
    gridname = name;
    width = width || '1500';
    height = height || '600';
    var rowData = $('#' + gridname).datagrid('getSelected');
    if (rowData == null) {
        tip('请选择数据');
        return;
    }

    if (params != null || params != '') {
        var paramsArr = params.split(",");
        for (var i = 0; i < paramsArr.length; i++) {
            url += "&" + paramsArr[i] + "=" + rowData[paramsArr[i]];
        }
    }

    safeShowDialog({
        content: 'url:' + url,
        title: title,
        cache: false,
        lock: true,
        width: width,
        height: height
    });
}

/**
 * 系统提示框
 * @param title
 * @param url
 * @param gridname
 * @param width
 * @param height
 * @param params
 */
function systemConfirm(title, url, gridname, width, height, params) {
    var rowData = $('#' + gridname).datagrid('getSelected');
    if (rowData == null) {
        tip('请选择数据');
        return;
    }

    if (params != null || params != '') {
        var paramsArr = params.split(",");
        for (var i = 0; i < paramsArr.length; i++) {
            url += "&" + paramsArr[i] + "=" + rowData[paramsArr[i]];
        }
    }
    createdialog('提示', '确认要操作？', url, gridname);
}

/**
 * 创建询问窗口
 * 
 * @param title
 * @param content
 * @param url
 */
function createdialog(title, content, url, name) {
    getSafeJq().dialog.confirm(content,
    function() {
        doSubmit(url, name);
        rowid = '';
    },
    function() {}).zindex();
}
/**
 * 执行保存
 * 
 * @param url
 * @param gridname
 */
function saveObj() {
    $('#btn_sub', iframe.document).click();
}

/**
 * 执行AJAX提交FORM
 * 
 * @param url
 * @param gridname
 */
function ajaxSubForm(url) {
    $('#myform', iframe.document).form('submit', {
        url: url,
        onSubmit: function() {
            iframe.editor.sync();
        },
        success: function(r) {
            tip('操作成功');
            reloadTable();
        }
    });
}
/**
 * 执行查询
 * 
 * @param url
 * @param gridname
 */
function search() {

    $('#btn_sub', iframe.document).click();
    iframe.search();
}

/**
 * 执行操作
 * 
 * @param url
 * @param index
 */
function doSubmit(url, name, data) {
    gridname = name;
    var paramsData = data;
    if (!paramsData) {
        paramsData = {};
        if (url.indexOf("&") != -1) {
            var str = url.substr(url.indexOf("&") + 1);
            url = url.substr(0, url.indexOf("&"));
            var strs = str.split("&");
            for (var i = 0; i < strs.length; i++) {
                paramsData[strs[i].split("=")[0]] = (strs[i].split("=")[1]);
            }
        }
    }
    $.ajax({
        async: false,
        cache: false,
        type: 'POST',
        data: paramsData,
        url: url,
        // 请求的action路径
        error: function() { // 请求失败处理函数
        },
        success: function(data) {
            var d = $.parseJSON(data);
            if (d.success) {
                var msg = d.msg;
                tip(msg);
                reloadTable();
            }
        }
    });

}
/**
 * 退出确认框
 * 
 * @param url
 * @param content
 * @param index
 */
function exit(url, content) {
    getSafeJq().dialog.confirm(content,
    function() {
        window.location = url;
    },
    function() {}).zindex();
}
/**
 * 模板页面ajax提交
 * 
 * @param url
 * @param gridname
 */
function ajaxdoSub(url, formname) {
    $('#' + formname).form('submit', {
        url: url,
        onSubmit: function() {
            editor.sync();
        },
        success: function(r) {
            tip('操作成功');
        }
    });
}

/**
 * ajax提交FORM
 * 
 * @param url
 * @param gridname
 */
function ajaxdoForm(url, formname) {
    $('#' + formname).form('submit', {
        url: url,
        onSubmit: function() {},
        success: function(r) {
            tip('操作成功');
        }
    });
}

/**
 * 打开一个子窗体. (预期子窗体中包含一个t:formValid标签)
 * @param title
 * @param url
 * @param okbutton
 * @param closebutton
 */
function opensinglewin(title, id, url, width, height) {
    var myOptions = {
        content: 'url:' + url,
        lock: true,
        width: width,
        height: height,
        title: title,
        opacity: 0.3,
        cache: false,
        cancelVal: '确定',
        cancel: function() {
            $("#" + id).datagrid('reload');
        }
    };
    safeShowDialog(myOptions);
}

function opensubwin(title, url, saveurl, okbutton, closebutton) {
    safeShowDialog({
        content: 'url:' + url,
        title: title,
        lock: true,
        opacity: 0.3,
        button: [{
            name: okbutton,
            callback: function() {
                iframe = this.iframe.contentWindow;
                win = frameElement.api.opener; // 来源页面
                $('#btn_sub', iframe.document).click();
                return false;
            }
        },
        {
            name: closebutton,
            callback: function() {}
        }]

    });
}

function openauditwin(title, url, saveurl, okbutton, backbutton, closebutton) {
    safeShowDialog({
        content: 'url:' + url,
        title: title,
        lock: true,
        opacity: 0.3,
        button: [{
            name: okbutton,
            callback: function() {
                iframe = this.iframe.contentWindow;
                win = $.dialog.open.origin; // 来源页面
                $('#btn_sub', iframe.document).click();
                return false;
            }
        },
        {
            name: backbutton,
            callback: function() {
                iframe = this.iframe.contentWindow;
                win = frameElement.api.opener; // 来源页面
                $('#formobj', iframe.document).form('submit', {
                    url: saveurl + "&code=exit",
                    onSubmit: function() {
                        $('#code').val('exit');
                    },
                    success: function(r) {
                        $.dialog.tips('操作成功', 2);
                        win.location.reload();
                    }
                });

            }
        },
        {
            name: closebutton,
            callback: function() {}
        }]

    });
}

/**
 * 获取Cookie值
 */
function getCookie(c_name) {
    if (document.cookie.length > 0) {
        c_start = document.cookie.indexOf(c_name + "=");
        if (c_start != -1) {
            c_start = c_start + c_name.length + 1;
            c_end = document.cookie.indexOf(";", c_start);
            if (c_end == -1)
            	c_end = document.cookie.length;
            return unescape(document.cookie.substring(c_start, c_end));
        }
    }
    return "";
}
/**
 * 根据datagrid数据来动态添加新tab标签
 * @param title
 * @param url
 * @param gridname
 * @param width
 * @param height
 * @param params
 */
function systemAddOneTab(title, url, gridname, width, height, params) {
    var rowData = $('#' + gridname).datagrid('getSelected');
    if (rowData == null) {
        tip('请选择数据');
        return;
    }

    if (params != null || params != '') {
        var paramsArr = params.split(",");
        for (var i = 0; i < paramsArr.length; i++) {
            url += "&" + paramsArr[i] + "=" + rowData[paramsArr[i]];
        }
    }
    addOneTab(title, url);
}

/**
 * 添加tab标签
 * @param subtitle
 * @param url
 * @param icon
 */
function addOneTab(subtitle, url, icon) {
    var indexStyle = getCookie("EISPINDEXSTYLE");
    if (indexStyle == 'sliding' || indexStyle == 'bootstrap') {
        // shortcut和bootstrap风格的tab跳转改为直接跳转
        window.location.href = url;
    } else {
        if (icon == '') {
            icon = 'icon folder';
        }
        window.top.$.messager.progress({
            text: '页面加载中....',
            interval: 300
        });
        window.top.$('#maintabs').tabs({
            onClose: function(subtitle, index) {
                window.top.$.messager.progress('close');
            }
        });
        if (window.top.$('#maintabs').tabs('exists', subtitle)) {
            window.top.$('#maintabs').tabs('select', subtitle);
            if (url.indexOf('isHref') != -1) {
                window.top.$('#maintabs').tabs('update', {
                    tab: window.top.$('#maintabs').tabs('getSelected'),
                    options: {
                        title: subtitle,
                        href: url,
                        // content : '<iframe src="' + url + '" frameborder="0"
                        // style="border:0;width:100%;height:99.4%;"></iframe>',
                        closable: true,
                        icon: icon
                    }
                });
            } else {
                window.top.$('#maintabs').tabs('update', {
                    tab: window.top.$('#maintabs').tabs('getSelected'),
                    options: {
                        title: subtitle,
                        content: '<iframe src="' + url + '" frameborder="0" style="border:0;width:100%;height:99.4%;"></iframe>',
                        // content : '<iframe src="' + url + '"
                        // frameborder="0"
                        // style="border:0;width:100%;height:99.4%;"></iframe>',
                        closable: true,
                        icon: icon
                    }
                });
            }
        } else {
            if (url.indexOf('isHref') != -1) {
                window.top.$('#maintabs').tabs('add', {
                    title: subtitle,
                    href: url,
                    closable: true,
                    icon: icon
                });
            } else {
                window.top.$('#maintabs').tabs('add', {
                    title: subtitle,
                    content: '<iframe src="' + url + '" frameborder="0" style="border:0;width:100%;height:99.4%;"></iframe>',
                    closable: true,
                    icon: icon
                });
            }
        }
    }
}

/**
 * 关闭自身TAB刷新父TABgrid
 */
function closetab(title) {
    // 暂时先不刷新
    // window.top.document.getElementById('tabiframe').contentWindow.reloadTable();
    // window.top.document.getElementById('maintabs').contentWindow.reloadTable();
    window.top.$('#maintabs').tabs('close', title);
    // tip("添加成功");
}

/**
 * popup
 * @param obj this
 * @param name 需要选择的列表的字段
 * @param code 动态报表的code
 */
function inputClick(obj, name, code) {
    $.dialog.setting.zIndex = 2000;
    if (name == "" || code == "") {
        alert("popup参数配置不全");
        return;
    }
    safeShowDialog({
        content: "url:cgReportController.do?popup&id=" + code,
        lock: true,
        title: "选择",
        width: 800,
        height: 400,
        cache: false,
        ok: function() {
            iframe = this.iframe.contentWindow;
            var selected = iframe.getSelectRows();
            if (selected == '' || selected == null) {
                alert("请选择");
                return false;
            } else {
                var str = "";
                $.each(selected,
                function(i, n) {
                    if (i == 0) str += n[name];
                    else str += "," + n[name];
                });
                $(obj).val("");
                // $('#myText').searchbox('setValue', str);
                $(obj).val(str);
                return true;
            }

        },
        cancelVal: '关闭',
        cancel: true
        /* 为true等价于function(){} */
    });
}

function inputClickCheckbox(obj, name, code) {
    $.dialog.setting.zIndex = 2000;
    if (name == "" || code == "") {
        alert("popup参数配置不全");
        return;
    }
    safeShowDialog({
        content: "url:cgReportController.do?popup&id=" + code,
        lock: true,
        title: "选择",
        width: 800,
        height: 400,
        cache: false,
        ok: function() {
            iframe = this.iframe.contentWindow;
            var selected = iframe.getSelectRows();
            if (selected == '' || selected == null) {
                alert("请选择");
                return false;
            } else {
                var str = "";
                var find = "td[field=\"" + name + "\"]";
                $(iframe.document).find('input[type="checkbox"][name="ck"]:checked').each(function(i) {
                    var val = $(this).parent().parent().parent().find(find).text();
                    if (i == 0) {
                        str += val;
                    } else {
                        str += "," + val;
                    }
                });

                $(obj).val(str);
                return true;
            }

        },
        cancelVal: '关闭',
        cancel: true
        /* 为true等价于function(){} */
    });
}

/**
 * 自定义url的弹出
 * 
 * obj:要填充的控件,可以为多个，以逗号分隔
 * name:列表中对应的字段,可以为多个，以逗号分隔（与obj要对应）
 * url：弹出页面的Url
 */
function popClick(obj, name, url, width, height) {
    //    $.dialog.setting.zIndex = 2001;
    var names = name.split(",");
    var objs = obj.split(",");
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: "选择",
        width: width == null ? 700 : width,
        height: height == null ? 400 : height,
        left: '85%',
        cache: false,
        ok: function() {
            iframe = this.iframe.contentWindow;
            var selected = iframe.getSelectRows();
            if (selected == '' || selected == null) {
                alert("请至少选择一条数据");
                return false;
            } else {
                for (var i1 = 0; i1 < names.length; i1++) {
                    var str = "";
                    $.each(selected,
                    function(i, n) {
                        if (i == 0) {
                            str += n[names[i1]];
                        } else {
                            str += ",";
                            str += n[names[i1]];
                        }
                    });
                    if ($("#" + objs[i1]).length >= 1) {
                        $("#" + objs[i1]).val("");
                        $("#" + objs[i1]).val(str);
                    } else {
                        $("input[name='" + objs[i1] + "']").val("");
                        $("input[name='" + objs[i1] + "']").val(str);
                    }
                }
                return true;
            }
        },
        cancelVal: '关闭',
        cancel: true
        /* 为true等价于function(){} */
    });
}

/**
 * 获取window grid 所有数据
 * 
 * @param obj 父window对象
 * @param name 子window对象需要封装的filed
 * @param url 数据加载url
 * @param id 子window grid的id
 * @param width 宽
 * @param height 高
 * @param isCheck 标记
 */
function popSelectAll(obj, name, url, id, width, height, isCheck) {
    gridname = id;
    var names = name.split(",");
    var objs = obj.split(",");
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: "选择",
        width: width == null ? 700 : width,
        height: height == null ? 400 : height,
        left: '85%',
        cache: false,
        ok: function() {
            iframe = this.iframe.contentWindow;
            var rowsData = iframe.$('#' + id).datagrid('getRows');
            if (isCheck) {
                if (rowsData != '' && rowsData != null) {
                    var flag = false;
                    $.each(rowsData,
                    function(i, v) {
                        if (v.isMain == "0") {
                            flag = true;
                        }
                    });
                    if (!flag) {
                        iframe.tip("请设置一个主职位");
                        return false;
                    }
                }
            }
            if ((rowsData == '' || rowsData == null) && isCheck) {
                iframe.tip("请至少选择一条数据");
                return false;
            } else {
                for (var i1 = 0; i1 < names.length; i1++) {
                    var str = "";
                    $.each(rowsData,
                    function(i, n) {
                        if (i == 0) {
                            str += n[names[i1]];
                        } else {
                            str += ",";
                            str += n[names[i1]];
                        }
                    });
                    if ($("#" + objs[i1]).length >= 1) {
                        $("#" + objs[i1]).val("");
                        $("#" + objs[i1]).val(str);
                    } else {
                        $("input[name='" + objs[i1] + "']").val("");
                        $("input[name='" + objs[i1] + "']").val(str);
                    }
                }
                return true;
            }
        },
        cancelVal: '关闭',
        cancel: true
        /* 为true等价于function(){} */
    });
}

/**
 * 自定义弹出列表
 * 
 * target: 要填充的控件ID，可以多个，以逗号分隔，与name要一一对应
 * src:列表中对应的字段,可以为多个，以逗号分隔
 * url：弹出页面的Url
 */
function popGridZJH(title, url, width, height) {
    //$.dialog.setting.zIndex = 2009;
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: title,
        width: width,
        height: height,
        cache: false,
        ok: function() {
            iframe = this.iframe.contentWindow;
            saveObj();
            return false;
        },
        cancelVal: '关闭',
        cancel: true
    });
}

/**
 * 自定义弹出列表
 * 
 * target: 要填充的控件ID，可以多个，以逗号分隔，与name要一一对应
 * src:列表中对应的字段,可以为多个，以逗号分隔
 * url：弹出页面的Url
 */
function popGrid(target, src, url, width, height) {
    //    $.dialog.setting.zIndex = 2009;
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: "选择",
        width: width,
        height: height,
        cache: false,
        init: function() {
            var hiddenField = '<input type="hidden" id="targetField" name="targetField" value="' + target + '">' + '<input type="hidden" id="srcField" name="srcField" value="' + src + '">';
            iframe = this.iframe.contentWindow;
            iframe.$("body").append(hiddenField);
        }
    });
}

/**
 * 自定义弹出树
 * 
 * name:列表中对应的字段,可以为多个，以逗号分隔
 * url：弹出页面的Url
 */
function popTree(name, url, width, height) {
    //    $.dialog.setting.zIndex = 2001;
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: "选择",
        width: width,
        height: height,
        cache: false,
        init: function() {
            var hiddenField = '<input type="hidden" id="targetField" name="targetField" value="' + name + '">';
            iframe = this.iframe.contentWindow;
            iframe.$("body").append(hiddenField);
        }
    });
}

/**
 * eisp Excel 导出 代入查询条件
 */
function EispExcelExport(url, datagridId) {
    var queryParams = $('#' + datagridId).datagrid('options').queryParams;
    $('#' + datagridId + 'tb').find('*').each(function() {
        queryParams[$(this).attr('name')] = $(this).val();
    });
    var params = '&';
    $.each(queryParams,
    function(key, val) {
        params += '&' + key + '=' + val;
    });
    var fields = '&field=';
    $.each($('#' + datagridId).datagrid('options').columns[0],
    function(i, val) {
        if (val.field != 'opt') {
            fields += val.field + ',';
        }
    });
    window.location.href = url + encodeURI(fields + params);
    // window.open(  url + encodeURI(fields + params)) ;
}

/**
 * 自动完成的解析函数
 * 
 * @param data
 * @returns {Array}
 */
function eispAutoParse(data) {
    var parsed = [];
    $.each(data.rows,
    function(index, row) {
        parsed.push({
            data: row,
            result: row,
            value: row.id
        });
    });
    return parsed;
}
/**
 * 
 * @param tips 提示信息
 * @param url 请求地址
 * @param params 请求参数
 * @param callbackfunc callback函数设置
 * @param async 是否同步
 * @param timout 超时设置
 */
function ajaxRequest(jsonconfig) {
    var tips = jsonconfig.tips;
    var param = jsonconfig.data;
    if (tips == "" || tips == null) {
        tips = "确认执行?";
    }
    var timout = jsonconfig.timout;
    if (timout == null || timout == "") {
        timout = 9000;
    }
    getSafeJq().dialog.confirm(tips,
    function() {
        window.top.$.messager.progress({
            text: '操作执行中....',
            interval: 300
        });
        $.ajax({
            type: "post",
            url: jsonconfig.url,
            data: jsonconfig.params || '',
            timeout: timout,
            success: function(r) {
                var callMethod = function(method) {
                    method(r);
                };
                callMethod(jsonconfig.callbackfun); // 提交成功回调
                window.top.$.messager.progress('close');
            },
            error: function() {
                window.top.$.messager.progress('close');
                $.dialog.tips('服务器繁忙，请稍后再试');
            }
        });
    })
}

/**
 * 允许指定扩展选项的创建窗体方法
 * @param title
 * @param addurl
 * @param width
 * @param height
 * @param options
 */
function createwindowExt(title, addurl, width, height, options) {
    var offsetW = window.top.document.body.offsetWidth;
    var offsetH = window.top.document.body.offsetHeight;
    width = (width && width != 'null') ? width: 700;
    height = (height && height != 'null') ? height: 400;
    if (width == "100%" || width > offsetW) {
        width = offsetW;
    }
    if (height == "100%" || height > (offsetH - 100)) {
        height = offsetH - 100;
    }
    var myOptions = {
        content: 'url:' + addurl,
        lock: true,
        width: parseInt(width),
        height: parseInt(height),
        title: title,
        opacity: 0.3,
        cache: false,
        /* 为true等价于function(){} */
    };
    if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
        $.extend(myOptions, {
            ok: function() {
                iframe = this.iframe.contentWindow;
                saveObj();
                return false;
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    $.extend(myOptions, options);
    safeShowDialog(myOptions);
}

/**
 * 创建选择弹窗， 要求打开的页面实现getSelections方法
 * 
 * @param title
 * @param addurl
 * @param width
 * @param height
 * @param onSelect
 */
function createselectwindow(title, addurl, width, height, onSelect) {
    createwindowExt(title, addurl, width, height, {
        ok: function() {
            iframe = this.iframe.contentWindow;
            if (typeof(iframe.getSelections) === 'function') {
                var selected = iframe.getSelections();
                if (typeof(onSelect) === 'function') {
                    onSelect(selected);
                }
            }
            this.iframe.api.close();
            return false;
        }
    });
}

/**
 * 金额数字转中文大写
 * 
 * @param Num
 * @returns {String}
 */
function Arabia_to_Chinese(Num) {
    debugger;
    for (i = Num.length - 1; i >= 0; i--) {
        Num = Num.replace(",", ""); //替换tomoney()中的“,”
        Num = Num.replace(" ", "") //替换tomoney()中的空格
    }
    Num = Num.replace("￥", ""); //替换掉可能出现的￥字符
    if (isNaN(Num)) { //验证输入的字符是否为数字
        return;
    }
    //---字符处理完毕，开始转换，转换采用前后两部分分别转换---//
    part = String(Num).split(".");
    newchar = "";
    //小数点前进行转化
    for (i = part[0].length - 1; i >= 0; i--) {
        if (part[0].length > 10) {
            alert("位数过大，无法计算");
            return "";
        } //若数量超过拾亿单位，提示
        tmpnewchar = "";
        perchar = part[0].charAt(i);
        switch (perchar) {
        case "0":
            tmpnewchar = "零" + tmpnewchar;
            break;
        case "1":
            tmpnewchar = "一" + tmpnewchar;
            break;
        case "2":
            tmpnewchar = "二" + tmpnewchar;
            break;
        case "3":
            tmpnewchar = "三" + tmpnewchar;
            break;
        case "4":
            tmpnewchar = "四" + tmpnewchar;
            break;
        case "5":
            tmpnewchar = "五" + tmpnewchar;
            break;
        case "6":
            tmpnewchar = "六" + tmpnewchar;
            break;
        case "7":
            tmpnewchar = "七" + tmpnewchar;
            break;
        case "8":
            tmpnewchar = "八" + tmpnewchar;
            break;
        case "9":
            tmpnewchar = "九" + tmpnewchar;
            break;
        }
        switch (part[0].length - i - 1) {
        case 0:
            tmpnewchar = tmpnewchar + "元";
            break;
        case 1:
            if (perchar != 0) tmpnewchar = tmpnewchar + "十";
            break;
        case 2:
            if (perchar != 0) tmpnewchar = tmpnewchar + "百";
            break;
        case 3:
            if (perchar != 0) tmpnewchar = tmpnewchar + "千";
            break;
        case 4:
            tmpnewchar = tmpnewchar + "万";
            break;
        case 5:
            if (perchar != 0) tmpnewchar = tmpnewchar + "十";
            break;
        case 6:
            if (perchar != 0) tmpnewchar = tmpnewchar + "百";
            break;
        case 7:
            if (perchar != 0) tmpnewchar = tmpnewchar + "千";
            break;
        case 8:
            tmpnewchar = tmpnewchar + "亿";
            break;
        case 9:
            tmpnewchar = tmpnewchar + "十";
            break;
        }
        newchar = tmpnewchar + newchar;
    }
    //小数点之后进行转化
    if (Num.indexOf(".") != -1) {
        if (part[1].length > 2) {
            tip("小数点之后只能保留两位,系统将自动截段");
            part[1] = part[1].substr(0, 2)
        }
        for (i = 0; i < part[1].length; i++) {
            tmpnewchar = "";
            perchar = part[1].charAt(i);
            switch (perchar) {
            case "0":
                tmpnewchar = "零" + tmpnewchar;
                break;
            case "1":
                tmpnewchar = "一" + tmpnewchar;
                break;
            case "2":
                tmpnewchar = "二" + tmpnewchar;
                break;
            case "3":
                tmpnewchar = "三" + tmpnewchar;
                break;
            case "4":
                tmpnewchar = "四" + tmpnewchar;
                break;
            case "5":
                tmpnewchar = "五" + tmpnewchar;
                break;
            case "6":
                tmpnewchar = "六" + tmpnewchar;
                break;
            case "7":
                tmpnewchar = "七 " + tmpnewchar;
                break;
            case "8":
                tmpnewchar = "八" + tmpnewchar;
                break;
            case "9":
                tmpnewchar = "九" + tmpnewchar;
                break;
            }
            if (i == 0) tmpnewchar = tmpnewchar + "角";
            if (i == 1) tmpnewchar = tmpnewchar + "分";
            newchar = newchar + tmpnewchar;
        }
    }
    //替换所有无用汉字
    while (newchar.search("零零") != -1) newchar = newchar.replace("零零", "零");
    newchar = newchar.replace("零亿", "亿");
    newchar = newchar.replace("亿万", "亿");
    newchar = newchar.replace("零万", "万");
    newchar = newchar.replace("零元", "元");
    newchar = newchar.replace("零角", "");
    newchar = newchar.replace("零分", "");
    if (newchar.charAt(newchar.length - 1) == "元" || newchar.charAt(newchar.length - 1) == "角") newchar = newchar + "整";
    //  document.write(newchar);
    return newchar;
}

//构造下拉选择
function createTargSelectOptions(targSelectId, datas, valueFiled, textFiled) {
    $('#' + targSelectId).empty();
    var str = '<option value="">--请选择--</option>';
    if (checkIsNotUndefinedAndNullAndNullValue(datas)) {
        $.each(datas, function (i, vo) {
            str += '<option value=' + vo[valueFiled] + ' >' + vo[textFiled] + '</option>';
        });
    }
    $('#' + targSelectId).append(str);
}

/**
 * 添加一个tab标签
 * @param subtitle
 * @param url
 * @param icon
 */
function addTab(subtitle, url, icon) {
    var progress = $("div.messager-progress");
    if (progress.length) {
        return;
    }
    rowid = "";

    var maintabsId = parent.$('#maintabs');
    if (!maintabsId.tabs('exists', subtitle)) {
        //判断是否进行href方式打开tab，默认为iframe方式
        if (url.indexOf('isHref') != -1) {
            maintabsId.tabs('add', {
                title: subtitle,
                href: url,
                closable: true,
                icon: icon
            });
        } else {
            maintabsId.tabs('add', {
                title: subtitle,
                content: '<iframe src="' + url + '" frameborder="0" style="border:0;width:100%;height:99.4%;"></iframe>',
                closable: true,
                icon: icon
            });
        }
    } else {
        maintabsId.tabs('select', subtitle);
        $.messager.progress('close');
    }
    parent.tabClose();
}

var ValidformCallbackFun = "";
/**
 * 公用验证form表单
 * @param para
 */
function pubValidForm(para) {
    //$.Tipmsg.r=null;
    ValidformCallbackFun = (typeof(para["callback"]) == "undefined" ? "": para["callback"]);
    $("#" + para['formId'] + "").Validform({
        tiptype: function(msg) {
            if (msg != "通过信息验证！") tip(msg);
        },
        tipSweep: true,
        ajaxPost: true,
        beforeSubmit: function() {
            if (ValidformCallbackFun != "") {
                eval(ValidformCallbackFun);
            }
            return false;
        },
        callback: "",
        datatype: {
            "float": function(gets, obj, curform, regxp) {
                var num = typeof(obj.attr("datatype-float-num")) == "undefined" ? 2 : Number(obj.attr("datatype-float-num"));
                var negative = (typeof(obj.attr("datatype-float-negative")) == "undefined" || obj.attr("datatype-float-negative") != "y" ? "": "(|-)");
                var patt1 = new RegExp("^" + negative + "([1-9][\\d]{0,9}|0)(\\.[\\d]{1," + num + "})?$");
                if (patt1.exec(gets) != null && patt1.exec(gets)[0] == gets) return true;
                else return false;
            }
        }
    });
}

/**
 * 新增多个TAB
 * @param subtitle
 * @param url
 * @param icon
 */
function addTabMore(subtitle, url, icon) {
    var progress = $("div.messager-progress");
    //if(progress.length){return;}
    rowid = "";
    $.messager.progress({
        text: loading,
        interval: 200
    });
    if (!$('#maintabs').tabs('exists', subtitle)) {
        //判断是否进行href方式打开tab，默认为iframe方式
        if (url.indexOf('isHref') != -1) {
            $('#maintabs').tabs('add', {
                title: subtitle,
                href: url,
                closable: true,
                icon: icon
            });
        } else {

            $('#maintabs').tabs('add', {
                title: subtitle,
                content: '<iframe src="' + url + '" frameborder="0" style="border:0;width:100%;height:99.4%;"></iframe>',
                closable: true,
                icon: icon
            });

        }

    } else {
        $('#maintabs').tabs('select', subtitle);
        $.messager.progress('close');
    }

    // $('#maintabs').tabs('select',subtitle);
    tabClose();

}

/**
 * 导入弹出窗口
 * @param cfg
 */
function importDataByXml(cfg) {
    if (!cfg.impName) {
        alert("未配置impName参数！");
        return;
    }
    gridname = cfg.gridName;
    $.dialog({
        content: "url:importController.do?importData&impName=" + cfg.impName,
        lock: true,
        title: "导入",
        max: false,
        width: 660,
        height: 400,
        button: [{
            name: "确定",
            callback: function() {
                iframe = this.iframe.contentWindow;
                iframe.upload();
                return false;
            }
        },
        /*{
		            name: "测试导入",
		            callback: function(){
		            	iframe = this.iframe.contentWindow;
						iframe.testUpload();
						return false;
		            }
		        },*/
        /*{
		            name: "模板下载",
		            callback: function(){
		            	iframe = this.iframe.contentWindow;
						iframe.downTemplete();
						return false;
		            }
		        },*/
        {
            name: "取消",
            callback: function() {
                this.close();
                reloadTable();
            }
        }]
    }).zindex();
}

/**
 * 获取 任意 日期
 * @param AddYear
 * @param AddMonth
 * @param AddDay
 * @returns {String}
 */
function GetDateStr(AddYear, AddMonth, AddDay) {
    AddYear ? AddYear: AddYear = 0;
    AddMonth ? AddMonth: AddMonth = 0;
    AddDay ? AddDay: AddDay = 0;
    var dd = new Date();
    dd.setFullYear(dd.getFullYear() + AddYear);
    dd.setMonth(dd.getMonth() + AddMonth);
    dd.setDate(dd.getDate() + AddDay);
    var y = dd.getFullYear();
    var m = dd.getMonth() + 1;
    var d = dd.getDate();
    m = checkTime(m);
    d = checkTime(d);
    return y + "-" + m + "-" + d;
}
/**
 * 日期补零
 * @param i
 * @returns {String}
 */
function checkTime(i) {
    if (i < 10) {
        i = "0" + i
    }
    return i
}
/**
 * 避免NaN
 * @param value
 * @returns {Number}
 */
function numberIsNull(value) {
    if (value == '') {
        value = 0;
    }
    return value;
}
/**
 *  打开遮罩
 */
function openProgress() {
    $.messager.progress({
        title: "提示",
        msg: '数据加载中,请稍后...'
    });
}
/**
 * 关闭遮罩
 */
function closeProgress() {
    $.messager.progress('close');
}

/**
 * 自动加载数据
 */
function autoLoadData(obj) {
    var key, value, tagName, type, arr;
    for (x in obj) {
        key = x;
        value = obj[x];
        $("[name='" + key + "'],[name='" + key + "[]']").each(function() {
            tagName = $(this)[0].tagName;
            type = $(this).attr('type');
            if (tagName == 'INPUT') {
                if (type == 'radio') {
                    $(this).attr('checked', $(this).val() == value);
                } else if (type == 'checkbox') {
                    arr = value.split(',');
                    for (var i = 0; i < arr.length; i++) {
                        if ($(this).val() == arr[i]) {
                            $(this).attr('checked', true);
                            break;
                        }
                    }
                } else {
                    $(this).val(value);
                }
            } else if (tagName == 'SELECT' || tagName == 'TEXTAREA') {
                $(this).val(value);
            }
        });
    }
}

//动态进度条Js
var interval = null; //定时器
function dynamicProgress(functionKey) {
	$.messager.progress({interval:0});
	interval = setInterval("getProgressInfo('"+functionKey+"')", 1000); //启动定时器，每1秒执行showImportInfo方法一次
}

//显示导入详情
function getProgressInfo(functionKey){
	var param = {};
	if(functionKey != 'undefined') {
		param.functionKey = functionKey;
	}
	$.ajax({
		async : false,
		cache : false,
		type : 'POST',
		data : param,
		url:"progressController.do?getProgress",// 请求的action路径
		error : function() {// 请求失败处理函数
			
		},
		success : function(data) {
			var result = $.parseJSON(data);
			if(result.obj != null) {
				$($.messager.progress("bar")).progressbar('setValue', ((result.obj.current/result.obj.total) * 100).toFixed(2)); 
	    	} else {
	    		window.clearInterval(interval);
	    	}
		}
	});
}

function closeDynamicProgress() {
	window.clearInterval(interval);
	$.messager.progress("close");
}


/**
 * 模板公用ajax方法
 * @param params
 */
function pbAjax(para) {
    var params = $.extend({
        url:"",
        data:"",
        async: true,
        type: "post",
        dataType: "json",
        dataList: "rows",
        containerObj: "",
        tplObj: "",
        isClear:true,
        isShowLoading: false,
        isAlertSuccess: (para.tplObj?false:true),
        isAlertError:true,
        callback_suc:function () {

        },
        callback_err:function () {

        },
        success:function (e) {
            var d = e;
            if(d["success"]){
                if(params.isClear && params.containerObj){
                    params.containerObj.html("");
                }
                if(params.tplObj){
                    $.each((params.dataList).split(","), function(k,v) {
                        if(v) d = d[v];
                    });
                    var tplHtml = params.tplObj.html();
                    if (null != d) {
                        for (var i = 0; i < d.length; i++) {
                            var result = laytpl(tplHtml).render(d[i]);
                            params.containerObj.append(result);
                        }
                    }
                }
                if(params.callback_suc){
                    params.callback_suc(e);
                }else if(params.isAlertSuccess){
                    tip("操作成功");
                }
            }else{
                if(params.callback_err){
                    params.callback_err(e);
                }else if(params.isAlertError){
                    tip("返回错误："+d["msg"]);
                }
            }
        },
        error:function(e){
            //alert("访问接口失败");
        },
        beforeSend:function(e){
            var ajax_num = $("body").attr('data-ajax-num')||0;
            if(params.isShowLoading && ajax_num==0) {
                $("body").append('<div class="pb-cover" data-ajax-cover ><div class="pb-cover-cont">请等待……</div></div>');
            }
            ajax_num++;
            $("body").attr('data-ajax-num', ajax_num);
        },
        complete:function(e){
            var ajax_num = $("body").attr('data-ajax-num')||0;
            ajax_num--;
            if(params.isShowLoading && ajax_num!=0) {
                $("[data-ajax-cover]").remove();
            }
            $("body").attr('data-ajax-num', ajax_num);
        }
    },para);
    if(params.isClear && params.containerObj){
        params.containerObj.html("");
    }
    $.ajax({
        url: params.url,
        data: params.data,
        async: params.async,
        type: params.type,
        dataType: params.dataType,
        success: function (e) {
            params.success(e);
        },
        error: function (e) {
            params.error(e);
        },
        beforeSend:function(e){
            params.beforeSend(e);
        },
        complete:function(e){
            params.complete(e);
        }
    });

}

