/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.departuse.controller;

import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActProductService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"ttActDepartUseController"})
@Controller
public class TtActDepartUseController {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtActProductService ttActProductService;

    @RequestMapping(value={"goTtActDepartUseMain"})
    public ModelAndView goTtActQuotaMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/act/departuse/TtActDepartUseMain");
    }

    @RequestMapping(value={"findTtActDepartUsePage"})
    @ResponseBody
    public DataGrid findTtActDepartUsePage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        vo.setActType(ConstantEnum.ACTTYPE.departuse.getVal());
        PageInfo<TtActVo> info = this.ttActService.findTtActPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"goUpdateOrAdd"})
    public ModelAndView goUpdateOrAdd(HttpServletRequest request, TtActDetailVo vo, String clickFunctionId) {
        TtActEntity entity = new TtActEntity();
        String tempUuid = UUIDGenerator.generate();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtActEntity)this.ttActService.selectByPrimaryKey(vo.getId());
            tempUuid = entity.getTempUuid();
        }
        request.setAttribute("vo", (Object)entity);
        request.setAttribute("tempUuid", (Object)tempUuid);
        request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        return new ModelAndView("com/biz/eisp/act/departuse/TtActDepartUseForm");
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(TtActVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                j.setSuccess(this.ttActService.update(vo));
            } else {
                vo.setActType(ConstantEnum.ACTTYPE.departuse.getVal());
                j.setSuccess(this.ttActService.save(vo));
            }
        }
        catch (BusinessException businessException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"goUpdateOrAddDetail"})
    public ModelAndView goUpdateOrAddDetail(HttpServletRequest request, TtActDetailVo vo) {
        TtActDetailEntity entity = new TtActDetailEntity();
        String tempUuid = vo.getTempUuid();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtActDetailEntity)this.ttActDetailService.selectByPrimaryKey(vo.getId());
            tempUuid = entity.getTempUuid();
        }
        request.setAttribute("budgetCode", (Object)vo.getBudgetCode());
        request.setAttribute("vo", (Object)entity);
        request.setAttribute("tempUuid", (Object)tempUuid);
        return new ModelAndView("com/biz/eisp/act/departuse/TtActDepartUseDetailForm");
    }

    @RequestMapping(value={"saveOrUpdateDetail"})
    @ResponseBody
    public AjaxJson saveOrUpdateDetail(TtActDetailVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isBlank((CharSequence)vo.getId())) {
                vo.setActType(ConstantEnum.ACTTYPE.departuse.getVal());
                j.setSuccess(this.ttActDetailService.saveDetail(vo, j));
            } else {
                vo.setActType(ConstantEnum.ACTTYPE.departuse.getVal());
                j.setSuccess(this.ttActDetailService.updateDetail(vo, j));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delDetail"})
    @ResponseBody
    public AjaxJson delDetail(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActDetailService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delProduct"})
    @ResponseBody
    public AjaxJson delProduct(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttActProductService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"findTtActDepartUseDetailPage"})
    @ResponseBody
    public DataGrid findTtActDepartUseDetailPage(HttpServletRequest request, TtActDetailVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActDetailVo> info = this.ttActService.findTtActDetailPage(vo, (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtAct"})
    public AjaxJson deleteTtActAdvance(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                this.ttActService.delByIds(ids);
            }
        }
        catch (RuntimeException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            j.setSuccess(false);
            e.printStackTrace();
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }
}

