/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.saledata.service.impl;

import com.biz.eisp.act.saledata.dao.TtRealSalesDataDao;
import com.biz.eisp.act.saledata.entity.TtRealSalesDataEntity;
import com.biz.eisp.act.saledata.service.TtRealSalesDataService;
import com.biz.eisp.act.saledata.vo.TtRealSalesDataVo;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttRealSalesDataService")
@Transactional
public class TtRealSalesDataServiceImpl
extends BaseServiceImpl<TtRealSalesDataEntity>
implements TtRealSalesDataService {
    @Autowired
    private TtRealSalesDataDao ttRealSalesDataDao;

    @Override
    public PageInfo<TtRealSalesDataVo> findTtRealSalesDataPage(TtRealSalesDataVo entity, Page page) {
        Example example = new Example(TtRealSalesDataEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)entity.getEnableStatus())) {
            criteria.andEqualTo("enableStatus", (Object)entity.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrderSn())) {
            criteria.andEqualTo("orderSn", (Object)entity.getOrderSn());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getRsYear())) {
            criteria.andEqualTo("rsYear", (Object)entity.getRsYear());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getRsMonth())) {
            criteria.andEqualTo("rsMonth", (Object)entity.getRsMonth());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustomerCode())) {
            criteria.andLike("customerCode", "%" + entity.getCustomerCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustomerName())) {
            criteria.andLike("customerName", "%" + entity.getCustomerName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getTerminalCode())) {
            criteria.andLike("terminalCode", "%" + entity.getTerminalCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getTerminalName())) {
            criteria.andLike("terminalName", "%" + entity.getTerminalName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getProductCode())) {
            criteria.andLike("productCode", "%" + entity.getProductCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getProductName())) {
            criteria.andLike("productName", "%" + entity.getProductName() + "%");
        }
        if (StringUtil.isNotEmpty((Object)entity.getNum())) {
            criteria.andEqualTo("num", (Object)entity.getNum());
        }
        if (StringUtil.isNotEmpty((Object)entity.getPrice())) {
            criteria.andEqualTo("price", (Object)entity.getPrice());
        }
        if (StringUtil.isNotEmpty((Object)entity.getTotalAmount())) {
            criteria.andEqualTo("totalAmount", (Object)entity.getTotalAmount());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar1())) {
            criteria.andLike("extChar1", "%" + entity.getExtChar1() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar2())) {
            criteria.andLike("extChar2", "%" + entity.getExtChar2() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar3())) {
            criteria.andLike("extChar3", "%" + entity.getExtChar3() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar4())) {
            criteria.andLike("extChar4", "%" + entity.getExtChar4() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar5())) {
            criteria.andLike("extChar5", "%" + entity.getExtChar5() + "%");
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttRealSalesDataDao.selectByExample(example), (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TtRealSalesDataServiceImpl.class)
    public boolean delete(String id) {
        int i = this.ttRealSalesDataDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public List<TtRealSalesDataVo> getTtRealSalesDataVoList(TtRealSalesDataVo vo) {
        return this.ttRealSalesDataDao.getTtRealSalesDataVoList(vo);
    }

    @Override
    public TtRealSalesDataEntity getTtRealSalesDataEntity(String id) {
        return (TtRealSalesDataEntity)this.ttRealSalesDataDao.selectByPrimaryKey(id);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtRealSalesDataServiceImpl.class)
    public void save(TtRealSalesDataVo vo) throws Exception {
        TtRealSalesDataEntity entity = new TtRealSalesDataEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            entity.setOrderSn(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_order_code.name()));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            entity.setOrderDate(format.format(new Date()));
            this.insertSelective(entity);
        }
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtRealSalesDataServiceImpl.class)
    public void update(TtRealSalesDataVo vo) throws Exception {
        TtRealSalesDataEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtRealSalesDataEntity)this.ttRealSalesDataDao.selectByPrimaryKey(vo.getId());
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.updateByPrimaryKeySelective(entity);
        }
    }
}

