/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.service.impl;

import com.biz.eisp.act.dao.TtActDao;
import com.biz.eisp.act.dao.TtActDetailDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.ActEndService;
import com.biz.eisp.audit.dao.TtAuditActDao;
import com.biz.eisp.audit.dao.TtAuditActDetailDao;
import com.biz.eisp.audit.dao.TtAuditDao;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.tools.CodeRuleUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class ActEndServiceImpl
implements ActEndService {
    @Autowired
    private TtActDao ttActDao;
    @Autowired
    private TtActDetailDao ttActDetailDao;
    @Autowired
    private TtCostTypeFineService ttCostTypeFineService;
    @Autowired
    private TtAuditActDao ttAuditActDao;
    @Autowired
    private TtAuditActDetailDao ttAuditActDetailDao;
    @Autowired
    private TtAuditDao ttAuditDao;

    @Override
    public void actEnd(String actType, String id) {
        if (ConstantEnum.ACTTYPE.quota.getVal().equals(actType)) {
            this.doQuotaAct(id);
        }
    }

    private void doQuotaAct(String id) {
        TtActEntity entity = (TtActEntity)this.ttActDao.selectByPrimaryKey(id);
        if (entity == null) {
            return;
        }
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actCode", (Object)entity.getActCode());
        List entities = this.ttActDetailDao.selectByExample(example);
        ArrayList<TtActDetailEntity> toDoDetailList = new ArrayList<TtActDetailEntity>();
        for (TtActDetailEntity actDetailEntity : entities) {
            TtCostTypeFineEntity costTypeFineEntity;
            String actSubclassCode = actDetailEntity.getActSubclassCode();
            if (StringUtil.isEmpty((String)actSubclassCode) || (costTypeFineEntity = this.ttCostTypeFineService.getFineEntity(null, actSubclassCode)) == null || !StringUtil.equals((String)costTypeFineEntity.getIsAudit(), (String)ConstantEnum.YesNoEnum.ZERO.getValue())) continue;
            toDoDetailList.add(actDetailEntity);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(toDoDetailList)) {
            this.saveAtuit(toDoDetailList, entity);
        }
    }

    private void saveAtuit(List<TtActDetailEntity> detailEntitys, TtActEntity entity) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(detailEntitys)) {
            return;
        }
        TtAuditEntity ttAuditEntity = this.createTtAuditEntity(entity);
        TtAuditActEntity actEntity = this.createTtAuditActEntity(ttAuditEntity, entity);
        ArrayList<TtAuditActDetailEntity> auditActDetailEntities = new ArrayList<TtAuditActDetailEntity>();
        for (TtActDetailEntity detailEntity : detailEntitys) {
            TtAuditActDetailEntity ttAuditActDetailEntity = this.createDetail(detailEntity, entity, ttAuditEntity);
            auditActDetailEntities.add(ttAuditActDetailEntity);
        }
        this.ttAuditDao.insertSelective(ttAuditEntity);
        this.ttAuditActDao.insertSelective(actEntity);
        this.ttAuditActDetailDao.insertList(auditActDetailEntities);
    }

    private TtAuditEntity createTtAuditEntity(TtActEntity entity) {
        TtAuditEntity ttAuditEntity = new TtAuditEntity();
        ttAuditEntity.setBpmStatus(ConstantEnum.bpmStatus.PASS.getValue());
        ttAuditEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        ttAuditEntity.setAuditCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_head.name()));
        ttAuditEntity.setAuditName(entity.getActName() + "(\u81ea\u52a8\u6838\u9500)");
        ttAuditEntity.setTempUuid("tempuuid" + UUIDGenerator.generate());
        return ttAuditEntity;
    }

    private TtAuditActEntity createTtAuditActEntity(TtAuditEntity ttAuditEntity, TtActEntity entity) {
        TtAuditActEntity actEntity = new TtAuditActEntity();
        actEntity.setAuditCode(ttAuditEntity.getAuditCode());
        actEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        actEntity.setActCode(entity.getActCode());
        actEntity.setActName(entity.getActName());
        actEntity.setTempUuid(entity.getTempUuid());
        return actEntity;
    }

    private TtAuditActDetailEntity createDetail(TtActDetailEntity detailEntity, TtActEntity entity, TtAuditEntity ttAuditEntity) {
        TtAuditActDetailEntity ttAuditActDetailEntity = new TtAuditActDetailEntity();
        ttAuditActDetailEntity.setCustomerCode(detailEntity.getCustomerCode());
        ttAuditActDetailEntity.setCustomerName(detailEntity.getCustomerName());
        ttAuditActDetailEntity.setFeeUsed(BigDecimal.ZERO);
        ttAuditActDetailEntity.setAuditCode(ttAuditEntity.getAuditCode());
        ttAuditActDetailEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        ttAuditActDetailEntity.setAuditDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_detail.name()));
        ttAuditActDetailEntity.setActDetailCode(detailEntity.getActDetailCode());
        ttAuditActDetailEntity.setActCode(entity.getActCode());
        ttAuditActDetailEntity.setActSubclassCode(detailEntity.getActSubclassCode());
        ttAuditActDetailEntity.setActSubclassName(detailEntity.getActSubclassName());
        ttAuditActDetailEntity.setTerminalCode(detailEntity.getTerminalCode());
        ttAuditActDetailEntity.setTerminalName(detailEntity.getTerminalName());
        ttAuditActDetailEntity.setPayType(detailEntity.getPayType());
        ttAuditActDetailEntity.setAmount(detailEntity.getAmount());
        ttAuditActDetailEntity.setAuditAmount(detailEntity.getAmount());
        ttAuditActDetailEntity.setCurrentAmount(detailEntity.getAmount());
        ttAuditActDetailEntity.setTempUuid(ttAuditEntity.getTempUuid());
        return ttAuditActDetailEntity;
    }
}

