/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.service.impl;

import com.biz.eisp.act.dao.TtActDetailDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.actcheck.common.SfaConstantEnum;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.entity.TtCostTypeFineDetailEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtActDetailServiceImpl
extends BaseServiceImpl<TtActDetailEntity>
implements TtActDetailService {
    private final String cust_type = "01";
    private final String terminal_type = "02";
    @Autowired
    private TtActDetailDao ttActDetailDao;
    @Autowired
    private TtCostTypeFineService ttCostTypeFineService;
    @Autowired
    private TtActService ttActService;

    @Override
    public boolean saveDetail(TtActDetailVo detailVo, AjaxJson j) throws Exception {
        TtActDetailEntity entity = new TtActDetailEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
        int i = this.insertSelective(entity);
        return i > 0;
    }

    @Override
    public Integer checkShareProduct(String tempUuid) {
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)tempUuid);
        criteria.andEqualTo("needShare", (Object)"1");
        int count = this.ttActDetailDao.selectCountByExample(example);
        return count;
    }

    @Override
    public boolean updateDetail(TtActDetailVo detailVo, AjaxJson j) throws Exception {
        int i;
        TtActDetailEntity entity = new TtActDetailEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.UPDATE.getValue());
        MyBeanUtils.copyBeanNotNull2Bean((Object)detailVo, (Object)entity);
        if (detailVo.getActType().equals(ConstantEnum.ACTTYPE.price.getVal())) {
            String actDetailType;
            switch (actDetailType = entity.getActDetailType()) {
                case "discount_custom_product": {
                    entity.setProductNum(0);
                    entity.setGiftNum(0);
                    entity.setTerminalCode("");
                    entity.setTerminalName("");
                    entity.setPriceGroup("");
                    break;
                }
                case "buy_custom_product": {
                    entity.setPriceGroup("");
                    entity.setTerminalCode("");
                    entity.setTerminalName("");
                    entity.setPriceGroup("");
                    break;
                }
                case "discount_product": {
                    entity.setCustomerCode("");
                    entity.setCustomerName("");
                    entity.setTerminalCode("");
                    entity.setTerminalName("");
                    entity.setPriceGroup("");
                    break;
                }
                case "buy_product": {
                    entity.setPriceGroup("");
                    entity.setCustomerCode("");
                    entity.setCustomerName("");
                    entity.setTerminalCode("");
                    entity.setTerminalName("");
                    entity.setPriceGroup("");
                    break;
                }
                case "discount_group_product": {
                    entity.setProductNum(0);
                    entity.setGiftNum(0);
                    entity.setCustomerCode("");
                    entity.setCustomerName("");
                    entity.setTerminalCode("");
                    entity.setTerminalName("");
                    break;
                }
                case "discount_dept_product": {
                    entity.setProductNum(0);
                    entity.setGiftNum(0);
                    entity.setCustomerCode("");
                    entity.setCustomerName("");
                    entity.setPriceGroup("");
                    break;
                }
                case "buy_dept_product": {
                    entity.setPriceGroup("");
                    entity.setCustomerCode("");
                    entity.setCustomerName("");
                    entity.setPriceGroup("");
                    break;
                }
            }
        }
        return (i = this.updateByPrimaryKeySelective(entity).intValue()) > 0;
    }

    @Override
    public PageInfo<TtActDetailVo> findTtActDetailByActsPage(TtActDetailVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttActDetailDao.findTtActDetailListByActs(vo), (Page)page);
    }

    @Override
    public List<TtActDetailVo> findTtActDetailByQuery(TtActDetailVo vo) {
        return this.ttActDetailDao.findTtActDetailByQuery(vo);
    }

    @Override
    public List<TtActDetailVo> findActDetailByCon(String clientCode, String clientType) {
        List<TtActDetailVo> list = this.ttActDetailDao.findActDetailByCon(clientCode, clientType);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.stream().filter(dd -> StringUtils.isNotBlank((String)dd.getDiscernModel())).forEach(item -> {
                Map map;
                KnlDictDataEntity data = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_project_group.getVal(), (String)item.getDiscernModel());
                if (data != null && (map = data.getExtendMap()) != null && map.size() > 0) {
                    String a = OConvertUtils.getString(map.get(SfaConstantEnum.aiProject.project_a.getVal()));
                    String b = OConvertUtils.getString(map.get(SfaConstantEnum.aiProject.project_b.getVal()));
                    String c = OConvertUtils.getString(map.get(SfaConstantEnum.aiProject.project_c.getVal()));
                    ArrayList<String> modelProjectNameList = new ArrayList<String>();
                    if (StringUtil.isNotEmpty((CharSequence)a)) {
                        KnlDictDataEntity aStr = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_model_project.getVal(), (String)a);
                        modelProjectNameList.add(aStr.getDictValue());
                    }
                    if (StringUtil.isNotEmpty((CharSequence)b)) {
                        KnlDictDataEntity bStr = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_model_project.getVal(), (String)b);
                        modelProjectNameList.add(bStr.getDictValue());
                    }
                    if (StringUtil.isNotEmpty((CharSequence)c)) {
                        KnlDictDataEntity cStr = DictUtil.getDicData((String)SfaConstantEnum.aiProject.ai_model_project.getVal(), (String)c);
                        modelProjectNameList.add(cStr.getDictValue());
                    }
                    item.setModelProjectName(((Object)modelProjectNameList).toString().replace("[", "").replace("]", ""));
                }
            });
        }
        return list;
    }

    @Override
    public List<TtActDetailEntity> findDetailByCodes(List<String> codes) {
        List<TtActDetailEntity> detailEntities = new ArrayList<TtActDetailEntity>();
        if (CollectionUtil.listEmpty(codes)) {
            return detailEntities;
        }
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actDetailCode", codes);
        detailEntities = this.ttActDetailDao.selectByExample(example);
        return detailEntities;
    }

    @Override
    public List<TtActDetailEntity> findDetailByActCodes(List<String> actCodes) {
        List<TtActDetailEntity> detailEntities = new ArrayList<TtActDetailEntity>();
        if (CollectionUtil.listEmpty(actCodes)) {
            return detailEntities;
        }
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actCode", actCodes);
        detailEntities = this.ttActDetailDao.selectByExample(example);
        return detailEntities;
    }

    @Override
    public AjaxJson saveAuditAmountForAct(String actDetailCode, BigDecimal auditAmount, String auditStatus, String status) {
        AjaxJson ajaxJson = new AjaxJson();
        String string = auditStatus = StringUtil.isBlank((CharSequence)auditStatus) ? ConstantEnum.YesNoEnum.ZERO.getValue() : auditStatus;
        if (StringUtil.isBlank((CharSequence)actDetailCode) || auditAmount == null || StringUtil.isBlank((CharSequence)status)) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        TtActDetailEntity entity = this.getEntity(null, actDetailCode);
        if (entity == null) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        if (ConstantEnum.YesNoEnum.ONE.getValue().equals(status)) {
            ajaxJson = this.checkActDetail(actDetailCode, auditAmount);
            if (!ajaxJson.isSuccess()) {
                return ajaxJson;
            }
            auditStatus = this.checkActDetailAuditStatus(ajaxJson, auditStatus, entity, auditAmount);
        } else {
            auditStatus = ConstantEnum.YesNoEnum.ZERO.getValue();
            auditAmount = auditAmount.multiply(new BigDecimal(-1));
        }
        BigDecimal amount = entity.getAuditAmount().add(auditAmount);
        TtActDetailEntity updateEntity = new TtActDetailEntity();
        updateEntity.setAuditAmount(amount);
        updateEntity.setId(entity.getId());
        updateEntity.setAuditStatus(auditStatus);
        this.ttActDetailDao.updateByPrimaryKeySelective(updateEntity);
        return ajaxJson;
    }

    private String checkActDetailAuditStatus(AjaxJson ajaxJson, String auditStatus, TtActDetailEntity entity, BigDecimal auditAmount) {
        if (ConstantEnum.YesNoEnum.ZERO.getValue().equals(auditStatus)) {
            Map attributes = ajaxJson.getAttributes();
            TtCostTypeFineEntity costTypeFineEntity = (TtCostTypeFineEntity)attributes.get("costTypeFineEntity");
            if (StringUtil.equals((String)ConstantEnum.YesNoEnum.ZERO.getValue(), (String)costTypeFineEntity.getIsMultipleAudit())) {
                auditStatus = ConstantEnum.YesNoEnum.ZERO.getValue();
            } else {
                BigDecimal amount;
                BigDecimal maxAmount = (BigDecimal)attributes.get("maxAmount");
                if (maxAmount.compareTo(amount = entity.getAuditAmount().add(auditAmount)) == 0) {
                    auditStatus = ConstantEnum.YesNoEnum.ZERO.getValue();
                }
            }
        }
        return auditStatus;
    }

    @Override
    public TtActDetailEntity getEntity(String id, String actDetailCode) {
        if (StringUtil.isBlank((CharSequence)id) && StringUtil.isBlank((CharSequence)actDetailCode)) {
            return null;
        }
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            return (TtActDetailEntity)this.ttActDetailDao.selectByPrimaryKey(id);
        }
        if (StringUtil.isNotEmpty((CharSequence)actDetailCode)) {
            Example example = new Example(TtActDetailEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("actDetailCode", (Object)actDetailCode);
            List detailEntities = this.ttActDetailDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)detailEntities)) {
                return (TtActDetailEntity)detailEntities.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public AjaxJson checkActDetail(String actDetailCode, BigDecimal auditAmount) {
        AjaxJson ajaxJson = new AjaxJson();
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        TtActDetailEntity entity = this.getEntity(null, actDetailCode);
        TtCostTypeFineEntity costTypeFineEntity = this.ttCostTypeFineService.getFineEntity(null, entity.getActSubclassCode());
        String isMultipleAudit = costTypeFineEntity.getIsMultipleAudit();
        if (StringUtil.equals((String)ConstantEnum.YesNoEnum.ZERO.getValue(), (String)isMultipleAudit) && StringUtil.equals((String)entity.getAuditStatus(), (String)ConstantEnum.YesNoEnum.ONE.getValue())) {
            throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + "\u53ea\u80fd\u6838\u9500\u4e00\u6b21");
        }
        ArrayList<String> rules = new ArrayList<String>();
        rules.add(ConstantEnum.FIELD_NAME.above_audit.name());
        Map<String, List<TtCostTypeFineDetailEntity>> map = this.ttCostTypeFineService.findCostTypeCons(actDetailCode, rules);
        BigDecimal maxAmount = BigDecimal.ZERO;
        BigDecimal amount = entity.getAuditAmount() == null ? BigDecimal.ZERO : entity.getAuditAmount();
        amount = amount.add(auditAmount);
        if (map.isEmpty() || !map.containsKey(ConstantEnum.FIELD_NAME.above_audit.name())) {
            maxAmount = entity.getAmount();
            if (amount.compareTo(maxAmount) > 0) {
                throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + " \u5df2\u7ecf\u6838\u9500\u91d1\u989d" + entity.getAuditAmount() + "\u672c\u6b21\u6838\u9500\u91d1\u989d" + auditAmount + " \u8d85\u8fc7\u6700\u5927\u53ef\u6838\u9500\u91d1\u989d" + maxAmount);
            }
        } else {
            BigDecimal extraAuditRatio = costTypeFineEntity.getExtraAuditRatio();
            extraAuditRatio = extraAuditRatio == null ? BigDecimal.ZERO : extraAuditRatio;
            maxAmount = entity.getAmount().multiply(extraAuditRatio).divide(new BigDecimal(100)).add(entity.getAmount());
            if (amount.compareTo(maxAmount) > 0) {
                throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + " \u5df2\u7ecf\u6838\u9500\u91d1\u989d" + entity.getAuditAmount() + "\u672c\u6b21\u6838\u9500\u91d1\u989d" + auditAmount + " \u8d85\u8fc7\u6700\u5927\u53ef\u6838\u9500\u91d1\u989d" + maxAmount);
            }
        }
        attributes.put("costTypeFineEntity", costTypeFineEntity);
        attributes.put("maxAmount", maxAmount);
        ajaxJson.setAttributes(attributes);
        return ajaxJson;
    }

    @Override
    public PageInfo<TtActDetailVo> findTtActDetailListPage(TtActDetailVo vo, Page page) {
        List<TtActDetailVo> list = this.ttActDetailDao.findTtActDetailListPage(vo);
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> list, (Page)page);
        return pageInfo;
    }
}

