/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.audit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.audit.dao.TtAuditActDetailDao;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.audit.service.TtAuditActDetailService;
import com.biz.eisp.audit.service.TtAuditService;
import com.biz.eisp.audit.vo.TtAuditActDetailVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtAuditActDetailServiceImpl
extends BaseServiceImpl<TtAuditActDetailEntity>
implements TtAuditActDetailService {
    @Autowired
    private TtAuditActDetailDao ttAuditActDetailDao;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtAuditService ttAuditService;

    @Override
    public List<TtAuditActDetailEntity> findTtAuditActDetailList(TtAuditActDetailVo vo) {
        Example example = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)vo.getTempUuid());
        List actDetailEntities = this.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actDetailEntities)) {
            List<String> actDetailCodes = actDetailEntities.stream().map(TtAuditActDetailEntity::getActDetailCode).collect(Collectors.toList());
            List<TtActDetailEntity> entities = this.ttActDetailService.findDetailByCodes(actDetailCodes);
            Map<String, BigDecimal> map = entities.stream().collect(Collectors.toMap(TtActDetailEntity::getActDetailCode, TtActDetailEntity::getAuditAmount));
            for (TtAuditActDetailEntity entity : actDetailEntities) {
                if (map.containsKey(entity.getActDetailCode()) && map.get(entity.getActDetailCode()) != null) {
                    entity.setAuditAmount(map.get(entity.getActDetailCode()));
                    continue;
                }
                entity.setAuditAmount(BigDecimal.ZERO);
            }
        }
        return actDetailEntities;
    }

    @Override
    public PageInfo<TtAuditActDetailEntity> findAuditDetailSelectPage(TtAuditActDetailEntity entity, Page page) {
        Example example = new Example(TtAuditActDetailEntity.class);
        example.setOrderByClause("id");
        Example.Criteria criteria = example.createCriteria();
        criteria.andNotEqualTo("enableStatus", (Object)ConstantEnum.StatusEnum.DELETE.getValue());
        criteria.andCondition(" audit_code in  (select a.audit_code from tt_audit a where a.bpm_status = 3 ) ");
        criteria.andCondition(" current_amount - ifnull(fee_used,0) >0 ");
        return PageAutoHelperUtil.generatePage(() -> this.selectExample(example), (Page)page);
    }

    @Override
    public void saveAuditActDetail(String tempUuid, String acts) {
        if (StringUtils.isBlank((CharSequence)tempUuid)) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u51fa\u9519\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u5173\u7cfb\uff01");
        }
        JSONArray jsonArray = JSONArray.parseArray((String)acts);
        if (jsonArray != null && jsonArray.size() > 0) {
            ArrayList<TtAuditActDetailEntity> list = new ArrayList<TtAuditActDetailEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                TtActDetailEntity ttActEntity = (TtActDetailEntity)this.ttActDetailService.selectByPrimaryKey(object.getString("id"));
                Example example = new Example(TtActDetailEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("actCode", (Object)ttActEntity.getActCode());
                criteria.andEqualTo("actDetailCode", (Object)ttActEntity.getActDetailCode());
                criteria.andEqualTo("tempUuid", (Object)tempUuid);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)this.ttActDetailService.selectExample(example))) continue;
                TtAuditActDetailEntity entity = new TtAuditActDetailEntity();
                entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                entity.setTempUuid(tempUuid);
                entity.setActDetailCode(ttActEntity.getActDetailCode());
                entity.setActSubclassCode(ttActEntity.getActSubclassCode());
                entity.setActSubclassName(ttActEntity.getActSubclassName());
                entity.setActRemarks(ttActEntity.getRemarks());
                entity.setAuditRemarks(ttActEntity.getRemarks());
                entity.setTerminalCode(ttActEntity.getTerminalCode());
                entity.setTerminalName(ttActEntity.getTerminalName());
                entity.setCustomerCode(ttActEntity.getCustomerCode());
                entity.setCustomerName(ttActEntity.getCustomerName());
                entity.setCurrentAmount(ttActEntity.getAmount());
                entity.setPayType(ttActEntity.getPayType());
                entity.setAmount(ttActEntity.getAmount());
                list.add(entity);
            }
            list.forEach(item -> this.insertSelective(item));
        }
    }

    @Override
    public void updateAuditActDetail(String saveDatas) {
        JSONArray jsonArray = JSON.parseArray((String)saveDatas);
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                TtAuditActDetailVo vo = (TtAuditActDetailVo)JSONObject.toJavaObject((JSON)jsonArray.getJSONObject(i), TtAuditActDetailVo.class);
                TtAuditActDetailEntity entity = new TtAuditActDetailEntity();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
                }
                catch (Exception e) {
                    throw new BusinessException("\u6570\u636e\u5f02\u5e38");
                }
                this.updateByPrimaryKeySelective(entity);
            }
        }
    }

    @Override
    public List<TtAuditActDetailEntity> getCodes(List<String> codes) {
        Example example = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("auditDetailCode", codes);
        List list = this.selectExample(example);
        return list;
    }

    @Override
    public void updateUsedAmount(String code, BigDecimal feeUsed) {
        Example example = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("auditDetailCode", (Object)code);
        List list = this.selectExample(example);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)list) || list.size() != 1) {
            throw new BusinessException("\u6838\u9500\u660e\u7ec6\u7f16\u53f7:" + code + "\u4e0d\u5b58\u5728");
        }
        TtAuditActDetailEntity entity = (TtAuditActDetailEntity)list.get(0);
        BigDecimal feeUsedOld = entity.getFeeUsed() == null ? BigDecimal.ZERO : entity.getFeeUsed();
        TtAuditActDetailEntity entityNew = new TtAuditActDetailEntity();
        entityNew.setId(entity.getId());
        entityNew.setFeeUsed(feeUsedOld.add(feeUsed));
        this.updateByPrimaryKeySelective(entityNew);
    }

    @Override
    public List<TtAuditActDetailEntity> getDetailsByCodeAndId(String auditCode, String id) {
        if (StringUtils.isBlank((CharSequence)auditCode) && StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)auditCode)) {
            return this.getDetailsByCode(auditCode);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            TtAuditEntity entity = this.ttAuditService.getEntity(id, auditCode);
            return this.getDetailsByCode(entity.getAuditCode());
        }
        return null;
    }

    private List<TtAuditActDetailEntity> getDetailsByCode(String auditCode) {
        Example example = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("auditCode", (Object)auditCode);
        return this.selectExample(example);
    }

    @Override
    public PageInfo<TtAuditActDetailVo> findTtAuditActDetailListPage(TtAuditActDetailVo vo, Page page) {
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttAuditActDetailDao.findTtAuditActDetailListPage(vo), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            List<String> actDetailCodes = pageInfo.getList().stream().map(TtAuditActDetailVo::getActDetailCode).collect(Collectors.toList());
            List<TtActDetailEntity> entities = this.ttActDetailService.findDetailByCodes(actDetailCodes);
            Map<String, BigDecimal> map = entities.stream().collect(Collectors.toMap(TtActDetailEntity::getActDetailCode, TtActDetailEntity::getAuditAmount));
            for (TtAuditActDetailVo entity : pageInfo.getList()) {
                if (map.containsKey(entity.getActDetailCode()) && map.get(entity.getActDetailCode()) != null) {
                    entity.setAuditAmount(map.get(entity.getActDetailCode()));
                    continue;
                }
                entity.setAuditAmount(BigDecimal.ZERO);
            }
        }
        return pageInfo;
    }
}

