/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ttCostTypeController"})
public class TtCostTypeController {
    @Autowired
    private TtCostTypeCategoriesService ttCostTypeCategoriesService;
    @Autowired
    private TtCostTypeFineService ttCostTypeFineService;

    @RequestMapping(value={"goCategoriesMain"})
    public ModelAndView goCategoriesMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/budget/config/categoriesMain");
    }

    @RequestMapping(value={"getCategoriesListPage"})
    @ResponseBody
    public DataGrid getCategoriesListPage(HttpServletRequest request, TtCostTypeCategoriesEntity ttCostTypeCategoriesEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtCostTypeCategoriesEntity> pageInfo = this.ttCostTypeCategoriesService.getMaiList(ttCostTypeCategoriesEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goFineMain"})
    public ModelAndView goFineMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/budget/config/fineMain");
    }

    @RequestMapping(value={"getFineListPage"})
    @ResponseBody
    public DataGrid getFineListPage(HttpServletRequest request, TtCostTypeFineEntity ttCostTypeFineEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtCostTypeFineEntity> pageInfo = this.ttCostTypeFineService.getMaiList(ttCostTypeFineEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goCategoriesSaveOrUpdate"})
    public ModelAndView goCategoriesSaveOrUpdate(HttpServletRequest request, String id, String show, String clickFunctionId) {
        request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            TtCostTypeCategoriesEntity entity = this.ttCostTypeCategoriesService.getCategoriesEntity(id, null);
            request.setAttribute("vo", (Object)entity);
        }
        show = StringUtil.isEmpty((String)show) ? "0" : "1";
        request.setAttribute("show", (Object)show);
        return new ModelAndView("com/biz/eisp/budget/config/categoriesMainForm");
    }

    @RequestMapping(value={"goFineSaveOrUpdate"})
    public ModelAndView goFineSaveOrUpdate(HttpServletRequest request, String id, String clickFunctionId) {
        request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            TtCostTypeFineEntity entity = this.ttCostTypeFineService.getFineEntity(id, null);
            request.setAttribute("vo", (Object)entity);
        }
        return new ModelAndView("com/biz/eisp/budget/config/fineMainForm");
    }

    @RequestMapping(value={"stopCategories"})
    @ResponseBody
    public AjaxJson deleteCategories(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttCostTypeCategoriesService.stopOrstartCategories(id, ajaxJson, ConstantEnum.StatusEnum.DELETE.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"startCategories"})
    @ResponseBody
    public AjaxJson startCategories(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttCostTypeCategoriesService.stopOrstartCategories(id, ajaxJson, ConstantEnum.StatusEnum.NEW.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdateCategories"})
    @ResponseBody
    public AjaxJson saveOrUpdateCategories(HttpServletRequest request, TtCostTypeCategoriesEntity categoriesEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)categoriesEntity.getId())) {
            ajaxJson = this.ttCostTypeCategoriesService.save(categoriesEntity, ajaxJson);
        } else {
            TtCostTypeCategoriesEntity entity = this.ttCostTypeCategoriesService.getCategoriesEntity(categoriesEntity.getId(), null);
            categoriesEntity.setEnableStatus(entity.getEnableStatus());
            ajaxJson = this.ttCostTypeCategoriesService.update(categoriesEntity, ajaxJson);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"stopFine"})
    @ResponseBody
    public AjaxJson stopFine(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttCostTypeFineService.stopOrStartFine(id, ajaxJson, ConstantEnum.StatusEnum.DELETE.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"startFine"})
    @ResponseBody
    public AjaxJson startFine(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttCostTypeFineService.stopOrStartFine(id, ajaxJson, ConstantEnum.StatusEnum.NEW.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdateFine"})
    @ResponseBody
    public AjaxJson saveOrUpdateFine(HttpServletRequest request, TtCostTypeFineEntity costTypeFineEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isEmpty((String)costTypeFineEntity.getId()) ? this.ttCostTypeFineService.save(costTypeFineEntity, ajaxJson) : this.ttCostTypeFineService.update(costTypeFineEntity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"goFineSelectMain"})
    public ModelAndView goFineSelectMain(HttpServletRequest request, String dataType) {
        request.setAttribute("dataType", (Object)dataType);
        return new ModelAndView("com/biz/eisp/budget/config/fineSelectMain");
    }

    @RequestMapping(value={"getSelectFinePage"})
    @ResponseBody
    public DataGrid getSelectFinePage(HttpServletRequest request, TtCostTypeFineEntity ttCostTypeFineEntity, String dataType) {
        EuPage page = new EuPage(request);
        PageInfo<TtCostTypeFineEntity> pageInfo = this.ttCostTypeFineService.getSelectFinePage(ttCostTypeFineEntity, dataType, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getFineListByCategories"})
    @ResponseBody
    public DataGrid getFineListByCategories(HttpServletRequest request, String code) {
        PageInfo pageInfo = new PageInfo();
        List<TtCostTypeFineEntity> list = this.ttCostTypeFineService.getFinesByCategoriesCode(code);
        pageInfo.setList(list);
        return new DataGrid(pageInfo);
    }

    @ResponseBody
    @RequestMapping(value={"deleteCategories"})
    public AjaxJson deleteCategories(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttCostTypeCategoriesService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }
}

