/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.saledata.controller;

import com.biz.eisp.act.saledata.entity.TtRealSalesDataEntity;
import com.biz.eisp.act.saledata.service.TtRealSalesDataService;
import com.biz.eisp.act.saledata.vo.TtRealSalesDataExcelVo;
import com.biz.eisp.act.saledata.vo.TtRealSalesDataVo;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.base.ImpExpController;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.vo.ExcelDate;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ttRealSalesDataController"})
public class TtRealSalesDataController
extends ImpExpController {
    @Autowired
    private TtRealSalesDataService ttRealSalesDataService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtActService ttActService;

    @RequestMapping(value={"goTtRealSalesDataMain"})
    public ModelAndView goTtSalesPlansMain(HttpServletRequest request, String id) {
        return new ModelAndView("com/biz/eisp/act/saledata/ttRealSalesDataMain");
    }

    @RequestMapping(value={"findTtRealSalesDataPage"})
    @ResponseBody
    public DataGrid findTtRealSalesDataPage(HttpServletRequest request, TtRealSalesDataVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtRealSalesDataVo> ttRealSalesDataVoPageInfo = this.ttRealSalesDataService.findTtRealSalesDataPage(vo, (Page)page);
        if (ttRealSalesDataVoPageInfo != null) {
            return new DataGrid(ttRealSalesDataVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"goSaveOrUpdate"})
    public ModelAndView goSaveOrUpdate(HttpServletRequest request, TtRealSalesDataVo vo, String clickFunctionId) {
        request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        if (vo != null && StringUtils.isNotBlank((CharSequence)vo.getId())) {
            TtRealSalesDataEntity entity = this.ttRealSalesDataService.getTtRealSalesDataEntity(vo.getId());
            request.setAttribute("vo", (Object)entity);
        }
        return new ModelAndView("com/biz/eisp/act/saledata/ttRealSalesDataForm");
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(TtRealSalesDataVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.ttRealSalesDataService.update(vo);
            } else {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                vo.setOrderDate(format.format(new Date()));
                this.ttRealSalesDataService.save(vo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtRealSalesData"})
    public AjaxJson deleteTtRealSalesData(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttRealSalesDataService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    protected AjaxJson checkImportList(List importList, ExcelDate excelDate) {
        return null;
    }

    protected AjaxJson doImportList(List importList, ExcelDate excelDate) {
        AjaxJson j = new AjaxJson();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)importList)) {
            importList.forEach(item -> {
                TtRealSalesDataExcelVo ttRealSalesDataExcelVo = (TtRealSalesDataExcelVo)item;
                TtRealSalesDataVo vo = new TtRealSalesDataVo();
                vo.setOrderDate(ttRealSalesDataExcelVo.getOrderDate());
                vo.setOrderSn(ttRealSalesDataExcelVo.getOrderSn());
                vo.setEnableStatus(ttRealSalesDataExcelVo.getEnableStatus());
                vo.setCustomerCode(ttRealSalesDataExcelVo.getCustomerCode());
                vo.setCustomerName(ttRealSalesDataExcelVo.getCustomerName());
                vo.setNum(ttRealSalesDataExcelVo.getNum());
                vo.setPrice(ttRealSalesDataExcelVo.getPrice());
                vo.setProductCode(ttRealSalesDataExcelVo.getProductCode());
                vo.setProductName(ttRealSalesDataExcelVo.getProductName());
                vo.setRsMonth(ttRealSalesDataExcelVo.getRsMonth());
                vo.setRsYear(ttRealSalesDataExcelVo.getRsYear());
                vo.setTerminalCode(ttRealSalesDataExcelVo.getTerminalCode());
                vo.setTerminalName(ttRealSalesDataExcelVo.getTerminalName());
                vo.setTotalAmount(ttRealSalesDataExcelVo.getTotalAmount());
                try {
                    this.ttRealSalesDataService.save(vo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
                    j.setSuccess(false);
                }
            });
        }
        return j;
    }
}

