/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.actcheck.service.impl;

import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.actcheck.common.SfaConstantEnum;
import com.biz.eisp.actcheck.dao.TsPictureDao;
import com.biz.eisp.actcheck.entity.TsActCheckEntity;
import com.biz.eisp.actcheck.service.TsActCheckService;
import com.biz.eisp.actcheck.vo.TsActCheckVo;
import com.biz.eisp.activiti.feign.SfaAiFegin;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class TsActCheckServiceImpl
extends BaseServiceImpl<TsActCheckEntity>
implements TsActCheckService {
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TsPictureDao tsPictureDao;
    @Autowired
    private SfaAiFegin sfaAiFegin;

    @Override
    public void saveCheckAct(TsActCheckVo vo) throws Exception {
        if (vo == null || StringUtils.isBlank((CharSequence)vo.getDetailId())) {
            throw new BusinessException("\u68c0\u6d4b\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (vo == null || StringUtils.isBlank((CharSequence)vo.getVisitType())) {
            throw new BusinessException("\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo == null || vo.getVisitId() == null) {
            throw new BusinessException("\u62dc\u8bbf\u7ebf\u8def\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<TsPictureEntity> pictureVoList = vo.getPictureVoList();
        if (CollectionUtil.listEmpty(pictureVoList)) {
            throw new BusinessException("\u672a\u63d0\u4ea4\u68c0\u6d4b\u62cd\u7167\uff01");
        }
        TtActDetailEntity detailEntity = (TtActDetailEntity)this.ttActDetailService.selectByPrimaryKey(vo.getDetailId());
        TtActDetailVo result = new TtActDetailVo();
        BeanUtils.copyProperties((Object)detailEntity, (Object)result);
        TsActCheckEntity entity = new TsActCheckEntity();
        MyBeanUtils.copyBeanNotNull2Bean((Object)result, (Object)entity);
        entity.setId(null);
        entity.setRemarks(vo.getRemarks());
        entity.setVisitId(vo.getVisitId());
        entity.setVisitType(vo.getVisitType());
        this.insertSelective(entity);
        pictureVoList.forEach(item -> {
            item.setBusinessId(entity.getId());
            item.setImgType(SfaConstantEnum.imgType.actcheck.getValue());
        });
        this.tsPictureDao.insertList(pictureVoList);
        this.sfaAiFegin.dealAIRest("product", pictureVoList, entity.getId() + "");
    }

    @Override
    public TsActCheckEntity getCheckActDetail(String actDetailCode, String visitType, Integer visitId) {
        Example example = new Example(TsActCheckEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actDetailCode", (Object)actDetailCode);
        criteria.andEqualTo("visitType", (Object)visitType);
        criteria.andEqualTo("visitId", (Object)visitId);
        List list = this.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            TsActCheckEntity checkEntity = (TsActCheckEntity)list.get(0);
            Example pic = new Example(TsPictureEntity.class);
            Example.Criteria criteriaPic = pic.createCriteria();
            criteriaPic.andEqualTo("businessId", (Object)checkEntity.getId());
            criteriaPic.andEqualTo("imgType", (Object)SfaConstantEnum.imgType.actcheck.getValue());
            List pictureEntities = this.tsPictureDao.selectByExample(pic);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)pictureEntities)) {
                checkEntity.setPicList(pictureEntities.stream().map(TsPictureEntity::getImgUrl).collect(Collectors.toList()));
            }
            return checkEntity;
        }
        return null;
    }

    @Override
    public PageInfo<TsActCheckEntity> getMaiListPage(TsActCheckEntity vo, Page page) {
        Example example = new Example(TsActCheckEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getActCode())) {
            criteria.andEqualTo("actCode", (Object)vo.getActCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getActDetailCode())) {
            criteria.andEqualTo("actDetailCode", (Object)vo.getActDetailCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getActSubclassCode())) {
            criteria.andEqualTo("actSubclassCode", (Object)vo.getActSubclassCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getActSubclassName())) {
            criteria.andLike("actSubclassName", "%" + vo.getActSubclassName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getCustomerCode())) {
            criteria.andEqualTo("customerCode", (Object)vo.getCustomerCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getCustomerName())) {
            criteria.andLike("customerName", "%" + vo.getCustomerName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getTerminalCode())) {
            criteria.andEqualTo("terminalCode", (Object)vo.getTerminalCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getTerminalName())) {
            criteria.andLike("terminalName", "%" + vo.getTerminalName() + "%");
        }
        return PageAutoHelperUtil.generatePage(() -> this.selectExample(example), (Page)page);
    }

    @Override
    public AjaxJson deleteByIds(String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        if (ids == null || ids.length <= 0) {
            ajaxJson.setErrMsg("\u8bf7\u4f20\u5165id");
            return ajaxJson;
        }
        for (String id : ids) {
            this.deleteByPrimaryKey(id);
        }
        return ajaxJson;
    }
}

