/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.api.tpm;

import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.saledata.service.TtRealSalesDataService;
import com.biz.eisp.act.saledata.vo.TtRealSalesDataVo;
import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.audit.service.TtAuditActService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import tk.mybatis.mapper.entity.Example;

@RequestMapping(value={"/ttApiSaleDataController"})
@Controller
public class TtApiSaleDataController {
    @Autowired
    private TtRealSalesDataService ttRealSalesDataService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtAuditActService ttAuditActService;

    @RequestMapping(value={"goApiSaleDataMain"})
    public ModelAndView goApiActMain(HttpServletRequest request, String tempUuid) {
        request.setAttribute("tempUuid", (Object)tempUuid);
        return new ModelAndView("com/biz/eisp/api/tpm/TtApiSaleDataListMain");
    }

    @RequestMapping(value={"findTtRealSalesDataVoList"})
    @ResponseBody
    public Object findTtRealSalesDataVoList(HttpServletRequest request, TtRealSalesDataVo vo, String tempUuid) {
        Example example = new Example(TtAuditActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)tempUuid);
        List ttAuditActEntities = this.ttAuditActService.selectExample(example);
        if (ttAuditActEntities != null && ttAuditActEntities.size() > 0) {
            ArrayList<TtRealSalesDataVo> ttRealSalesDataVos = new ArrayList<TtRealSalesDataVo>();
            for (TtAuditActEntity ttAuditActEntity : ttAuditActEntities) {
                String actCode = ttAuditActEntity.getActCode();
                TtActEntity ttActEntity = this.ttActService.getTtActVoByActCode(actCode);
                TtActDetailVo ttActDetailVo = new TtActDetailVo();
                ttActDetailVo.setActCode(actCode);
                List<TtActDetailVo> ttActDetailVos = this.ttActDetailService.findTtActDetailByQuery(ttActDetailVo);
                for (TtActDetailVo actDetailVo : ttActDetailVos) {
                    vo.setCustomerCode(actDetailVo.getCustomerCode());
                    vo.setTerminalCode(actDetailVo.getTerminalCode());
                    vo.setBeginDate(ttActEntity.getBeginDate());
                    vo.setEndDate(ttActEntity.getEndDate());
                    List<TtRealSalesDataVo> realSalesDataVos = this.ttRealSalesDataService.getTtRealSalesDataVoList(vo);
                    if (realSalesDataVos == null || realSalesDataVos.size() <= 0) continue;
                    TtRealSalesDataVo salesDataVo = new TtRealSalesDataVo();
                    int actNum = 0;
                    BigDecimal actPrice = new BigDecimal(0);
                    for (TtRealSalesDataVo ttRealSalesDataVo : realSalesDataVos) {
                        actNum += ttRealSalesDataVo.getNum().intValue();
                        actPrice = actPrice.add(ttRealSalesDataVo.getTotalAmount());
                    }
                    salesDataVo.setActCode(ttActEntity.getActCode());
                    salesDataVo.setActName(ttActEntity.getActName());
                    salesDataVo.setActTime(ttActEntity.getBeginDate() + "\u81f3" + ttActEntity.getEndDate());
                    salesDataVo.setActNum(actNum);
                    salesDataVo.setActPrice(actPrice);
                    salesDataVo.setCustomerCode(actDetailVo.getCustomerCode());
                    salesDataVo.setCustomerName(actDetailVo.getCustomerName());
                    salesDataVo.setTerminalCode(actDetailVo.getTerminalCode());
                    salesDataVo.setTerminalName(actDetailVo.getTerminalName());
                    ttRealSalesDataVos.add(salesDataVo);
                }
            }
            return ttRealSalesDataVos;
        }
        AjaxJson j = new AjaxJson();
        j.setMsg("\u8bf7\u5148\u9009\u62e9\u6d3b\u52a8\uff01");
        j.setSuccess(false);
        return j;
    }
}

