/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.controller;

import com.biz.eisp.base.ImpExpController;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.vo.ExcelDate;
import com.biz.eisp.budget.config.entity.TtFiscalConfigEntity;
import com.biz.eisp.budget.config.service.TtFiscalConfigService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ttFiscalConfigController"})
public class TtFiscalConfigController
extends ImpExpController {
    @Autowired
    private TtFiscalConfigService ttFiscalConfigService;

    @RequestMapping(value={"goMain"})
    public ModelAndView goMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/budget/config/fiscalMain");
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtFiscalConfigEntity ttFiscalConfigEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFiscalConfigEntity> pageInfo = this.ttFiscalConfigService.getMaiList(ttFiscalConfigEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goSaveOrUpdate"})
    public ModelAndView goSaveOrUpdate(HttpServletRequest request, String id, String clickFunctionId) {
        request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            TtFiscalConfigEntity entity = this.ttFiscalConfigService.getEntity(id);
            request.setAttribute("vo", (Object)entity);
        }
        return new ModelAndView("com/biz/eisp/budget/config/fiscalForm");
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TtFiscalConfigEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isNotEmpty((CharSequence)entity.getId()) ? this.ttFiscalConfigService.update(entity, ajaxJson) : this.ttFiscalConfigService.save(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"stopFiscal"})
    @ResponseBody
    public AjaxJson stopFiscal(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttFiscalConfigService.stopOrStart(id, ajaxJson, ConstantEnum.StatusEnum.DELETE.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"startFiscal"})
    @ResponseBody
    public AjaxJson startFiscal(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttFiscalConfigService.stopOrStart(id, ajaxJson, ConstantEnum.StatusEnum.NEW.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    protected AjaxJson checkImportList(List importList, ExcelDate excelDate) {
        return null;
    }

    protected AjaxJson doImportList(List importList, ExcelDate excelDate) {
        return null;
    }
}

