/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.fee.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.budget.fee.vo.AdjustAmountVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ttFeeBudgetController"})
public class TtFeeBudgetController {
    @Autowired
    private TtFeeBudgetService ttFeeBudgetService;

    @RequestMapping(value={"goMain"})
    public ModelAndView goMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/budget/fee/feeBudgetMain");
    }

    @RequestMapping(value={"getSelectPage"})
    @ResponseBody
    public DataGrid getSelectPage(HttpServletRequest request, TtFeeBudgetEntity ttFeeBudgetEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeeBudgetEntity> pageInfo = this.ttFeeBudgetService.getMaiList(ttFeeBudgetEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtFeeBudgetEntity ttFeeBudgetEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeeBudgetEntity> pageInfo = this.ttFeeBudgetService.getMaiList(ttFeeBudgetEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goSaveOrUpdate"})
    public ModelAndView goSaveOrUpdate(HttpServletRequest request, String id, String clickFunctionId) {
        request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            TtFeeBudgetEntity entity = this.ttFeeBudgetService.getEntity(id, null);
            request.setAttribute("vo", (Object)entity);
            request.setAttribute("updateFlag", (Object)"1");
        }
        return new ModelAndView("com/biz/eisp/budget/fee/feeBudgetForm");
    }

    @RequestMapping(value={"goUpdateAmount"})
    public ModelAndView goUpdateAmount(HttpServletRequest request, String id) {
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            TtFeeBudgetEntity entity = this.ttFeeBudgetService.getEntity(id, null);
            request.setAttribute("vo", (Object)entity);
        }
        return new ModelAndView("com/biz/eisp/budget/fee/feeBudgetUpdateAmount");
    }

    @RequestMapping(value={"goAdjustAmount"})
    public ModelAndView goAdjustAmount(HttpServletRequest request, String id) {
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            TtFeeBudgetEntity entity = this.ttFeeBudgetService.getEntity(id, null);
            request.setAttribute("vo", (Object)entity);
        }
        return new ModelAndView("com/biz/eisp/budget/fee/feeBudgetAdjustAmount");
    }

    @RequestMapping(value={"updateAmount"})
    @ResponseBody
    public AjaxJson updateAmount(HttpServletRequest request, TtFeeBudgetEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = this.ttFeeBudgetService.updateAmount(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"adjustAmount"})
    @ResponseBody
    public AjaxJson adjustAmount(@RequestBody AdjustAmountVo adjustAmountVo) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = this.ttFeeBudgetService.adjustAmount(adjustAmountVo, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TtFeeBudgetEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isNotEmpty((CharSequence)entity.getId()) ? this.ttFeeBudgetService.update(entity, ajaxJson) : this.ttFeeBudgetService.save(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public AjaxJson delete(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttFeeBudgetService.delete(id, ajaxJson);
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"findFeeBudgetByCode"})
    @ResponseBody
    public AjaxJson<TtFeeBudgetEntity> findFeeBudgetByCode(TtFeeBudgetEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        if (entity == null) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        TtFeeBudgetEntity feeBudgetEntity = this.ttFeeBudgetService.getEntity(entity.getId(), entity.getBudgetCode());
        ajaxJson.setObj((Object)feeBudgetEntity);
        return ajaxJson;
    }
}

