/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.fee.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.fee.entity.TtFeePoolEntity;
import com.biz.eisp.fee.service.TtFeePoolService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ttFeePoolController"})
public class TtFeePoolController {
    @Autowired
    private TtFeePoolService ttFeePoolService;

    @RequestMapping(value={"goMain"})
    public ModelAndView goMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/fee/feeMain");
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtFeePoolEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeePoolEntity> pageInfo = this.ttFeePoolService.getMaiList(entity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goSaveOrUpdate"})
    public ModelAndView goSaveOrUpdate(HttpServletRequest request, String id, String clickFunctionId) {
        request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            TtFeePoolEntity entity = this.ttFeePoolService.getEntityByIdOrPoolCode(id, null);
            request.setAttribute("vo", (Object)entity);
        }
        return new ModelAndView("com/biz/eisp/fee/feeMainForm");
    }

    @RequestMapping(value={"updateAmount"})
    @ResponseBody
    public AjaxJson updateAmount(HttpServletRequest request, TtFeePoolEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)entity.getCustCode())) {
            ajaxJson.setErrMsg("\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        TtFeePoolEntity old = this.ttFeePoolService.getEntityByCustAndCompany(entity.getCustCode(), entity.getCompanyCode());
        if (old != null) {
            entity.setId(old.getId());
            entity.setPoolCode(old.getPoolCode());
        } else if (ConstantEnum.FeePoolTypeEnum.INCOME_OUT.getValue().equals(entity.getFeePoolType())) {
            ajaxJson.setErrMsg("\u8d39\u7528\u6c60\u4e0d\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u80fd\u6263\u51cf");
        }
        ajaxJson = this.ttFeePoolService.updateAmount(entity, ajaxJson);
        return ajaxJson;
    }
}

