/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.account.service.impl;

import com.biz.eisp.account.dao.TtAccountDetailDao;
import com.biz.eisp.account.dao.TtAccountInvoiceDao;
import com.biz.eisp.account.entity.TtAccountDetailEntity;
import com.biz.eisp.account.entity.TtAccountInvoiceEntity;
import com.biz.eisp.account.service.TtAccountDetailService;
import com.biz.eisp.account.vo.AccountDetailVo;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.service.TtAuditActDetailService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.entity.BaseEntity;
import com.biz.eisp.fee.entity.TtFeePoolEntity;
import com.biz.eisp.fee.service.TtFeePoolService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tk.utils.CollectionUtils;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TtAccountDetailServiceImpl
extends BaseServiceImpl<TtAccountDetailEntity>
implements TtAccountDetailService {
    @Autowired
    private TtAccountDetailDao ttAccountDetailDao;
    @Autowired
    private TtAccountInvoiceDao ttAccountInvoiceDao;
    @Autowired
    private TtFeePoolService ttFeePoolService;
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;

    @Override
    public PageInfo<TtAccountDetailEntity> getMaiList(TtAccountDetailEntity ttAccountDetailEntity, Page page) {
        Example example = new Example(TtAccountDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getEnableStatus())) {
            criteria.andLike("enableStatus", ttAccountDetailEntity.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getAccountCode())) {
            criteria.andLike("accountCode", "%" + ttAccountDetailEntity.getAccountCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getAuditCode())) {
            criteria.andLike("auditCode", "%" + ttAccountDetailEntity.getAuditCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getAuditDetailCode())) {
            criteria.andLike("auditDetailCode", ttAccountDetailEntity.getAuditDetailCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getActCode())) {
            criteria.andLike("actCode", "%" + ttAccountDetailEntity.getActCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getActName())) {
            criteria.andLike("actName", "%" + ttAccountDetailEntity.getActName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getId())) {
            criteria.andEqualTo("id", (Object)ttAccountDetailEntity.getId());
        }
        if (StringUtil.isNotEmpty((Object)ttAccountDetailEntity.getAuditAmount())) {
            criteria.andEqualTo("auditAmount", (Object)ttAccountDetailEntity.getAuditAmount());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getPaymentCode())) {
            criteria.andLike("paymentCode", ttAccountDetailEntity.getPaymentCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getAccountProductName())) {
            criteria.andLike("accountProductName", ttAccountDetailEntity.getAccountProductName());
        }
        if (StringUtil.isNotEmpty((Object)ttAccountDetailEntity.getAccountAmount())) {
            criteria.andEqualTo("accountAmount", (Object)ttAccountDetailEntity.getAccountAmount());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getCredentialsCode())) {
            criteria.andLike("credentialsCode", ttAccountDetailEntity.getCredentialsCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getExtChar1())) {
            criteria.andLike("extChar1", "%" + ttAccountDetailEntity.getExtChar1() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getExtChar2())) {
            criteria.andLike("extChar2", "%" + ttAccountDetailEntity.getExtChar2() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getExtChar3())) {
            criteria.andLike("extChar3", ttAccountDetailEntity.getExtChar3());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getExtChar4())) {
            criteria.andLike("extChar4", ttAccountDetailEntity.getExtChar4());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttAccountDetailEntity.getExtChar5())) {
            criteria.andLike("extChar5", ttAccountDetailEntity.getExtChar5());
        }
        example.setOrderByClause(" account_time desc ");
        return PageAutoHelperUtil.generatePage(() -> this.ttAccountDetailDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<TtAccountInvoiceEntity> getInvoiceMaiListPage(TtAccountInvoiceEntity ttAccountInvoiceEntity, Page page) {
        Example example = new Example(TtAccountInvoiceEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)ttAccountInvoiceEntity.getAccountCode())) {
            criteria.andEqualTo("accountCode", (Object)ttAccountInvoiceEntity.getAccountCode());
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttAccountInvoiceDao.selectByExample(example), (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtAccountDetailServiceImpl.class)
    public AjaxJson saveOrUpdateData(AccountDetailVo accountDetailVo, AjaxJson ajaxJson) {
        AjaxJson ajaxJsonTemp;
        List<TtAccountDetailEntity> detailList = accountDetailVo.getDetailList();
        String status = accountDetailVo.getStatus();
        if (StringUtil.equals((String)ConstantEnum.StatusEnum.NEW.getValue(), (String)status) && !(ajaxJsonTemp = this.checkAmount(detailList)).isSuccess()) {
            ajaxJson.setErrMsg(ajaxJsonTemp.getMsg());
            return ajaxJson;
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(detailList)) {
            List codes = detailList.stream().map(TtAccountDetailEntity::getAccountCode).collect(Collectors.toList());
            Example example = new Example(TtAccountDetailEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andIn("accountCode", codes);
            List oldEntitys = this.ttAccountDetailDao.selectByExample(example);
            Map<Object, Object> map = new HashMap();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)oldEntitys)) {
                map = oldEntitys.stream().collect(Collectors.toMap(TtAccountDetailEntity::getAccountCode, accountEntity -> accountEntity));
            }
            HashMap mapOld = map;
            ArrayList<TtAccountDetailEntity> addList = new ArrayList<TtAccountDetailEntity>();
            ArrayList<TtAccountDetailEntity> updateList = new ArrayList<TtAccountDetailEntity>();
            detailList.forEach(item -> {
                if (mapOld.containsKey(item.getAccountCode())) {
                    item.setEnableStatus(status);
                    updateList.add((TtAccountDetailEntity)item);
                } else {
                    item.setEnableStatus(status);
                    addList.add((TtAccountDetailEntity)item);
                }
            });
            if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
                this.saveData(addList, ajaxJson);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
                this.updateData(updateList, ajaxJson);
            }
        }
        return ajaxJson;
    }

    private AjaxJson checkAmount(List<TtAccountDetailEntity> detailList) {
        AjaxJson ajaxJson = new AjaxJson();
        if (CollectionUtils.isEmpty(detailList)) {
            return ajaxJson;
        }
        HashMap mapAmount = new HashMap();
        detailList.forEach(item -> {
            String auditDetailCode = item.getAuditDetailCode();
            BigDecimal accountAmount = item.getAccountAmount();
            if (mapAmount.containsKey(auditDetailCode)) {
                BigDecimal temp = (BigDecimal)mapAmount.get(auditDetailCode);
                mapAmount.put(auditDetailCode, accountAmount.add(temp));
            } else {
                mapAmount.put(auditDetailCode, accountAmount);
            }
        });
        ArrayList<String> codes = new ArrayList<String>(mapAmount.keySet());
        List<TtAuditActDetailEntity> list = this.ttAuditActDetailService.getCodes(codes);
        HashMap mapAmountOld = new HashMap();
        list.forEach(item -> {
            String auditDetailCode = item.getAuditDetailCode();
            BigDecimal currentAmount = item.getCurrentAmount() == null ? BigDecimal.ZERO : item.getCurrentAmount();
            BigDecimal feeUsed = item.getFeeUsed() == null ? BigDecimal.ZERO : item.getFeeUsed();
            BigDecimal accountAmount = currentAmount.subtract(feeUsed);
            if (mapAmountOld.containsKey(auditDetailCode)) {
                BigDecimal temp = (BigDecimal)mapAmountOld.get(auditDetailCode);
                mapAmountOld.put(auditDetailCode, accountAmount.add(temp));
            } else {
                mapAmountOld.put(auditDetailCode, accountAmount);
            }
        });
        for (Map.Entry tempMap : mapAmount.entrySet()) {
            String k = (String)tempMap.getKey();
            if (!mapAmountOld.containsKey(k)) {
                ajaxJson.setErrMsg("\u6838\u9500\u660e\u7ec6\u7f16\u7801:" + k + "\u4e0d\u5b58\u5728");
                break;
            }
            if (((BigDecimal)mapAmountOld.get(k)).compareTo((BigDecimal)tempMap.getValue()) >= 0) continue;
            ajaxJson.setErrMsg("\u8d85\u8fc7\u6838\u9500\u660e\u7ec6\u7f16\u7801:" + k + "\u53ef\u4ee5\u4e0a\u8d26\u91d1\u989d" + mapAmountOld.get(k));
            break;
        }
        return ajaxJson;
    }

    private AjaxJson updateData(List<TtAccountDetailEntity> detailList, AjaxJson ajaxJson) {
        ArrayList<TtAccountInvoiceEntity> invoiceEntities = new ArrayList<TtAccountInvoiceEntity>();
        if (CollectionUtil.listNotEmptyNotSizeZero(detailList)) {
            detailList.forEach(item -> {
                List<TtAccountInvoiceEntity> invoiceList;
                item.setAccountProductName(StringUtil.equals((String)"\u8bf7\u9009\u62e9", (String)item.getAccountProductName()) ? "" : item.getAccountProductName());
                this.ttAccountDetailDao.updateByPrimaryKeySelective(item);
                if (StringUtil.equals((String)item.getEnableStatus(), (String)ConstantEnum.StatusEnum.NEW.getValue())) {
                    this.ttAuditActDetailService.updateUsedAmount(item.getAuditDetailCode(), item.getAccountAmount());
                    this.addFeePoolByAccount((TtAccountDetailEntity)item, ajaxJson);
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(invoiceList = item.getInvoiceList())) {
                    invoiceEntities.addAll(invoiceList);
                } else {
                    Example example = new Example(TtAccountInvoiceEntity.class);
                    Example.Criteria criteria = example.createCriteria();
                    criteria.andEqualTo("accountCode", (Object)item.getAccountCode());
                    this.ttAccountInvoiceDao.deleteByExample(example);
                }
            });
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(invoiceEntities)) {
            this.saveAndUpdateInvoice(invoiceEntities, ajaxJson);
        }
        return ajaxJson;
    }

    private void saveAndUpdateInvoice(List<TtAccountInvoiceEntity> invoiceEntities, AjaxJson ajaxJson) {
        Map<String, TtAccountInvoiceEntity> map;
        if (!CollectionUtil.listNotEmptyNotSizeZero(invoiceEntities)) {
            return;
        }
        List ids = invoiceEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        Example example = new Example(TtAccountInvoiceEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("id", ids);
        List oldEntitys = this.ttAccountInvoiceDao.selectByExample(example);
        Map<String, TtAccountInvoiceEntity> oldMap = map = oldEntitys.stream().collect(Collectors.toMap(BaseEntity::getId, entity -> entity));
        ArrayList addList = new ArrayList();
        ArrayList updateList = new ArrayList();
        invoiceEntities.forEach(item -> {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
            } else {
                item.setId(null);
                item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                addList.add(item);
            }
        });
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            this.ttAccountInvoiceDao.insertList(addList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            updateList.forEach(item -> this.ttAccountInvoiceDao.updateByPrimaryKeySelective(item));
        }
    }

    private void addFeePoolByAccount(TtAccountDetailEntity item, AjaxJson ajaxJson) {
        TtFeePoolEntity entity = new TtFeePoolEntity();
        entity.setCustCode(item.getCustCode());
        entity.setUpdateAmount(item.getAccountAmount());
        entity.setFromCode(item.getAccountCode());
        entity.setFromTable("tt_account_detail");
        entity.setCustName(item.getCustName());
        if (ConstantEnum.StatusEnum.NEW.getValue().equals(item.getEnableStatus())) {
            entity.setFeePoolType(ConstantEnum.FeePoolTypeEnum.INIT_FEE.getValue());
            entity.setNotes("\u8d39\u7528\u4e0a\u8d26");
        }
        if (ConstantEnum.StatusEnum.DELETE.getValue().equals(item.getEnableStatus())) {
            entity.setFeePoolType(ConstantEnum.FeePoolTypeEnum.DELETE_FEE.getValue());
            entity.setNotes("\u4e0a\u8d26\u5220\u9664");
        }
        entity.setMoneyUnits("CNY");
        this.ttFeePoolService.updateAmount(entity, ajaxJson);
    }

    private AjaxJson saveData(List<TtAccountDetailEntity> detailList, AjaxJson ajaxJson) {
        ArrayList invoiceList = new ArrayList();
        if (CollectionUtil.listNotEmptyNotSizeZero(detailList)) {
            detailList.forEach(item -> {
                item.setId(null);
                if (StringUtil.equals((String)ConstantEnum.StatusEnum.NEW.getValue(), (String)item.getEnableStatus())) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    item.setAccountTime(simpleDateFormat.format(new Date()));
                }
                item.setAccountProductName(StringUtil.equals((String)"\u8bf7\u9009\u62e9", (String)item.getAccountProductName()) ? "" : item.getAccountProductName());
                if (CollectionUtil.listNotEmptyNotSizeZero(item.getInvoiceList())) {
                    invoiceList.addAll(item.getInvoiceList());
                }
                if (StringUtil.equals((String)item.getEnableStatus(), (String)ConstantEnum.StatusEnum.NEW.getValue())) {
                    this.ttAuditActDetailService.updateUsedAmount(item.getAuditDetailCode(), item.getAccountAmount());
                    this.addFeePoolByAccount((TtAccountDetailEntity)item, ajaxJson);
                }
            });
            this.insertList(detailList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(invoiceList)) {
            invoiceList.forEach(item -> {
                item.setId(null);
                this.ttAccountInvoiceDao.insertSelective(item);
            });
        }
        return ajaxJson;
    }

    @Override
    public TtAccountDetailEntity getEntityByIdOrAccountCode(String id, String accountCode) {
        TtAccountDetailEntity entity = null;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)accountCode)) {
            return entity;
        }
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            entity = (TtAccountDetailEntity)this.ttAccountDetailDao.selectByPrimaryKey(id);
        } else {
            Example example = new Example(TtAccountDetailEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("accountCode", (Object)accountCode);
            List entities = this.ttAccountDetailDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)entities)) {
                entity = (TtAccountDetailEntity)entities.get(0);
            }
        }
        return entity;
    }

    @Override
    public AjaxJson delete(String id, AjaxJson ajaxJson) {
        TtAccountDetailEntity entity = this.getEntityByIdOrAccountCode(id, null);
        if (ConstantEnum.StatusEnum.UPDATE.getValue().equals(entity.getEnableStatus())) {
            this.deleteAccount(entity, ajaxJson);
            return ajaxJson;
        }
        if (ConstantEnum.StatusEnum.DELETE.getValue().equals(entity.getEnableStatus())) {
            ajaxJson.setErrMsg(entity.getAccountCode() + "\u5df2\u7ecf\u5220\u9664\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u5220\u9664");
            return ajaxJson;
        }
        if (ConstantEnum.StatusEnum.NEW.getValue().equals(entity.getEnableStatus())) {
            ajaxJson.setErrMsg(entity.getAccountCode() + "\u5df2\u4e0a\u8d26\u6210\u529f\uff0c\u4e0d\u80fd\u5220\u9664");
            return ajaxJson;
        }
        BigDecimal accountAmount = entity.getAccountAmount();
        TtFeePoolEntity ttFeePoolEntity = this.ttFeePoolService.getEntityByCustAndCompany(entity.getCustCode(), null);
        if (ttFeePoolEntity != null) {
            BigDecimal feeUsableAmount = ttFeePoolEntity.getFeeUsableAmount();
            if (feeUsableAmount.compareTo(accountAmount) < 0) {
                ajaxJson.setErrMsg("\u7f16\u53f7\uff1a" + entity.getAccountCode() + "\u8d39\u7528\u6c60\u4f59\u989d\u4e3a\uff1a" + feeUsableAmount + " \u5c0f\u4e8e\u5f53\u524d\u5220\u9664\u91d1\u989d:" + accountAmount);
                return ajaxJson;
            }
            entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
            this.addFeePoolByAccount(entity, ajaxJson);
            if (!ajaxJson.isSuccess()) {
                return ajaxJson;
            }
        }
        this.deleteAccount(entity, ajaxJson);
        return ajaxJson;
    }

    private void deleteAccount(TtAccountDetailEntity entity, AjaxJson ajaxJson) {
        this.ttAccountDetailDao.deleteByPrimaryKey(entity.getId());
        TtAccountInvoiceEntity updaettIncoice = new TtAccountInvoiceEntity();
        updaettIncoice.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        Example example = new Example(TtAccountInvoiceEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("accountCode", (Object)entity.getAccountCode());
        this.ttAccountInvoiceDao.deleteByExample(example);
    }
}

