/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.advance.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.advance.dao.TtActAdvanceDao;
import com.biz.eisp.act.advance.dao.TtActAdvanceDetailDao;
import com.biz.eisp.act.advance.entity.TtActAdvanceDetailEntity;
import com.biz.eisp.act.advance.entity.TtActAdvanceEntity;
import com.biz.eisp.act.advance.service.TtActAdvanceService;
import com.biz.eisp.act.advance.vo.TtActAdvanceDetailVo;
import com.biz.eisp.act.advance.vo.TtActAdvanceVo;
import com.biz.eisp.activiti.vo.ActivitiCallBackVo;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttActAdvanceService")
@Transactional
public class TtActAdvanceServiceImpl
extends BaseServiceImpl<TtActAdvanceEntity>
implements TtActAdvanceService {
    @Autowired
    private TtActAdvanceDao ttActAdvanceDao;
    @Autowired
    private TtActAdvanceDetailDao ttActAdvanceDetailDao;

    @Override
    public PageInfo<TtActAdvanceVo> findTtActAdvancePage(TtActAdvanceVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttActAdvanceDao.findTtActAdvanceList(vo), (Page)page);
    }

    @Override
    public TtActAdvanceEntity getTtActAdvanceEntity(String id) {
        return (TtActAdvanceEntity)this.ttActAdvanceDao.selectByPrimaryKey(id);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtActAdvanceServiceImpl.class)
    public boolean saveTtActAdvance(TtActAdvanceVo vo) throws Exception {
        BigDecimal advancePrice;
        BigDecimal applyPrice;
        if (StringUtils.isBlank((CharSequence)vo.getTempUuid())) {
            return false;
        }
        TtActAdvanceEntity entity = new TtActAdvanceEntity();
        MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
        entity.setBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue());
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        entity.setAdvanceCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.advance_code.name()));
        this.insertSelective(entity);
        Example example = new Example(TtActAdvanceDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)vo.getTempUuid());
        List details = this.ttActAdvanceDetailDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)details)) {
            applyPrice = BigDecimal.ZERO;
            advancePrice = BigDecimal.ZERO;
            for (TtActAdvanceDetailEntity item : details) {
                item.setAdvanceCode(entity.getAdvanceCode());
                if (StringUtils.isBlank((CharSequence)item.getAdvanceCode())) {
                    item.setAdvanceDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.advance_detail_code.name()).toString());
                }
                advancePrice = advancePrice.add(item.getAdvancePrice() == null ? BigDecimal.ZERO : item.getAdvancePrice());
                applyPrice = applyPrice.add(item.getApplyPrice() == null ? BigDecimal.ZERO : item.getApplyPrice());
            }
        } else {
            throw new RuntimeException("\u672a\u6dfb\u52a0\u6d3b\u52a8\u9884\u4ed8\u6b3e\u660e\u7ec6,\u4e0d\u80fd\u4fdd\u5b58");
        }
        this.ttActAdvanceDetailDao.updateBatchByPrimaryKeySelective(details);
        this.updateActAdvanceDetail(vo.getUpdatedJsonData());
        entity.setApplyPrice(applyPrice);
        entity.setAdvancePrice(advancePrice);
        this.updateByPrimaryKeySelective(entity);
        return true;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtActAdvanceServiceImpl.class)
    public boolean updateTtActAdvance(TtActAdvanceVo vo) throws Exception {
        TtActAdvanceEntity entity = (TtActAdvanceEntity)this.selectByPrimaryKey(vo.getId());
        if (StringUtils.isBlank((CharSequence)entity.getTempUuid())) {
            return false;
        }
        if (!(entity.getBpmStatus().equals(ConstantEnum.bpmStatus.COMMIT.getValue()) || entity.getBpmStatus().equals(ConstantEnum.bpmStatus.REJECT.getValue()) || entity.getBpmStatus().equals(ConstantEnum.bpmStatus.BACK.getValue()))) {
            throw new RuntimeException("\u6570\u636e\u6d41\u7a0b\u4e2d\u4e0d\u80fd\u4fee\u6539\uff01");
        }
        MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
        this.updateByPrimaryKeySelective(entity);
        this.updateActAdvanceDetail(vo.getUpdatedJsonData());
        Example example = new Example(TtActAdvanceDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)vo.getTempUuid());
        List details = this.ttActAdvanceDetailDao.selectByExample(example);
        BigDecimal applyPrice = BigDecimal.ZERO;
        BigDecimal advancePrice = BigDecimal.ZERO;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)details)) {
            for (TtActAdvanceDetailEntity item : details) {
                item.setAdvanceCode(entity.getAdvanceCode());
                if (StringUtils.isBlank((CharSequence)item.getAdvanceDetailCode())) {
                    item.setAdvanceDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.advance_detail_code.name()).toString());
                }
                advancePrice = advancePrice.add(item.getAdvancePrice() == null ? BigDecimal.ZERO : item.getAdvancePrice());
                applyPrice = applyPrice.add(item.getApplyPrice() == null ? BigDecimal.ZERO : item.getApplyPrice());
            }
            this.ttActAdvanceDetailDao.updateBatchByPrimaryKeySelective(details);
        }
        entity.setApplyPrice(applyPrice);
        entity.setAdvancePrice(advancePrice);
        this.updateByPrimaryKeySelective(entity);
        return true;
    }

    public void updateActAdvanceDetail(String saveDatas) throws Exception {
        JSONArray jsonArray;
        if (StringUtils.isNotBlank((CharSequence)saveDatas) && (jsonArray = JSON.parseArray((String)saveDatas)) != null && jsonArray.size() > 0) {
            ArrayList<TtActAdvanceDetailEntity> list = new ArrayList<TtActAdvanceDetailEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                TtActAdvanceDetailVo vo = (TtActAdvanceDetailVo)JSONObject.toJavaObject((JSON)jsonArray.getJSONObject(i), TtActAdvanceDetailVo.class);
                TtActAdvanceDetailEntity entity = new TtActAdvanceDetailEntity();
                MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
                list.add(entity);
            }
            this.ttActAdvanceDetailDao.updateBatchByPrimaryKeySelective(list);
        }
    }

    @Override
    public void updateBpmStatus(TtActAdvanceVo vo) {
        if (vo == null || StringUtils.isBlank((CharSequence)vo.getBpmStatus()) || StringUtils.isBlank((CharSequence)vo.getId())) {
            return;
        }
        TtActAdvanceEntity entity = new TtActAdvanceEntity();
        entity.setId(vo.getId());
        entity.setBpmStatus(vo.getBpmStatus());
        entity.setProcessKey(vo.getProcessKey());
        this.ttActAdvanceDao.updateByPrimaryKeySelective(entity);
    }

    @Override
    public void doActAdvanceCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        TtActAdvanceEntity entity = new TtActAdvanceEntity();
        entity.setId(activitiCallBackVo.getBusinessObjId());
        entity.setBpmStatus(activitiCallBackVo.getBpmStatus());
        this.ttActAdvanceDao.updateByPrimaryKeySelective(entity);
    }
}

