/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.api.tpm;

import com.biz.eisp.act.service.TtActDetailService;
import com.biz.eisp.act.service.TtActService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.audit.service.TtAuditActService;
import com.biz.eisp.audit.service.TtAuditService;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.BaseController;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/ttApiActController"})
@Controller
public class TtApiActController
extends BaseController {
    @Autowired
    private TtActService ttActService;
    @Autowired
    private TtActDetailService ttActDetailService;
    @Autowired
    private TtAuditActService ttAuditActService;
    @Autowired
    private TtAuditService ttAuditService;
    @Autowired
    private TtCostTypeFineService ttCostTypeFineService;

    @RequestMapping(value={"goApiActMain"})
    public ModelAndView goApiActMain() {
        return new ModelAndView("com/biz/eisp/api/tpm/TtApiActListMain");
    }

    @RequestMapping(value={"goApiActDetailMain"})
    public ModelAndView goApiActDetailMain(HttpServletRequest request, String tempUuid) {
        request.setAttribute("tempUuid", (Object)tempUuid);
        return new ModelAndView("com/biz/eisp/api/tpm/TtApiActDetailListMain");
    }

    @RequestMapping(value={"findTtActPage"})
    @ResponseBody
    public DataGrid findTtActPage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActVo> info = null;
        vo.setBpmStatus(ConstantEnum.bpmStatus.PASS.getValue());
        info = this.ttActService.findTtActPage(vo, (Page)page);
        return new DataGrid(info);
    }

    @RequestMapping(value={"findTtActDetailPage"})
    @ResponseBody
    public List<TtActDetailVo> findTtActDetailPage(HttpServletRequest request, TtActDetailVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActDetailVo> info = null;
        ArrayList<TtActDetailVo> ttActDetailVos = new ArrayList<TtActDetailVo>();
        try {
            info = this.ttActDetailService.findTtActDetailByActsPage(vo, (Page)page);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)info.getList())) {
                info.getList().forEach(item -> {
                    TtCostTypeFineEntity ttCostTypeFineEntity = this.ttCostTypeFineService.getFineEntity(null, item.getActSubclassCode());
                    if (ttCostTypeFineEntity.getActMethodCode().equals(ConstantEnum.ActMethodEnum.DDFY.getValue()) || ttCostTypeFineEntity.getActMethodCode().equals(ConstantEnum.ActMethodEnum.HFFY.getValue())) {
                        ttActDetailVos.add((TtActDetailVo)item);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ttActDetailVos;
    }

    @RequestMapping(value={"goApiActAdvanceMain"})
    public ModelAndView goApiActAdvanceMain() {
        return new ModelAndView("com/biz/eisp/api/tpm/TtApiActAdvanceListMain");
    }

    @RequestMapping(value={"findTtActAdvanceList"})
    @ResponseBody
    public DataGrid findTtActAdvanceList(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActVo> ttActVos = this.ttActService.findTtActListForAdvance(vo, (Page)page);
        return new DataGrid(ttActVos);
    }
}

