/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.income.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.income.dao.TtIncomeBudgetDao;
import com.biz.eisp.budget.income.entity.TtIncomeBudgetEntity;
import com.biz.eisp.budget.income.service.TtIncomeBudgetService;
import com.biz.eisp.budget.used.service.TtBudgutDetailService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.surplus.Service.TtCustPostService;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttIncomeBudgetService")
@Transactional
public class TtIncomeBudgetServiceImpl
extends BaseServiceImpl<TtIncomeBudgetEntity>
implements TtIncomeBudgetService {
    @Autowired
    private TtIncomeBudgetDao ttIncomeBudgetDao;
    @Autowired
    private TtBudgutDetailService ttBudgutDetailService;
    @Autowired
    private TtCustPostService ttCustPostService;

    @Override
    public PageInfo<TtIncomeBudgetEntity> getMaiList(TtIncomeBudgetEntity entity, Page page) {
        Example example = new Example(TtIncomeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetYear())) {
            criteria.andEqualTo("budgetYear", (Object)entity.getBudgetYear());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetYear())) {
            criteria.andEqualTo("budgetMonth", (Object)entity.getBudgetMonth());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetCode())) {
            criteria.andLike("budgetCode", "%" + entity.getBudgetCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetName())) {
            criteria.andLike("budgetName", "%" + entity.getBudgetName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetDepartName())) {
            criteria.andLike("budgetDepartName", "%" + entity.getBudgetDepartName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getProductName())) {
            criteria.andLike("productName", "%" + entity.getProductName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCreateName())) {
            criteria.andLike("createName", "%" + entity.getCreateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getUpdateName())) {
            criteria.andLike("updateName", "%" + entity.getUpdateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar1())) {
            criteria.andLike("extChar1", "%" + entity.getExtChar1() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar2())) {
            criteria.andLike("extChar2", "%" + entity.getExtChar2() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar3())) {
            criteria.andLike("extChar3", "%" + entity.getExtChar3() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar4())) {
            criteria.andLike("extChar4", "%" + entity.getExtChar4() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar5())) {
            criteria.andLike("extChar5", "%" + entity.getExtChar5() + "%");
        }
        criteria.andNotEqualTo("enableStatus", (Object)ConstantEnum.StatusEnum.DELETE.getValue());
        return PageAutoHelperUtil.generatePage(() -> this.ttIncomeBudgetDao.selectByExample(example), (Page)page);
    }

    @Override
    public TtIncomeBudgetEntity getEntity(String id, String budgetCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)budgetCode)) {
            return null;
        }
        Example example = new Example(TtIncomeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)budgetCode)) {
            criteria.andEqualTo("budgetCode", (Object)budgetCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttIncomeBudgetDao.selectByExample(example)))) {
            return (TtIncomeBudgetEntity)list.get(0);
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtIncomeBudgetServiceImpl.class)
    public AjaxJson update(TtIncomeBudgetEntity entity, AjaxJson ajaxJson) {
        this.ttIncomeBudgetDao.updateByPrimaryKeySelective(entity);
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtIncomeBudgetServiceImpl.class)
    public AjaxJson save(TtIncomeBudgetEntity entity, AjaxJson ajaxJson) {
        if (entity.getInitAmount() == null) {
            ajaxJson.setErrMsg("\u521d\u59cb\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        entity.setBudgetCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.income_budget.name()));
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.ttIncomeBudgetDao.insertSelective(entity);
        this.ttBudgutDetailService.incomeFeeBudgutDetail(entity.getBudgetCode(), ConstantEnum.BudgetUesdTypeEnum.INIT.getValue(), entity.getInitAmount(), "\u65b0\u589e");
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson delete(String id, AjaxJson ajaxJson) {
        TtIncomeBudgetEntity entity = new TtIncomeBudgetEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        entity.setId(id);
        this.ttIncomeBudgetDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }
}

