<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="feeList_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="feeList" tagConf="${clickFunctionId}" controllerTarget="ttAccountController" methedTarget="getMaiListPage" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/tpm/ttAccountController/getMaiListPage?clickFunctionId=${clickFunctionId}" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="扩展字段1" field="extChar1"  hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段2" field="extChar2"  hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段3" field="extChar3"  hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段4" field="extChar4"  hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段5" field="extChar5"  hidden="true" query="false"></t:dgCol>
            <t:dgCol title="上账编码" field="accountCode" query="true"></t:dgCol>
            <t:dgCol title="核销明细编码" field="auditDetailCode" query="true"></t:dgCol>
            <t:dgCol title="活动名称" field="actName" query="true"></t:dgCol>
            <t:dgCol title="活动开始时间" field="beginDate" query="true"></t:dgCol>
            <t:dgCol title="活动结束时间" field="endDate" query="true"></t:dgCol>
            <t:dgCol title="核销金额" field="auditAmount" query="true"></t:dgCol>
            <t:dgCol title="支付方式" field="paymentCode" dictionary="pay_type" ></t:dgCol>
            <t:dgCol title="货补产品" field="accountProductName" ></t:dgCol>
            <t:dgCol title="上账金额" field="accountAmount" query="true"></t:dgCol>
            <t:dgCol title="上账时间" field="accountTime" ></t:dgCol>
            <t:dgCol title="凭证编号" field="credentialsCode" query="true"></t:dgCol>
            <t:dgCol title="状态" field="enableStatus" query="true" dictionary="account_status"></t:dgCol>
            <t:dgCol title="备注" field="notes" query="true"></t:dgCol>

            <t:dgToolBar operationCode="add" title="新增" icon="icon-add" url="/tpm/ttAccountController/goSaveOrUpdate"
                         funname="addDetail" width="1100" height="550"></t:dgToolBar>
            <t:dgToolBar operationCode="edit" title="编辑" icon="icon-edit" url="/tpm/ttAccountController/goSaveOrUpdate"
                         funname="updateDetail" width="1100" height="550"></t:dgToolBar>
            <t:dgToolBar operationCode="look" title="查看" icon="icon-edit" url="/tpm/ttAccountController/goSaveOrUpdate"
                         funname="detail" width="1100" height="550"></t:dgToolBar>
            <t:dgToolBar operationCode="remove" title="删除" icon="icon-remove" url="/tpm/ttAccountController/delete"
                         funname="deleteALLSelectList" width="1100" height="550"></t:dgToolBar>
            <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn"
                         onclick="importDataByXml({impName:'tmAdministrativeArea', gridName:'tbaList'})"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                         url="/tpm/commonExcelController/excel" excelName="费用上账" excelSheetName="费用上账" funname="excelCommonExport"></t:dgToolBar>
            <t:dgToolBar operationCode="log" title="日志"  icon="icon-log" url="/tpm/knlLogController/goShowLog"
                         width="1000" height="500" funname="update"></t:dgToolBar>
            <t:dgToolBar operationCode="style" title="个性设置" icon="icon-add" url="/tpm/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>
<script type="text/javascript">

    /* 修改上账明细 */
    function updateDetail(title, url, id, width, height, params) {
        title = "新增";
        url="/tpm/ttAccountController/goSaveOrUpdate";
        height="550";
        width="1100";
        id="feeList";
        gridname = id;
        var rowsData = $('#' + id).datagrid('getSelections');

        if (rowsData.length !=1) {
            tip('请选择一条记录再编辑');
            return;
        }

        var _char ="&";
        if (url.indexOf("?")==-1) {
            _char = "?";
        }
        var updateFlag = true;
        $.ajax({
            type: "POST",
            url: "/tpm/ttAccountController/getEntityByIdOrAccountCode",
            data: {"id":rowsData[0].id},
            async:false,
            success: function(data){
                if(!data.success){
                    tip(data.msg);
                    updateFlag = data.success;
                }
            }
        });
        if(!updateFlag){
            return;
        }
        url += _char+'id=' + rowsData[0].id;
        createwindowSmallOver(title, url, width, height);
    }
    //费用上账新增
    function addDetail(title, url, id, width, height, params) {
        title = "新增";
        url="/tpm/ttAccountController/goSaveOrUpdate";
        height="550";
        width="1100";
        var _char ="&";
        if (url.indexOf("?")==-1) {
            _char = "?";
        }
        url += _char;
        createwindowSmallOver(title, url, width, height);
    }
    //费用上账新增处理
    function createwindowSmallOver(title, addurl, width, height, options) {
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'feeListForm',
            zIndex:1500,
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    iframe.saveData("009");
                    return false;
                },
                button:[{
                    name: '暂存',
                    callback: function () {
                        iframe = this.iframe.contentWindow;
                        iframe.saveData("004");
                        return false;
                    },
                    focus: true
                }],
                cancelVal: '关闭',
                cancel: true,
                okVal:"提交"
            });
        }
        $.extend(myOptions, options);
        safeShowDialog(myOptions);
    }
</script>


