<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>定额明细添加</title>
    <t:base type="jquery,easyui,tools"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/tpm/ttActQuotaController/saveOrUpdateDetail" callback="@Override callbackParentStatus"  layout="div"  dialog="true" formid="detailId">
    <t:dgFormList>
        <t:dgFormColumn field="id" hidden="true" defaultVal="${vo.id}" formClass="form" labelName="id" optionType="input" required="false"/>
        <t:dgFormColumn field="tempUuid" hidden="true" defaultVal="${tempUuid}" formClass="form" labelName="id" optionType="input" required="false"/>
        <t:dgFormColumn field="needShare" hidden="true" defaultVal="${vo.needShare}" formClass="form" labelName="id" optionType="input" required="false"/>
        <t:dgFormColumn field="needStatus" hidden="true" defaultVal="${vo.needStatus}" formClass="form" labelName="id" optionType="input" required="false"/>
        <t:dgFormColumn field="budgetCode" hidden="true" defaultVal="${budgetCode}" formClass="form" labelName="budgetCode" optionType="input" required="false"/>
        <t:dgFormColumn field="actSubclassName" hidden="false" formClass="form" labelName="活动细类" optionType="choseDialog" required="true"
                        onclick="selectActSubClass()" defaultVal="${vo.actSubclassName}" dataType="*" />
        <t:dgFormColumn field="actSubclassCode"  formClass="form" labelName="活动细类编码" optionType="input" hidden="true" required="false"
                        defaultVal="${vo.actSubclassCode}" />
        <t:dgFormColumn field="customerName" hidden="false" formClass="form" labelName="客户名称" optionType="choseDialog" required="false"
                        onclick="selectCustomer()" defaultVal="${vo.customerName}" />
        <t:dgFormColumn field="customerCode"  formClass="form" labelName="客户编码" optionType="input" hidden="true" required="false"
                        defaultVal="${vo.customerCode}" />
        <t:dgFormColumn field="terminalName" hidden="false" formClass="form" labelName="门店名称" optionType="choseDialog" required="false"
                        onclick="selectTerminal()" defaultVal="${vo.terminalName}" />
        <t:dgFormColumn field="terminalCode"  formClass="form" labelName="门店编码" optionType="input" hidden="true" required="false"
                        defaultVal="${vo.terminalCode}" />
        <t:dgFormColumn field="amount" hidden="false" formClass="form" labelName="申请金额" optionType="input" required="true"
                         defaultVal="${vo.amount}" dataType="*"/>
        <t:dgFormColumn field="payType" hidden="false" formClass="form" labelName="支付方式" optionType="select" required="true"
                        defaultVal="${vo.payType }" formTags="${formTags}" dataType="*"/>

        <t:dgFormColumn field="fsalesAmountCustomer" hidden="false" formClass="form" labelName="预估销售额(客户)" optionType="input" required="false"
                        defaultVal="${vo.fsalesAmountCustomer}" />

        <t:dgFormColumn field="fsalesAmountTerminal" hidden="false" formClass="form" labelName="预估销售额(门店)" optionType="input" required="false"
                        defaultVal="${vo.fsalesAmountTerminal}" />
    </t:dgFormList>
    <div>

    </div>
</t:formvalid>
<script>
    var id = '${vo.id}';
    if (id != "") {
        var actSubclassCode = '${vo.actSubclassCode}';
        checkAndDeal(actSubclassCode);
    }

    function selectActSubClass(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        var tableType = "act_quota";
        var budgetCode = $("#budgetCode").val();
        triggerId = "actSubclassCode";
        triggerName = "actSubclassName";
        url = "/tpm/ttApiFineController/goApiActFineMain?tableType="+tableType+"&budgetCode="+budgetCode;
        width = 1000;
        height = 450;
        id = "actSubclassList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].fineCode);
                    $("#" + triggerName).val(myobj[0].fineName);
                    //请求活动需求控制
                    checkAndDeal(myobj[0].fineCode);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    var needStatus=0;
    var needShare=0;
    //请求校验是控制类数据 ：如是否到客户到产品
    //判断 逻辑如下  ： 如果到 终端 那么 客户+终端 必填  如果到 客户 那么 客户必填 终端 可不填
    function checkAndDeal(actSubclassCode){
         needStatus=0;
         needShare=0;
        if (actSubclassCode ==null ||actSubclassCode ==undefined ||actSubclassCode==""){
            tip("活动细类为空！");
            return ;
        }
        $.ajax({
            url : "/tpm/ttApiCostTypeFineController/checkfindCostTypeCons",
            type : 'post',
            data : {"actSubclassCode":actSubclassCode},
            cache : false,
            success : function(data) {
                if (data.success) {
                    var attributes =data.attributes;
                    var paytype = attributes.pay_type;
                    $("#payType").empty();
                    if(paytype.length!=1){
                        $("#payType").append("<option value=''>请选择--请选择--</option>");
                    }
                    for(var i=0;i<paytype.length;i++){
                        $("#payType").append('<option value="'+paytype[i].code+'">'+paytype[i].name+'</option>');
                    }
                     needStatus=0;
                    if(attributes){
                        needShare=attributes.needShare;
                        needStatus=attributes.needStatus;
                        $("#needShare").val(needShare);
                        $("#needStatus").val(needStatus);
                    }
                    //1 发布需要到客户，2 到终端，3 客户与终端都满足
                    if(needStatus==1){
                        $("#customerName").attr("datatype","*");
                        $("#customerName").parent().parent().show();
                        $("#fsalesAmountCustomer").parent().parent().show();
                        $("#terminalName").parent().parent().hide();
                        $("#fsalesAmountTerminal").parent().parent().hide();
                    }else if(needStatus==2){
                        $("#terminalName").attr("datatype","*");
                        $("#customerName").parent().parent().hide();
                        $("#fsalesAmountCustomer").parent().parent().hide();
                        $("#terminalName").parent().parent().show();
                        $("#fsalesAmountTerminal").parent().parent().show();
                    }else if(needStatus==3){
                        $("#customerName").attr("datatype","*");
                        $("#terminalName").attr("datatype","*");
                        $("#customerName").parent().parent().show();
                        $("#terminalName").parent().parent().show();
                        $("#fsalesAmountCustomer").parent().parent().show();
                        $("#fsalesAmountTerminal").parent().parent().show();
                    }

                }else{
                    tip(data.msg);
                }
            }
        });
    }
    function selectCustomer(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
            triggerId = "customerCode";
            triggerName = "customerName";
            url = "/tpm/tmApiCustomerController/goCustomerListMain";
            width = 1000;
            height = 450;
            id = "customerList";
            gridname = id;
            safeShowDialog({
                content: "url:" + url,
                lock: true,
                title: "选择",
                width: width == null ? 700 : width,
                height: height == null ? 400 : height,
                left: '85%',
                cache: false,
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                        if (notRequired) {
                            $("#" + triggerName).val("");
                            $("#" + hiddenId).val("");
                            return true;
                        } else {
                            iframe.tip("请至少选择一条数据");
                            return false;
                        }

                    } else {
                        if (validFunction != null && validFunction != "undefined") {
                            if (!validFunction(rowsData)) {
                                return false;
                            }
                        }
                        var myobj=eval(rowsData);
                        $("#" + triggerId).val(myobj[0].customerCode);
                        $("#" + triggerName).val(myobj[0].customerName);
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
    }
    function selectTerminal(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        var customerCode=$("#customerCode").val();
        if (isEmpty(customerCode)){
            tip("请先选择客户");
            return ;
        }
        triggerId = "terminalCode";
        triggerName = "terminalName";
        url = "/tpm/tmApiTerminalController/goTerminalListMain?customerCode="+customerCode;
        width = 1000;
        height = 450;
        id = "terminalList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].terminalCode);
                    $("#" + triggerName).val(myobj[0].terminalName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    function callbackParentStatus(data){
        var win = frameElement.api.config.parent;
        if(win == null || win == "" || win=="undefined"){
            win = frameElement.api.opener;
        }else{
            win = frameElement.api.config.parent.content;
        }
        if (data.success == true) {
            if (needShare==1){ // 1表示需要分摊 0 不需要分摊
                win.settingStatus();  //设置细类状态 控制 显示与隐藏 产品分摊
            }
            frameElement.api.close();
            win.tip(data.msg,'info');
        } else {
            if (data.responseText == '' || data.responseText == undefined) {
                $.messager.alert('错误', data.msg, 'error');
                $.Hidemsg();
            } else {
                try {
                    var emsg = data.responseText.substring(data.responseText.indexOf('错误描述'), data.responseText.indexOf('错误信息'));
                    $.messager.alert('错误', emsg, 'error');
                    $.Hidemsg();
                } catch(ex) {
                    $.messager.alert('错误', data.responseText + "", 'error');
                    $.Hidemsg();
                }
            }
            return false;
        }
        win.reloadTable();
    }
</script>
</body>
</html>